/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.events;

import java.util.Arrays;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.events.FilterType;
import org.apache.commons.math3.ode.events.Transformer;

public class EventFilter
implements EventHandler {
    private static final int HISTORY_SIZE = 100;
    private final EventHandler rawHandler;
    private final FilterType filter;
    private final Transformer[] transformers;
    private final double[] updates;
    private boolean forward;
    private double extremeT;

    public EventFilter(EventHandler rawHandler, FilterType filter2) {
        this.rawHandler = rawHandler;
        this.filter = filter2;
        this.transformers = new Transformer[100];
        this.updates = new double[100];
    }

    public void init(double t0, double[] y0, double t2) {
        this.rawHandler.init(t0, y0, t2);
        this.forward = t2 >= t0;
        this.extremeT = this.forward ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        Arrays.fill((Object[])this.transformers, (Object)Transformer.UNINITIALIZED);
        Arrays.fill(this.updates, this.extremeT);
    }

    public double g(double t2, double[] y) {
        double rawG = this.rawHandler.g(t2, y);
        if (this.forward) {
            int last2 = this.transformers.length - 1;
            if (this.extremeT < t2) {
                Transformer previous = this.transformers[last2];
                Transformer next = this.filter.selectTransformer(previous, rawG, this.forward);
                if (next != previous) {
                    System.arraycopy(this.updates, 1, this.updates, 0, last2);
                    System.arraycopy(this.transformers, 1, this.transformers, 0, last2);
                    this.updates[last2] = this.extremeT;
                    this.transformers[last2] = next;
                }
                this.extremeT = t2;
                return next.transformed(rawG);
            }
            for (int i = last2; i > 0; --i) {
                if (!(this.updates[i] <= t2)) continue;
                return this.transformers[i].transformed(rawG);
            }
            return this.transformers[0].transformed(rawG);
        }
        if (t2 < this.extremeT) {
            Transformer previous = this.transformers[0];
            Transformer next = this.filter.selectTransformer(previous, rawG, this.forward);
            if (next != previous) {
                System.arraycopy(this.updates, 0, this.updates, 1, this.updates.length - 1);
                System.arraycopy(this.transformers, 0, this.transformers, 1, this.transformers.length - 1);
                this.updates[0] = this.extremeT;
                this.transformers[0] = next;
            }
            this.extremeT = t2;
            return next.transformed(rawG);
        }
        for (int i = 0; i < this.updates.length - 1; ++i) {
            if (!(t2 <= this.updates[i])) continue;
            return this.transformers[i].transformed(rawG);
        }
        return this.transformers[this.updates.length - 1].transformed(rawG);
    }

    public EventHandler.Action eventOccurred(double t2, double[] y, boolean increasing) {
        return this.rawHandler.eventOccurred(t2, y, this.filter.getTriggeredIncreasing());
    }

    public void resetState(double t2, double[] y) {
        this.rawHandler.resetState(t2, y);
    }
}

