/*
 * Decompiled with CFR 0.152.
 */
package log;

import config.Config;
import config.ConfigType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import log.ArtifactLocation;
import log.ArtifactManager$WhenMappings;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tac.DebuggableProgram;
import tac.DumpType;
import tac.TACFile;
import utils.ArtifactFileUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J \u0010\u0018\u001a\u0004\u0018\u00010\u0019\"\b\b\u0000\u0010\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001dJ-\u0010\u0018\u001a\u0004\u0018\u00010\u0019\"\b\b\u0000\u0010\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001d2\u0006\u0010\u001e\u001a\u0002H\u001a\u00a2\u0006\u0002\u0010\u001fJ7\u0010\u0018\u001a\u0004\u0018\u00010\u0019\"\b\b\u0000\u0010\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001d2\u0006\u0010\u001e\u001a\u0002H\u001a2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010 J5\u0010!\u001a\u00020\u0019\"\b\b\u0000\u0010\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001d2\u0006\u0010\u001e\u001a\u0002H\u001a2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010 J\u0014\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%J\u0010\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004H\u0016J\u0014\u0010'\u001a\u00020\u00042\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%J\u000e\u0010'\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u0010\u0010(\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020\u0004J\u0018\u0010)\u001a\n **\u0004\u0018\u00010\u00040\u00042\u0006\u0010+\u001a\u00020\u0013H\u0004J\u0014\u0010,\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%J\u0018\u0010,\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u0013J(\u0010-\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150/J$\u0010-\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00042\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150/H\u0016J\"\u00100\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150/R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0012\u0010\u000b\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Llog/ArtifactManager;", "", "()V", "debugDir", "", "getDebugDir", "()Ljava/lang/String;", "formulasDir", "getFormulasDir", "inputsDir", "getInputsDir", "mainPath", "getMainPath", "mainReportsDir", "getMainReportsDir", "outputDir", "getOutputDir", "registeredArtifacts", "", "Llog/ArtifactLocation;", "backup", "", "filename", "location", "dumpCodeArtifacts", "Ltac/TACFile;", "T", "Ltac/DumpType;", "p", "Ltac/DebuggableProgram;", "dumpType", "(Ltac/DebuggableProgram;Ltac/DumpType;)Ltac/TACFile;", "(Ltac/DebuggableProgram;Ltac/DumpType;Llog/ArtifactLocation;)Ltac/TACFile;", "dumpMandatoryCodeArtifacts", "getArtifactHandle", "Ljava/io/OutputStreamWriter;", "conf", "Lconfig/ConfigType;", "name", "getRegisteredArtifactPath", "getRegisteredArtifactPathOrNull", "getWhere", "kotlin.jvm.PlatformType", "l", "registerArtifact", "useArtifact", "action", "Lkotlin/Function1;", "useTempArtifact", "Shared"})
public abstract class ArtifactManager {
    private final Map<String, ArtifactLocation> registeredArtifacts;

    @NotNull
    public abstract String getMainPath();

    protected final String getWhere(@NotNull ArtifactLocation l) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)l, "l");
        switch (ArtifactManager$WhenMappings.$EnumSwitchMapping$0[l.ordinal()]) {
            case 1: {
                string2 = System.getProperty("user.dir");
                break;
            }
            default: {
                if (l.isDefault()) {
                    string2 = l.get(this.getMainPath());
                    break;
                }
                File file = new File(l.get());
                boolean bl = false;
                boolean bl2 = false;
                File f = file;
                boolean bl3 = false;
                if (f.isAbsolute()) {
                    string2 = f.getAbsolutePath();
                    break;
                }
                string2 = l.get(".");
            }
        }
        return string2;
    }

    @NotNull
    public String getMainReportsDir() {
        String string2 = this.getWhere(ArtifactLocation.REPORTS);
        Intrinsics.checkExpressionValueIsNotNull(string2, "getWhere(ArtifactLocation.REPORTS)");
        return string2;
    }

    @NotNull
    public String getOutputDir() {
        String string2 = this.getWhere(ArtifactLocation.OUTPUTS);
        Intrinsics.checkExpressionValueIsNotNull(string2, "getWhere(ArtifactLocation.OUTPUTS)");
        return string2;
    }

    @NotNull
    public String getDebugDir() {
        String string2 = this.getWhere(ArtifactLocation.DEBUGS);
        Intrinsics.checkExpressionValueIsNotNull(string2, "getWhere(ArtifactLocation.DEBUGS)");
        return string2;
    }

    @NotNull
    public String getFormulasDir() {
        String string2 = this.getWhere(ArtifactLocation.FORMULAS);
        Intrinsics.checkExpressionValueIsNotNull(string2, "getWhere(ArtifactLocation.FORMULAS)");
        return string2;
    }

    @NotNull
    public String getInputsDir() {
        String string2 = this.getWhere(ArtifactLocation.INPUT);
        Intrinsics.checkExpressionValueIsNotNull(string2, "getWhere(ArtifactLocation.INPUT)");
        return string2;
    }

    @Nullable
    public final <T extends DumpType> TACFile dumpCodeArtifacts(@NotNull DebuggableProgram<T> p) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        return this.dumpCodeArtifacts(p, p.getDefaultType());
    }

    @Nullable
    public final <T extends DumpType> TACFile dumpCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull T dumpType) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        Intrinsics.checkParameterIsNotNull(dumpType, "dumpType");
        return this.dumpCodeArtifacts(p, dumpType, ArtifactLocation.DEBUGS);
    }

    @Nullable
    public <T extends DumpType> TACFile dumpCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull T dumpType, @NotNull ArtifactLocation location) {
        TACFile tACFile;
        Intrinsics.checkParameterIsNotNull(p, "p");
        Intrinsics.checkParameterIsNotNull(dumpType, "dumpType");
        Intrinsics.checkParameterIsNotNull((Object)location, "location");
        if (!((Boolean)Config.INSTANCE.getLowFootprint().get()).booleanValue() && dumpType.isEnabled()) {
            String string2 = this.getWhere(location);
            Intrinsics.checkExpressionValueIsNotNull(string2, "getWhere(location)");
            tACFile = p.dump(dumpType, string2);
        } else {
            tACFile = null;
        }
        return tACFile;
    }

    @NotNull
    public <T extends DumpType> TACFile dumpMandatoryCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull T dumpType, @NotNull ArtifactLocation location) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        Intrinsics.checkParameterIsNotNull(dumpType, "dumpType");
        Intrinsics.checkParameterIsNotNull((Object)location, "location");
        String string2 = this.getWhere(location);
        Intrinsics.checkExpressionValueIsNotNull(string2, "getWhere(location)");
        return p.dump(dumpType, string2);
    }

    @Nullable
    public final String getRegisteredArtifactPathOrNull(@NotNull String name) {
        String string2;
        Intrinsics.checkParameterIsNotNull(name, "name");
        ArtifactLocation artifactLocation = this.registeredArtifacts.get(name);
        if (artifactLocation != null) {
            ArtifactLocation artifactLocation2 = artifactLocation;
            boolean bl = false;
            boolean bl2 = false;
            ArtifactLocation l = artifactLocation2;
            boolean bl3 = false;
            string2 = this.getWhere(l) + File.separator + name;
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final String getRegisteredArtifactPath(@NotNull ConfigType<String> conf) {
        Intrinsics.checkParameterIsNotNull(conf, "conf");
        return this.getRegisteredArtifactPath(conf.get());
    }

    @NotNull
    public final String getRegisteredArtifactPath(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String string2 = this.getRegisteredArtifactPathOrNull(name);
        if (string2 == null) {
            string2 = "N/A";
        }
        return string2;
    }

    public final void registerArtifact(@NotNull ConfigType<String> conf) {
        Intrinsics.checkParameterIsNotNull(conf, "conf");
        this.registerArtifact(conf.get(), Intrinsics.areEqual(conf.get(), conf.getDefault()) ^ true ? ArtifactLocation.CWD : ArtifactLocation.REPORTS);
    }

    public final void registerArtifact(@NotNull String name, @NotNull ArtifactLocation location) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull((Object)location, "location");
        this.registeredArtifacts.putIfAbsent(name, location);
    }

    public static /* synthetic */ void registerArtifact$default(ArtifactManager artifactManager, String string2, ArtifactLocation artifactLocation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerArtifact");
        }
        if ((n & 2) != 0) {
            artifactLocation = ArtifactLocation.REPORTS;
        }
        artifactManager.registerArtifact(string2, artifactLocation);
    }

    public final void useArtifact(@NotNull ConfigType<String> conf, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull(conf, "conf");
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.useArtifact(conf.get(), action);
    }

    public void useArtifact(@NotNull String name, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(action, "action");
        String fullPath = this.getRegisteredArtifactPathOrNull(name);
        if (fullPath == null) {
            return;
        }
        action.invoke(fullPath);
    }

    @NotNull
    public final OutputStreamWriter getArtifactHandle(@NotNull ConfigType<String> conf) {
        Intrinsics.checkParameterIsNotNull(conf, "conf");
        return this.getArtifactHandle(conf.get());
    }

    @NotNull
    public OutputStreamWriter getArtifactHandle(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String fullPath = this.getRegisteredArtifactPathOrNull(name);
        if (fullPath == null) {
            String string2 = "Non existing artifact " + name;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return new OutputStreamWriter(new FileOutputStream(fullPath));
    }

    public void backup(@NotNull String filename, @NotNull ArtifactLocation location) {
        Intrinsics.checkParameterIsNotNull(filename, "filename");
        Intrinsics.checkParameterIsNotNull((Object)location, "location");
        try {
            File file = new File(ArtifactFileUtils.Companion.getNameFromPath(filename));
            String target = this.getWhere(location) + File.separator + file.getName();
            if (file.isDirectory()) {
                FilesKt.copyRecursively$default(file, new File(target), false, null, 6, null);
            } else {
                FilesKt.copyTo$default(file, new File(target), false, 0, 6, null);
            }
        }
        catch (Exception e) {
            Logger.Companion.alwaysError("Failed to backup " + filename);
        }
    }

    @NotNull
    public final String useTempArtifact(@NotNull String name, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(action, "action");
        File tmpFile = File.createTempFile(name, null);
        tmpFile.deleteOnExit();
        File file = tmpFile;
        Intrinsics.checkExpressionValueIsNotNull(file, "tmpFile");
        String string2 = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string2, "tmpFile.path");
        action.invoke(string2);
        String string3 = tmpFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string3, "tmpFile.path");
        return string3;
    }

    public ArtifactManager() {
        Map map2;
        ArtifactManager artifactManager = this;
        boolean bl = false;
        artifactManager.registeredArtifacts = map2 = (Map)new LinkedHashMap();
    }
}

