/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import compiler.ABI;
import compiler.CertoraJsonSrcMapping;
import compiler.SolcJsonSrcMapping;
import compiler.SolidityParserToolsKt;
import compiler.SourceList;
import compiler.SrcMapping;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.builtins.CollectionSerializersKt;
import kotlinx.serialization.json.Json;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0011\u001a\u00020\u0006\u001a$\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fj\u0002`\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0006\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"logger", "Lmu/KLogger;", "getABI", "", "Lcompiler/ABI;", "fileName", "", "getBytecodeAsText", "getSrcMapping", "Lcompiler/SrcMapping;", "getSrcMappingAsText", "getSrclist", "", "", "parseSolcSrcmapJson", "Lcompiler/SolcJsonSrcMapping;", "parseSrcMapping", "srcMap", "parseVariableMapping", "Lcompiler/VariableMapping;", "varMap", "solcJsonSrcMappingToCertora", "Lcompiler/CertoraJsonSrcMapping;", "solcJsonSrcMapping", "Shared"})
public final class SolidityParserToolsKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);

    @NotNull
    public static final SolcJsonSrcMapping parseSolcSrcmapJson(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        try {
            FileReader reader = new FileReader(fileName);
            String output = TextStreamsKt.readText(reader);
            logger.info((Function0<? extends Object>)new Function0<String>(output){
                final /* synthetic */ String $output;

                @NotNull
                public final String invoke() {
                    return this.$output;
                }
                {
                    this.$output = string2;
                    super(0);
                }
            });
            SolcJsonSrcMapping jsonObj = (SolcJsonSrcMapping)Json.Default.getNonstrict().parse(SolcJsonSrcMapping.Companion.serializer(), output);
            return jsonObj;
        }
        catch (IOException e) {
            List<String> list2;
            logger.error("solc did not generate " + fileName + ", so will be missing source mappings");
            boolean bl = false;
            Map map2 = MapsKt.emptyMap();
            bl = false;
            List<String> list3 = list2 = CollectionsKt.emptyList();
            Map map3 = map2;
            return new SolcJsonSrcMapping(map3, list3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CertoraJsonSrcMapping solcJsonSrcMappingToCertora(@NotNull SolcJsonSrcMapping solcJsonSrcMapping) {
        Intrinsics.checkParameterIsNotNull(solcJsonSrcMapping, "solcJsonSrcMapping");
        boolean bl = false;
        Map srcMapping = new LinkedHashMap();
        boolean bl2 = false;
        Map sourceList = new LinkedHashMap();
        boolean bl3 = false;
        Map sourceToFile = new LinkedHashMap();
        Map<String, Map<String, String>> $this$forEach$iv = solcJsonSrcMapping.getContracts();
        boolean $i$f$forEach = false;
        Map<String, Map<String, String>> map2 = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<Map.Entry<String, Map<String, String>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void contractFile;
            String string2;
            String[] stringArray;
            Map.Entry<String, Map<String, String>> element$iv;
            Map.Entry<String, Map<String, String>> entry = element$iv = iterator2.next();
            boolean bl5 = false;
            String string3 = entry.getValue().get("srcmap-runtime");
            boolean bl6 = false;
            boolean bl7 = false;
            String it = string3;
            boolean bl8 = false;
            if (it == null) {
                throw (Throwable)new Exception("In " + entry + " there is no srcmap-runtime, possibly indicating a problem with solc");
            }
            String srcmap = it;
            String contractFileAndName = entry.getKey();
            int lastColon = StringsKt.lastIndexOf$default((CharSequence)contractFileAndName, ':', 0, false, 6, null);
            List<String> list2 = contractFileAndName;
            int n = 0;
            int n2 = 0;
            String[] stringArray2 = stringArray = new String[2];
            boolean bl9 = false;
            String string4 = list2;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, lastColon);
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            stringArray[n2] = string2 = string5;
            list2 = contractFileAndName;
            n = lastColon + 1;
            n2 = 1;
            stringArray = stringArray2;
            bl9 = false;
            String string6 = list2;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue(string7, "(this as java.lang.String).substring(startIndex)");
            stringArray[n2] = string2 = string7;
            list2 = bl8 = CollectionsKt.listOf(stringArray2);
            n = 0;
            String string8 = (String)list2.get(0);
            list2 = bl8;
            n = 0;
            String contractName = list2.get(1);
            srcMapping.put(contractName, srcmap);
            int sourceListIndex = solcJsonSrcMapping.getSourceList().indexOf(contractFile);
            sourceList.put(sourceListIndex, contractName);
            sourceToFile.put(sourceListIndex, contractFile);
            logger.info((Function0<? extends Object>)new Function0<String>(contractName, (String)contractFile, sourceListIndex, srcmap){
                final /* synthetic */ String $contractName;
                final /* synthetic */ String $contractFile;
                final /* synthetic */ int $sourceListIndex;
                final /* synthetic */ String $srcmap;

                @NotNull
                public final String invoke() {
                    return "Added srcmapping " + this.$contractName + " (file " + this.$contractFile + "): (" + this.$sourceListIndex + ") -> " + this.$srcmap;
                }
                {
                    this.$contractName = string2;
                    this.$contractFile = string3;
                    this.$sourceListIndex = n;
                    this.$srcmap = string4;
                    super(0);
                }
            });
        }
        return new CertoraJsonSrcMapping(srcMapping, sourceList, sourceToFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Integer, String> getSrclist(@NotNull String fileName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        FileReader reader = new FileReader(fileName);
        String output = TextStreamsKt.readText(reader);
        List jsonObj = (List)Json.Default.parse(CollectionSerializersKt.ListSerializer(SourceList.Companion.serializer()), output);
        Iterable $this$map$iv = jsonObj;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SourceList sourceList = (SourceList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair<Integer, String> pair = new Pair<Integer, String>(it.getContractIndex(), it.getContractName());
            collection.add(pair);
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }

    @NotNull
    public static final String getBytecodeAsText(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        try {
            FileReader reader = new FileReader(fileName);
            String output = TextStreamsKt.readText(reader);
            return output;
        }
        catch (Exception e) {
            logger.warn((Function0<? extends Object>)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Encountered exception " + this.$e + ", not getting bytecode";
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            return "";
        }
    }

    @NotNull
    public static final String getSrcMappingAsText(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        try {
            FileReader reader = new FileReader(fileName);
            String output = TextStreamsKt.readText(reader);
            return output;
        }
        catch (Exception e) {
            logger.warn((Function0<? extends Object>)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Encountered exception " + this.$e + ", not generating source map";
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            return "";
        }
    }

    @NotNull
    public static final List<SrcMapping> getSrcMapping(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        try {
            FileReader reader = new FileReader(fileName);
            String output = TextStreamsKt.readText(reader);
            return SolidityParserToolsKt.parseSrcMapping(output);
        }
        catch (Exception e) {
            logger.warn((Function0<? extends Object>)new Function0<String>(e){
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Encountered exception " + this.$e + ", not generating source map";
                }
                {
                    this.$e = exception;
                    super(0);
                }
            });
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public static final List<SrcMapping> parseSrcMapping(@NotNull String srcMap) {
        List perInstruction;
        parseSrcMapping.1 $fun$convertFull$1;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull(srcMap, "srcMap");
                $fun$convertFull$1 = parseSrcMapping.1.INSTANCE;
                perInstruction = StringsKt.split$default((CharSequence)srcMap, new String[]{";"}, false, 0, 6, null);
                if (perInstruction.size() == 0) break block6;
                if (perInstruction.size() != 1) break block7;
                String string2 = (String)CollectionsKt.first(perInstruction);
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                if (!StringsKt.isBlank(((Object)StringsKt.trim((CharSequence)string3)).toString())) break block7;
            }
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        String first2 = (String)CollectionsKt.first(perInstruction);
        SrcMapping last2 = null;
        boolean bl = false;
        List retList = new ArrayList();
        last2 = $fun$convertFull$1.invoke(first2, last2);
        retList.add(last2);
        Iterable $this$forEach$iv = CollectionsKt.drop(perInstruction, 1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String i = (String)element$iv;
            boolean bl2 = false;
            SrcMapping srcMapping = last2 = parseSrcMapping.1.INSTANCE.invoke(i, last2);
            if (srcMapping == null) {
                Intrinsics.throwNpe();
            }
            retList.add(srcMapping);
        }
        return retList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Map<String, Integer>> parseVariableMapping(@NotNull String varMap) {
        void $this$mapTo$iv$iv;
        List perInstruction;
        block14: {
            block13: {
                Intrinsics.checkParameterIsNotNull(varMap, "varMap");
                perInstruction = StringsKt.split$default((CharSequence)varMap, new String[]{";"}, false, 0, 6, null);
                if (perInstruction.isEmpty()) break block13;
                if (perInstruction.size() != 1) break block14;
                String string2 = (String)CollectionsKt.first(perInstruction);
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                if (!StringsKt.isBlank(((Object)StringsKt.trim((CharSequence)string3)).toString())) break block14;
            }
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = perInstruction;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map map2;
            void mapping;
            String string4 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)mapping;
            boolean bl2 = false;
            if (charSequence.length() == 0) {
                boolean bl3 = false;
                map2 = MapsKt.emptyMap();
            } else {
                void $this$associateByTo$iv$iv;
                Object object;
                Object object2;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)mapping, new String[]{","}, false, 0, 6, null);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    Pair pair;
                    void it;
                    String string5 = (String)item$iv$iv2;
                    object2 = destination$iv$iv2;
                    boolean bl4 = false;
                    List list2 = StringsKt.split$default((CharSequence)it, new String[]{":"}, false, 0, 6, null);
                    if (list2.isEmpty()) {
                        pair = null;
                    } else if (list2.size() == 2) {
                        pair = new Pair(list2.get(0), list2.get(1));
                    } else {
                        throw (Throwable)new Exception("malformed variable mapping: " + (String)mapping + ", " + "should have exactly 2 elements at " + (String)it);
                    }
                    object = pair;
                    object2.add(object);
                }
                Iterable $this$associateBy$iv = CollectionsKt.filterNotNull((List)destination$iv$iv2);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                destination$iv$iv2 = $this$associateBy$iv;
                Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    Pair it;
                    Pair bl4 = (Pair)element$iv$iv;
                    object2 = destination$iv$iv3;
                    boolean bl5 = false;
                    object = (String)it.getFirst();
                    it = (Pair)element$iv$iv;
                    boolean bl6 = false;
                    Pair pair = it;
                    String string6 = pair != null ? (String)pair.getSecond() : null;
                    boolean bl7 = false;
                    Integer n = Integer.parseInt(string6);
                    object2.put(object, n);
                }
                map2 = destination$iv$iv3;
            }
            Map map3 = map2;
            collection.add(map3);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<ABI> getABI(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        try {
            FileReader abiReader = new FileReader(fileName);
            String output = TextStreamsKt.readText(abiReader);
            List jsonObj = (List)Json.Default.parse(CollectionSerializersKt.ListSerializer(ABI.Companion.serializer()), output);
            return jsonObj;
        }
        catch (Exception e) {
            logger.error("Encountered exception " + e + ", not generating ABI");
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }
}

