/*
 * Decompiled with CFR 0.152.
 */
package com.ionspin.kotlin.bignum.decimal;

import com.ionspin.kotlin.bignum.decimal.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/ionspin/kotlin/bignum/decimal/DecimalMode;", "", "decimalPrecision", "", "roundingMode", "Lcom/ionspin/kotlin/bignum/decimal/RoundingMode;", "scale", "(JLcom/ionspin/kotlin/bignum/decimal/RoundingMode;J)V", "getDecimalPrecision", "()J", "isPrecisionUnlimited", "", "()Z", "getRoundingMode", "()Lcom/ionspin/kotlin/bignum/decimal/RoundingMode;", "getScale", "usingScale", "getUsingScale", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "bignum"})
public final class DecimalMode {
    private final boolean isPrecisionUnlimited;
    private final boolean usingScale;
    private final long decimalPrecision;
    @NotNull
    private final RoundingMode roundingMode;
    private final long scale;
    @NotNull
    private static final DecimalMode DEFAULT;
    @NotNull
    private static final DecimalMode US_CURRENCY;
    @NotNull
    public static final Companion Companion;

    public final boolean isPrecisionUnlimited() {
        return this.isPrecisionUnlimited;
    }

    public final boolean getUsingScale() {
        return this.usingScale;
    }

    public final long getDecimalPrecision() {
        return this.decimalPrecision;
    }

    @NotNull
    public final RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public final long getScale() {
        return this.scale;
    }

    public DecimalMode(long decimalPrecision, @NotNull RoundingMode roundingMode, long scale) {
        Intrinsics.checkNotNullParameter((Object)roundingMode, "roundingMode");
        this.decimalPrecision = decimalPrecision;
        this.roundingMode = roundingMode;
        this.scale = scale;
        this.isPrecisionUnlimited = this.decimalPrecision == 0L;
        this.usingScale = this.scale >= 0L;
        if (this.decimalPrecision == 0L && this.roundingMode != RoundingMode.NONE) {
            throw (Throwable)new ArithmeticException("Rounding mode with 0 digits precision.");
        }
        if (this.scale < (long)-1) {
            throw (Throwable)new ArithmeticException("Negative Scale is unsupported.");
        }
        if (this.usingScale && this.roundingMode == RoundingMode.NONE) {
            throw (Throwable)new ArithmeticException("Scale of " + this.scale + " digits to the right of the decimal requires a RoundingMode that is not NONE.");
        }
        if (this.usingScale && !this.isPrecisionUnlimited && this.scale >= this.decimalPrecision) {
            throw (Throwable)new ArithmeticException("Scale of " + this.scale + " digits to the right of the decimal must be less than precision " + this.decimalPrecision + '.');
        }
    }

    public /* synthetic */ DecimalMode(long l, RoundingMode roundingMode, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            roundingMode = RoundingMode.NONE;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        this(l, roundingMode, l2);
    }

    public DecimalMode() {
        this(0L, null, 0L, 7, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new DecimalMode(0L, null, 0L, 7, null);
        US_CURRENCY = new DecimalMode(30L, RoundingMode.ROUND_HALF_AWAY_FROM_ZERO, 2L);
    }

    public final long component1() {
        return this.decimalPrecision;
    }

    @NotNull
    public final RoundingMode component2() {
        return this.roundingMode;
    }

    public final long component3() {
        return this.scale;
    }

    @NotNull
    public final DecimalMode copy(long decimalPrecision, @NotNull RoundingMode roundingMode, long scale) {
        Intrinsics.checkNotNullParameter((Object)roundingMode, "roundingMode");
        return new DecimalMode(decimalPrecision, roundingMode, scale);
    }

    public static /* synthetic */ DecimalMode copy$default(DecimalMode decimalMode, long l, RoundingMode roundingMode, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = decimalMode.decimalPrecision;
        }
        if ((n & 2) != 0) {
            roundingMode = decimalMode.roundingMode;
        }
        if ((n & 4) != 0) {
            l2 = decimalMode.scale;
        }
        return decimalMode.copy(l, roundingMode, l2);
    }

    @NotNull
    public String toString() {
        return "DecimalMode(decimalPrecision=" + this.decimalPrecision + ", roundingMode=" + (Object)((Object)this.roundingMode) + ", scale=" + this.scale + ")";
    }

    public int hashCode() {
        long l = this.decimalPrecision;
        RoundingMode roundingMode = this.roundingMode;
        long l2 = this.scale;
        return ((int)(l ^ l >>> 32) * 31 + (roundingMode != null ? ((Object)((Object)roundingMode)).hashCode() : 0)) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DecimalMode)) break block3;
                DecimalMode decimalMode = (DecimalMode)object;
                if (this.decimalPrecision != decimalMode.decimalPrecision || !Intrinsics.areEqual((Object)this.roundingMode, (Object)decimalMode.roundingMode) || this.scale != decimalMode.scale) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/ionspin/kotlin/bignum/decimal/DecimalMode$Companion;", "", "()V", "DEFAULT", "Lcom/ionspin/kotlin/bignum/decimal/DecimalMode;", "getDEFAULT", "()Lcom/ionspin/kotlin/bignum/decimal/DecimalMode;", "US_CURRENCY", "getUS_CURRENCY", "bignum"})
    public static final class Companion {
        @NotNull
        public final DecimalMode getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final DecimalMode getUS_CURRENCY() {
            return US_CURRENCY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

