/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Type;
import java.util.List;
import java.util.stream.Collectors;
import spec.cvlast.CVLInbuiltSimpleTypes;
import spec.cvlast.CVLInbuiltStructTypes;
import spec.cvlast.CVLType;

public abstract class InbuiltType
implements Type {

    public static class Simple
    extends InbuiltType {
        private final CVLInbuiltSimpleTypes cvlInbuiltSimpleType;

        public Simple(String _typeId) {
            this.cvlInbuiltSimpleType = CVLInbuiltSimpleTypes.Companion.valueFromString(_typeId);
            if (this.cvlInbuiltSimpleType == null) {
                throw new IllegalStateException("Found no CVLInbuiltSimpleTypes for type Id " + _typeId);
            }
        }

        public Simple(List<Simple> _tupleComponents) {
            this.cvlInbuiltSimpleType = new CVLInbuiltSimpleTypes.EVMStruct(_tupleComponents.stream().map(comp -> comp.cvlInbuiltSimpleType).collect(Collectors.toList()));
        }

        public Simple(Simple _baseType, List<String> _dimensions) {
            this.cvlInbuiltSimpleType = new CVLInbuiltSimpleTypes.EVMArray(_baseType.cvlInbuiltSimpleType, _dimensions.stream().map(Integer::valueOf).collect(Collectors.toList()));
        }

        @Override
        public String getName() {
            return this.cvlInbuiltSimpleType.getKeyword();
        }

        public String toString() {
            return String.format("Type(%s)", this.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple type1 = (Simple)o;
            return this.cvlInbuiltSimpleType.equals(type1.cvlInbuiltSimpleType);
        }

        @Override
        public CVLType kotlinize() {
            return this.cvlInbuiltSimpleType.getCvlType();
        }
    }

    public static class Struct
    extends InbuiltType {
        private final CVLInbuiltStructTypes cvlInbuiltStructType;
        private final String typeId;

        public Struct(String _typeId) {
            this.cvlInbuiltStructType = CVLInbuiltStructTypes.Companion.valueFromString(_typeId);
            if (this.cvlInbuiltStructType == null) {
                throw new IllegalStateException("Found no CVLInbuiltStructTypes for type Id " + _typeId);
            }
            this.typeId = _typeId;
        }

        @Override
        public String getName() {
            return this.typeId;
        }

        public String toString() {
            return String.format("Type(%s)", this.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Struct)) {
                return false;
            }
            Struct type1 = (Struct)o;
            return this.typeId.equals(type1.typeId);
        }

        @Override
        public CVLType kotlinize() {
            return this.cvlInbuiltStructType.getCvlType();
        }
    }
}

