/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.CVLFunction;
import com.certora.evmverifier.cvl.Definitions;
import com.certora.evmverifier.cvl.GhostDecl;
import com.certora.evmverifier.cvl.Hook;
import com.certora.evmverifier.cvl.ImportedContract;
import com.certora.evmverifier.cvl.ImportedEvent;
import com.certora.evmverifier.cvl.ImportedFunction;
import com.certora.evmverifier.cvl.Invariant;
import com.certora.evmverifier.cvl.MacroDefinition;
import com.certora.evmverifier.cvl.Rule;
import com.certora.evmverifier.cvl.UninterpretedSortDecl;
import java.util.List;
import kotlinizable.Kotlinizable;
import kotlinizable.Kotlinizer;
import spec.cvlast.CVLAst;

public class Ast
implements Kotlinizable<CVLAst> {
    public int pragma = 0;
    public List<ImportedFunction> imports;
    public List<ImportedEvent> events;
    public List<Rule> rules;
    public List<CVLFunction> subs;
    public List<Invariant> invs;
    public List<UninterpretedSortDecl> sorts;
    public List<GhostDecl> ghosts;
    public List<MacroDefinition> macros;
    public List<Hook> hooks;
    public List<ImportedContract> importedContracts;

    public Ast(String _pragma, List<ImportedFunction> _imports, List<ImportedEvent> _events, Definitions definitions2, List<ImportedContract> _contracts) {
        this.pragma = this.parsePragma(_pragma);
        this.imports = _imports;
        this.events = _events;
        this.rules = definitions2.rules;
        this.subs = definitions2.subs;
        this.invs = definitions2.invs;
        this.sorts = definitions2.sorts;
        this.ghosts = definitions2.ghosts;
        this.macros = definitions2.macros;
        this.hooks = definitions2.hooks;
        this.importedContracts = _contracts;
    }

    private Integer parsePragma(String pragma) {
        int mainSeparator = pragma.indexOf(".");
        int majorVersion = Integer.parseInt(pragma.substring(0, mainSeparator));
        int minorVersion = Integer.parseInt(pragma.substring(mainSeparator + 1));
        return majorVersion * 100 + minorVersion;
    }

    @Override
    public CVLAst kotlinize() {
        return new CVLAst(this.pragma, Kotlinizer.kotlinizeList(this.imports), Kotlinizer.kotlinizeList(this.events), Kotlinizer.kotlinizeList(this.rules), Kotlinizer.kotlinizeList(this.subs), Kotlinizer.kotlinizeList(this.invs), Kotlinizer.kotlinizeList(this.sorts), Kotlinizer.kotlinizeList(this.ghosts), Kotlinizer.kotlinizeList(this.macros), Kotlinizer.kotlinizeList(this.hooks), Kotlinizer.kotlinizeList(this.importedContracts), null);
    }
}

