# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lightly.openapi_generated.swagger_client.api_client import ApiClient


class MetaDataConfigurationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_meta_data_configuration(self, body, **kwargs):  # noqa: E501
        """create_meta_data_configuration  # noqa: E501

        Create a new metadata configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_meta_data_configuration(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigurationSetRequest body: (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_meta_data_configuration_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_meta_data_configuration_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_meta_data_configuration_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_meta_data_configuration  # noqa: E501

        Create a new metadata configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_meta_data_configuration_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigurationSetRequest body: (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_meta_data_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_meta_data_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/configuration/metadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_meta_data_configuration_by_id(self, configuration_id, **kwargs):  # noqa: E501
        """get_meta_data_configuration_by_id  # noqa: E501

        Get a specific metadata configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meta_data_configuration_by_id(configuration_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID configuration_id: ObjectId of the metadata configuration (required)
        :return: ConfigurationData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_meta_data_configuration_by_id_with_http_info(configuration_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_meta_data_configuration_by_id_with_http_info(configuration_id, **kwargs)  # noqa: E501
            return data

    def get_meta_data_configuration_by_id_with_http_info(self, configuration_id, **kwargs):  # noqa: E501
        """get_meta_data_configuration_by_id  # noqa: E501

        Get a specific metadata configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meta_data_configuration_by_id_with_http_info(configuration_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID configuration_id: ObjectId of the metadata configuration (required)
        :return: ConfigurationData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['configuration_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_meta_data_configuration_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'configuration_id' is set
        if self.api_client.client_side_validation and ('configuration_id' not in params or
                                                       params['configuration_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `configuration_id` when calling `get_meta_data_configuration_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'configuration_id' in params:
            path_params['configurationId'] = params['configuration_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/configuration/metadata/{configurationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigurationData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_meta_data_configurations(self, **kwargs):  # noqa: E501
        """get_meta_data_configurations  # noqa: E501

        Get the all metadata configurations that exist for a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meta_data_configurations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[ConfigurationData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_meta_data_configurations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_meta_data_configurations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_meta_data_configurations_with_http_info(self, **kwargs):  # noqa: E501
        """get_meta_data_configurations  # noqa: E501

        Get the all metadata configurations that exist for a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meta_data_configurations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[ConfigurationData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_meta_data_configurations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/configuration/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ConfigurationData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_meta_data_configuration_by_id(self, body, configuration_id, **kwargs):  # noqa: E501
        """update_meta_data_configuration_by_id  # noqa: E501

        update a specific metadata configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_meta_data_configuration_by_id(body, configuration_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigurationSetRequest body: (required)
        :param MongoObjectID configuration_id: ObjectId of the metadata configuration (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_meta_data_configuration_by_id_with_http_info(body, configuration_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_meta_data_configuration_by_id_with_http_info(body, configuration_id, **kwargs)  # noqa: E501
            return data

    def update_meta_data_configuration_by_id_with_http_info(self, body, configuration_id, **kwargs):  # noqa: E501
        """update_meta_data_configuration_by_id  # noqa: E501

        update a specific metadata configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_meta_data_configuration_by_id_with_http_info(body, configuration_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigurationSetRequest body: (required)
        :param MongoObjectID configuration_id: ObjectId of the metadata configuration (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'configuration_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_meta_data_configuration_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_meta_data_configuration_by_id`")  # noqa: E501
        # verify the required parameter 'configuration_id' is set
        if self.api_client.client_side_validation and ('configuration_id' not in params or
                                                       params['configuration_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `configuration_id` when calling `update_meta_data_configuration_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'configuration_id' in params:
            path_params['configurationId'] = params['configuration_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/configuration/metadata/{configurationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
