# Generated by Django 2.2.8 on 2019-12-13 16:29

import django.db.models.deletion
import jsonfield.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="DefaultSetting",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "default_type",
                    models.CharField(
                        choices=[
                            ("system", "System Default"),
                            ("configured", "Configured Default"),
                        ],
                        max_length=30,
                    ),
                ),
                ("namespace", models.CharField(max_length=100)),
                ("key", models.CharField(max_length=100)),
                ("value", jsonfield.fields.JSONField()),
            ],
            options={"unique_together": {("default_type", "namespace", "key")},},
        ),
        migrations.CreateModel(
            name="Setting",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("namespace", models.CharField(max_length=100)),
                ("key", models.CharField(max_length=100)),
                ("value", jsonfield.fields.JSONField()),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={"unique_together": {("user", "namespace", "key")},},
        ),
    ]
