# Generated by Django 2.2.8 on 2019-12-13 16:29

import django.db.models.deletion
import jsonfield.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("unplugged", "0008_auto_20190715_1944"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("services_listing", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Metadata",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("priority", models.SmallIntegerField(default=20)),
                (
                    "last_update_status",
                    models.CharField(
                        choices=[
                            ("do-not-fetch", "Do not fetch"),
                            ("pending", "Pending"),
                            ("updating", "Updating"),
                            ("failed", "Failed"),
                            ("success", "Success"),
                        ],
                        db_index=True,
                        default="pending",
                        max_length=20,
                    ),
                ),
                ("last_updated", models.DateTimeField(null=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("identifier", models.CharField(max_length=255, unique=True)),
                ("populated", models.BooleanField(default=False)),
                ("title", models.CharField(max_length=300, null=True)),
                ("cover", models.URLField(max_length=1000, null=True)),
                (
                    "prefetch_related_denormalized",
                    jsonfield.fields.JSONField(blank=True, null=True),
                ),
                ("name", models.CharField(max_length=200)),
                ("year", models.IntegerField(blank=True, null=True)),
                ("season", models.IntegerField(blank=True, null=True)),
                ("episode", models.IntegerField(blank=True, null=True)),
                (
                    "episode_type",
                    models.CharField(blank=True, max_length=200, null=True),
                ),
                ("source", models.CharField(blank=True, max_length=100, null=True)),
                ("fix_type", models.CharField(blank=True, max_length=100, null=True)),
                (
                    "plugin",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_metadata_iteminfo",
                        to="unplugged.Plugin",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="ListingItemRelation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "listingitem",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_iteminfo",
                        to="services_listing.ListingItem",
                    ),
                ),
                (
                    "metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_iteminfo.Metadata",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_iteminfo",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("listingitem", "metadata", "user")},
            },
        ),
    ]
