# Contributing to Sycomore

All contribution proposals are welcome! A contribution is not necessarily finding and fixing bugs; it can also be improvements to the documentation or code samples.

The following guidelines will ensure a smooth contribution process.

- Start by searching in [issues](https://github.com/lamyj/sycomore/issues?q=is%3Aissue) and [pull requests](https://github.com/lamyj/sycomore/pulls?q=is%3Apr) to see if your idea has been proposed previously.
- If you want to report a bug, [open a new issue](https://github.com/lamyj/sycomore/issues/new). Include a clear description of what should have happened and what happened instead, and give as much information as possible about the environment (operating system, version of Sycomore, etc.). If possible, include a minimal code sample which reproduces the problem.
- If you want to solve a bug, improve the documentation, contribute code samples, or otherwise modify the existing resources:
  1. [Fork](https://guides.github.com/activities/forking/) the repository, or create a new branch in your existing fork.
  2. [Commit and push](https://guides.github.com/introduction/git-handbook/) your changes to your repository.
  3. [Open a new pull request](https://github.com/lamyj/sycomore/pulls), describing the problem and proposed solution. Include the relevant [issue number](https://github.com/lamyj/sycomore/issues) if applicable.
- If you want to add a new feature, [open a new issue](https://github.com/lamyj/sycomore/issues/new) to discuss it first.
