"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cf = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const extensions = require("../../extensions");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'redirect-by-geolocation');
// create the cloudfront distribution with extension(s)
const ext = new extensions.RedirectByGeolocation(stack, 'RedirectByGeolocation', {
    countryTable: {
        CN: 'https://amazonaws.cn',
        US: 'https://twitter.com',
    },
});
// CloudfrontWebDistribution
const policy = new cf.OriginRequestPolicy(stack, 'OrigReqPolicy', {
    headerBehavior: cf.OriginRequestHeaderBehavior.allowList('cloudfront-viewer-country'),
});
// create the cloudfront distribution with extension(s)
const dist = new cf.Distribution(stack, 'dist', {
    defaultBehavior: {
        origin: new origins.HttpOrigin('aws.amazon.com'),
        edgeLambdas: [ext],
        originRequestPolicy: {
            originRequestPolicyId: policy.originRequestPolicyId,
        },
    },
});
new cdk.CfnOutput(stack, 'distributionDomainName', {
    value: dist.distributionDomainName,
});
//# sourceMappingURL=data:application/json;base64,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