/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.model;

import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.RaphtoryArrowPartition;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;

public abstract class Entity {
    protected long _globalId;
    protected long _localId;
    protected boolean _initialValue;
    protected long _creationTime = -1L;
    protected long _oldestPoint;
    protected int _historyPtr = -1;
    protected final RaphtoryArrowPartition _rap;
    protected final EntityFieldAccessor[] _fieldAccessors;
    protected final VersionedEntityPropertyAccessor[] _propertyAccessors;
    protected volatile int _refCount = 0;

    public Entity(RaphtoryArrowPartition raphtoryArrowPartition, EntityFieldAccessor[] entityFieldAccessorArray, VersionedEntityPropertyAccessor[] versionedEntityPropertyAccessorArray) {
        this._rap = raphtoryArrowPartition;
        this._fieldAccessors = entityFieldAccessorArray;
        this._propertyAccessors = versionedEntityPropertyAccessorArray;
    }

    public void init(long l, long l2, boolean bl, long l3) {
        this._localId = l;
        this._globalId = l2;
        this._initialValue = bl;
        this._oldestPoint = l3;
        if (this._initialValue) {
            this._creationTime = l3;
        }
    }

    public void reset() {
        int n;
        if (this._fieldAccessors != null) {
            for (n = 0; n < this._fieldAccessors.length; ++n) {
                this._fieldAccessors[n].reset();
            }
        }
        if (this._propertyAccessors != null) {
            for (n = 0; n < this._propertyAccessors.length; ++n) {
                this._propertyAccessors[n].reset();
            }
        }
    }

    public RaphtoryArrowPartition getRaphtory() {
        return this._rap;
    }

    public int getRefCount() {
        return this._refCount;
    }

    public void incRefCount() {
        ++this._refCount;
    }

    public abstract void decRefCount();

    public void resetHistoryData(int n) {
        this._historyPtr = n;
    }

    public long getLocalId() {
        return this._localId;
    }

    public long getGlobalId() {
        return this._globalId;
    }

    public int getHistoryPtr() {
        return this._historyPtr;
    }

    public boolean getInitialValue() {
        return this._initialValue;
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public long getOldestPoint() {
        return this._oldestPoint;
    }

    public void clear() {
        this._globalId = 0L;
        this._localId = 0L;
        this._initialValue = false;
        this._creationTime = -1L;
        this._oldestPoint = -1L;
        this._historyPtr = -1;
    }

    public void recycle() {
    }

    public void reset(long l, long l2, boolean bl, long l3) {
        this._localId = l;
        this._globalId = l2;
        this._initialValue = bl;
        this._creationTime = this._initialValue ? l3 : -1L;
    }

    protected void makeClone(Entity entity) {
        entity._globalId = this._globalId;
        entity._localId = this._localId;
        entity._initialValue = this._initialValue;
        entity._creationTime = this._creationTime;
        entity._oldestPoint = this._oldestPoint;
        entity._historyPtr = this._historyPtr;
    }

    public EntityFieldAccessor getField(int n) {
        return this._fieldAccessors[n];
    }

    public VersionedEntityPropertyAccessor getProperty(int n) {
        return this._propertyAccessors[n];
    }
}

