/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.implementation.VertexPartitionManager;
import com.raphtory.arrowcore.implementation.VertexSnapshotStore;
import com.raphtory.arrowcore.util.ArrowBinarySearch;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;

public class VertexSnapshotPartition {
    private static final ThreadLocal<IntArrayList> _tmpListTL = ThreadLocal.withInitial(IntArrayList::new);
    private static final ThreadLocal<SnapshotVertexTimeComparatorIAL> _vertexTimeCmpTL = ThreadLocal.withInitial(() -> new SnapshotVertexTimeComparatorIAL());
    private static final ThreadLocal<VertexTimeWindowComparator> _timeVertexWindowComparatorTL = ThreadLocal.withInitial(() -> new VertexTimeWindowComparator());
    private final int _partitionId;
    private final VertexPartition _avp;
    private final VertexPartitionManager _apm;
    private VertexSnapshotStore _store;
    private VectorSchemaRoot _snapshotRO;
    private ArrowFileReader _reader;
    private boolean _modified = false;
    private boolean _sorted = false;

    public VertexSnapshotPartition(int n, VertexPartition vertexPartition) {
        this._partitionId = n;
        this._avp = vertexPartition;
        this._apm = vertexPartition._apm;
        this._store = new VertexSnapshotStore();
    }

    public void initialize() {
        this._store.init(null, this._avp);
        this._snapshotRO = VectorSchemaRoot.create((Schema)this._store.createVertexSnapshotSchema(), (BufferAllocator)this._apm.getAllocator());
        this._store.init(this._snapshotRO, this._avp);
    }

    public int takeSnapshot(long l, int n, boolean bl, long l2) {
        return this._store.takeSnapshot(l, n, bl, l2, this._avp);
    }

    public boolean getIsAliveBySnapshotRowId(int n) {
        return this._store._initialValues.get(n) != 0;
    }

    public long getModificationTimeBySnapshotRowId(int n) {
        return this._store._times.get(n);
    }

    public long getVertexIdBySnapshotRowId(int n) {
        return this._store._localIds.get(n);
    }

    public void close() {
        this.clearReader();
    }

    public void saveToFile() {
        try {
            this.sortSnapshotTimes();
            if (this._modified) {
                this._snapshotRO.syncSchema();
                this._snapshotRO.setRowCount(this._store._maxRow);
                File file = this._apm.getSnapshotFile(this._partitionId);
                ArrowFileWriter arrowFileWriter = new ArrowFileWriter(this._snapshotRO, null, (WritableByteChannel)new FileOutputStream(file).getChannel());
                arrowFileWriter.start();
                arrowFileWriter.writeBatch();
                arrowFileWriter.end();
                arrowFileWriter.close();
            }
            this._modified = false;
            this._sorted = true;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public boolean loadFromFile() {
        File file = this._apm.getSnapshotFile(this._partitionId);
        if (!file.exists()) {
            return false;
        }
        try {
            this.clearReader();
            this._reader = new ArrowFileReader((SeekableByteChannel)new FileInputStream(file).getChannel(), this._apm.getAllocator(), this._apm.getCompressionFactory());
            this._reader.loadNextBatch();
            this._snapshotRO = this._reader.getVectorSchemaRoot();
            this._snapshotRO.syncSchema();
            this._store.init(this._snapshotRO, this._avp);
            this._store._maxRow = this._snapshotRO.getRowCount();
            this._modified = false;
            this._sorted = true;
            return true;
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    private void clearReader() {
        try {
            if (this._store != null) {
                this._store.init(null, this._avp);
            }
            if (this._snapshotRO != null) {
                this._snapshotRO.clear();
                this._snapshotRO.close();
                this._snapshotRO = null;
            }
            if (this._reader != null) {
                this._reader.close();
                this._reader = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    protected synchronized void sortSnapshotTimes() {
        if (this._sorted) {
            return;
        }
        int n = this._store._maxRow;
        IntArrayList intArrayList = _tmpListTL.get();
        intArrayList.clear();
        intArrayList.ensureCapacity(n);
        intArrayList.size(n);
        int[] nArray = intArrayList.elements();
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        SnapshotVertexTimeComparatorIAL snapshotVertexTimeComparatorIAL = _vertexTimeCmpTL.get();
        snapshotVertexTimeComparatorIAL.init(this);
        intArrayList.sort((IntComparator)snapshotVertexTimeComparatorIAL);
        IntVector intVector = this._store._sortedVertexTimeIndices;
        intVector.setValueCount(n);
        for (int i = 0; i < n; ++i) {
            intVector.set(i, nArray[i]);
        }
        this._sorted = true;
    }

    private void dump() {
        IntVector intVector = this._store._sortedVertexTimeIndices;
        int n = this._store._maxRow;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            int n2 = intVector.get(i);
            l = this._store._times.get(n2);
            System.out.println(i + ": " + n2 + ", v=" + this._store._localIds.get(n2) + ", t=" + l);
        }
    }

    protected int getSnapshotRowForVertex(long l, long l2) {
        if (this._snapshotRO.getRowCount() != this._store._maxRow) {
            this._snapshotRO.setRowCount(this._store._maxRow);
        }
        this.sortSnapshotTimes();
        VertexTimeWindowComparator vertexTimeWindowComparator = _timeVertexWindowComparatorTL.get();
        vertexTimeWindowComparator.init(l, this._store._localIds, this._store._sortedVertexTimeIndices, this._store._times, l2);
        int n = ArrowBinarySearch.binarySearch(this._store._sortedVertexTimeIndices, vertexTimeWindowComparator, null, -1);
        return n;
    }

    private static class VertexTimeWindowComparator
    extends VectorValueComparator<IntVector> {
        private long _targetVertexId;
        private long _targetTime;
        private BigIntVector _vertexIds;
        private IntVector _sortedIndices;
        private BigIntVector _times;

        private VertexTimeWindowComparator() {
        }

        public void init(long l, BigIntVector bigIntVector, IntVector intVector, BigIntVector bigIntVector2, long l2) {
            this._targetVertexId = l;
            this._vertexIds = bigIntVector;
            this._sortedIndices = intVector;
            this._times = bigIntVector2;
            this._targetTime = l2;
        }

        public int compare(int n, int n2) {
            boolean bl = ((IntVector)this.vector2).isNull(n2);
            if (!bl) {
                return this.compareNotNull(n, n2);
            }
            return 1;
        }

        public int compareNotNull(int n, int n2) {
            int n3 = this._sortedIndices.get(n2);
            long l = this._vertexIds.get(n3);
            if (this._targetVertexId != l) {
                return this._targetVertexId < l ? -1 : 1;
            }
            long l2 = this._times.get(n3);
            if (this._targetTime == l2) {
                return 0;
            }
            return this._targetTime < l2 ? -1 : 1;
        }

        public VectorValueComparator<IntVector> createNew() {
            return new VertexTimeWindowComparator();
        }
    }

    private static class SnapshotVertexTimeComparatorIAL
    implements IntComparator {
        private VertexSnapshotPartition _vsp;
        private BigIntVector _times;
        private BigIntVector _vertexIds;

        private SnapshotVertexTimeComparatorIAL() {
        }

        public void init(VertexSnapshotPartition vertexSnapshotPartition) {
            this._vsp = vertexSnapshotPartition;
            this._times = vertexSnapshotPartition._store._times;
            this._vertexIds = vertexSnapshotPartition._store._localIds;
        }

        public int compare(int n, int n2) {
            long l;
            long l2 = this._vertexIds.get(n);
            int n3 = Long.compare(l2, l = this._vertexIds.get(n2));
            if (n3 != 0) {
                return n3;
            }
            long l3 = this._times.get(n);
            long l4 = this._times.get(n2);
            return Long.compare(l3, l4);
        }
    }
}

