/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VersionedPropertyStore;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class VersionedProperty {
    public static final int LOCAL_ID_FIELD = 0;
    public static final int INITIAL_VALUE_FIELD = 1;
    public static final int CREATION_TIME_FIELD = 2;
    public static final int PREV_PTR_FIELD = 3;
    public static final int N_CORE_FIELDS = 4;
    public static final int FIRST_USER_FIELD = 4;
    public static final HashMap<Class, Supplier<ArrowType>> _typeMap = new HashMap();
    public static final HashMap<Class, Supplier<VersionedPropertyStore>> _schemaAccessorMap = new HashMap();
    public static final HashMap<Class, Supplier<VersionedEntityPropertyAccessor>> _entityAccessorMap = new HashMap();
    protected final String _name;
    protected final Class _class;
    protected final Supplier<VersionedEntityPropertyAccessor> _accessor;
    protected int _prevPtrFieldIndexInEntitySchema;

    public VersionedProperty(String string, Class clazz) {
        this._name = string.toLowerCase();
        this._class = clazz;
        this._accessor = _entityAccessorMap.get(this._class);
    }

    protected void setPrevPtrFieldIndexInEntity(int n) {
        this._prevPtrFieldIndexInEntitySchema = n;
    }

    public String name() {
        return this._name;
    }

    protected void addToSchema(List<Field> list) {
        Field field = new Field(this._name, new FieldType(false, _typeMap.get(this._class).get(), null), null);
        list.add(field);
    }

    public VersionedPropertyStore getNewSchemaFieldAccessor(VectorSchemaRoot vectorSchemaRoot) {
        VersionedPropertyStore versionedPropertyStore = _schemaAccessorMap.get(this._class).get();
        versionedPropertyStore.initialise(vectorSchemaRoot);
        return versionedPropertyStore;
    }

    public VersionedEntityPropertyAccessor getNewEntityFieldAccessor(int n) {
        VersionedEntityPropertyAccessor versionedEntityPropertyAccessor = this._accessor.get();
        versionedEntityPropertyAccessor.setEntityPrevPtrFieldId(n);
        return versionedEntityPropertyAccessor;
    }

    static {
        _typeMap.put(Integer.TYPE, () -> new ArrowType.Int(32, true));
        _typeMap.put(Long.TYPE, () -> new ArrowType.Int(64, true));
        _typeMap.put(Long.class, () -> new ArrowType.Int(64, true));
        _typeMap.put(Float.TYPE, () -> new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE));
        _typeMap.put(Double.TYPE, () -> new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE));
        _typeMap.put(Boolean.TYPE, ArrowType.Bool::new);
        _typeMap.put(StringBuilder.class, ArrowType.Utf8::new);
        _schemaAccessorMap.put(Integer.TYPE, VersionedPropertyStore.IntPropertyAccessor::new);
        _schemaAccessorMap.put(Long.TYPE, VersionedPropertyStore.LongPropertyAccessor::new);
        _schemaAccessorMap.put(Float.TYPE, VersionedPropertyStore.FloatPropertyAccessor::new);
        _schemaAccessorMap.put(Double.TYPE, VersionedPropertyStore.DoublePropertyAccessor::new);
        _schemaAccessorMap.put(Boolean.TYPE, VersionedPropertyStore.BooleanPropertyAccessor::new);
        _schemaAccessorMap.put(StringBuilder.class, VersionedPropertyStore.StringPropertyAccessor::new);
        _entityAccessorMap.put(Integer.TYPE, VersionedEntityPropertyAccessor.IntPropertyAccessor::new);
        _entityAccessorMap.put(Long.TYPE, VersionedEntityPropertyAccessor.LongPropertyAccessor::new);
        _entityAccessorMap.put(Float.TYPE, VersionedEntityPropertyAccessor.FloatPropertyAccessor::new);
        _entityAccessorMap.put(Double.TYPE, VersionedEntityPropertyAccessor.DoublePropertyAccessor::new);
        _entityAccessorMap.put(Boolean.TYPE, VersionedEntityPropertyAccessor.BooleanPropertyAccessor::new);
        _entityAccessorMap.put(StringBuilder.class, VersionedEntityPropertyAccessor.StringPropertyAccessor::new);
        _entityAccessorMap.put(Long.class, VersionedEntityPropertyAccessor.LongPropertyAccessor::new);
    }
}

