/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

public abstract class VersionedEntityPropertyAccessor {
    protected boolean _isSet;
    protected long _localId;
    protected boolean _initialValue;
    protected long _creationTime;
    protected int _prevPtr;
    protected int _entitySchemaPrevPtrFieldId = -1;

    protected VersionedEntityPropertyAccessor() {
    }

    public boolean isSet() {
        return this._isSet;
    }

    public void reset() {
        this._isSet = false;
    }

    protected int getEntityPrevPtrFieldId() {
        return this._entitySchemaPrevPtrFieldId;
    }

    protected void setEntityPrevPtrFieldId(int n) {
        this._entitySchemaPrevPtrFieldId = n;
    }

    protected void set(long l, boolean bl, long l2, int n) {
        this._localId = l;
        this._initialValue = bl;
        this._creationTime = l2;
        this._prevPtr = n;
    }

    public VersionedEntityPropertyAccessor setHistory(boolean bl, long l) {
        this._initialValue = bl;
        this._creationTime = l;
        return this;
    }

    public long getLocalId() {
        return this._localId;
    }

    public boolean getInitialValue() {
        return this._initialValue;
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public int getPrevPtr() {
        return this._prevPtr;
    }

    public void set(int n) {
        this.load(n);
        this._isSet = true;
    }

    public void set(long l) {
        this.load(l);
        this._isSet = true;
    }

    public void set(float f) {
        this.load(f);
        this._isSet = true;
    }

    public void set(double d) {
        this.load(d);
        this._isSet = true;
    }

    public void set(boolean bl) {
        this.load(bl);
        this._isSet = true;
    }

    public void set(CharSequence charSequence) {
        this.load(charSequence);
        this._isSet = true;
    }

    public void set(Object object) {
        this.load(object);
        this._isSet = true;
    }

    public int getInt() {
        throw new IllegalArgumentException("value is not int");
    }

    public long getLong() {
        throw new IllegalArgumentException("value is not long");
    }

    public float getFloat() {
        throw new IllegalArgumentException("value is not float");
    }

    public double getDouble() {
        throw new IllegalArgumentException("value is not double");
    }

    public boolean getBoolean() {
        throw new IllegalArgumentException("value is not boolean");
    }

    public StringBuilder getString() {
        throw new IllegalArgumentException("value is not string");
    }

    public Object get() {
        throw new UnsupportedOperationException();
    }

    protected void load(int n) {
        throw new IllegalArgumentException("value is not int");
    }

    protected void load(long l) {
        throw new IllegalArgumentException("value is not long");
    }

    protected void load(float f) {
        throw new IllegalArgumentException("value is not float");
    }

    protected void load(double d) {
        throw new IllegalArgumentException("value is not double");
    }

    protected void load(boolean bl) {
        throw new IllegalArgumentException("value is not boolean");
    }

    protected void load(StringBuilder stringBuilder) {
        throw new IllegalArgumentException("value is not string");
    }

    protected void load(CharSequence charSequence) {
        throw new IllegalArgumentException("value is not string");
    }

    protected void load(Object object) {
        throw new UnsupportedOperationException();
    }

    public static final class StringPropertyAccessor
    extends VersionedEntityPropertyAccessor {
        private StringBuilder _value = new StringBuilder();

        @Override
        protected void load(StringBuilder stringBuilder) {
            this._value.setLength(0);
            this._value.append((CharSequence)stringBuilder);
        }

        @Override
        protected void load(CharSequence charSequence) {
            this._value.setLength(0);
            this._value.append(charSequence);
        }

        @Override
        public StringBuilder getString() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value.setLength(0);
        }
    }

    public static final class BooleanPropertyAccessor
    extends VersionedEntityPropertyAccessor {
        private boolean _value;

        @Override
        protected void load(boolean bl) {
            this._value = bl;
        }

        @Override
        public boolean getBoolean() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = false;
        }
    }

    public static final class DoublePropertyAccessor
    extends VersionedEntityPropertyAccessor {
        private double _value;

        @Override
        protected void load(double d) {
            this._value = d;
        }

        @Override
        public double getDouble() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0.0;
        }
    }

    public static final class FloatPropertyAccessor
    extends VersionedEntityPropertyAccessor {
        private float _value;

        @Override
        protected void load(float f) {
            this._value = f;
        }

        @Override
        public float getFloat() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0.0f;
        }
    }

    public static final class LongPropertyAccessor
    extends VersionedEntityPropertyAccessor {
        private long _value;

        @Override
        protected void load(long l) {
            this._value = l;
        }

        @Override
        public long getLong() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0L;
        }
    }

    public static final class IntPropertyAccessor
    extends VersionedEntityPropertyAccessor {
        private int _value;

        @Override
        protected void load(int n) {
            this._value = n;
        }

        @Override
        public int getInt() {
            return this._value;
        }

        @Override
        public void reset() {
            super.reset();
            this._value = 0;
        }
    }
}

