/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RaphtoryThreadPool {
    public static RaphtoryThreadPool THREAD_POOL = new RaphtoryThreadPool(Runtime.getRuntime().availableProcessors(), Integer.MAX_VALUE);
    private final ThreadPoolExecutor _threadPool;

    public RaphtoryThreadPool(int n, int n2) {
        ThreadFactory threadFactory = runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        };
        LinkedBlockingQueue linkedBlockingQueue = n2 == Integer.MAX_VALUE ? new LinkedBlockingQueue(Integer.MAX_VALUE) : new LinkedBlockingQueue(n2){

            @Override
            public boolean offer(Object object) {
                try {
                    this.put(object);
                    return true;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
        };
        this._threadPool = new ThreadPoolExecutor(n, n, Long.MAX_VALUE, TimeUnit.SECONDS, (BlockingQueue<Runnable>)linkedBlockingQueue, threadFactory);
    }

    public Future<?> submitTask(Runnable runnable) {
        return this._threadPool.submit(runnable);
    }

    public boolean isIdle() {
        return this._threadPool.getActiveCount() == 0;
    }

    public void waitTilComplete(Future<?> future) {
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            this.cancel(future);
        }
    }

    public void waitTilComplete(ArrayList<Future<?>> arrayList) {
        int n = arrayList.size();
        try {
            for (int i = 0; i < n; ++i) {
                arrayList.get(i).get();
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            this.cancel(arrayList);
        }
    }

    public void cancel(Future<?> future) {
        try {
            future.cancel(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cancel(ArrayList<Future<?>> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            try {
                arrayList.get(i).cancel(true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

