/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgeHistoryIterator;
import com.raphtory.arrowcore.implementation.EdgeHistoryStore;
import com.raphtory.arrowcore.implementation.EdgeIterator;
import com.raphtory.arrowcore.implementation.EdgePartition;
import com.raphtory.arrowcore.implementation.EdgePartitionManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.algorithm.search.VectorRangeSearcher;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;

public class EdgeHistoryPartition {
    private static final ThreadLocal<IntArrayList> _tmpListTL = ThreadLocal.withInitial(IntArrayList::new);
    private static final ThreadLocal<HistoryTimeComparatorIAL> _timeCmpTL = ThreadLocal.withInitial(() -> new HistoryTimeComparatorIAL());
    private static final ThreadLocal<HistoryEdgeTimeComparatorIAL> _edgeTimeCmpTL = ThreadLocal.withInitial(() -> new HistoryEdgeTimeComparatorIAL());
    private static final ThreadLocal<WindowComparator> _windowComparatorTL = ThreadLocal.withInitial(() -> new WindowComparator());
    private static final ThreadLocal<EdgeWindowComparator> _edgeWindowComparatorTL = ThreadLocal.withInitial(() -> new EdgeWindowComparator());
    private static final ThreadLocal<EdgeHistoryBoundedBinarySearch> _edgeBoundWindowComparatorTL = ThreadLocal.withInitial(EdgeHistoryBoundedBinarySearch::new);
    private final int _partitionId;
    private final EdgePartition _aep;
    private final EdgePartitionManager _aepm;
    protected final EdgeHistoryStore _history;
    private VectorSchemaRoot _historyRO;
    private ArrowFileReader _historyReader;
    private boolean _modified = false;
    protected boolean _sorted = false;

    public EdgeHistoryPartition(int n, EdgePartition edgePartition) {
        this._partitionId = n;
        this._aep = edgePartition;
        this._aepm = edgePartition._aepm;
        this._history = new EdgeHistoryStore();
    }

    public void initialize() {
        this._historyRO = VectorSchemaRoot.create((Schema)EdgeHistoryStore.HISTORY_SCHEMA, (BufferAllocator)this._aepm.getAllocator());
        this._history.init(this._historyRO);
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public int addHistory(int n, long l, boolean bl, boolean bl2, int n2) {
        this._modified = true;
        this._sorted = false;
        int n3 = this._history.addHistory(n, l, bl, bl2, n2);
        return n3;
    }

    protected boolean getIsAliveByRowId(int n) {
        return this._history._states.get(n) != 0;
    }

    protected int getEdgeLocalRowIdByHistoryRowId(int n) {
        return this._history._edgeRowIds.get(n);
    }

    public void close() {
        this.clearReader();
    }

    public void saveToFile() {
        try {
            this.sortHistoryTimes();
            if (this._modified) {
                this._historyRO.syncSchema();
                this._historyRO.setRowCount(this._history._maxRow);
                File file = this._aepm.getHistoryFile(this._partitionId);
                ArrowFileWriter arrowFileWriter = new ArrowFileWriter(this._historyRO, null, (WritableByteChannel)new FileOutputStream(file).getChannel());
                arrowFileWriter.start();
                arrowFileWriter.writeBatch();
                arrowFileWriter.end();
                arrowFileWriter.close();
            }
            this._modified = false;
            this._sorted = true;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public boolean loadFromFile() {
        File file = this._aepm.getHistoryFile(this._partitionId);
        if (!file.exists()) {
            return false;
        }
        try {
            this.clearReader();
            this._historyReader = new ArrowFileReader((SeekableByteChannel)new FileInputStream(file).getChannel(), this._aepm.getAllocator(), this._aepm.getCompressionFactory());
            this._historyReader.loadNextBatch();
            this._historyRO = this._historyReader.getVectorSchemaRoot();
            this._historyRO.syncSchema();
            this._history.init(this._historyRO);
            this._history._maxRow = this._historyRO.getRowCount();
            this._modified = false;
            this._sorted = true;
            return true;
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    private void clearReader() {
        try {
            if (this._history != null) {
                this._history.init(null);
            }
            if (this._historyRO != null) {
                this._historyRO.clear();
                this._historyRO.close();
                this._historyRO = null;
            }
            if (this._historyReader != null) {
                this._historyReader.close();
                this._historyReader = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    protected synchronized void sortHistoryTimes() {
        int n;
        if (this._sorted) {
            return;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        int n2 = this._history._maxRow;
        IntArrayList intArrayList = _tmpListTL.get();
        intArrayList.clear();
        intArrayList.ensureCapacity(n2);
        intArrayList.size(n2);
        int[] nArray = intArrayList.elements();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
        HistoryEdgeTimeComparatorIAL historyEdgeTimeComparatorIAL = _edgeTimeCmpTL.get();
        historyEdgeTimeComparatorIAL.init(this);
        intArrayList.sort((IntComparator)historyEdgeTimeComparatorIAL);
        IntVector intVector = this._history._sortedEdgeTimeIndices;
        intVector.setValueCount(n2);
        for (n = 0; n < n2; ++n) {
            intVector.set(n, nArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        HistoryTimeComparatorIAL historyTimeComparatorIAL = _timeCmpTL.get();
        historyTimeComparatorIAL.init(this);
        intArrayList.sort((IntComparator)historyTimeComparatorIAL);
        IntVector intVector2 = this._history._sortedTimeIndices;
        intVector2.setValueCount(n2);
        for (int i = 0; i < n2; ++i) {
            intVector2.set(i, nArray[i]);
        }
        this._sorted = true;
    }

    protected void isAliveAtWithWindowVector(EdgeIterator.WindowedEdgeIterator windowedEdgeIterator) {
        if (this._historyRO == null) {
            windowedEdgeIterator._firstIndex = -1;
            windowedEdgeIterator._lastIndex = -1;
            return;
        }
        this.sortHistoryTimes();
        WindowComparator windowComparator = _windowComparatorTL.get();
        windowComparator.init(this._history._sortedTimeIndices, this._history._times, windowedEdgeIterator._minTime, windowedEdgeIterator._maxTime);
        int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)windowComparator, null, (int)0);
        if (n < 0) {
            windowedEdgeIterator._firstIndex = -1;
            windowedEdgeIterator._lastIndex = -1;
            return;
        }
        int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)windowComparator, null, (int)0);
        windowedEdgeIterator._firstIndex = n;
        windowedEdgeIterator._lastIndex = n2;
    }

    public int getHistoryRowIdBySortedIndex(int n) {
        int n2 = this._history._sortedTimeIndices.get(n);
        return n2;
    }

    public int getHistoryRowIdBySortedEdgeIndex(int n) {
        int n2 = this._history._sortedEdgeTimeIndices.get(n);
        return n2;
    }

    public long getLowestTime() {
        if (this._history._maxRow == 0) {
            return Long.MAX_VALUE;
        }
        this.sortHistoryTimes();
        int n = this._history._sortedTimeIndices.get(0);
        return this._history._times.get(n);
    }

    public long getHighestTime() {
        if (this._history._maxRow == 0) {
            return Long.MIN_VALUE;
        }
        this.sortHistoryTimes();
        int n = this._history._sortedTimeIndices.get(this._history._maxRow - 1);
        return this._history._times.get(n);
    }

    public long getNHistoryItems() {
        return this._history._maxRow;
    }

    protected long getEdgeMinHistoryTime(int n) {
        if (this._historyRO == null) {
            return Long.MIN_VALUE;
        }
        this.sortHistoryTimes();
        EdgeWindowComparator edgeWindowComparator = _edgeWindowComparatorTL.get();
        edgeWindowComparator.init(n, this._history._edgeRowIds, this._history._sortedEdgeTimeIndices, this._history._times, Long.MIN_VALUE, Long.MAX_VALUE);
        int n2 = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedEdgeTimeIndices, (VectorValueComparator)edgeWindowComparator, null, (int)0);
        if (n2 >= 0) {
            int n3 = this._history._sortedEdgeTimeIndices.get(n2);
            return this._history._times.get(n3);
        }
        return Long.MIN_VALUE;
    }

    protected long getEdgeMaxHistoryTime(int n) {
        if (this._historyRO == null) {
            return Long.MAX_VALUE;
        }
        this.sortHistoryTimes();
        EdgeWindowComparator edgeWindowComparator = _edgeWindowComparatorTL.get();
        edgeWindowComparator.init(n, this._history._edgeRowIds, this._history._sortedEdgeTimeIndices, this._history._times, Long.MIN_VALUE, Long.MAX_VALUE);
        int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedEdgeTimeIndices, (VectorValueComparator)edgeWindowComparator, null, (int)0);
        if (n2 >= 0) {
            int n3 = this._history._sortedEdgeTimeIndices.get(n2);
            return this._history._times.get(n3);
        }
        return Long.MAX_VALUE;
    }

    protected void findHistory(EdgeHistoryIterator.WindowedEdgeHistoryIterator windowedEdgeHistoryIterator) {
        if (this._historyRO == null) {
            windowedEdgeHistoryIterator._firstIndex = -1;
            windowedEdgeHistoryIterator._lastIndex = -1;
            return;
        }
        this.sortHistoryTimes();
        if (windowedEdgeHistoryIterator._edgeId == -1L) {
            WindowComparator windowComparator = _windowComparatorTL.get();
            windowComparator.init(this._history._sortedTimeIndices, this._history._times, windowedEdgeHistoryIterator._minTime, windowedEdgeHistoryIterator._maxTime);
            int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)windowComparator, null, (int)0);
            if (n < 0) {
                windowedEdgeHistoryIterator._firstIndex = -1;
                windowedEdgeHistoryIterator._lastIndex = -1;
            } else {
                int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)windowComparator, null, (int)0);
                windowedEdgeHistoryIterator._firstIndex = n;
                windowedEdgeHistoryIterator._lastIndex = n2;
            }
        } else {
            EdgeWindowComparator edgeWindowComparator = _edgeWindowComparatorTL.get();
            edgeWindowComparator.init(this._aepm.getRowId(windowedEdgeHistoryIterator._edgeId), this._history._edgeRowIds, this._history._sortedEdgeTimeIndices, this._history._times, windowedEdgeHistoryIterator._minTime, windowedEdgeHistoryIterator._maxTime);
            int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedEdgeTimeIndices, (VectorValueComparator)edgeWindowComparator, null, (int)0);
            if (n < 0) {
                windowedEdgeHistoryIterator._firstIndex = -1;
                windowedEdgeHistoryIterator._lastIndex = -1;
            } else {
                int n3 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedEdgeTimeIndices, (VectorValueComparator)edgeWindowComparator, null, (int)0);
                windowedEdgeHistoryIterator._firstIndex = n;
                windowedEdgeHistoryIterator._lastIndex = n3;
            }
        }
    }

    public EdgeHistoryStore getHistoryStore() {
        return this._history;
    }

    public boolean isAliveAt(long l, long l2, long l3) {
        return this.isAliveAt(l, l2, l3, _edgeBoundWindowComparatorTL.get());
    }

    public boolean isAliveAt(long l, long l2, long l3, EdgeHistoryBoundedBinarySearch edgeHistoryBoundedBinarySearch) {
        int n = this._aepm.getRowId(l);
        int n2 = this._history._maxRow;
        int n3 = this._aep._store._sortedHStart.get(n);
        int n4 = this._aep._store._sortedHEnd.get(n);
        edgeHistoryBoundedBinarySearch.init(n, this._history._edgeRowIds, this._history._sortedEdgeTimeIndices, this._history._times, l3, n3, n4);
        int n5 = edgeHistoryBoundedBinarySearch.find();
        if (n5 < 0) {
            n5 = -n5;
            if (--n5 >= n2) {
                n5 = n2 - 1;
            }
            if (n5 < n3) {
                return false;
            }
            int n6 = this._history._sortedEdgeTimeIndices.get(n5);
            if ((this._history._edgeRowIds.get(n6) != n || this._history._times.get(n6) > l3) && n5 > 0) {
                n6 = this._history._sortedEdgeTimeIndices.get(--n5);
            }
            return n6 < n2 && this._history._states.get(n6) != 0 && this._history._edgeRowIds.get(n6) == n && this._history._times.get(n6) >= l2 && this._history._times.get(n6) <= l3;
        }
        int n7 = this._history._sortedEdgeTimeIndices.get(n5);
        return this._history._states.get(n7) != 0;
    }

    protected static class EdgeHistoryBoundedBinarySearch {
        private int _edgeRowId;
        private long _maxTime;
        private IntVector _rowIds;
        private IntVector _sortedIndices;
        private BigIntVector _creationTimes;
        private int _low;
        private int _high;

        protected EdgeHistoryBoundedBinarySearch() {
        }

        public void init(int n, IntVector intVector, IntVector intVector2, BigIntVector bigIntVector, long l, int n2, int n3) {
            this.init(n, intVector, intVector2, bigIntVector, l);
            this.setBounds(n2, n3);
        }

        public void init(int n, IntVector intVector, IntVector intVector2, BigIntVector bigIntVector, long l) {
            this._edgeRowId = n;
            this._rowIds = intVector;
            this._sortedIndices = intVector2;
            this._creationTimes = bigIntVector;
            this._maxTime = l;
            this._low = 0;
            this._high = this._sortedIndices.getValueCount() - 1;
        }

        public void setBounds(int n, int n2) {
            this._low = n;
            this._high = n2;
        }

        public int find() {
            int n = this._low;
            int n2 = this._high;
            while (n <= n2) {
                int n3 = n + (n2 - n) / 2;
                int n4 = this.compare(n3);
                if (n4 < 0) {
                    n2 = n3 - 1;
                    continue;
                }
                if (n4 > 0) {
                    n = n3 + 1;
                    continue;
                }
                return n3;
            }
            return -(n + 1);
        }

        private int compare(int n) {
            int n2 = this._sortedIndices.get(n);
            int n3 = this._rowIds.get(n2);
            if (this._edgeRowId != n3) {
                return n3 < this._edgeRowId ? 1 : -1;
            }
            long l = this._creationTimes.get(n2);
            if (l < this._maxTime) {
                return 1;
            }
            if (l > this._maxTime) {
                return -1;
            }
            return 0;
        }
    }

    private static class EdgeWindowComparator
    extends VectorValueComparator<IntVector> {
        private int _edgeRowId;
        private long _minTime;
        private long _maxTime;
        private IntVector _rowIds;
        private IntVector _sortedIndices;
        private BigIntVector _creationTimes;

        private EdgeWindowComparator() {
        }

        public void init(int n, IntVector intVector, IntVector intVector2, BigIntVector bigIntVector, long l, long l2) {
            this._edgeRowId = n;
            this._rowIds = intVector;
            this._sortedIndices = intVector2;
            this._creationTimes = bigIntVector;
            this._minTime = l;
            this._maxTime = l2;
        }

        public int compare(int n, int n2) {
            boolean bl = ((IntVector)this.vector2).isNull(n2);
            if (!bl) {
                return this.compareNotNull(n, n2);
            }
            return 1;
        }

        public int compareNotNull(int n, int n2) {
            int n3 = this._sortedIndices.get(n2);
            int n4 = this._rowIds.get(n3);
            if (this._edgeRowId != n4) {
                return this._edgeRowId < n4 ? -1 : 1;
            }
            long l = this._creationTimes.get(n3);
            if (l < this._minTime) {
                return 1;
            }
            if (l > this._maxTime) {
                return -1;
            }
            return 0;
        }

        public VectorValueComparator<IntVector> createNew() {
            return new EdgeWindowComparator();
        }
    }

    private static class WindowComparator
    extends VectorValueComparator<IntVector> {
        private long _minTime;
        private long _maxTime;
        private IntVector _sortedIndices;
        private BigIntVector _creationTimes;

        private WindowComparator() {
        }

        public void init(IntVector intVector, BigIntVector bigIntVector, long l, long l2) {
            this._sortedIndices = intVector;
            this._creationTimes = bigIntVector;
            this._minTime = l;
            this._maxTime = l2;
        }

        public int compare(int n, int n2) {
            boolean bl = ((IntVector)this.vector2).isNull(n2);
            if (!bl) {
                return this.compareNotNull(n, n2);
            }
            return 1;
        }

        public int compareNotNull(int n, int n2) {
            int n3 = this._sortedIndices.get(n2);
            long l = this._creationTimes.get(n3);
            if (l < this._minTime) {
                return 1;
            }
            if (l > this._maxTime) {
                return -1;
            }
            return 0;
        }

        public VectorValueComparator<IntVector> createNew() {
            return new WindowComparator();
        }
    }

    private static class HistoryEdgeTimeComparatorIAL
    implements IntComparator {
        private EdgeHistoryPartition _aehpm;
        private BigIntVector _times;
        private IntVector _edgeRowIds;

        private HistoryEdgeTimeComparatorIAL() {
        }

        public void init(EdgeHistoryPartition edgeHistoryPartition) {
            this._aehpm = edgeHistoryPartition;
            this._times = edgeHistoryPartition._history._times;
            this._edgeRowIds = edgeHistoryPartition._history._edgeRowIds;
        }

        public int compare(int n, int n2) {
            int n3;
            int n4 = this._edgeRowIds.get(n);
            int n5 = Integer.compare(n4, n3 = this._edgeRowIds.get(n2));
            if (n5 != 0) {
                return n5;
            }
            long l = this._times.get(n);
            long l2 = this._times.get(n2);
            n5 = Long.compare(l, l2);
            return n5;
        }
    }

    private static class HistoryTimeComparatorIAL
    implements IntComparator {
        private EdgeHistoryPartition _aehpm;
        private BigIntVector _times;

        private HistoryTimeComparatorIAL() {
        }

        public void init(EdgeHistoryPartition edgeHistoryPartition) {
            this._aehpm = edgeHistoryPartition;
            this._times = edgeHistoryPartition._history._times;
        }

        public int compare(int n, int n2) {
            long l = this._times.get(n);
            long l2 = this._times.get(n2);
            int n3 = Long.compare(l, l2);
            return n3;
        }
    }
}

