/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sources;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.sources.PostgresConnection$;
import com.raphtory.sources.SqlConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** SqlConnection for Postgres databases\n  *\n  * @param database the name of the database\n  * @param user the name of the user\n  * @param password the password for the user\n  * @param address the address of the host serving the database\n  * @param port the port of the Postgres service (5432 by default)\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001B\u0015+\u0001FB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t+\u0002\u0011\t\u0012)A\u0005\u001b\"Aa\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005X\u0001\tE\t\u0015!\u0003N\u0011!A\u0006A!f\u0001\n\u0003a\u0005\u0002C-\u0001\u0005#\u0005\u000b\u0011B'\t\u0011i\u0003!Q3A\u0005\u00021C\u0001b\u0017\u0001\u0003\u0012\u0003\u0006I!\u0014\u0005\t9\u0002\u0011)\u001a!C\u0001;\"A\u0011\r\u0001B\tB\u0003%a\fC\u0003c\u0001\u0011\u00051\rC\u0003k\u0001\u0011\u00053\u000eC\u0004u\u0001\u0005\u0005I\u0011A;\t\u000fm\u0004\u0011\u0013!C\u0001y\"A\u0011q\u0002\u0001\u0012\u0002\u0013\u0005A\u0010\u0003\u0005\u0002\u0012\u0001\t\n\u0011\"\u0001}\u0011!\t\u0019\u0002AI\u0001\n\u0003a\b\"CA\u000b\u0001E\u0005I\u0011AA\f\u0011%\tY\u0002AA\u0001\n\u0003\ni\u0002\u0003\u0005\u0002*\u0001\t\t\u0011\"\u0001^\u0011%\tY\u0003AA\u0001\n\u0003\ti\u0003C\u0005\u0002:\u0001\t\t\u0011\"\u0011\u0002<!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00111\n\u0005\n\u0003+\u0002\u0011\u0011!C!\u0003/B\u0011\"a\u0017\u0001\u0003\u0003%\t%!\u0018\t\u0013\u0005}\u0003!!A\u0005B\u0005\u0005\u0004\"CA2\u0001\u0005\u0005I\u0011IA3\u000f%\t)IKA\u0001\u0012\u0003\t9I\u0002\u0005*U\u0005\u0005\t\u0012AAE\u0011\u0019\u0011W\u0004\"\u0001\u0002\"\"I\u0011qL\u000f\u0002\u0002\u0013\u0015\u0013\u0011\r\u0005\n\u0003Gk\u0012\u0011!CA\u0003KC\u0001\"!-\u001e#\u0003%\t\u0001 \u0005\t\u0003gk\u0012\u0013!C\u0001y\"I\u0011QW\u000f\u0012\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003ok\u0012\u0011!CA\u0003sC\u0001\"a3\u001e#\u0003%\t\u0001 \u0005\t\u0003\u001bl\u0012\u0013!C\u0001y\"I\u0011qZ\u000f\u0012\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003#l\u0012\u0011!C\u0005\u0003'\u0014!\u0003U8ti\u001e\u0014Xm]\"p]:,7\r^5p]*\u00111\u0006L\u0001\bg>,(oY3t\u0015\tic&\u0001\u0005sCBDGo\u001c:z\u0015\u0005y\u0013aA2p[\u000e\u00011#\u0002\u00013qqz\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g\r\u0005\u0002:u5\t!&\u0003\u0002<U\ti1+\u001d7D_:tWm\u0019;j_:\u0004\"aM\u001f\n\u0005y\"$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0001\"s!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011\u0003\u0014A\u0002\u001fs_>$h(C\u00016\u0013\t9E'A\u0004qC\u000e\\\u0017mZ3\n\u0005%S%\u0001D*fe&\fG.\u001b>bE2,'BA$5\u0003!!\u0017\r^1cCN,W#A'\u0011\u00059\u0013fBA(Q!\t\u0011E'\u0003\u0002Ri\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\tF'A\u0005eCR\f'-Y:fA\u0005!Qo]3s\u0003\u0015)8/\u001a:!\u0003!\u0001\u0018m]:x_J$\u0017!\u00039bgN<xN\u001d3!\u0003\u001d\tG\r\u001a:fgN\f\u0001\"\u00193ee\u0016\u001c8\u000fI\u0001\u0005a>\u0014H/F\u0001_!\t\u0019t,\u0003\u0002ai\t\u0019\u0011J\u001c;\u0002\u000bA|'\u000f\u001e\u0011\u0002\rqJg.\u001b;?)\u0019!WMZ4iSB\u0011\u0011\b\u0001\u0005\u0006\u0017.\u0001\r!\u0014\u0005\u0006-.\u0001\r!\u0014\u0005\b1.\u0001\n\u00111\u0001N\u0011\u001dQ6\u0002%AA\u00025Cq\u0001X\u0006\u0011\u0002\u0003\u0007a,A\u0005fgR\f'\r\\5tQR\tA\u000e\u0005\u0002ne6\taN\u0003\u0002pa\u0006\u00191/\u001d7\u000b\u0003E\fAA[1wC&\u00111O\u001c\u0002\u000b\u0007>tg.Z2uS>t\u0017\u0001B2paf$b\u0001\u001a<xqfT\bbB&\u000e!\u0003\u0005\r!\u0014\u0005\b-6\u0001\n\u00111\u0001N\u0011\u001dAV\u0002%AA\u00025CqAW\u0007\u0011\u0002\u0003\u0007Q\nC\u0004]\u001bA\u0005\t\u0019\u00010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tQP\u000b\u0002N}.\nq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0005i\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00111\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\u001a)\u0012aL`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015\u0002/\u0001\u0003mC:<\u0017bA*\u0002$\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0018\u0003k\u00012aMA\u0019\u0013\r\t\u0019\u0004\u000e\u0002\u0004\u0003:L\b\u0002CA\u001c+\u0005\u0005\t\u0019\u00010\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0004\u0005\u0004\u0002@\u0005\u0015\u0013qF\u0007\u0003\u0003\u0003R1!a\u00115\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\n\tE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA'\u0003'\u00022aMA(\u0013\r\t\t\u0006\u000e\u0002\b\u0005>|G.Z1o\u0011%\t9dFA\u0001\u0002\u0004\ty#\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0010\u00033B\u0001\"a\u000e\u0019\u0003\u0003\u0005\rAX\u0001\tQ\u0006\u001c\bnQ8eKR\ta,\u0001\u0005u_N#(/\u001b8h)\t\ty\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001b\n9\u0007C\u0005\u00028m\t\t\u00111\u0001\u00020!:\u0001!a\u001b\u0002\u0000\u0005\u0005\u0005\u0003BA7\u0003wj!!a\u001c\u000b\t\u0005E\u00141O\u0001\tg\u000e\fG.\u00193pG*!\u0011QOA<\u0003\u001d!\u0018m[3{_\u0016T1!!\u001f/\u0003\u00199\u0017\u000e\u001e5vE&!\u0011QPA8\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017EAAB\u0003\t%tF\u000b\u0016!'Fd7i\u001c8oK\u000e$\u0018n\u001c8!M>\u0014\b\u0005U8ti\u001e\u0014Xm\u001d\u0011eCR\f'-Y:fg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\t]1sC6\u0004C-\u0019;bE\u0006\u001cX\r\t;iK\u0002r\u0017-\\3!_\u001a\u0004C\u000f[3!I\u0006$\u0018MY1tK*\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011vg\u0016\u0014\b\u0005\u001e5fA9\fW.\u001a\u0011pM\u0002\"\b.\u001a\u0011vg\u0016\u0014(\u0002\t\u0011+A\u0001\u0003\u0018M]1nAA\f7o]<pe\u0012\u0004C\u000f[3!a\u0006\u001c8o^8sI\u00022wN\u001d\u0011uQ\u0016\u0004So]3s\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000eI1eIJ,7o\u001d\u0011uQ\u0016\u0004\u0013\r\u001a3sKN\u001c\be\u001c4!i\",\u0007\u0005[8ti\u0002\u001aXM\u001d<j]\u001e\u0004C\u000f[3!I\u0006$\u0018MY1tK*\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011q_J$\b\u0005\u001e5fAA|'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011Q_N$xM]3tAM,'O^5dK\u0002BS\u0007N\u001a3A\tL\b\u0005Z3gCVdG/\u000b\u0006!A)z\u0013A\u0005)pgR<'/Z:D_:tWm\u0019;j_:\u0004\"!O\u000f\u0014\u000bu\tY)a&\u0011\u0015\u00055\u00151S'N\u001b6sF-\u0004\u0002\u0002\u0010*\u0019\u0011\u0011\u0013\u001b\u0002\u000fI,h\u000e^5nK&!\u0011QSAH\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\u000e\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0019\u0011Q\u00149\u0002\u0005%|\u0017bA%\u0002\u001cR\u0011\u0011qQ\u0001\u0006CB\u0004H.\u001f\u000b\fI\u0006\u001d\u0016\u0011VAV\u0003[\u000by\u000bC\u0003LA\u0001\u0007Q\nC\u0003WA\u0001\u0007Q\nC\u0004YAA\u0005\t\u0019A'\t\u000fi\u0003\u0003\u0013!a\u0001\u001b\"9A\f\tI\u0001\u0002\u0004q\u0016aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY,a2\u0011\u000bM\ni,!1\n\u0007\u0005}FG\u0001\u0004PaRLwN\u001c\t\tg\u0005\rW*T'N=&\u0019\u0011Q\u0019\u001b\u0003\rQ+\b\u000f\\36\u0011!\tI\rJA\u0001\u0002\u0004!\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002VB!\u0011\u0011EAl\u0013\u0011\tI.a\t\u0003\r=\u0013'.Z2u\u0001")
public class PostgresConnection
implements SqlConnection,
Product,
Serializable {
    private final String database;
    private final String user;
    private final String password;
    private final String address;
    private final int port;

    public static int $lessinit$greater$default$5() {
        return PostgresConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return PostgresConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return PostgresConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple5<String, String, String, String, Object>> unapply(PostgresConnection x$0) {
        return PostgresConnection$.MODULE$.unapply(x$0);
    }

    public static int apply$default$5() {
        return PostgresConnection$.MODULE$.apply$default$5();
    }

    public static String apply$default$4() {
        return PostgresConnection$.MODULE$.apply$default$4();
    }

    public static String apply$default$3() {
        return PostgresConnection$.MODULE$.apply$default$3();
    }

    public static PostgresConnection apply(String database, String user, String password, String address, int port) {
        return PostgresConnection$.MODULE$.apply(database, user, password, address, port);
    }

    public static Function1<Tuple5<String, String, String, String, Object>, PostgresConnection> tupled() {
        return PostgresConnection$.MODULE$.tupled();
    }

    public static Function1<String, Function1<String, Function1<String, Function1<String, Function1<Object, PostgresConnection>>>>> curried() {
        return PostgresConnection$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String database() {
        return this.database;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public String address() {
        return this.address;
    }

    public int port() {
        return this.port;
    }

    @Override
    public Connection establish() {
        Class.forName("org.postgresql.Driver");
        return DriverManager.getConnection(new StringBuilder(20).append("jdbc:postgresql://").append(this.address()).append(":").append(this.port()).append("/").append(this.database()).toString(), this.user(), this.password());
    }

    public PostgresConnection copy(String database, String user, String password, String address, int port) {
        return new PostgresConnection(database, user, password, address, port);
    }

    public String copy$default$1() {
        return this.database();
    }

    public String copy$default$2() {
        return this.user();
    }

    public String copy$default$3() {
        return this.password();
    }

    public String copy$default$4() {
        return this.address();
    }

    public int copy$default$5() {
        return this.port();
    }

    public String productPrefix() {
        return "PostgresConnection";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.database();
                break;
            }
            case 1: {
                object = this.user();
                break;
            }
            case 2: {
                object = this.password();
                break;
            }
            case 3: {
                object = this.address();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.port());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PostgresConnection;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "database";
                break;
            }
            case 1: {
                string = "user";
                break;
            }
            case 2: {
                string = "password";
                break;
            }
            case 3: {
                string = "address";
                break;
            }
            case 4: {
                string = "port";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.database()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.password()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.address()));
        n = Statics.mix((int)n, (int)this.port());
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PostgresConnection)) return false;
        boolean bl = true;
        if (!bl) return false;
        PostgresConnection postgresConnection = (PostgresConnection)x$1;
        if (this.port() != postgresConnection.port()) return false;
        String string = this.database();
        String string2 = postgresConnection.database();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.user();
        String string4 = postgresConnection.user();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.password();
        String string6 = postgresConnection.password();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        String string7 = this.address();
        String string8 = postgresConnection.address();
        if (string7 == null) {
            if (string8 != null) {
                return false;
            }
        } else if (!string7.equals(string8)) return false;
        if (!postgresConnection.canEqual(this)) return false;
        return true;
    }

    public PostgresConnection(String database, String user, String password, String address, int port) {
        this.database = database;
        this.user = user;
        this.password = password;
        this.address = address;
        this.port = port;
        Product.$init$((Product)this);
    }
}

