/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.storage.arrow;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.visitor.InterlayerEdge;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.components.querymanager.FilteredEdgeMessage;
import com.raphtory.internals.components.querymanager.FilteredInEdgeMessage;
import com.raphtory.internals.components.querymanager.FilteredOutEdgeMessage;
import com.raphtory.internals.components.querymanager.GenericVertexMessage;
import com.raphtory.internals.components.querymanager.VertexMessage;
import com.raphtory.internals.graph.LensInterface;
import com.raphtory.internals.management.Scheduler;
import com.raphtory.internals.storage.GraphExecutionState;
import com.raphtory.internals.storage.GraphExecutionState$;
import com.raphtory.internals.storage.VotingMachine;
import com.raphtory.internals.storage.VotingMachine$;
import com.raphtory.internals.storage.arrow.ArrowPartition;
import com.raphtory.internals.storage.arrow.entities.ArrowExVertex;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.View;
import scala.collection.View$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\r-g!B\u001e=\u0003\u00039\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0005M\"Aq\b\u0001BC\u0002\u0013E!\u000f\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003t\u0011!A\bA!b\u0001\n\u0013I\b\"CA\u000b\u0001\t\u0005\t\u0015!\u0003{\u0011)\tY\u0003\u0001BC\u0002\u0013%\u0011Q\u0006\u0005\u000b\u0003\u0007\u0002!\u0011!Q\u0001\n\u0005=\u0002BCA#\u0001\t\u0015\r\u0011\"\u0003\u0002H!Q\u0011Q\u000b\u0001\u0003\u0002\u0003\u0006I!!\u0013\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!I\u0011q\u000f\u0001C\u0002\u0013%\u0011\u0011\u0010\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002|!I\u0011Q\u0012\u0001C\u0002\u0013%\u0011q\u0012\u0005\b\u0003#\u0003\u0001\u0015!\u0003g\u0011%\t\u0019\n\u0001a\u0001\n\u0013\t)\nC\u0005\u0002\u001e\u0002\u0001\r\u0011\"\u0003\u0002 \"A\u0011Q\u0015\u0001!B\u0013\t9\nC\u0005\u0002(\u0002\u0011\r\u0011\"\u0003\u0002*\"A\u00111\u0017\u0001!\u0002\u0013\tY\u000bC\u0005\u00026\u0002\u0011\r\u0011\"\u0005\u00028\"A\u0011q\u0018\u0001!\u0002\u0013\tI\fC\u0005\u0002B\u0002\u0001\r\u0011\"\u0003\u0002D\"I\u0011Q\u001d\u0001A\u0002\u0013%\u0011q\u001d\u0005\t\u0003W\u0004\u0001\u0015)\u0003\u0002F\"I\u0011Q\u001e\u0001A\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003c\u0004\u0001\u0019!C\u0001\u0003gDq!a>\u0001A\u0003&\u0011\rC\u0004\u0002z\u0002!\t%a?\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\"9!q\u0001\u0001\u0005\u0002\t%\u0001b\u0002B\b\u0001\u0011\u0005!\u0011\u0003\u0005\b\u0005C\u0001A\u0011IAK\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005KAqAa\n\u0001\t\u0003\u0012)\u0003C\u0004\u0003*\u0001!\tEa\u000b\t\u000f\te\u0002A\"\u0001\u0003<!9!q\r\u0001\u0005\u0002\t%\u0004b\u0002BF\u0001\u0011\u0005!1\b\u0005\b\u0005\u001b\u0003A\u0011\tBH\u0011\u001d\u0011i\t\u0001C!\u0005GCqAa1\u0001\t\u0003\u0012)\rC\u0004\u0003D\u0002!\tE!4\t\u000f\te\u0007\u0001\"\u0011\u0003\\\"9!q\u001d\u0001\u0005B\t%\bb\u0002B~\u0001\u0011\u0005#Q \u0005\b\u0007\u000f\u0001A\u0011IB\u0005\u0011\u001d\u0019I\u0007\u0001C!\u0007WBqa!!\u0001\t\u0003\u001a\u0019\tC\u0004\u0004\n\u0002!\tea#\t\u000f\rE\u0005\u0001\"\u0011\u0004\u0014\"9!q\u001d\u0001\u0005B\re\u0005bBBQ\u0001\u0011\u000531\u0015\u0005\b\u0007[\u0003A\u0011IBX\u0011\u001d\u0019y\f\u0001C!\u0005KAqa!1\u0001\t\u0003\u001a\u0019MA\tBEN$(/Y2u\u000fJ\f\u0007\u000f\u001b'f]NT!!\u0010 \u0002\u000b\u0005\u0014(o\\<\u000b\u0005}\u0002\u0015aB:u_J\fw-\u001a\u0006\u0003\u0003\n\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005\r#\u0015\u0001\u0003:ba\"$xN]=\u000b\u0003\u0015\u000b1aY8n\u0007\u0001\u00192\u0001\u0001%O!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u0019\te.\u001f*fMB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bQ\u0001\u0006OJ\f\u0007\u000f[\u0005\u0003'B\u0013Q\u0002T3og&sG/\u001a:gC\u000e,\u0017!\u00026pE&#\u0007C\u0001,^\u001d\t96\f\u0005\u0002Y\u00156\t\u0011L\u0003\u0002[\r\u00061AH]8pizJ!\u0001\u0018&\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039*\u000bQa\u001d;beR\u0004\"!\u00132\n\u0005\rT%\u0001\u0002'p]\u001e\f1!\u001a8e\u0003%\u0019X\u000f]3s'R,\u0007\u000f\u0005\u0002ha6\t\u0001N\u0003\u0002jU\u00061\u0011\r^8nS\u000eT!a\u001b7\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002n]\u0006!Q\u000f^5m\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!\u001d5\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s+\u0005\u0019\bC\u0001;v\u001b\u0005a\u0014B\u0001<=\u00059\t%O]8x!\u0006\u0014H/\u001b;j_:\f\u0001b\u001d;pe\u0006<W\rI\u0001\u000e[\u0016\u001c8/Y4f'\u0016tG-\u001a:\u0016\u0003i\u0004R!S>~\u0003KI!\u0001 &\u0003\u0013\u0019+hn\u0019;j_:\f\u0004g\u0001@\u0002\u0012A)q0!\u0003\u0002\u000e5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0007rk\u0016\u0014\u00180\\1oC\u001e,'OC\u0002\u0002\b\u0001\u000b!bY8na>tWM\u001c;t\u0013\u0011\tY!!\u0001\u0003)\u001d+g.\u001a:jGZ+'\u000f^3y\u001b\u0016\u001c8/Y4f!\u0011\ty!!\u0005\r\u0001\u0011Y\u00111\u0003\u0005\u0002\u0002\u0003\u0005)\u0011AA\f\u0005\ryF%M\u0001\u000f[\u0016\u001c8/Y4f'\u0016tG-\u001a:!#\u0011\tI\"a\b\u0011\u0007%\u000bY\"C\u0002\u0002\u001e)\u0013qAT8uQ&tw\rE\u0002J\u0003CI1!a\tK\u0005\r\te.\u001f\t\u0004\u0013\u0006\u001d\u0012bAA\u0015\u0015\n!QK\\5u\u00031)'O]8s\u0011\u0006tG\r\\3s+\t\ty\u0003\u0005\u0004Jw\u0006E\u0012Q\u0005\t\u0005\u0003g\tiD\u0004\u0003\u00026\u0005ebb\u0001-\u00028%\t1*C\u0002\u0002<)\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0005\u0005#!\u0003+ie><\u0018M\u00197f\u0015\r\tYDS\u0001\u000eKJ\u0014xN\u001d%b]\u0012dWM\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA%!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(\u0001\u0006QQ.\u00198bO\u0016lWM\u001c;\n\t\u0005M\u0013Q\n\u0002\n'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0011\u00121LA/\u0003?\n\t'a\u0019\u0002f\u0005\u001d\u00141OA;!\t!\b\u0001C\u0003U\u001b\u0001\u0007Q\u000bC\u0003a\u001b\u0001\u0007\u0011\rC\u0003e\u001b\u0001\u0007\u0011\rC\u0003f\u001b\u0001\u0007a\rC\u0003@\u001b\u0001\u00071\u000f\u0003\u0004y\u001b\u0001\u0007\u0011\u0011\u000e\t\u0007\u0013n\fY'!\n1\t\u00055\u0014\u0011\u000f\t\u0006\u007f\u0006%\u0011q\u000e\t\u0005\u0003\u001f\t\t\b\u0002\u0007\u0002\u0014\u0005\u001d\u0014\u0011!A\u0001\u0006\u0003\t9\u0002C\u0004\u0002,5\u0001\r!a\f\t\u000f\u0005\u0015S\u00021\u0001\u0002J\u00051An\\4hKJ,\"!a\u001f\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006a1oY1mC2|wmZ5oO*\u0019\u0011Q\u0011#\u0002\u0011QL\b/Z:bM\u0016LA!!#\u0002\u0000\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006wKJ$X\r_\"pk:$X#\u00014\u0002\u0019Y,'\u000f^3y\u0007>,h\u000e\u001e\u0011\u0002\u001b\u0019,H\u000e\\$sCBD7+\u001b>f+\t\t9\nE\u0002J\u00033K1!a'K\u0005\rIe\u000e^\u0001\u0012MVdGn\u0012:ba\"\u001c\u0016N_3`I\u0015\fH\u0003BA\u0013\u0003CC\u0011\"a)\u0014\u0003\u0003\u0005\r!a&\u0002\u0007a$\u0013'\u0001\bgk2dwI]1qQNK'0\u001a\u0011\u0002\u001bY|G/\u001b8h\u001b\u0006\u001c\u0007.\u001b8f+\t\tY\u000b\u0005\u0003\u0002.\u0006=V\"\u0001 \n\u0007\u0005EfHA\u0007W_RLgnZ'bG\"Lg.Z\u0001\u000fm>$\u0018N\\4NC\u000eD\u0017N\\3!\u0003)9'/\u00199i'R\fG/Z\u000b\u0003\u0003s\u0003B!!,\u0002<&\u0019\u0011Q\u0018 \u0003'\u001d\u0013\u0018\r\u001d5Fq\u0016\u001cW\u000f^5p]N#\u0018\r^3\u0002\u0017\u001d\u0014\u0018\r\u001d5Ti\u0006$X\rI\u0001\nI\u0006$\u0018\rV1cY\u0016,\"!!2\u0011\r\u0005\u001d\u0017QZAi\u001b\t\tIMC\u0002\u0002L*\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty-!3\u0003\tYKWm\u001e\t\u0005\u0003'\f\t/\u0004\u0002\u0002V*!\u0011q[Am\u0003\u0015!\u0018M\u00197f\u0015\u0011\tY.!8\u0002\u0011\u0005t\u0017\r\\=tSNT1!a8C\u0003\r\t\u0007/[\u0005\u0005\u0003G\f)NA\u0002S_^\fQ\u0002Z1uCR\u000b'\r\\3`I\u0015\fH\u0003BA\u0013\u0003SD\u0011\"a)\u001b\u0003\u0003\u0005\r!!2\u0002\u0015\u0011\fG/\u0019+bE2,\u0007%\u0001\u0002ucU\t\u0011-\u0001\u0004uc}#S-\u001d\u000b\u0005\u0003K\t)\u0010\u0003\u0005\u0002$v\t\t\u00111\u0001b\u0003\r!\u0018\u0007I\u0001\fa\u0006\u0014H/\u001b;j_:LE\t\u0006\u0002\u0002\u0018\u0006Q1\r[3dWZ{G/Z:\u0015\u0005\t\u0005\u0001cA%\u0003\u0004%\u0019!Q\u0001&\u0003\u000f\t{w\u000e\\3b]\u0006\u00012/\u001a;Gk2dwI]1qQNK'0\u001a\u000b\u0005\u0003K\u0011Y\u0001C\u0004\u0003\u000e\u0005\u0002\r!a&\u0002\tML'0Z\u0001\fg\u0016tG-T3tg\u0006<W\r\u0006\u0003\u0002&\tM\u0001b\u0002B\u000bE\u0001\u0007!qC\u0001\u0004[N<\u0007\u0007\u0002B\r\u0005;\u0001Ra`A\u0005\u00057\u0001B!a\u0004\u0003\u001e\u0011a!q\u0004B\n\u0003\u0003\u0005\tQ!\u0001\u0002\u0018\t\u0019q\f\n\u001a\u0002!\u001d,GOR;mY\u001e\u0013\u0018\r\u001d5TSj,\u0017\u0001\u00038fqR\u001cF/\u001a9\u0015\u0005\u0005\u0015\u0012!D2mK\u0006\u0014X*Z:tC\u001e,7/\u0001\bsK\u000e,\u0017N^3NKN\u001c\u0018mZ3\u0015\t\u0005\u0015\"Q\u0006\u0005\b\u0005+1\u0003\u0019\u0001B\u0018a\u0011\u0011\tD!\u000e\u0011\u000b}\fIAa\r\u0011\t\u0005=!Q\u0007\u0003\r\u0005o\u0011i#!A\u0001\u0002\u000b\u0005\u0011q\u0003\u0002\u0004?\u0012\u001a\u0014\u0001\u0003<feRL7-Z:\u0016\u0005\tu\u0002CBAd\u0003\u001b\u0014y\u0004\u0005\u0003\u0003B\t\u001dSB\u0001B\"\u0015\u0011\u0011)%!7\u0002\u000fYL7/\u001b;pe&!!\u0011\nB\"\u0005\u00191VM\u001d;fq\":qE!\u0014\u0003b\t\r\u0004\u0003\u0002B(\u0005;j!A!\u0015\u000b\t\tM#QK\u0001\tg\u000e\fG.\u00193pG*!!q\u000bB-\u0003\u001d!\u0018m[3{_\u0016T1Aa\u0017E\u0003\u00199\u0017\u000e\u001e5vE&!!q\fB)\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017E\u0001B3\u0003\tUqF\u000b\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011HSZ,\u0007%\\3!i\",\u0007E^3si&\u001cWm\u001d\u0011bY&4X\rI1uAQD\u0017n\u001d\u0011q_&tGO\u0003\u0011!A\u0001R\u0003%^:fAQDW\rI.\\\u000fJ\f\u0007\u000f[#yK\u000e,H/[8o'R\fG/\u001a\u0018jg\u0006c\u0017N^3^;\u0002\"x\u000eI2iK\u000e\\'\u0002\t\u0011!A)\u0002\u0013N\u001c\u0011uQ\u0016\u0004\u0013M\u001d:po\u0002\u001a\u0017m]3!o\u0016<C\u000e\u001c\u0011cK\u0002\u0002\u0018m]:j]\u001e\u0004C\u000f[3!Y>\u001c\u0017\r\u001c\u0011wKJ$X\r\u001f\u0011jI*\u0001\u0003\u0005\t\u0011+AQDWm]3!C2\u001cx\u000eI7vgR\u0004C/Y6fA%tGo\u001c\u0011bG\u000e|WO\u001c;!i\",\u0007eW.ti\u0006\u0014H/X/!C:$\u0007eW.f]\u0012lV\f\t7j[&$8O\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003I]3ukJt'\u0002\t\u0011!A)z\u0013\u0001\u00049be\u0006;wM]3hCR,W\u0003\u0002B6\u0005g\"BA!\u001c\u0003\bR!!q\u000eBA)\u0011\u0011\tHa\u001e\u0011\t\u0005=!1\u000f\u0003\b\u0005kB#\u0019AA\f\u0005\u0005\u0011\u0005b\u0002B=Q\u0001\u0007!1P\u0001\u0004C\u000e\u001c\u0007#C%\u0003~\tE$\u0011\u000fB9\u0013\r\u0011yH\u0013\u0002\n\rVt7\r^5p]JBqAa!)\u0001\u0004\u0011))\u0001\u0004nCB\u0004XM\u001d\t\u0007\u0013n\u0014yD!\u001d\t\u000f\t%\u0005\u00061\u0001\u0003r\u0005\t!-A\bdkJ\u0014XM\u001c;WKJ$\u0018nY3t\u0003A\u0011XO\\$sCBDg)\u001e8di&|g\u000e\u0006\u0003\u0003\u0012\nuE\u0003BA\u0013\u0005'CqA!&+\u0001\u0004\u00119*\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016\u0004R!\u0013BM\u0003KI1Aa'K\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0003 *\u0002\rA!)\u0002\u0003\u0019\u0004b!S>\u0003@\u0005\u0015BC\u0002BS\u0005S\u0013\t\r\u0006\u0003\u0002&\t\u001d\u0006b\u0002BKW\u0001\u0007!q\u0013\u0005\b\u0005?[\u0003\u0019\u0001BVa\u0011\u0011iK!-\u0011\u0013%\u0013iHa,\u00036\u0006\u0015\u0002\u0003BA\b\u0005c#ABa-\u0003*\u0006\u0005\t\u0011!B\u0001\u0003/\u00111a\u0018\u00135!\u0011\u00119L!0\u000e\u0005\te&\u0002\u0002B^\u00033\f!b\u001a:ba\"\u001cH/\u0019;f\u0013\u0011\u0011yL!/\u0003\u0015\u001d\u0013\u0018\r\u001d5Ti\u0006$X\rC\u0004\u00026.\u0002\rA!.\u00021I,h.T3tg\u0006<W\rZ$sCBDg)\u001e8di&|g\u000e\u0006\u0003\u0003H\n-G\u0003BA\u0013\u0005\u0013DqA!&-\u0001\u0004\u00119\nC\u0004\u0003 2\u0002\rA!)\u0015\r\t='1\u001bBl)\u0011\t)C!5\t\u000f\tUU\u00061\u0001\u0003\u0018\"9!qT\u0017A\u0002\tU\u0007#C%\u0003~\t}\"QWA\u0013\u0011\u001d\t),\fa\u0001\u0005k\u000bab\u001e:ji\u0016$\u0015\r^1UC\ndW\r\u0006\u0003\u0003^\n\u0005H\u0003BA\u0013\u0005?DqA!&/\u0001\u0004\u00119\nC\u0004\u0003d:\u0002\rA!:\u0002\r]\u0014\u0018\u000e^3s!\u0019I50!5\u0002&\u0005iQ\r_3dkR,7+\u001a7fGR$bAa;\u0003p\neH\u0003BA\u0013\u0005[DqA!&0\u0001\u0004\u00119\nC\u0004\u0003r>\u0002\rAa=\u0002\rY\fG.^3t!\u0015\t\u0019D!>V\u0013\u0011\u001190!\u0011\u0003\u0007M+\u0017\u000fC\u0004\u00026>\u0002\rA!.\u0002\u001b\u0019LG\u000e^3sK\u0012$\u0016M\u00197f)\u0011\u0011ypa\u0001\u0015\t\u0005\u00152\u0011\u0001\u0005\b\u0005+\u0003\u0004\u0019\u0001BL\u0011\u001d\u0011y\n\ra\u0001\u0007\u000b\u0001b!S>\u0002R\n\u0005\u0011A\u0003:fIV\u001cWMV5foRA11BB\b\u0007\u0013\u001a)\u0007\u0006\u0003\u0002&\r5\u0001b\u0002BKc\u0001\u0007!q\u0013\u0005\b\u0007#\t\u0004\u0019AB\n\u0003Q!WMZ1vYRlUM]4f'R\u0014\u0018\r^3hsB)\u0011j!\u0006\u0004\u001a%\u00191q\u0003&\u0003\r=\u0003H/[8oa\u0019\u0019Yba\u0010\u0004FAA1QDB\u001c\u0007{\u0019\u0019E\u0004\u0003\u0004 \rMb\u0002BB\u0011\u0007cqAaa\t\u000409!1QEB\u0017\u001d\u0011\u00199ca\u000b\u000f\u0007a\u001bI#C\u0001F\u0013\t\u0019E)C\u0002\u0002`\nKA!a7\u0002^&!!QIAm\u0013\u0011\u0019)Da\u0011\u0002+A\u0013x\u000e]3siflUM]4f'R\u0014\u0018\r^3hs&!1\u0011HB\u001e\u00055\u0001&o\u001c9feRLX*\u001a:hK*!1Q\u0007B\"!\u0011\tyaa\u0010\u0005\u0019\r\u00053qBA\u0001\u0002\u0003\u0015\t!a\u0006\u0003\u0007}#S\u0007\u0005\u0003\u0002\u0010\r\u0015C\u0001DB$\u0007\u001f\t\t\u0011!A\u0003\u0002\u0005]!aA0%m!911J\u0019A\u0002\r5\u0013\u0001E7fe\u001e,7\u000b\u001e:bi\u0016<\u00170T1q!\u0015I5QCB(!\u001916\u0011K+\u0004V%\u001911K0\u0003\u00075\u000b\u0007\u000f\r\u0004\u0004X\rm3\u0011\r\t\t\u0007;\u00199d!\u0017\u0004`A!\u0011qBB.\t1\u0019if!\u0013\u0002\u0002\u0003\u0005)\u0011AA\f\u0005\ryFe\u000e\t\u0005\u0003\u001f\u0019\t\u0007\u0002\u0007\u0004d\r%\u0013\u0011!A\u0001\u0006\u0003\t9BA\u0002`IaBqaa\u001a2\u0001\u0004\u0011\t!A\u0005bO\u001e\u0014XmZ1uK\u0006YQ\r\u001f9m_\u0012,g+[3x)\u0011\u0019ig!\u001d\u0015\t\u0005\u00152q\u000e\u0005\b\u0005+\u0013\u0004\u0019\u0001BL\u0011\u001d\u0019\u0019H\ra\u0001\u0007k\nQ#\u001b8uKJd\u0017-_3s\u000b\u0012<WMQ;jY\u0012,'\u000fE\u0003J\u0007+\u00199\b\u0005\u0004Jw\n}2\u0011\u0010\t\u0007\u0003g\u0011)pa\u001f\u0011\t\t\u00053QP\u0005\u0005\u0007\u007f\u0012\u0019E\u0001\bJ]R,'\u000f\\1zKJ,EmZ3\u0002\u001dYLWm^+oI&\u0014Xm\u0019;fIR\u00111Q\u0011\u000b\u0005\u0003K\u00199\tC\u0004\u0003\u0016N\u0002\rAa&\u0002\u0019YLWm\u001e#je\u0016\u001cG/\u001a3\u0015\u0005\r5E\u0003BA\u0013\u0007\u001fCqA!&5\u0001\u0004\u00119*\u0001\u0007wS\u0016<(+\u001a<feN,G\r\u0006\u0002\u0004\u0016R!\u0011QEBL\u0011\u001d\u0011)*\u000ea\u0001\u0005/#Baa'\u0004 R!\u0011QEBO\u0011\u001d\u0011)J\u000ea\u0001\u0005/CqA!=7\u0001\u0004\u0011\u00190\u0001\bfqBdw\u000eZ3D_2,XN\\:\u0015\t\r\u00156\u0011\u0016\u000b\u0005\u0003K\u00199\u000bC\u0004\u0003\u0016^\u0002\rAa&\t\u000f\r-v\u00071\u0001\u0003t\u000691m\u001c7v[:\u001c\u0018!\u0004:f]\u0006lWmQ8mk6t7\u000f\u0006\u0003\u00042\u000eUF\u0003BA\u0013\u0007gCqA!&9\u0001\u0004\u00119\nC\u0004\u0004,b\u0002\raa.\u0011\r\u0005M\"Q_B]!\u0015I51X+V\u0013\r\u0019iL\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0017%tg-\u001a:IK\u0006$WM]\u0001\u000fS:4WM\u001d:fI\"+\u0017\rZ3s+\t\u0019)\rE\u0003\u00024\r\u001dW+\u0003\u0003\u0004J\u0006\u0005#\u0001\u0002'jgR\u0004")
public abstract class AbstractGraphLens
implements LensInterface {
    private final AtomicInteger superStep;
    private final ArrowPartition storage;
    private final Function1<GenericVertexMessage<?>, BoxedUnit> messageSender;
    private final Function1<Throwable, BoxedUnit> errorHandler;
    private final Scheduler scheduler;
    private final Logger logger;
    private final AtomicInteger vertexCount;
    private int fullGraphSize;
    private final VotingMachine votingMachine;
    private final GraphExecutionState graphState;
    private View<Row> dataTable;
    private long t1;

    public ArrowPartition storage() {
        return this.storage;
    }

    private Function1<GenericVertexMessage<?>, BoxedUnit> messageSender() {
        return this.messageSender;
    }

    private Function1<Throwable, BoxedUnit> errorHandler() {
        return this.errorHandler;
    }

    private Scheduler scheduler() {
        return this.scheduler;
    }

    private Logger logger() {
        return this.logger;
    }

    private AtomicInteger vertexCount() {
        return this.vertexCount;
    }

    private int fullGraphSize() {
        return this.fullGraphSize;
    }

    private void fullGraphSize_$eq(int x$1) {
        this.fullGraphSize = x$1;
    }

    private VotingMachine votingMachine() {
        return this.votingMachine;
    }

    public GraphExecutionState graphState() {
        return this.graphState;
    }

    private View<Row> dataTable() {
        return this.dataTable;
    }

    private void dataTable_$eq(View<Row> x$1) {
        this.dataTable = x$1;
    }

    public long t1() {
        return this.t1;
    }

    public void t1_$eq(long x$1) {
        this.t1 = x$1;
    }

    @Override
    public int partitionID() {
        return this.storage().getPartitionID();
    }

    @Override
    public boolean checkVotes() {
        return this.votingMachine().checkVotes(this.vertexCount().get());
    }

    @Override
    public void setFullGraphSize(int size) {
        BoxedUnit boxedUnit;
        this.fullGraphSize_$eq(size);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Set Graph Size to '{}'.", (Object)BoxesRunTime.boxToInteger((int)this.fullGraphSize()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void sendMessage(GenericVertexMessage<?> msg) {
        this.messageSender().apply(msg);
    }

    @Override
    public int getFullGraphSize() {
        return this.fullGraphSize();
    }

    @Override
    public void nextStep() {
        this.votingMachine().reset();
        this.t1_$eq(System.currentTimeMillis());
        this.vertexCount().set(0);
        this.graphState().nextStep(this.superStep.getAndIncrement());
    }

    @Override
    public void clearMessages() {
        this.graphState().clearMessages();
    }

    @Override
    public void receiveMessage(GenericVertexMessage<?> msg) {
        GenericVertexMessage<?> genericVertexMessage = msg;
        if (genericVertexMessage instanceof VertexMessage) {
            VertexMessage vertexMessage = (VertexMessage)genericVertexMessage;
            this.graphState().receiveMessage(vertexMessage.vertexId(), vertexMessage.superstep(), vertexMessage.data());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (genericVertexMessage instanceof FilteredEdgeMessage) {
            FilteredEdgeMessage filteredEdgeMessage = (FilteredEdgeMessage)genericVertexMessage;
            this.graphState().removeEdge(BoxesRunTime.unboxToLong(filteredEdgeMessage.vertexId()), BoxesRunTime.unboxToLong(filteredEdgeMessage.sourceId()), (Option<Object>)None$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (genericVertexMessage instanceof FilteredInEdgeMessage) {
            FilteredInEdgeMessage filteredInEdgeMessage = (FilteredInEdgeMessage)genericVertexMessage;
            this.graphState().removeInEdge(BoxesRunTime.unboxToLong(filteredInEdgeMessage.sourceId()), BoxesRunTime.unboxToLong(filteredInEdgeMessage.vertexId()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (genericVertexMessage instanceof FilteredOutEdgeMessage) {
            FilteredOutEdgeMessage filteredOutEdgeMessage = (FilteredOutEdgeMessage)genericVertexMessage;
            this.graphState().removeOutEdge(BoxesRunTime.unboxToLong(filteredOutEdgeMessage.sourceId()), BoxesRunTime.unboxToLong(filteredOutEdgeMessage.vertexId()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Scaladoc(value="/**\n    * Give me the vertices alive at this point\n    * use the [[GraphExecutionState.isAlive]] to check\n    * in the arrow case we'll be passing the local vertex id\n    * these also must take into account the [[start]] and [[end]] limits\n    *\n    * @return\n    */")
    public abstract View<Vertex> vertices();

    public <B> B parAggregate(B b, Function1<Vertex, B> mapper, Function2<B, B, B> acc) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public View<Vertex> currentVertices() {
        return (View)this.graphState().currentStepVertices().map((Function1 & Serializable)id -> AbstractGraphLens.$anonfun$currentVertices$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    @Override
    public void runGraphFunction(Function1<Vertex, BoxedUnit> f, Function0<BoxedUnit> onComplete) {
        this.vertexCount().set(0);
        int count = BoxesRunTime.unboxToInt((Object)this.parAggregate((Object)BoxesRunTime.boxToInteger((int)0), (Function1)(Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)AbstractGraphLens.$anonfun$runGraphFunction$1(f, v)), (Function2)(JFunction2.mcIII.sp & Serializable)(x$1, x$2) -> x$1 + x$2));
        this.vertexCount().set(count);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void runGraphFunction(Function2<?, GraphState, BoxedUnit> f, GraphState graphState, Function0<BoxedUnit> onComplete) {
        this.vertexCount().set(0);
        int count = BoxesRunTime.unboxToInt((Object)this.parAggregate((Object)BoxesRunTime.boxToInteger((int)0), (Function1)(Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)AbstractGraphLens.$anonfun$runGraphFunction$3(f, graphState, v)), (Function2)(JFunction2.mcIII.sp & Serializable)(x$3, x$4) -> x$3 + x$4));
        this.vertexCount().set(count);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void runMessagedGraphFunction(Function1<Vertex, BoxedUnit> f, Function0<BoxedUnit> onComplete) {
        this.vertexCount().set(0);
        int count = BoxesRunTime.unboxToInt((Object)this.parAggregate((Object)BoxesRunTime.boxToInteger((int)0), (Function1)(Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)AbstractGraphLens.$anonfun$runMessagedGraphFunction$1(f, v)), (Function2)(JFunction2.mcIII.sp & Serializable)(x$5, x$6) -> x$5 + x$6));
        this.vertexCount().set(count);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void runMessagedGraphFunction(Function2<Vertex, GraphState, BoxedUnit> f, GraphState graphState, Function0<BoxedUnit> onComplete) {
        this.vertexCount().set(0);
        int count = BoxesRunTime.unboxToInt((Object)this.parAggregate((Object)BoxesRunTime.boxToInteger((int)0), (Function1)(Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)AbstractGraphLens.$anonfun$runMessagedGraphFunction$3(f, graphState, v)), (Function2)(JFunction2.mcIII.sp & Serializable)(x$7, x$8) -> x$7 + x$8));
        this.vertexCount().set(count);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void writeDataTable(Function1<Row, BoxedUnit> writer, Function0<BoxedUnit> onComplete) {
        this.dataTable().foreach(writer);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void executeSelect(Seq<String> values, GraphState graphState, Function0<BoxedUnit> onComplete) {
        if (this.partitionID() == 0) {
            this.dataTable_$eq((View<Row>)View$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq<Tuple2<String, Object>>)((Seq)values.map((Function1 & Serializable)key -> new Tuple2(key, graphState.apply((String)key).value()))))})));
        }
        onComplete.apply$mcV$sp();
    }

    @Override
    public void filteredTable(Function1<Row, Object> f, Function0<BoxedUnit> onComplete) {
        this.dataTable_$eq((View<Row>)((View)this.dataTable().filter(f)));
        onComplete.apply$mcV$sp();
    }

    @Override
    public void reduceView(Option<Function1<Iterable<PropertyValue<Object>>, Object>> defaultMergeStrategy, Option<Map<String, Function1<Iterable<PropertyValue<Object>>, Object>>> mergeStrategyMap, boolean aggregate, Function0<BoxedUnit> onComplete) {
        onComplete.apply$mcV$sp();
    }

    @Override
    public void explodeView(Option<Function1<Vertex, Seq<InterlayerEdge>>> interlayerEdgeBuilder, Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void viewUndirected(Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void viewDirected(Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void viewReversed(Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void executeSelect(Seq<String> values, Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void explodeColumns(Seq<String> columns, Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void renameColumns(Seq<Tuple2<String, String>> columns, Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void inferHeader() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public List<String> inferredHeader() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static final /* synthetic */ ArrowExVertex $anonfun$currentVertices$1(AbstractGraphLens $this, long id) {
        return new ArrowExVertex($this.graphState(), $this.storage().getVertex(id));
    }

    public static final /* synthetic */ int $anonfun$runGraphFunction$1(Function1 f$1, Vertex v) {
        f$1.apply((Object)v);
        return 1;
    }

    public static final /* synthetic */ int $anonfun$runGraphFunction$3(Function2 f$2, GraphState graphState$1, Vertex v) {
        f$2.apply((Object)v, (Object)graphState$1);
        return 1;
    }

    public static final /* synthetic */ int $anonfun$runMessagedGraphFunction$1(Function1 f$3, Vertex v) {
        int n;
        if (v.hasMessage()) {
            f$3.apply((Object)v);
            n = 1;
        } else {
            n = 0;
        }
        return n;
    }

    public static final /* synthetic */ int $anonfun$runMessagedGraphFunction$3(Function2 f$4, GraphState graphState$2, Vertex v) {
        int n;
        if (v.hasMessage()) {
            f$4.apply((Object)v, (Object)graphState$2);
            n = 1;
        } else {
            n = 0;
        }
        return n;
    }

    public AbstractGraphLens(String jobId, long start, long end, AtomicInteger superStep, ArrowPartition storage, Function1<GenericVertexMessage<?>, BoxedUnit> messageSender, Function1<Throwable, BoxedUnit> errorHandler, Scheduler scheduler) {
        this.superStep = superStep;
        this.storage = storage;
        this.messageSender = messageSender;
        this.errorHandler = errorHandler;
        this.scheduler = scheduler;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        this.vertexCount = new AtomicInteger(0);
        this.fullGraphSize = 0;
        this.votingMachine = VotingMachine$.MODULE$.apply();
        this.graphState = GraphExecutionState$.MODULE$.apply(this.partitionID(), superStep, messageSender, (Function1<Object, Object>)(JFunction1.mcJJ.sp & Serializable)vertexId -> this.storage().asGlobal(vertexId), this.votingMachine(), start, end);
        this.dataTable = View$.MODULE$.empty();
        this.t1 = System.currentTimeMillis();
    }
}

