/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.management.discovery;

import cats.effect.kernel.Async;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.raphtory.internals.management.discovery.ServiceInstance;
import java.io.Serializable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001\u0002\u0006\f\u0001YA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tW\u0001\u0011\t\u0011)A\u0006Y!)A\n\u0001C\u0001\u001b\"91\u000b\u0001b\u0001\n\u0013!\u0006BB0\u0001A\u0003%Q\u000bC\u0003a\u0001\u0011\u0005\u0011\rC\u0003x\u0001\u0011%\u0001\u0010C\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002\b\u0001!\t!!\u0003\u0003!M+'O^5dK\u0012K7oY8wKJL(B\u0001\u0007\u000e\u0003%!\u0017n]2pm\u0016\u0014\u0018P\u0003\u0002\u000f\u001f\u0005QQ.\u00198bO\u0016lWM\u001c;\u000b\u0005A\t\u0012!C5oi\u0016\u0014h.\u00197t\u0015\t\u00112#\u0001\u0005sCBDGo\u001c:z\u0015\u0005!\u0012aA2p[\u000e\u0001QCA\fA'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0003u.\u0004\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\u0013\u0019\u0014\u0018-\\3x_J\\'B\u0001\u0013&\u0003\u001d\u0019WO]1u_JT!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO&\u0011!&\t\u0002\u0011\u0007V\u0014\u0018\r^8s\rJ\fW.Z<pe.\f\u0011A\u0012\t\u0004[mrdB\u0001\u00189\u001d\tySG\u0004\u00021g5\t\u0011G\u0003\u00023+\u00051AH]8pizJ\u0011\u0001N\u0001\u0005G\u0006$8/\u0003\u00027o\u00051QM\u001a4fGRT\u0011\u0001N\u0005\u0003si\nq\u0001]1dW\u0006<WM\u0003\u00027o%\u0011A(\u0010\u0002\u0006\u0003NLhn\u0019\u0006\u0003si\u0002\"a\u0010!\r\u0001\u0011)\u0011\t\u0001b\u0001\u0005\n\ta)\u0006\u0002D\u0015F\u0011Ai\u0012\t\u00033\u0015K!A\u0012\u000e\u0003\u000f9{G\u000f[5oOB\u0011\u0011\u0004S\u0005\u0003\u0013j\u00111!\u00118z\t\u0015Y\u0005I1\u0001D\u0005\u0011yF\u0005J\u0019\u0002\rqJg.\u001b;?)\tq%\u000b\u0006\u0002P#B\u0019\u0001\u000b\u0001 \u000e\u0003-AQaK\u0002A\u00041BQAH\u0002A\u0002}\t!a\\7\u0016\u0003U\u0003\"AV/\u000e\u0003]S!\u0001W-\u0002\u0011\u0011\fG/\u00192j]\u0012T!AW.\u0002\u000f)\f7m[:p]*\u0011AlE\u0001\nM\u0006\u001cH/\u001a:y[2L!AX,\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u0007=l\u0007%A\bsK\u001eL7\u000f^3s'\u0016\u0014h/[2f)\u0011\u0011gm[;\u0011\u0007}\u00025\r\u0005\u0002\u001aI&\u0011QM\u0007\u0002\u0004\u0013:$\b\"B4\u0007\u0001\u0004A\u0017aD:feZL7-Z%ogR\fgnY3\u0011\u0005AK\u0017B\u00016\f\u0005=\u0019VM\u001d<jG\u0016Len\u001d;b]\u000e,\u0007\"\u00027\u0007\u0001\u0004i\u0017\u0001\u00028b[\u0016\u0004\"A\u001c:\u000f\u0005=\u0004\bC\u0001\u0019\u001b\u0013\t\t($\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9\u001b\u0011\u00151h\u00011\u0001d\u0003\tIG-\u0001\u0004nWB\u000bG\u000f\u001b\u000b\u0004[fT\b\"\u00027\b\u0001\u0004i\u0007\"\u0002<\b\u0001\u0004\u0019\u0017\u0001E9vKJLhi\u001c:J]N$\u0018M\\2f)\u0015i\u00181AA\u0003!\ry\u0004I \t\u00043}D\u0017bAA\u00015\t1q\n\u001d;j_:DQ\u0001\u001c\u0005A\u00025DQA\u001e\u0005A\u0002\r\f\u0011#\u001e8sK\u001eL7\u000f^3s'\u0016\u0014h/[2f)\u0019\tY!a\u0005\u0002\u0016A!q\bQA\u0007!\rI\u0012qB\u0005\u0004\u0003#Q\"\u0001B+oSRDQ\u0001\\\u0005A\u00025DQA^\u0005A\u0002\r\u0004")
public class ServiceDiscovery<F> {
    private final CuratorFramework zk;
    private final Async<F> F;
    private final ObjectMapper om;

    private ObjectMapper om() {
        return this.om;
    }

    public F registerService(ServiceInstance serviceInstance, String name, int id) {
        return (F)this.F.blocking((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            ((PathAndBytesable)$this.zk.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.mkPath(name, id), this.om().writeValueAsBytes((Object)serviceInstance));
            return id;
        });
    }

    private String mkPath(String name, int id) {
        return new StringBuilder(12).append("/discovery/").append(name).append("-").append(id).toString();
    }

    public F queryForInstance(String name, int id) {
        return (F)this.F.blocking((Function0 & Serializable)() -> {
            Some some;
            try {
                byte[] bytes = (byte[])$this.zk.getData().forPath(this.mkPath(name, id));
                some = new Some(this.om().readValue(bytes, ServiceInstance.class));
            }
            catch (Throwable throwable) {
                Throwable t;
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() || !((t = (Throwable)option.get()) instanceof KeeperException.NoNodeException)) {
                    throw throwable;
                }
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        });
    }

    public F unregisterService(String name, int id) {
        return (F)this.F.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.zk.delete().forPath(this.mkPath(name, id)));
    }

    public ServiceDiscovery(CuratorFramework zk, Async<F> F) {
        this.zk = zk;
        this.F = F;
        this.om = new ObjectMapper();
        this.om().registerModule((Module)DefaultScalaModule$.MODULE$);
    }
}

