/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.graph;

import cats.Functor;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.MaybeType;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Type;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.graph.UnsafeGraphCallback$;
import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** This class implements Graph interface by putting updates into a provided array buffer\n  * so we can get updates out of it to be sent to the partitions\n  */")
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001\u0002\u000f\u001e\u0001\u001aB\u0001\"\u0012\u0001\u0003\u0012\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0019!C\u0001\u0017\"A\u0011\u000b\u0001B\tB\u0003&q\t\u0003\u0005S\u0001\tU\r\u0011\"\u0001T\u0011!Y\u0007A!E!\u0002\u0013!\u0006\u0002\u00037\u0001\u0005\u0007\u0005\u000b1B7\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u00111\u0003\u0001\u0005R\u0005U\u0001\"CA\u000e\u0001\u0005\u0005I\u0011AA\u000f\u0011%\t)\u0004AI\u0001\n\u0003\t9\u0004C\u0005\u0002V\u0001\t\n\u0011\"\u0001\u0002X!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003o\u0002\u0011\u0011!C\u0001\u0003sB\u0011\"!!\u0001\u0003\u0003%\t!a!\t\u0013\u0005\u001d\u0005!!A\u0005B\u0005%\u0005\"CAJ\u0001\u0005\u0005I\u0011AAK\u0011%\ty\nAA\u0001\n\u0003\n\t\u000bC\u0005\u0002&\u0002\t\t\u0011\"\u0011\u0002(\"I\u0011\u0011\u0016\u0001\u0002\u0002\u0013\u0005\u00131\u0016\u0005\n\u0003[\u0003\u0011\u0011!C!\u0003_;\u0011\"a4\u001e\u0003\u0003E\t!!5\u0007\u0011qi\u0012\u0011!E\u0001\u0003'Dq!a\u0001\u0017\t\u0003\ty\u000eC\u0005\u0002*Z\t\t\u0011\"\u0012\u0002,\"I\u0011\u0011\u001d\f\u0002\u0002\u0013\u0005\u00151\u001d\u0005\n\u0003w4\u0012\u0011!CA\u0003{D\u0011Ba\u0007\u0017\u0003\u0003%IA!\b\u0003'Us7/\u00194f\u000fJ\f\u0007\u000f[\"bY2\u0014\u0017mY6\u000b\u0005yy\u0012!B4sCBD'B\u0001\u0011\"\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002#G\u0005A!/\u00199ii>\u0014\u0018PC\u0001%\u0003\r\u0019w.\\\u0002\u0001+\t9SoE\u0003\u0001Q92\u0014\b\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nQ!\u001b8qkRT!aM\u0011\u0002\u0007\u0005\u0004\u0018.\u0003\u00026a\t)qI]1qQB\u0011\u0011fN\u0005\u0003q)\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002;\u0005:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}\u0015\na\u0001\u0010:p_Rt\u0014\"A\u0016\n\u0005\u0005S\u0013a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!\u0011\u0016\u0002\u000b%tG-\u001a=\u0016\u0003\u001d\u0003\"!\u000b%\n\u0005%S#\u0001\u0002'p]\u001e\f\u0011\"\u001b8eKb|F%Z9\u0015\u00051{\u0005CA\u0015N\u0013\tq%F\u0001\u0003V]&$\bb\u0002)\u0003\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0014AB5oI\u0016D\b%A\u0001c+\u0005!\u0006cA+[96\taK\u0003\u0002X1\u00069Q.\u001e;bE2,'BA-+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00037Z\u00131\"\u0011:sCf\u0014UO\u001a4feB\u0011Q\f\u001b\b\u0003=\u001at!aX3\u000f\u0005\u0001$gBA1d\u001d\ta$-C\u0001%\u0013\t\u00113%\u0003\u0002!C%\u0011adH\u0005\u0003Ov\tqb\u0012:ba\"\fE\u000e^3sCRLwN\\\u0005\u0003S*\u00141b\u0012:ba\",\u0006\u000fZ1uK*\u0011q-H\u0001\u0003E\u0002\n!\"\u001a<jI\u0016t7-\u001a\u00132!\rq\u0017o]\u0007\u0002_*\t\u0001/\u0001\u0003dCR\u001c\u0018B\u0001:p\u0005\u001d1UO\\2u_J\u0004\"\u0001^;\r\u0001\u0011)a\u000f\u0001b\u0001o\n\ta)\u0006\u0002y\u007fF\u0011\u0011\u0010 \t\u0003SiL!a\u001f\u0016\u0003\u000f9{G\u000f[5oOB\u0011\u0011&`\u0005\u0003}*\u00121!\u00118z\t\u0019\t\t!\u001eb\u0001q\n!q\f\n\u00133\u0003\u0019a\u0014N\\5u}Q1\u0011qAA\b\u0003#!B!!\u0003\u0002\u000eA!\u00111\u0002\u0001t\u001b\u0005i\u0002\"\u00027\b\u0001\bi\u0007\"B#\b\u0001\u00049\u0005\"\u0002*\b\u0001\u0004!\u0016!\u00055b]\u0012dWm\u0012:ba\",\u0006\u000fZ1uKR\u0019A*a\u0006\t\r\u0005e\u0001\u00021\u0001]\u0003\u0019)\b\u000fZ1uK\u0006!1m\u001c9z+\u0011\ty\"a\n\u0015\r\u0005\u0005\u0012\u0011GA\u001a)\u0011\t\u0019#!\f\u0011\u000b\u0005-\u0001!!\n\u0011\u0007Q\f9\u0003\u0002\u0004w\u0013\t\u0007\u0011\u0011F\u000b\u0004q\u0006-BaBA\u0001\u0003O\u0011\r\u0001\u001f\u0005\u0007Y&\u0001\u001d!a\f\u0011\t9\f\u0018Q\u0005\u0005\b\u000b&\u0001\n\u00111\u0001H\u0011\u001d\u0011\u0016\u0002%AA\u0002Q\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0002:\u0005=SCAA\u001eU\r9\u0015QH\u0016\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\n\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0005\r#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121aO\u0003b\u0001\u0003#*2\u0001_A*\t\u001d\t\t!a\u0014C\u0002a\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0003\u0002Z\u0005uSCAA.U\r!\u0016Q\b\u0003\u0007m.\u0011\r!a\u0018\u0016\u0007a\f\t\u0007B\u0004\u0002\u0002\u0005u#\u0019\u0001=\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\t1\fgn\u001a\u0006\u0003\u0003c\nAA[1wC&!\u0011QOA6\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0010\t\u0004S\u0005u\u0014bAA@U\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A0!\"\t\u0011As\u0011\u0011!a\u0001\u0003w\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0003R!!$\u0002\u0010rl\u0011\u0001W\u0005\u0004\u0003#C&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a&\u0002\u001eB\u0019\u0011&!'\n\u0007\u0005m%FA\u0004C_>dW-\u00198\t\u000fA\u0003\u0012\u0011!a\u0001y\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9'a)\t\u0011A\u000b\u0012\u0011!a\u0001\u0003w\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003w\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003O\na!Z9vC2\u001cH\u0003BAL\u0003cCq\u0001\u0015\u000b\u0002\u0002\u0003\u0007A\u0010K\u0004\u0001\u0003k\u000bI-a3\u0011\t\u0005]\u0016QY\u0007\u0003\u0003sSA!a/\u0002>\u0006A1oY1mC\u0012|7M\u0003\u0003\u0002@\u0006\u0005\u0017a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0003\u0007\u001c\u0013AB4ji\",(-\u0003\u0003\u0002H\u0006e&\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\u00055\u0017!a\u00100U)\u0002C\u000b[5tA\rd\u0017m]:!S6\u0004H.Z7f]R\u001c\be\u0012:ba\"\u0004\u0013N\u001c;fe\u001a\f7-\u001a\u0011cs\u0002\u0002X\u000f\u001e;j]\u001e\u0004S\u000f\u001d3bi\u0016\u001c\b%\u001b8u_\u0002\n\u0007\u0005\u001d:pm&$W\r\u001a\u0011beJ\f\u0017\u0010\t2vM\u001a,'O\u0003\u0011!U\u0001\u001ax\u000eI<fA\r\fg\u000eI4fi\u0002*\b\u000fZ1uKN\u0004s.\u001e;!_\u001a\u0004\u0013\u000e\u001e\u0011u_\u0002\u0012W\rI:f]R\u0004Co\u001c\u0011uQ\u0016\u0004\u0003/\u0019:uSRLwN\\:\u000bA\u0001Rs&A\nV]N\fg-Z$sCBD7)\u00197mE\u0006\u001c7\u000eE\u0002\u0002\fY\u0019BA\u0006\u0015\u0002VB!\u0011q[Ao\u001b\t\tIN\u0003\u0003\u0002\\\u0006=\u0014AA5p\u0013\r\u0019\u0015\u0011\u001c\u000b\u0003\u0003#\fQ!\u00199qYf,B!!:\u0002nR1\u0011q]A|\u0003s$B!!;\u0002tB)\u00111\u0002\u0001\u0002lB\u0019A/!<\u0005\rYL\"\u0019AAx+\rA\u0018\u0011\u001f\u0003\b\u0003\u0003\tiO1\u0001y\u0011\u0019a\u0017\u0004q\u0001\u0002vB!a.]Av\u0011\u0015)\u0015\u00041\u0001H\u0011\u0015\u0011\u0016\u00041\u0001U\u0003\u001d)h.\u00199qYf,B!a@\u0003\u0016Q!!\u0011\u0001B\u0007!\u0015I#1\u0001B\u0004\u0013\r\u0011)A\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b%\u0012Ia\u0012+\n\u0007\t-!F\u0001\u0004UkBdWM\r\u0005\n\u0005\u001fQ\u0012\u0011!a\u0001\u0005#\t1\u0001\u001f\u00131!\u0015\tY\u0001\u0001B\n!\r!(Q\u0003\u0003\u0007mj\u0011\rAa\u0006\u0016\u0007a\u0014I\u0002B\u0004\u0002\u0002\tU!\u0019\u0001=\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t}\u0001\u0003BA5\u0005CIAAa\t\u0002l\t1qJ\u00196fGR\u0004")
public class UnsafeGraphCallback<F>
implements Graph,
Product,
Serializable {
    private long index;
    private final ArrayBuffer<GraphAlteration.GraphUpdate> b;

    public static <F> Option<Tuple2<Object, ArrayBuffer<GraphAlteration.GraphUpdate>>> unapply(UnsafeGraphCallback<F> x$0) {
        return UnsafeGraphCallback$.MODULE$.unapply(x$0);
    }

    public static <F> UnsafeGraphCallback<F> apply(long index, ArrayBuffer<GraphAlteration.GraphUpdate> b, Functor<F> evidence$1) {
        return UnsafeGraphCallback$.MODULE$.apply(index, b, evidence$1);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param posTypeArg specify a [[Type Type]] for the vertex\n    */")
    public void addVertex(long updateTime, long srcId, Type posTypeArg) {
        Graph.addVertex$(this, updateTime, srcId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param properties Optionally specify vertex properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param vertexType Optionally specify a [[Type Type]] for the vertex\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addVertex(long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        Graph.addVertex$(this, updateTime, srcId, properties, vertexType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param properties edge properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param edgeType   specify a [[Type Type]] for the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        Graph.addEdge$(this, updateTime, srcId, dstId, properties, edgeType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param posTypeArg   specify a [[Type Type]] for the edge\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Type posTypeArg) {
        Graph.addEdge$(this, updateTime, srcId, dstId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Convenience method for generating unique IDs based on vertex names\n    *\n    * Use of this method is optional. A `GraphBuilder` is free to assign vertex IDs in different ways, provided\n    * that each vertex is assigned a unique ID of type `Long`.\n    *\n    * @param uniqueChars Vertex name\n    */")
    public long assignID(String uniqueChars) {
        return Graph.assignID$(this, uniqueChars);
    }

    @Override
    @Scaladoc(value="/** Convenience method for converting dates into epochs to be used internally by Raphtory. This is the same function\n    * used by the `add vertex` and `add edge` functions, so can be called explicitly in a graph builder\n    * to reduce the number of conversions when performing multiple updates per tuple.\n    *\n    * @param dateTime The date string you wish to convert\n    * @param format The format of the date string. The default being \"yyyy-MM-dd[ HH:mm:ss[.SSS]].\"\n    * .\n    */")
    public long parseDatetime(String dateTime, String format) {
        return Graph.parseDatetime$(this, dateTime, format);
    }

    @Override
    public Properties addVertex$default$3() {
        return Graph.addVertex$default$3$(this);
    }

    @Override
    public MaybeType addVertex$default$4() {
        return Graph.addVertex$default$4$(this);
    }

    @Override
    public long addVertex$default$5() {
        return Graph.addVertex$default$5$(this);
    }

    @Override
    public Properties addEdge$default$4() {
        return Graph.addEdge$default$4$(this);
    }

    @Override
    public MaybeType addEdge$default$5() {
        return Graph.addEdge$default$5$(this);
    }

    @Override
    public long addEdge$default$6() {
        return Graph.addEdge$default$6$(this);
    }

    @Override
    public String parseDatetime$default$2() {
        return Graph.parseDatetime$default$2$(this);
    }

    @Override
    public long index() {
        return this.index;
    }

    public void index_$eq(long x$1) {
        this.index = x$1;
    }

    public ArrayBuffer<GraphAlteration.GraphUpdate> b() {
        return this.b;
    }

    @Override
    public void handleGraphUpdate(GraphAlteration.GraphUpdate update) {
        this.b().$plus$eq((Object)update);
    }

    public <F> UnsafeGraphCallback<F> copy(long index, ArrayBuffer<GraphAlteration.GraphUpdate> b, Functor<F> evidence$1) {
        return new UnsafeGraphCallback<F>(index, b, evidence$1);
    }

    public <F> long copy$default$1() {
        return this.index();
    }

    public <F> ArrayBuffer<GraphAlteration.GraphUpdate> copy$default$2() {
        return this.b();
    }

    public String productPrefix() {
        return "UnsafeGraphCallback";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToLong((long)this.index());
                break;
            }
            case 1: {
                object = this.b();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnsafeGraphCallback;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "index";
                break;
            }
            case 1: {
                string = "b";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.index()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.b()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnsafeGraphCallback)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnsafeGraphCallback unsafeGraphCallback = (UnsafeGraphCallback)x$1;
        if (this.index() != unsafeGraphCallback.index()) return false;
        ArrayBuffer<GraphAlteration.GraphUpdate> arrayBuffer = this.b();
        ArrayBuffer<GraphAlteration.GraphUpdate> arrayBuffer2 = unsafeGraphCallback.b();
        if (arrayBuffer == null) {
            if (arrayBuffer2 != null) {
                return false;
            }
        } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
        if (!unsafeGraphCallback.canEqual(this)) return false;
        return true;
    }

    public UnsafeGraphCallback(long index, ArrayBuffer<GraphAlteration.GraphUpdate> b, Functor<F> evidence$1) {
        this.index = index;
        this.b = b;
        Graph.$init$(this);
        Product.$init$((Product)this);
    }
}

