/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.graph;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Type;
import com.raphtory.internals.components.querymanager.GenericVertexMessage;
import com.raphtory.internals.graph.GraphPartition$;
import com.raphtory.internals.graph.LensInterface;
import com.raphtory.internals.management.Partitioner;
import com.raphtory.internals.management.Partitioner$;
import com.raphtory.internals.management.Scheduler;
import com.raphtory.internals.storage.arrow.ArrowGraphLens;
import com.raphtory.internals.storage.arrow.ArrowPartition;
import com.raphtory.internals.storage.pojograph.PojoBasedPartition;
import com.raphtory.internals.storage.pojograph.PojoGraphLens;
import com.raphtory.internals.storage.pojograph.entities.external.vertex.PojoExVertex;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Scaladoc(value="/** Singleton representing the Storage for the entities\n  */")
@ScalaSignature(bytes="\u0006\u0005\teaA\u0002\f\u0018\u0003\u0003Yr\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003)\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u000b\u0001\u0003A\u0011A!\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\"1q\n\u0001Q\u0001\n%CQ\u0001\u0015\u0001\u0005\u0002ECQ!\u0016\u0001\u0007\u0002YCQA\u001d\u0001\u0007\u0002MDQ\u0001 \u0001\u0007\u0002uDq!!\u0003\u0001\r\u0003\tY\u0001C\u0004\u0002\u001a\u00011\t!a\u0007\t\u0013\u0005m\u0003A1A\u0005\n\u0005u\u0003\u0002CA6\u0001\u0001\u0006I!a\u0018\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBA@\u0001\u0011\u0005\u0011\u0011Q\u0004\b\u0005\u00079\u0002\u0012\u0001B\u0003\r\u00191r\u0003#\u0001\u0003\b!1\u0001i\u0005C\u0001\u0005\u0013AqAa\u0003\u0014\t\u0003\u0011iA\u0001\bHe\u0006\u0004\b\u000eU1si&$\u0018n\u001c8\u000b\u0005aI\u0012!B4sCBD'B\u0001\u000e\u001c\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002\u001d;\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u001f\u0003\r\u0019w.\\\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017aB4sCBD\u0017\nR\u0002\u0001!\tI\u0003G\u0004\u0002+]A\u00111FI\u0007\u0002Y)\u0011QfJ\u0001\u0007yI|w\u000e\u001e \n\u0005=\u0012\u0013A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\u0012\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u0012\t\u0003CUJ!A\u000e\u0012\u0003\u0007%sG/\u0001\u0003d_:4\u0007CA\u001d?\u001b\u0005Q$BA\u001e=\u0003\u0019\u0019wN\u001c4jO*\u0011Q(H\u0001\tif\u0004Xm]1gK&\u0011qH\u000f\u0002\u0007\u0007>tg-[4\u0002\rqJg.\u001b;?)\u0011\u0011E)\u0012$\u0011\u0005\r\u0003Q\"A\f\t\u000b\u0019\"\u0001\u0019\u0001\u0015\t\u000bM\"\u0001\u0019\u0001\u001b\t\u000b]\"\u0001\u0019\u0001\u001d\u0002\r1|wmZ3s+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'=\u00031\u00198-\u00197bY><w-\u001b8h\u0013\tq5J\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u00151G.^:i)\u0005\u0011\u0006CA\u0011T\u0013\t!&E\u0001\u0003V]&$\u0018!C1eIZ+'\u000f^3y)\u0019\u0011v\u000b\u00180aU\")\u0001\f\u0003a\u00013\u00069Qn]4US6,\u0007CA\u0011[\u0013\tY&E\u0001\u0003M_:<\u0007\"B/\t\u0001\u0004I\u0016!B5oI\u0016D\b\"B0\t\u0001\u0004I\u0016!B:sG&#\u0007\"B1\t\u0001\u0004\u0011\u0017A\u00039s_B,'\u000f^5fgB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0006S:\u0004X\u000f\u001e\u0006\u0003On\t1!\u00199j\u0013\tIGM\u0001\u0006Qe>\u0004XM\u001d;jKNDQa\u001b\u0005A\u00021\f!B^3si\u0016DH+\u001f9f!\r\tSn\\\u0005\u0003]\n\u0012aa\u00149uS>t\u0007CA2q\u0013\t\tHM\u0001\u0003UsB,\u0017\u0001D1eI2{7-\u00197FI\u001e,Gc\u0002*ukZ<\u0018P\u001f\u0005\u00061&\u0001\r!\u0017\u0005\u0006;&\u0001\r!\u0017\u0005\u0006?&\u0001\r!\u0017\u0005\u0006q&\u0001\r!W\u0001\u0006IN$\u0018\n\u001a\u0005\u0006C&\u0001\rA\u0019\u0005\u0006w&\u0001\r\u0001\\\u0001\tK\u0012<W\rV=qK\u0006y\u0011\r\u001a3PkR<w.\u001b8h\u000b\u0012<W\rF\u0006S}~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0001\"\u0002-\u000b\u0001\u0004I\u0006\"B/\u000b\u0001\u0004I\u0006\"B0\u000b\u0001\u0004I\u0006\"\u0002=\u000b\u0001\u0004I\u0006\"B1\u000b\u0001\u0004\u0011\u0007\"B>\u000b\u0001\u0004a\u0017aD1eI&s7m\\7j]\u001e,EmZ3\u0015\u001bI\u000bi!a\u0004\u0002\u0012\u0005M\u0011QCA\f\u0011\u0015A6\u00021\u0001Z\u0011\u0015i6\u00021\u0001Z\u0011\u0015y6\u00021\u0001Z\u0011\u0015A8\u00021\u0001Z\u0011\u0015\t7\u00021\u0001c\u0011\u0015Y8\u00021\u0001m\u0003-9W\r\u001e,feRL7-Z:\u0015\u0011\u0005u\u0011\u0011JA*\u0003/\u0002r!a\b\u0002*e\u000bi#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\u001diW\u000f^1cY\u0016T1!a\n#\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003W\t\tCA\u0002NCB\u0004B!a\f\u0002F5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0004wKJ$X\r\u001f\u0006\u0005\u0003o\tI$\u0001\u0005fqR,'O\\1m\u0015\u0011\tY$!\u0010\u0002\u0011\u0015tG/\u001b;jKNTA!a\u0010\u0002B\u0005I\u0001o\u001c6pOJ\f\u0007\u000f\u001b\u0006\u0004\u0003\u0007J\u0012aB:u_J\fw-Z\u0005\u0005\u0003\u000f\n\tD\u0001\u0007Q_*|W\t\u001f,feR,\u0007\u0010C\u0004\u0002L1\u0001\r!!\u0014\u0002!\u001d\u0014\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0007cA\"\u0002P%\u0019\u0011\u0011K\f\u0003\u001b1+gn]%oi\u0016\u0014h-Y2f\u0011\u0019\t)\u0006\u0004a\u00013\u0006)1\u000f^1si\"1\u0011\u0011\f\u0007A\u0002e\u000b1!\u001a8e\u0003-\u0001\u0018M\u001d;ji&|g.\u001a:\u0016\u0005\u0005}\u0003\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015\u0014$\u0001\u0006nC:\fw-Z7f]RLA!!\u001b\u0002d\tY\u0001+\u0019:uSRLwN\\3s\u00031\u0001\u0018M\u001d;ji&|g.\u001a:!\u000399W\r\u001e)beRLG/[8o\u0013\u0012+\u0012\u0001N\u0001\bSNdunY1m)\u0011\t)(a\u001f\u0011\u0007\u0005\n9(C\u0002\u0002z\t\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002~A\u0001\r!W\u0001\u0003S\u0012\fA\u0001\\3ogR\u0001\u0012QJAB\u0003\u000f\u000bY)a$\u0002\u0014\u0006\u0015\u0017Q\u001c\u0005\u0007\u0003\u000b\u000b\u0002\u0019\u0001\u0015\u0002\u000b)|'-\u0013#\t\r\u0005%\u0015\u00031\u0001Z\u0003-\t7\r^;bYN#\u0018M\u001d;\t\r\u00055\u0015\u00031\u0001Z\u0003%\t7\r^;bY\u0016sG\r\u0003\u0004\u0002\u0012F\u0001\r\u0001N\u0001\ngV\u0004XM]*uKBDq!!&\u0012\u0001\u0004\t9*A\u0006tK:$W*Z:tC\u001e,\u0007CB\u0011\u0002\u001a\u0006u%+C\u0002\u0002\u001c\n\u0012\u0011BR;oGRLwN\\\u00191\t\u0005}\u00151\u0017\t\u0007\u0003C\u000bY+a,\u000e\u0005\u0005\r&\u0002BAS\u0003O\u000bA\"];fefl\u0017M\\1hKJT1!!+\u001a\u0003)\u0019w.\u001c9p]\u0016tGo]\u0005\u0005\u0003[\u000b\u0019K\u0001\u000bHK:,'/[2WKJ$X\r_'fgN\fw-\u001a\t\u0005\u0003c\u000b\u0019\f\u0004\u0001\u0005\u0019\u0005U\u00161SA\u0001\u0002\u0003\u0015\t!a.\u0003\u0007}#\u0013'\u0005\u0003\u0002:\u0006}\u0006cA\u0011\u0002<&\u0019\u0011Q\u0018\u0012\u0003\u000f9{G\u000f[5oOB\u0019\u0011%!1\n\u0007\u0005\r'EA\u0002B]fDq!a2\u0012\u0001\u0004\tI-\u0001\u0007feJ|'\u000fS1oI2,'\u000f\u0005\u0004\"\u00033\u000bYM\u0015\t\u0005\u0003\u001b\f9N\u0004\u0003\u0002P\u0006MgbA\u0016\u0002R&\t1%C\u0002\u0002V\n\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002Z\u0006m'!\u0003+ie><\u0018M\u00197f\u0015\r\t)N\t\u0005\b\u0003?\f\u0002\u0019AAq\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002b\u0005\r\u0018\u0002BAs\u0003G\u0012\u0011bU2iK\u0012,H.\u001a:)\u000f\u0001\tI/!@\u0002\u0000B!\u00111^A}\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018\u0001C:dC2\fGm\\2\u000b\t\u0005M\u0018Q_\u0001\bi\u0006\\WM_8f\u0015\r\t90H\u0001\u0007O&$\b.\u001e2\n\t\u0005m\u0018Q\u001e\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\u0012!\u0011A\u0001=_)R\u0003eU5oO2,Go\u001c8!e\u0016\u0004(/Z:f]RLgn\u001a\u0011uQ\u0016\u00043\u000b^8sC\u001e,\u0007EZ8sAQDW\rI3oi&$\u0018.Z:\u000bA\u0001Rs&\u0001\bHe\u0006\u0004\b\u000eU1si&$\u0018n\u001c8\u0011\u0005\r\u001b2CA\n!)\t\u0011)!\u0001\u0005dQ\u0016\u001c7\u000eR:u)!\t)Ha\u0004\u0003\u0014\t]\u0001B\u0002B\t+\u0001\u0007\u0011,A\u0003egRLE\t\u0003\u0004\u0003\u0016U\u0001\r\u0001N\u0001\u0010i>$\u0018\r\u001c)beRLG/[8og\")1'\u0006a\u0001i\u0001")
public abstract class GraphPartition {
    private final int partitionID;
    private final Config conf;
    private final Logger logger;
    private final Partitioner partitioner;

    public static boolean checkDst(long dstID, int totalPartitions, int partitionID) {
        return GraphPartition$.MODULE$.checkDst(dstID, totalPartitions, partitionID);
    }

    public Logger logger() {
        return this.logger;
    }

    public void flush() {
    }

    public abstract void addVertex(long var1, long var3, long var5, Properties var7, Option<Type> var8);

    public abstract void addLocalEdge(long var1, long var3, long var5, long var7, Properties var9, Option<Type> var10);

    public abstract void addOutgoingEdge(long var1, long var3, long var5, long var7, Properties var9, Option<Type> var10);

    public abstract void addIncomingEdge(long var1, long var3, long var5, long var7, Properties var9, Option<Type> var10);

    public abstract Map<Object, PojoExVertex> getVertices(LensInterface var1, long var2, long var4);

    private Partitioner partitioner() {
        return this.partitioner;
    }

    public int getPartitionID() {
        return this.partitionID;
    }

    public boolean isLocal(long id) {
        return this.partitioner().getPartitionForId(id) == this.partitionID;
    }

    public LensInterface lens(String jobID, long actualStart, long actualEnd, int superStep, Function1<GenericVertexMessage<?>, BoxedUnit> sendMessage, Function1<Throwable, BoxedUnit> errorHandler, Scheduler scheduler) {
        Product product;
        GraphPartition graphPartition = this;
        if (graphPartition instanceof ArrowPartition) {
            ArrowPartition arrowPartition = (ArrowPartition)graphPartition;
            product = new ArrowGraphLens(jobID, actualStart, actualEnd, superStep, arrowPartition, sendMessage, errorHandler, scheduler);
        } else if (graphPartition instanceof PojoBasedPartition) {
            PojoBasedPartition pojoBasedPartition = (PojoBasedPartition)graphPartition;
            product = new PojoGraphLens(jobID, actualStart, actualEnd, 0, pojoBasedPartition, this.conf, sendMessage, errorHandler, scheduler);
        } else {
            throw new MatchError((Object)graphPartition);
        }
        return product;
    }

    public GraphPartition(String graphID, int partitionID, Config conf) {
        this.partitionID = partitionID;
        this.conf = conf;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        this.partitioner = Partitioner$.MODULE$.apply(conf);
    }
}

