/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.components.registries;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.syntax.package;
import com.raphtory.internals.components.ServiceDescriptor;
import com.raphtory.internals.components.ServiceRegistry;
import com.raphtory.internals.components.registries.DistributedServiceRegistry$;
import com.raphtory.internals.management.discovery.ServiceDiscovery;
import com.raphtory.internals.management.discovery.ServiceInstance;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.net.InetAddress;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001\u0002\t\u0012\u0001qA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!AQ\t\u0001B\u0002B\u0003-a\tC\u0003Y\u0001\u0011\u0005\u0011\fC\u0004a\u0001\t\u0007I\u0011B1\t\r!\u0004\u0001\u0015!\u0003c\u0011\u0015I\u0007\u0001\"\u0003k\u0011\u0015Q\b\u0001\"\u0003|\u0011\u001d\t9\u0001\u0001C)\u0003\u0013Aq!!\n\u0001\t#\n9cB\u0004\u0002DEA\t!!\u0012\u0007\rA\t\u0002\u0012AA$\u0011\u0019AF\u0002\"\u0001\u0002P!9\u0011\u0011\u000b\u0007\u0005\u0002\u0005M\u0003bBA8\u0019\u0011\u0005\u0011\u0011\u000f\u0002\u001b\t&\u001cHO]5ckR,GmU3sm&\u001cWMU3hSN$(/\u001f\u0006\u0003%M\t!B]3hSN$(/[3t\u0015\t!R#\u0001\u0006d_6\u0004xN\\3oiNT!AF\f\u0002\u0013%tG/\u001a:oC2\u001c(B\u0001\r\u001a\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\u000e\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005u!3C\u0001\u0001\u001f!\ry\u0002EI\u0007\u0002'%\u0011\u0011e\u0005\u0002\u0010'\u0016\u0014h/[2f%\u0016<\u0017n\u001d;ssB\u00111\u0005\n\u0007\u0001\t\u0015)\u0003A1\u0001'\u0005\u00051UCA\u00142#\tAc\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#FA\u0004O_RD\u0017N\\4\u0011\u0005%z\u0013B\u0001\u0019+\u0005\r\te.\u001f\u0003\u0006e\u0011\u0012\ra\n\u0002\u0005?\u0012\"\u0013'\u0001\ttKJ4\u0018nY3ESN\u001cwN^3ssB\u0019QG\u000f\u0012\u000e\u0003YR!a\u000e\u001d\u0002\u0013\u0011L7oY8wKJL(BA\u001d\u0016\u0003)i\u0017M\\1hK6,g\u000e^\u0005\u0003wY\u0012\u0001cU3sm&\u001cW\rR5tG>4XM]=\u0002\t\r|gN\u001a\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000baaY8oM&<'B\u0001\"\u001a\u0003!!\u0018\u0010]3tC\u001a,\u0017B\u0001#@\u0005\u0019\u0019uN\u001c4jO\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007\u001d+&E\u0004\u0002I%:\u0011\u0011j\u0014\b\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019n\ta\u0001\u0010:p_Rt\u0014\"\u0001(\u0002\t\r\fGo]\u0005\u0003!F\u000ba!\u001a4gK\u000e$(\"\u0001(\n\u0005M#\u0016a\u00029bG.\fw-\u001a\u0006\u0003!FK!AV,\u0003\u000b\u0005\u001b\u0018P\\2\u000b\u0005M#\u0016A\u0002\u001fj]&$h\bF\u0002[=~#\"aW/\u0011\u0007q\u0003!%D\u0001\u0012\u0011\u0015)E\u0001q\u0001G\u0011\u0015\u0019D\u00011\u00015\u0011\u0015aD\u00011\u0001>\u0003\rawnZ\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011Q-Q\u0001\rg\u000e\fG.\u00197pO\u001eLgnZ\u0005\u0003O\u0012\u0014a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\n\u0011b]3sm&\u001cW-\u00133\u0015\u0007-\u001cX\u000f\u0005\u0002ma:\u0011QN\u001c\t\u0003\u0015*J!a\u001c\u0016\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_*BQ\u0001^\u0004A\u0002-\fAA\\1nK\")ao\u0002a\u0001o\u0006\u0011\u0011\u000e\u001a\t\u0003SaL!!\u001f\u0016\u0003\u0007%sG/A\u0006tKJ4\u0018nY3OC6,W#\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0004\u0005!!.\u0019<b\u0013\t\th0\u0001\u0006hKR\u001cVM\u001d<jG\u0016,B!a\u0003\u0002\u0016Q1\u0011QBA\r\u0003G\u0001baRA\bE\u0005M\u0011bAA\t/\nA!+Z:pkJ\u001cW\rE\u0002$\u0003+!a!a\u0006\n\u0005\u00049#!\u0001+\t\u000f\u0005m\u0011\u00021\u0001\u0002\u001e\u0005QA-Z:de&\u0004Ho\u001c:\u0011\r}\tyBIA\n\u0013\r\t\tc\u0005\u0002\u0012'\u0016\u0014h/[2f\t\u0016\u001c8M]5qi>\u0014\bb\u0002<\n!\u0003\u0005\ra^\u0001\te\u0016<\u0017n\u001d;feV!\u0011\u0011FA\u001e)!\tY#!\u000e\u0002>\u0005\u0005\u0003\u0003B\u0012%\u0003[\u0001Ba\t\u0013\u00020A\u0019\u0011&!\r\n\u0007\u0005M\"F\u0001\u0003V]&$\bbBA\u001c\u0015\u0001\u0007\u0011\u0011H\u0001\tS:\u001cH/\u00198dKB\u00191%a\u000f\u0005\r\u0005]!B1\u0001(\u0011\u001d\tYB\u0003a\u0001\u0003\u007f\u0001baHA\u0010E\u0005e\u0002\"\u0002<\u000b\u0001\u00049\u0018A\u0007#jgR\u0014\u0018NY;uK\u0012\u001cVM\u001d<jG\u0016\u0014VmZ5tiJL\bC\u0001/\r'\ra\u0011\u0011\n\t\u0004S\u0005-\u0013bAA'U\t1\u0011I\\=SK\u001a$\"!!\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005U\u0013Q\f\u000b\u0005\u0003/\ni\u0007\u0006\u0003\u0002Z\u0005\u001d\u0004cB$\u0002\u0010\u0005m\u0013Q\r\t\u0004G\u0005uCAB\u0013\u000f\u0005\u0004\ty&F\u0002(\u0003C\"q!a\u0019\u0002^\t\u0007qE\u0001\u0003`I\u0011\u0012\u0004\u0003B\u0010!\u00037B\u0011\"!\u001b\u000f\u0003\u0003\u0005\u001d!a\u001b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0003H+\u0006m\u0003\"\u0002!\u000f\u0001\u0004i\u0014!\u00042vS2$'l[\"mS\u0016tG\u000f\u0006\u0003\u0002t\u0005-\u0005\u0003BA;\u0003\u000fk!!a\u001e\u000b\t\u0005e\u00141P\u0001\nMJ\fW.Z<pe.TA!! \u0002\u0000\u000591-\u001e:bi>\u0014(\u0002BAA\u0003\u0007\u000ba!\u00199bG\",'BAAC\u0003\ry'oZ\u0005\u0005\u0003\u0013\u000b9H\u0001\tDkJ\fGo\u001c:Ge\u0006lWm^8sW\"1\u0011QR\bA\u0002-\fq!\u00193ee\u0016\u001c8\u000f")
public class DistributedServiceRegistry<F>
extends ServiceRegistry<F> {
    private final ServiceDiscovery<F> serviceDiscovery;
    private final Async<F> evidence$1;
    private final Logger log;

    public static CuratorFramework buildZkClient(String address) {
        return DistributedServiceRegistry$.MODULE$.buildZkClient(address);
    }

    public static <F> Resource<F, ServiceRegistry<F>> apply(Config config, Async<F> evidence$2) {
        return DistributedServiceRegistry$.MODULE$.apply(config, evidence$2);
    }

    private Logger log() {
        return this.log;
    }

    private String serviceId(String name, int id) {
        return new StringBuilder(1).append(name).append("-").append(Integer.toString(id)).toString();
    }

    private String serviceName() {
        return "service";
    }

    @Override
    public <T> Resource<F, T> getService(ServiceDescriptor<F, T> descriptor, int id) {
        return cats.effect.package$.MODULE$.Resource().eval(this.getServiceRetry$1(descriptor, id, new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds(), 15, DistributedServiceRegistry.getServiceRetry$default$5$1())).flatMap((Function1 & Serializable)instance -> descriptor.makeClient(instance.address(), instance.port()).map((Function1 & Serializable)client -> client));
    }

    @Override
    public <T> F register(T instance, ServiceDescriptor<F, T> descriptor, int id) {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(descriptor.makeServer(instance).allocated(this.evidence$1), this.evidence$1).map((Function1 & Serializable)serverResource -> {
            Tuple2 tuple2 = serverResource;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int port = tuple2._1$mcI$sp();
            Object stopServer = tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)port), stopServer);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$3 = (Tuple2)tuple32._1();
            int port2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Object stopServer2 = tuple32._3();
            ServiceInstance zkInstance = new ServiceInstance(InetAddress.getLocalHost().getHostAddress(), port2);
            return new Tuple3(serverResource, (Object)x$3, (Object)zkInstance);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$6 -> {
            ServiceInstance zkInstance;
            Tuple2 tuple2;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$6;
                    if (tuple3 == null) break block2;
                    tuple2 = (Tuple2)tuple3._2();
                    zkInstance = (ServiceInstance)tuple3._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            Object stopServer = tuple2._2();
            Object object = package.all$.MODULE$.toFlatMapOps($this.serviceDiscovery.registerService(zkInstance, descriptor.name(), id), $this.evidence$1).flatMap((Function1 & Serializable)x$5 -> DistributedServiceRegistry.$anonfun$register$3(this, descriptor, id, stopServer, BoxesRunTime.unboxToInt((Object)x$5)));
            return object;
        });
    }

    private final Object getServiceRetry$1(ServiceDescriptor descriptor, int id, FiniteDuration waitBeforeRetry, int count, int attempt) {
        String name = this.serviceId(descriptor.name(), id);
        return package.all$.MODULE$.toFlatMapOps(this.serviceDiscovery.queryForInstance(descriptor.name(), id), this.evidence$1).flatMap((Function1 & Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (None$.MODULE$.equals(option) && count > 0) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("Searching for service-name: {}, name: {} attempt {}", new Object[]{this.serviceName(), name, BoxesRunTime.boxToInteger((int)attempt)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = package.all$.MODULE$.catsSyntaxApply(cats.effect.package$.MODULE$.Async().apply($this.evidence$1).sleep(waitBeforeRetry), $this.evidence$1).$times$greater(this.getServiceRetry$1(descriptor, id, waitBeforeRetry.$times(2L), count - 1, attempt + 1));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                ServiceInstance v = (ServiceInstance)some.value();
                object = cats.effect.package$.MODULE$.Async().apply($this.evidence$1).pure((Object)v);
            } else {
                object = cats.effect.package$.MODULE$.Async().apply($this.evidence$1).raiseError((Object)new IllegalStateException(new StringBuilder(47).append("Failed to find service-name: ").append(this.serviceName()).append(", name: ").append(name).append(" giving up").toString()));
            }
            return object;
        });
    }

    private static final int getServiceRetry$default$5$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$register$5(BoxedUnit x$1) {
        BoxedUnit boxedUnit = x$1;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$register$3(DistributedServiceRegistry $this, ServiceDescriptor descriptor$3, int id$2, Object stopServer$1, int x$5) {
        int n = x$5;
        Object object = package.all$.MODULE$.toFunctorOps(cats.effect.package$.MODULE$.Async().apply($this.evidence$1).pure(package.all$.MODULE$.toFlatMapOps($this.serviceDiscovery.unregisterService(descriptor$3.name(), id$2), $this.evidence$1).flatMap((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit = x$2;
            Object object = package.all$.MODULE$.toFunctorOps(stopServer$1, $this.evidence$1).map((Function1 & Serializable)x$1 -> {
                DistributedServiceRegistry.$anonfun$register$5(x$1);
                return BoxedUnit.UNIT;
            });
            return object;
        })), $this.evidence$1).map((Function1 & Serializable)unregister -> unregister);
        return object;
    }

    public DistributedServiceRegistry(ServiceDiscovery<F> serviceDiscovery, Config conf, Async<F> evidence$1) {
        this.serviceDiscovery = serviceDiscovery;
        this.evidence$1 = evidence$1;
        super(conf, evidence$1);
        this.log = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
    }
}

