/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.components.partition;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import com.raphtory.internals.components.partition.Writer$;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.graph.GraphPartition;
import com.raphtory.internals.management.Partitioner;
import com.raphtory.internals.management.Partitioner$;
import com.raphtory.internals.management.telemetry.TelemetryReporter$;
import com.raphtory.protocol.GraphAlterations;
import com.raphtory.protocol.PartitionService;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import io.prometheus.client.Counter;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh!B\u000e\u001d\u0001\t2\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011m\u0002!\u0011!Q\u0001\nqB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aq\n\u0001B\u0001B\u0003-\u0001\u000bC\u0003n\u0001\u0011\u0005a\u000eC\u0004x\u0001\t\u0007I\u0011\u0002=\t\r}\u0004\u0001\u0015!\u0003z\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\u0003\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\u0019\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0003\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\t)\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0014\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015uaBAI9!\u0005\u00111\u0013\u0004\u00077qA\t!!&\t\r5,B\u0011AAL\u0011%\t\u0019#\u0006b\u0001\n\u0013\t)\u0003\u0003\u0005\u00024U\u0001\u000b\u0011BA\u0014\u0011\u001d\tI*\u0006C\u0001\u00037Cq!!5\u0016\t\u0013\t\u0019N\u0001\u0004Xe&$XM\u001d\u0006\u0003;y\t\u0011\u0002]1si&$\u0018n\u001c8\u000b\u0005}\u0001\u0013AC2p[B|g.\u001a8ug*\u0011\u0011EI\u0001\nS:$XM\u001d8bYNT!a\t\u0013\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011!J\u0001\u0004G>lWCA\u0014b'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\bOJ\f\u0007\u000f[%E\u0007\u0001\u0001\"!\r\u001d\u000f\u0005I2\u0004CA\u001a+\u001b\u0005!$BA\u001b0\u0003\u0019a$o\\8u}%\u0011qGK\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028U\u0005Y\u0001/\u0019:uSRLwN\\%E!\tIS(\u0003\u0002?U\t\u0019\u0011J\u001c;\u0002\u000fM$xN]1hKB\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tI\u0001\u0006OJ\f\u0007\u000f[\u0005\u0003\u000b\n\u0013ab\u0012:ba\"\u0004\u0016M\u001d;ji&|g.\u0001\u0003d_:4\u0007C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u0019\u0019wN\u001c4jO*\u0011A\nJ\u0001\tif\u0004Xm]1gK&\u0011a*\u0013\u0002\u0007\u0007>tg-[4\u0002\u0003\u0019\u00032!\u0015/`\u001d\t\u0011\u0016L\u0004\u0002T-:\u00111\u0007V\u0005\u0002+\u0006!1-\u0019;t\u0013\t9\u0006,\u0001\u0004fM\u001a,7\r\u001e\u0006\u0002+&\u0011!lW\u0001\ba\u0006\u001c7.Y4f\u0015\t9\u0006,\u0003\u0002^=\n)\u0011i]=oG*\u0011!l\u0017\t\u0003A\u0006d\u0001\u0001B\u0003c\u0001\t\u00071MA\u0001G+\t!7.\u0005\u0002fQB\u0011\u0011FZ\u0005\u0003O*\u0012qAT8uQ&tw\r\u0005\u0002*S&\u0011!N\u000b\u0002\u0004\u0003:LH!\u00027b\u0005\u0004!'\u0001B0%IE\na\u0001P5oSRtD#B8tiV4HC\u00019s!\r\t\baX\u0007\u00029!)qJ\u0002a\u0002!\")aF\u0002a\u0001a!)1H\u0002a\u0001y!)qH\u0002a\u0001\u0001\")aI\u0002a\u0001\u000f\u0006Y\u0001/\u0019:uSRLwN\\3s+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?!\u0003)i\u0017M\\1hK6,g\u000e^\u0005\u0003}n\u00141\u0002U1si&$\u0018n\u001c8fe\u0006a\u0001/\u0019:uSRLwN\\3sA\u0005\u0019b/\u001a:uKb\fE\rZ5uS>t7i\\;oiV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tI\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u001d\u0019u.\u001e8uKJTA!a\u0004\u0002\u0012\u000511\r\\5f]RTA!a\u0005\u0002\u0016\u0005Q\u0001O]8nKRDW-^:\u000b\u0005\u0005]\u0011AA5p\u0013\u0011\tY\"!\u0003\u0003\u000b\rC\u0017\u000e\u001c3\u0002)Y,'\u000f^3y\u0003\u0012$\u0017\u000e^5p]\u000e{WO\u001c;!\u00031)GmZ3BI\u0012\u001cu.\u001e8u\u00035)GmZ3BI\u0012\u001cu.\u001e8uA\u00051An\\4hKJ,\"!a\n\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\fL\u00031\u00198-\u00197bY><w-\u001b8h\u0013\u0011\t\t$a\u000b\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\na\u0002\u001d:pG\u0016\u001c8/\u00169eCR,7\u000f\u0006\u0003\u0002:\u0005\u0005\u0003\u0003\u00021b\u0003w\u00012!KA\u001f\u0013\r\tyD\u000b\u0002\u0005+:LG\u000fC\u0004\u0002D=\u0001\r!!\u0012\u0002\u0007I,\u0017\u000f\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tYEI\u0001\taJ|Go\\2pY&!\u0011qJA%\u0005A9%/\u00199i\u00032$XM]1uS>t7/A\u0003gYV\u001c\b.\u0006\u0002\u0002:\u00051\u0002.\u00198eY\u0016dunY1m\u00032$XM]1uS>t7\u000f\u0006\u0003\u0002<\u0005e\u0003bBA.#\u0001\u0007\u0011QI\u0001\u0005[N<7/\u0001\tqe>\u001cWm]:WKJ$X\r_!eIR!\u00111HA1\u0011\u001d\t\u0019G\u0005a\u0001\u0003K\na!\u001e9eCR,\u0007\u0003BA4\u0003{rA!!\u001b\u0002z9!\u00111NA<\u001d\u0011\ti'!\u001e\u000f\t\u0005=\u00141\u000f\b\u0004g\u0005E\u0014\"A\u0013\n\u0005\r\"\u0013BA\u0011#\u0013\t\u0019\u0005%C\u0002\u0002|\t\u000bqb\u0012:ba\"\fE\u000e^3sCRLwN\\\u0005\u0005\u0003\u007f\n\tIA\u0005WKJ$X\r_!eI*\u0019\u00111\u0010\"\u0002\u001dA\u0014xnY3tg\u0016#w-Z!eIR!\u00111HAD\u0011\u001d\tIi\u0005a\u0001\u0003\u0017\u000b1!\u001e9e!\u0011\t9'!$\n\t\u0005=\u0015\u0011\u0011\u0002\b\u000b\u0012<W-\u00113e\u0003\u00199&/\u001b;feB\u0011\u0011/F\n\u0003+!\"\"!a%\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005u\u0015\u0011\u0016\u000b\r\u0003?\u000bI,a/\u0002>\u0006}\u0016q\u001a\u000b\u0005\u0003C\u000b\u0019\fE\u0004R\u0003G\u000b9+!-\n\u0007\u0005\u0015fL\u0001\u0005SKN|WO]2f!\r\u0001\u0017\u0011\u0016\u0003\u0007Ef\u0011\r!a+\u0016\u0007\u0011\fi\u000bB\u0004\u00020\u0006%&\u0019\u00013\u0003\t}#CE\r\t\u0005c\u0002\t9\u000bC\u0005\u00026f\t\t\u0011q\u0001\u00028\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\tEc\u0016q\u0015\u0005\u0006]e\u0001\r\u0001\r\u0005\u0006we\u0001\r\u0001\u0010\u0005\u0006\u007fe\u0001\r\u0001\u0011\u0005\b\u0003\u0003L\u0002\u0019AAb\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007c\u0005\u0015G(!3\n\u0007\u0005\u001d'HA\u0002NCB\u0004b!a\u0012\u0002L\u0006\u001d\u0016\u0002BAg\u0003\u0013\u0012\u0001\u0003U1si&$\u0018n\u001c8TKJ4\u0018nY3\t\u000b\u0019K\u0002\u0019A$\u0002\u001dM$\u0018M\u001d;va6+7o]1hKV!\u0011Q[An)\u0019\t9.a;\u0002pR!\u0011\u0011\\Ar!\u0015\u0001\u00171\\A\u001e\t\u0019\u0011'D1\u0001\u0002^V\u0019A-a8\u0005\u000f\u0005\u0005\u00181\u001cb\u0001I\n!q\f\n\u00134\u0011%\t)OGA\u0001\u0002\b\t9/\u0001\u0006fm&$WM\\2fII\u0002B!\u0015/\u0002jB\u0019\u0001-a7\t\r\u00055(\u00041\u00011\u0003\u001d9'/\u00199i\u0013\u0012Da!!=\u001b\u0001\u0004a\u0014a\u00039beRLG/[8o\u0013\u0012\u0004")
public class Writer<F> {
    private final int partitionID;
    private final GraphPartition storage;
    private final Async<F> F;
    private final Partitioner partitioner;
    private final Counter.Child vertexAdditionCount;
    private final Counter.Child edgeAddCount;
    private final Logger logger;

    public static <F> Resource<F, Writer<F>> apply(String graphID, int partitionID, GraphPartition storage, Map<Object, PartitionService<F>> partitions, Config conf, Async<F> evidence$1) {
        return Writer$.MODULE$.apply(graphID, partitionID, storage, partitions, conf, evidence$1);
    }

    private Partitioner partitioner() {
        return this.partitioner;
    }

    private Counter.Child vertexAdditionCount() {
        return this.vertexAdditionCount;
    }

    private Counter.Child edgeAddCount() {
        return this.edgeAddCount;
    }

    private Logger logger() {
        return this.logger;
    }

    public F processUpdates(GraphAlterations req) {
        return (F)package$.MODULE$.Async().apply(this.F).blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> this.handleLocalAlterations(req));
    }

    public F flush() {
        return (F)package$.MODULE$.Async().apply(this.F).blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.storage.flush());
    }

    private void handleLocalAlterations(GraphAlterations msgs) {
        msgs.alterations().view().foreach((Function1 & Serializable)x0$1 -> {
            Writer.$anonfun$handleLocalAlterations$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void processVertexAdd(GraphAlteration.VertexAdd update) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Partition {}: Received VertexAdd message '{}'.", new Object[]{BoxesRunTime.boxToInteger((int)this.partitionID), update});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.storage.addVertex(update.updateTime(), update.index(), update.srcId(), update.properties(), update.vType());
        this.vertexAdditionCount().inc();
    }

    public void processEdgeAdd(GraphAlteration.EdgeAdd upd) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Partition {}: Received EdgeAdd message '{}'.", new Object[]{BoxesRunTime.boxToInteger((int)this.partitionID), upd});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int srcPartition = this.partitioner().getPartitionForId(upd.srcId());
        int dstPartition = this.partitioner().getPartitionForId(upd.dstId());
        if (srcPartition == this.partitionID && dstPartition == this.partitionID) {
            this.storage.addLocalEdge(upd.updateTime(), upd.index(), upd.srcId(), upd.dstId(), upd.properties(), upd.eType());
        } else if (srcPartition == this.partitionID) {
            this.storage.addOutgoingEdge(upd.updateTime(), upd.index(), upd.srcId(), upd.dstId(), upd.properties(), upd.eType());
        } else {
            this.storage.addIncomingEdge(upd.updateTime(), upd.index(), upd.srcId(), upd.dstId(), upd.properties(), upd.eType());
        }
        this.edgeAddCount().inc();
    }

    public static final /* synthetic */ void $anonfun$handleLocalAlterations$1(Writer $this, GraphAlteration x0$1) {
        GraphAlteration graphAlteration = x0$1;
        if (graphAlteration instanceof GraphAlteration.VertexAdd) {
            GraphAlteration.VertexAdd vertexAdd = (GraphAlteration.VertexAdd)graphAlteration;
            $this.processVertexAdd(vertexAdd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (graphAlteration instanceof GraphAlteration.EdgeAdd) {
            GraphAlteration.EdgeAdd edgeAdd = (GraphAlteration.EdgeAdd)graphAlteration;
            $this.processEdgeAdd(edgeAdd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)graphAlteration);
        }
    }

    public Writer(String graphID, int partitionID, GraphPartition storage, Config conf, Async<F> F) {
        this.partitionID = partitionID;
        this.storage = storage;
        this.F = F;
        this.partitioner = Partitioner$.MODULE$.apply(conf);
        this.vertexAdditionCount = (Counter.Child)TelemetryReporter$.MODULE$.writerVertexAdditions().labels(new String[]{Integer.toString(partitionID), graphID});
        this.edgeAddCount = (Counter.Child)TelemetryReporter$.MODULE$.writerEdgeAdditions().labels(new String[]{Integer.toString(partitionID), graphID});
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
    }
}

