/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.algorithm;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.GenericallyApplicable;
import com.raphtory.api.analysis.algorithm.Multilayer;
import com.raphtory.api.analysis.algorithm.MultilayerReduction;
import com.raphtory.api.analysis.graphview.ConcreteMultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.MultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base class for writing graph algorithms that return multilayer views.\n  *\n  * A `MultilayerProjection` maps any graph view to a multilayer graph view.\n  *\n  * @define chainBody The new algorithm's `apply` method first applies this algorithm and then the `other`,\n  *                   clearing all messages in-between. The `tabularise` method of the chained algorithm calls only\n  *                   the `tabularise` method of `other`.\n  */")
@ScalaSignature(bytes="\u0006\u0005E4q!\u0003\u0006\u0011\u0002\u0007\u0005Q\u0003C\u0003!\u0001\u0011\u0005\u0011%\u0002\u0003&\u0001\u00012\u0003\"\u0002\u0017\u0001\t\u0003j\u0003\"\u0002$\u0001\t\u0003:\u0005\"\u0002$\u0001\t\u0003\t\u0006\"\u0002$\u0001\t\u0003I\u0006\"\u0002$\u0001\t\u0003\t\u0007\"\u0002$\u0001\t\u00031'\u0001F'vYRLG.Y=feB\u0013xN[3di&|gN\u0003\u0002\f\u0019\u0005I\u0011\r\\4pe&$\b.\u001c\u0006\u0003\u001b9\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u001fA\t1!\u00199j\u0015\t\t\"#\u0001\u0005sCBDGo\u001c:z\u0015\u0005\u0019\u0012aA2p[\u000e\u00011c\u0001\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0010\u000e\u0003)I!a\b\u0006\u0003+\u001d+g.\u001a:jG\u0006dG._!qa2L7-\u00192mK\u00061A%\u001b8ji\u0012\"\u0012A\t\t\u0003/\rJ!\u0001\n\r\u0003\tUs\u0017\u000e\u001e\u0002\u0004\u001fV$\bCA\u0014+\u001b\u0005A#BA\u0015\r\u0003%9'/\u00199im&,w/\u0003\u0002,Q\tQR*\u001e7uS2\f\u00170\u001a:He\u0006\u0004\b\u000eU3sgB,7\r^5wK\u0006)\u0011\r\u001d9msR\u0011a&\r\t\u0003_Yr!\u0001M\u0019\r\u0001!)!g\u0001a\u0001g\u0005)qM]1qQB\u0011q\u0005N\u0005\u0003k!\u0012\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\n\u0005]\"$aD'vYRLG.Y=fe\u001e\u0013\u0018\r\u001d5)\t\rI4\t\u0012\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\n\u0001b]2bY\u0006$wn\u0019\u0006\u0003}}\nq\u0001^1lKj|WM\u0003\u0002A%\u00051q-\u001b;ik\nL!AQ\u001e\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013!R\u0001r_)R\u0003\u0005R3gCVdG\u000fI5na2,W.\u001a8uCRLwN\u001c\u0011sKR,(O\\:!i\",\u0007e\u001a:ba\"\u0004SO\\2iC:<W\r\u001a\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007e\u001a:ba\"\u0004sM]1qQ\u0002\"x\u000e\t:v]\u00022WO\\2uS>t\u0007%\u001e9p]*\u0001\u0003\u0005\t\u0011+_\u0005qA%\\5okN$sM]3bi\u0016\u0014HC\u0001%J!\ti\u0002\u0001C\u0003K\t\u0001\u00071*A\u0003pi\",'\u000f\u0005\u0002\u001e\u0019&\u0011QJ\u0003\u0002\b\u000f\u0016tWM]5dQ\u0011!\u0011hQ(\"\u0003A\u000b\u0011\u0011C\u0018+U\u0001\u001a\u0005.Y5oAQD\u0017n\u001d\u0011bY\u001e|'/\u001b;i[\u0002:\u0018\u000e\u001e5!C\u0002Z6lR3oKJL7-X/!C2<wN]5uQ6T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0011\u001a\u0007.Y5o\u0005>$\u0017P\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007e\u001c;iKJ\u0004\u0013\t\\4pe&$\b.\u001c\u0011u_\u0002\n\u0007\u000f\u001d7zA\u00054G/\u001a:!i\"L7\u000fI8oK*\u0001\u0003\u0005\t\u0011+_Q\u0011!+\u0016\t\u0003;MK!\u0001\u0016\u0006\u0003!\u001d+g.\u001a:jGJ+G-^2uS>t\u0007\"\u0002&\u0006\u0001\u0004\u0011\u0006\u0006B\u0003:\u0007^\u000b\u0013\u0001W\u0001\u0002$=R#\u0006I\"iC&t\u0007\u0005\u001e5jg\u0002\nGnZ8sSRDW\u000eI<ji\"\u0004\u0013\rI.\\\u000f\u0016tWM]5d%\u0016$Wo\u0019;j_:lV\fI1mO>\u0014\u0018\u000e\u001e5n\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011%G\"\f\u0017N\u001c\"pIfT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002zG\u000f[3sA\u0005cwm\u001c:ji\"l\u0007\u0005^8!CB\u0004H.\u001f\u0011bMR,'\u000f\t;iSN\u0004sN\\3\u000bA\u0001\u0002\u0003EK\u0018\u0015\u0005!S\u0006\"\u0002&\u0007\u0001\u0004Y\u0006CA\u000f]\u0013\ti&B\u0001\u0006Nk2$\u0018\u000e\\1zKJDCAB\u001dD?\u0006\n\u0001-AA\f_)R\u0003e\u00115bS:\u0004C\u000f[5tA\u0005dwm\u001c:ji\"l\u0007e^5uQ\u0002\n\u0007eW.Nk2$\u0018\u000e\\1zKJlV\fI1mO>\u0014\u0018\u000e\u001e5n\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011%G\"\f\u0017N\u001c\"pIfT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002zG\u000f[3sA\u0005cwm\u001c:ji\"l\u0007\u0005^8!CB\u0004H.\u001f\u0011bMR,'\u000f\t;iSN\u0004sN\\3\u000bA\u0001\u0002\u0003EK\u0018\u0015\u0005!\u0013\u0007\"\u0002&\b\u0001\u0004A\u0005\u0006B\u0004:\u0007\u0012\f\u0013!Z\u0001\u0002,=R#\u0006I\"iC&t\u0007\u0005\u001e5jg\u0002\nGnZ8sSRDW\u000eI<ji\"\u0004\u0013\rI.\\\u001bVdG/\u001b7bs\u0016\u0014\bK]8kK\u000e$\u0018n\u001c8^;\u0002\nGnZ8sSRDWN\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002Ce\u00195bS:\u0014u\u000eZ=\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011pi\",'\u000fI!mO>\u0014\u0018\u000e\u001e5nAQ|\u0007%\u00199qYf\u0004\u0013M\u001a;fe\u0002\"\b.[:!_:,'\u0002\t\u0011!A)zCC\u0001*h\u0011\u0015Q\u0005\u00021\u0001i!\ti\u0012.\u0003\u0002k\u0015\t\u0019R*\u001e7uS2\f\u00170\u001a:SK\u0012,8\r^5p]\"\"\u0001\"O\"mC\u0005i\u0017!!\u000b0U)\u00023\t[1j]\u0002\"\b.[:!C2<wN]5uQ6\u0004s/\u001b;iA\u0005\u00043lW'vYRLG.Y=feJ+G-^2uS>tW,\u0018\u0011bY\u001e|'/\u001b;i[*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!I\rD\u0017-\u001b8C_\u0012L(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004s\u000e\u001e5fe\u0002\nEnZ8sSRDW\u000e\t;pA\u0005\u0004\b\u000f\\=!C\u001a$XM\u001d\u0011uQ&\u001c\be\u001c8f\u0015\u0001\u0002\u0003\u0005\t\u00160Q\u0011\u0001\u0011hQ8\"\u0003A\f11P\u0018+U\u0001\u0012\u0015m]3!G2\f7o\u001d\u0011g_J\u0004sO]5uS:<\u0007e\u001a:ba\"\u0004\u0013\r\\4pe&$\b.\\:!i\"\fG\u000f\t:fiV\u0014h\u000eI7vYRLG.Y=fe\u00022\u0018.Z<t])\u0001\u0003E\u000b\u0006!A)\u0002\u0013\t\t1Nk2$\u0018\u000e\\1zKJ\u0004&o\u001c6fGRLwN\u001c1![\u0006\u00048\u000fI1os\u0002:'/\u00199iAYLWm\u001e\u0011u_\u0002\n\u0007%\\;mi&d\u0017-_3sA\u001d\u0014\u0018\r\u001d5!m&,wO\f\u0006!A)R\u0001\u0005\t\u0016!\u0001\u0012,g-\u001b8fA\rD\u0017-\u001b8C_\u0012L\b\u0005\u00165fA9,w\u000fI1mO>\u0014\u0018\u000e\u001e5nOM\u0004\u0003-\u00199qYf\u0004\u0007%\\3uQ>$\u0007EZ5sgR\u0004\u0013\r\u001d9mS\u0016\u001c\b\u0005\u001e5jg\u0002\nGnZ8sSRDW\u000eI1oI\u0002\"\b.\u001a8!i\",\u0007\u0005Y8uQ\u0016\u0014\b\r\f\u0006!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!G2,\u0017M]5oO\u0002\nG\u000e\u001c\u0011nKN\u001c\u0018mZ3tA%tWFY3uo\u0016,gN\f\u0011UQ\u0016\u0004\u0003\r^1ck2\f'/[:fA\u0002jW\r\u001e5pI\u0002zg\r\t;iK\u0002\u001a\u0007.Y5oK\u0012\u0004\u0013\r\\4pe&$\b.\u001c\u0011dC2d7\u000fI8oYfT\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001e5fA\u0001$\u0018MY;mCJL7/\u001a1![\u0016$\bn\u001c3!_\u001a\u0004\u0003m\u001c;iKJ\u0004gF\u0003\u0011!U=\u0002")
public interface MultilayerProjection
extends GenericallyApplicable {
    public static /* synthetic */ ConcreteMultilayerGraphPerspective apply$(MultilayerProjection $this, GraphPerspective graph) {
        return $this.apply(graph);
    }

    @Override
    @Scaladoc(value="/** Default implementation returns the graph unchanged\n    *\n    * @param graph graph to run function upon\n    */")
    default public ConcreteMultilayerGraphPerspective apply(GraphPerspective graph) {
        return graph.multilayerView();
    }

    public static /* synthetic */ MultilayerProjection $minus$greater$(MultilayerProjection $this, Generic other) {
        return $this.$minus$greater(other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public MultilayerProjection $minus$greater(Generic other) {
        return new MultilayerProjection(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Generic other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[Multilayer]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Multilayer other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(MultilayerReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            public ConcreteMultilayerGraphPerspective apply(GraphPerspective graph) {
                return (ConcreteMultilayerGraphPerspective)((Generic)this.second()).apply(((MultilayerProjection)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(MultilayerGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                MultilayerProjection.$init$(this);
            }
        };
    }

    public static /* synthetic */ GenericReduction $minus$greater$(MultilayerProjection $this, GenericReduction other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public GenericReduction $minus$greater(GenericReduction other) {
        return new GenericReduction(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(Generic other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
                return ((GenericReduction)this.second()).apply(((MultilayerProjection)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(ReducedGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                GenericReduction.$init$(this);
            }
        };
    }

    public static /* synthetic */ MultilayerProjection $minus$greater$(MultilayerProjection $this, Multilayer other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[Multilayer]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public MultilayerProjection $minus$greater(Multilayer other) {
        return new MultilayerProjection(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Generic other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[Multilayer]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Multilayer other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(MultilayerReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            public ConcreteMultilayerGraphPerspective apply(GraphPerspective graph) {
                return ((Multilayer)this.second()).apply((MultilayerGraphPerspective)((Object)((MultilayerProjection)this.first()).apply(graph).clearMessages()));
            }

            public Table tabularise(MultilayerGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                MultilayerProjection.$init$(this);
            }
        };
    }

    public static /* synthetic */ MultilayerProjection $minus$greater$(MultilayerProjection $this, MultilayerProjection other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return new MultilayerProjection(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Generic other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[Multilayer]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Multilayer other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(MultilayerReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            public ConcreteMultilayerGraphPerspective apply(GraphPerspective graph) {
                return ((MultilayerProjection)this.second()).apply(((MultilayerProjection)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(MultilayerGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                MultilayerProjection.$init$(this);
            }
        };
    }

    public static /* synthetic */ GenericReduction $minus$greater$(MultilayerProjection $this, MultilayerReduction other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public GenericReduction $minus$greater(MultilayerReduction other) {
        return new GenericReduction(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(Generic other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
                return ((MultilayerReduction)this.second()).apply((MultilayerGraphPerspective)((Object)((MultilayerProjection)this.first()).apply(graph).clearMessages()));
            }

            public Table tabularise(ReducedGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                GenericReduction.$init$(this);
            }
        };
    }

    public static void $init$(MultilayerProjection $this) {
    }
}

