/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.KCore$;
import com.raphtory.algorithms.temporal.motif.StarMotifCounter;
import com.raphtory.algorithms.temporal.motif.TriadMotifCounter;
import com.raphtory.algorithms.temporal.motif.TwoNodeMotifs;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@Scaladoc(value="/**\n  *  {s}`LocalThreeNodeMotifs(delta:Long, graphWide:Boolean=true, prettyPrint:Boolean=true)`\n  *    : Count occurrences of three-edge up-to-three-node temporal motifs each node participates in. See the ThreeNodeMotifs class and Local ThreeNodeMotifs\n  *    class within the same package for more details.\n  *\n  *  ## Parameters\n  *  {s}`deltas: List[Long]`\n  *    : The list of deltas (motif completion windows) to use\n  *\n  *  | delta             | 1 2 ... 40                   |\n  *  | ----------------- | ------------------------ |\n  *  | {s}`delta: Long`  | {s}`motifCount: Long` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001\u0002\t\u0012\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006i\u0001!\t!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u0019y\u0005\u0001)A\u0005w!9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006BB+\u0001A\u0003%!\u000bC\u0004W\u0001\t\u0007I\u0011A,\t\ry\u0003\u0001\u0015!\u0003Y\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015q\u0007\u0001\"\u0011p\u000f\u001d\t\t\"\u0005E\u0001\u0003'1a\u0001E\t\t\u0002\u0005U\u0001B\u0002\u001b\r\t\u0003\t9\u0003\u0003\u0004`\u0019\u0011\u0005\u0011\u0011\u0006\u0005\n\u0003[a\u0011\u0011!C\u0005\u0003_\u00111\u0003\u00165sK\u0016tu\u000eZ3Nk2$\u0018\u000eR3mi\u0006T!AE\n\u0002\u000b5|G/\u001b4\u000b\u0005Q)\u0012\u0001\u0003;f[B|'/\u00197\u000b\u0005Y9\u0012AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011\u0001$G\u0001\te\u0006\u0004\b\u000e^8ss*\t!$A\u0002d_6\u001c\u0001aE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u0003%\tGnZ8sSRDWN\u0003\u0002)S\u0005A\u0011M\\1msNL7O\u0003\u0002+/\u0005\u0019\u0011\r]5\n\u00051*#\u0001E$f]\u0016\u0014\u0018n\u0019*fIV\u001cG/[8o\u0003\u0019!W\r\u001c;bgB\u0019adL\u0019\n\u0005Az\"!B!se\u0006L\bC\u0001\u00103\u0013\t\u0019tD\u0001\u0003M_:<\u0017A\u0002\u001fj]&$h\b\u0006\u00027qA\u0011q\u0007A\u0007\u0002#!)QF\u0001a\u0001]\u0005Qq.\u001e;qkRd\u0015n\u001d;\u0016\u0003m\u00022\u0001\u0010#H\u001d\ti$I\u0004\u0002?\u00036\tqH\u0003\u0002A7\u00051AH]8pizJ\u0011\u0001I\u0005\u0003\u0007~\tq\u0001]1dW\u0006<W-\u0003\u0002F\r\n!A*[:u\u0015\t\u0019u\u0004\u0005\u0002I\u0019:\u0011\u0011J\u0013\t\u0003}}I!aS\u0010\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017~\t1b\\;uaV$H*[:uA\u0005\u0001r\r\\8cC2|U\u000f\u001e9vi2K7\u000f^\u000b\u0002%B\u0019AhU$\n\u0005Q3%aA*fc\u0006\tr\r\\8cC2|U\u000f\u001e9vi2K7\u000f\u001e\u0011\u0002\u0019M,GN\u001a'p_B4\u0015\u000e\u001c;\u0016\u0003a\u0003BAH-\\7&\u0011!l\b\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B)a\u0004X\u00192c%\u0011Ql\b\u0002\u0007)V\u0004H.Z\u001a\u0002\u001bM,GN\u001a'p_B4\u0015\u000e\u001c;!\u0003\u0015\t\u0007\u000f\u001d7z)\t\tG\r\u0005\u0002cY:\u00111\r\u001a\u0007\u0001\u0011\u0015)\u0017\u00021\u0001g\u0003\u00159'/\u00199i!\t9'.D\u0001i\u0015\tIw%A\u0005he\u0006\u0004\bN^5fo&\u00111\u000e\u001b\u0002\u0011\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016L!!\u001c6\u0003\u0019I+G-^2fI\u001e\u0013\u0018\r\u001d5\u0002\u0015Q\f'-\u001e7be&\u001cX\r\u0006\u0002qmB\u0011\u0011\u000f^\u0007\u0002e*\u00111oJ\u0001\u0006i\u0006\u0014G.Z\u0005\u0003kJ\u0014Q\u0001V1cY\u0016DQ!\u001a\u0006A\u0002]\u0004\"a\u001a=\n\u0005eD'a\u0006*fIV\u001cW\rZ$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<fQ\u0019\u000110a\u0003\u0002\u000eA\u0019A0a\u0002\u000e\u0003uT!A`@\u0002\u0011M\u001c\u0017\r\\1e_\u000eTA!!\u0001\u0002\u0004\u00059A/Y6fu>,'bAA\u00033\u00051q-\u001b;ik\nL1!!\u0003~\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017EAA\b\u0003\u0011\u0015vF\u000b\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002dunY1m)\"\u0014X-\u001a(pI\u0016lu\u000e^5gg\"\"W\r\u001c;bu1{gn\u001a\u0017!OJ\f\u0007\u000f[,jI\u0016T$i\\8mK\u0006tW\b\u001e:vK2\u0002\u0003O]3uif\u0004&/\u001b8uu\t{w\u000e\\3b]v\"(/^3*A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004eQ8v]R\u0004snY2veJ,gnY3tA=4\u0007\u0005\u001e5sK\u0016lS\rZ4fAU\u0004X\u0006^8.i\"\u0014X-Z\u0017o_\u0012,\u0007\u0005^3na>\u0014\u0018\r\u001c\u0011n_RLgm\u001d\u0011fC\u000eD\u0007E\\8eK\u0002\u0002\u0018M\u001d;jG&\u0004\u0018\r^3tA%tg\u0006I*fK\u0002\"\b.\u001a\u0011UQJ,WMT8eK6{G/\u001b4tA\rd\u0017m]:!C:$\u0007\u0005T8dC2\u0004C\u000b\u001b:fK:{G-Z'pi&47O\u0003\u0011!U\u0001\u0002\u0003\u0005I2mCN\u001c\be^5uQ&t\u0007\u0005\u001e5fAM\fW.\u001a\u0011qC\u000e\\\u0017mZ3!M>\u0014\b%\\8sK\u0002\"W\r^1jYNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)\u0002\u0003e_:~A\u0012,G\u000e^1tu\u0001b\u0015n\u001d;\\\u0019>tw-\u00181\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\"\u0006.\u001a\u0011mSN$\be\u001c4!I\u0016dG/Y:!Q5|G/\u001b4!G>l\u0007\u000f\\3uS>t\u0007e^5oI><8/\u000b\u0011u_\u0002*8/\u001a\u0006!A)R\u0001\u0005\t\u0016!Aq\u0004C-\u001a7uC\u0002\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!y\u0002\n\u0004E\r\u0011/]9\u0002C\u0007\r\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002CP\u0003\u0011!U\u0001\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.AqT\u0001\u0005\t\u0016!Aq\u00043p]?aI\u0016dG/\u0019\u001e!\u0019>tw\r\u0019\u0011!y\u0002Z8/ 1n_RLgmQ8v]RT\u0004\u0005T8oO\u0002\u0004CP\u0003\u0011!U=\n1\u0003\u00165sK\u0016tu\u000eZ3Nk2$\u0018\u000eR3mi\u0006\u0004\"a\u000e\u0007\u0014\t1i\u0012q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\tIwN\u0003\u0002\u0002\"\u0005!!.\u0019<b\u0013\u0011\t)#a\u0007\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005MAc\u0001\u001c\u0002,!)QF\u0004a\u0001]\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0007\t\u0005\u0003g\tI$\u0004\u0002\u00026)!\u0011qGA\u0010\u0003\u0011a\u0017M\\4\n\t\u0005m\u0012Q\u0007\u0002\u0007\u001f\nTWm\u0019;")
public class ThreeNodeMultiDelta
implements GenericReduction {
    private final long[] deltas;
    private final List<String> outputList;
    private final Seq<String> globalOutputList;
    private final PartialFunction<Tuple3<Object, Object, Object>, Tuple3<Object, Object, Object>> selfLoopFilt;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(Generic other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    public List<String> outputList() {
        return this.outputList;
    }

    public Seq<String> globalOutputList() {
        return this.globalOutputList;
    }

    public PartialFunction<Tuple3<Object, Object, Object>, Tuple3<Object, Object, Object>> selfLoopFilt() {
        return this.selfLoopFilt;
    }

    @Override
    public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return (ConcreteReducedGraphPerspective)KCore$.MODULE$.apply(2, KCore$.MODULE$.apply$default$2()).apply(graph).clearMessages().reducedView().setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(this.deltas), (Function1)(JFunction1.mcVJ.sp & Serializable)delta -> {
                state.newAccumulator(new StringBuilder(13).append("twoNodeCounts").append(Long.toString(delta)).toString(), Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(ar1, ar2) -> (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(ar1), (IterableOnce)Predef$.MODULE$.wrapLongArray(ar2))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)ThreeNodeMultiDelta.$anonfun$apply$5(x0$1)), (ClassTag)ClassTag$.MODULE$.Long()));
                state.newAccumulator(new StringBuilder(9).append("triCounts").append(Long.toString(delta)).toString(), Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(ar1, ar2) -> (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(ar1), (IterableOnce)Predef$.MODULE$.wrapLongArray(ar2))), (Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)ThreeNodeMultiDelta.$anonfun$apply$8(x0$2)), (ClassTag)ClassTag$.MODULE$.Long()));
                state.newAccumulator(new StringBuilder(10).append("starCounts").append(Long.toString(delta)).toString(), Array$.MODULE$.fill(24, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(ar1, ar2) -> (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(ar1), (IterableOnce)Predef$.MODULE$.wrapLongArray(ar2))), (Function1 & Serializable)x0$3 -> BoxesRunTime.boxToLong((long)ThreeNodeMultiDelta.$anonfun$apply$11(x0$3)), (ClassTag)ClassTag$.MODULE$.Long()));
            });
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            ThreeNodeMultiDelta.$anonfun$apply$12(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            ThreeNodeMultiDelta.$anonfun$apply$13(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            ThreeNodeMultiDelta.$anonfun$apply$15(v);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(v, state) -> {
            ThreeNodeMultiDelta.$anonfun$apply$20(this, v, state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(v, state) -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(this.deltas), (Function1)(JFunction1.mcVJ.sp & Serializable)delta -> {
                StarMotifCounter mc = new StarMotifCounter(BoxesRunTime.unboxToLong((Object)v.ID()), (Iterable<Object>)((Iterable)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$6 -> x$6 != BoxesRunTime.unboxToLong((Object)v.ID()))));
                mc.execute((List<Tuple3<Object, Object, Object>>)((List)v.explodeAllEdges(v.explodeAllEdges$default$1(), v.explodeAllEdges$default$2()).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).collect($this.selfLoopFilt()).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))), delta);
                long[] counts = mc.getCounts();
                ObjectRef twoNodeCounts = ObjectRef.create((Object)((long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long())));
                ((IterableOnceOps)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 != BoxesRunTime.unboxToLong((Object)v.ID()))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)vid -> {
                    TwoNodeMotifs mc2node = new TwoNodeMotifs(BoxesRunTime.unboxToLong((Object)v.ID()));
                    mc2node.execute((Tuple3[])((IterableOnceOps)((List)v.explodedEdge(vid, v.explodedEdge$default$2(), v.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).toArray(ClassTag$.MODULE$.apply(Tuple3.class)), delta);
                    long[] twoNC = mc2node.getCounts();
                    ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.longArrayOps(counts)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                        counts$1[i] = counts[i] - twoNC[i % 8];
                    });
                    twoNodeCounts$1.elem = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps((long[])twoNodeCounts$1.elem), (IterableOnce)Predef$.MODULE$.wrapLongArray(twoNC))), (Function1 & Serializable)x0$5 -> BoxesRunTime.boxToLong((long)ThreeNodeMultiDelta.$anonfun$apply$41(x0$5)), (ClassTag)ClassTag$.MODULE$.Long());
                });
                state.apply(new StringBuilder(13).append("twoNodeCounts").append(Long.toString(delta)).toString()).$plus$eq((long[])twoNodeCounts.elem);
                state.apply(new StringBuilder(10).append("starCounts").append(Long.toString(delta)).toString()).$plus$eq(counts);
            });
            return BoxedUnit.UNIT;
        });
    }

    public Table tabularise(ReducedGraphPerspective graph) {
        return graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            ThreeNodeMultiDelta.$anonfun$tabularise$1(this, state);
            return BoxedUnit.UNIT;
        }).globalSelect(this.globalOutputList()).explode(this.globalOutputList());
    }

    public static final /* synthetic */ String $anonfun$outputList$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ String $anonfun$globalOutputList$1(int x$2) {
        return Integer.toString(x$2);
    }

    public static final /* synthetic */ long $anonfun$apply$5(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ long $anonfun$apply$8(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ long $anonfun$apply$11(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$apply$12(ReducedVertex v) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            v.messageAllNeighbours(v.ID(), SchemaProviderInstances$.MODULE$.longSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$13(ReducedVertex v) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            scala.collection.immutable.Set neighbours = v.messageQueue().toSet();
            ((EntityVisitor)((Object)v)).setState("effNeighbours", neighbours);
            neighbours.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)nb -> v.messageVertex(BoxesRunTime.boxToLong((long)nb), new Tuple2(v.ID(), (Object)neighbours), SchemaProviderInstances$.MODULE$.genericSchemaProvider()));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$16(ReducedVertex v$2, scala.collection.immutable.Set neighbours$2, Tuple2 x0$4) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            long nb = tuple2._1$mcJ$sp();
            scala.collection.immutable.Set friendsOfFriend = (scala.collection.immutable.Set)tuple2._2();
            if (BoxesRunTime.unboxToLong((Object)v$2.ID()) > nb) {
                friendsOfFriend.intersect((Set)neighbours$2).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)w -> {
                    block0: {
                        if (nb <= w) break block0;
                        v$2.messageVertex(BoxesRunTime.boxToLong((long)w), ((List)v$2.explodedEdge(nb, v$2.explodedEdge$default$2(), v$2.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$apply$15(ReducedVertex v) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            scala.collection.immutable.Set neighbours = (scala.collection.immutable.Set)((EntityVisitor)((Object)v)).getState("effNeighbours", ((EntityVisitor)((Object)v)).getState$default$2());
            ((EntityVisitor)((Object)v)).clearState("effNeighbours");
            Seq queue = v.messageQueue();
            queue.foreach((Function1 & Serializable)x0$4 -> {
                ThreeNodeMultiDelta.$anonfun$apply$16(v, neighbours, x0$4);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$apply$21(ThreeNodeMultiDelta $this, ReducedVertex v$3, GraphState state$2, List edges) {
        Tuple3 tuple3 = (Tuple3)edges.head();
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        long u = BoxesRunTime.unboxToLong((Object)tuple3._1());
        long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(u, w);
        Tuple2.mcJJ.sp sp3 = sp2;
        long u2 = sp3._1$mcJ$sp();
        long w2 = sp3._2$mcJ$sp();
        List inputEdges = (List)((SeqOps)((IterableOps)((List)v$3.explodedEdge(u2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).$plus$plus((IterableOnce)((List)v$3.explodedEdge(w2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))))).$plus$plus((IterableOnce)edges)).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$));
        List ids = (List)((SeqOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)v$3.ID()), u2, w2}))).sortWith((Function2)(JFunction2.mcZJJ.sp & Serializable)(x$4, x$5) -> x$4 < x$5);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps($this.deltas), (Function1)(JFunction1.mcVJ.sp & Serializable)delta -> {
            TriadMotifCounter mc = new TriadMotifCounter(BoxesRunTime.unboxToLong((Object)ids.apply(0)), BoxesRunTime.unboxToLong((Object)ids.apply(1)), (Iterable<Object>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)ids.apply(2))}))));
            mc.execute((List<Tuple3<Object, Object, Object>>)inputEdges, delta);
            state$2.apply(new StringBuilder(9).append("triCounts").append(Long.toString(delta)).toString()).$plus$eq(mc.getCounts());
        });
    }

    public static final /* synthetic */ void $anonfun$apply$20(ThreeNodeMultiDelta $this, ReducedVertex v, GraphState state) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            v.messageQueue().foreach((Function1 & Serializable)edges -> {
                ThreeNodeMultiDelta.$anonfun$apply$21($this, v, state, edges);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ long $anonfun$apply$41(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(ThreeNodeMultiDelta $this, GraphState state) {
        state.newConstant("delta", Predef$.MODULE$.wrapLongArray($this.deltas).toList());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 24).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long[] motifDelta = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps($this.deltas), (Function1)(JFunction1.mcJJ.sp & Serializable)d -> ((long[])state.apply(new StringBuilder(10).append("starCounts").append(Long.toString(d)).toString()).value())[i - 1], (ClassTag)ClassTag$.MODULE$.Long());
            state.newConstant(Integer.toString(i), Predef$.MODULE$.wrapLongArray(motifDelta).toList());
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(25), 32).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long[] motifDelta = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps($this.deltas), (Function1)(JFunction1.mcJJ.sp & Serializable)d -> ((long[])state.apply(new StringBuilder(13).append("twoNodeCounts").append(Long.toString(d)).toString()).value())[i - 25], (ClassTag)ClassTag$.MODULE$.Long());
            state.newConstant(Integer.toString(i), Predef$.MODULE$.wrapLongArray(motifDelta).toList());
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(33), 40).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long[] motifDelta = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps($this.deltas), (Function1)(JFunction1.mcJJ.sp & Serializable)d -> ((long[])state.apply(new StringBuilder(9).append("triCounts").append(Long.toString(d)).toString()).value())[i - 33], (ClassTag)ClassTag$.MODULE$.Long());
            state.newConstant(Integer.toString(i), Predef$.MODULE$.wrapLongArray(motifDelta).toList());
        });
    }

    public ThreeNodeMultiDelta(long[] deltas) {
        this.deltas = deltas;
        BaseAlgorithm.$init$(this);
        GenericReduction.$init$(this);
        this.outputList = (List)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 40).map((Function1 & Serializable)x$1 -> ThreeNodeMultiDelta.$anonfun$outputList$1(BoxesRunTime.unboxToInt((Object)x$1))));
        this.globalOutputList = (Seq)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"delta"}))).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 40).map((Function1 & Serializable)x$2 -> ThreeNodeMultiDelta.$anonfun$globalOutputList$1(BoxesRunTime.unboxToInt((Object)x$2))));
        this.selfLoopFilt = new Serializable(null){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple3<Object, Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    long src = BoxesRunTime.unboxToLong((Object)A1._1());
                    long dst = BoxesRunTime.unboxToLong((Object)A1._2());
                    long time = BoxesRunTime.unboxToLong((Object)A1._3());
                    if (src != dst) {
                        object = new Tuple3((Object)BoxesRunTime.boxToLong((long)src), (Object)BoxesRunTime.boxToLong((long)dst), (Object)BoxesRunTime.boxToLong((long)time));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple3<Object, Object, Object> x1) {
                long dst;
                long src;
                Tuple3<Object, Object, Object> tuple3 = x1;
                boolean bl = tuple3 != null && (src = BoxesRunTime.unboxToLong((Object)tuple3._1())) != (dst = BoxesRunTime.unboxToLong((Object)tuple3._2()));
                return bl;
            }
        };
    }
}

