/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.motif;

import com.raphtory.algorithms.temporal.motif.EdgeEvent;
import com.raphtory.algorithms.temporal.motif.MotifCounter;
import com.raphtory.algorithms.temporal.motif.ThreeNodeMotifs$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.LongMap;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001B\u000e\u001d\u0001\u001dB\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)\u0001\t\u0001C\u0001\u0003\"9Q\t\u0001b\u0001\n\u00031\u0005B\u0002&\u0001A\u0003%q\tC\u0004L\u0001\t\u0007I\u0011\u0001'\t\rA\u0003\u0001\u0015!\u0003N\u0011\u001d\t\u0006A1A\u0005\u00021CaA\u0015\u0001!\u0002\u0013i\u0005bB*\u0001\u0005\u0004%\t\u0001\u0014\u0005\u0007)\u0002\u0001\u000b\u0011B'\t\u000fU\u0003!\u0019!C\u0001\u0019\"1a\u000b\u0001Q\u0001\n5Cqa\u0016\u0001C\u0002\u0013\u0005A\n\u0003\u0004Y\u0001\u0001\u0006I!\u0014\u0005\b3\u0002\u0011\r\u0011\"\u0001M\u0011\u0019Q\u0006\u0001)A\u0005\u001b\"91\f\u0001b\u0001\n\u0003a\u0005B\u0002/\u0001A\u0003%Q\nC\u0004^\u0001\t\u0007I\u0011\u0001'\t\ry\u0003\u0001\u0015!\u0003N\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015)\b\u0001\"\u0001w\u0011\u0019\t\t\u0001\u0001C\u0001\u0019\n\u00012\u000b^1s\u001b>$\u0018NZ\"pk:$XM\u001d\u0006\u0003;y\tQ!\\8uS\u001aT!a\b\u0011\u0002\u0011Q,W\u000e]8sC2T!!\t\u0012\u0002\u0015\u0005dwm\u001c:ji\"l7O\u0003\u0002$I\u0005A!/\u00199ii>\u0014\u0018PC\u0001&\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*U5\tA$\u0003\u0002,9\taQj\u001c;jM\u000e{WO\u001c;fe\u0006\u0019a/\u001b3\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\t1{gnZ\u0001\u000b]\u0016Lw\r\u001b2pkJ\u001c\bcA\u001b>[9\u0011ag\u000f\b\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0019\na\u0001\u0010:p_Rt\u0014\"\u0001\u0019\n\u0005qz\u0013a\u00029bG.\fw-Z\u0005\u0003}}\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003y=\na\u0001P5oSRtDc\u0001\"D\tB\u0011\u0011\u0006\u0001\u0005\u0006Y\r\u0001\r!\f\u0005\u0006g\r\u0001\r\u0001N\u0001\u0002\u001dV\tq\t\u0005\u0002/\u0011&\u0011\u0011j\f\u0002\u0004\u0013:$\u0018A\u0001(!\u0003!\u0001(/\u001a(pI\u0016\u001cX#A'\u0011\u00079rU&\u0003\u0002P_\t)\u0011I\u001d:bs\u0006I\u0001O]3O_\u0012,7\u000fI\u0001\na>\u001cHOT8eKN\f!\u0002]8ti:{G-Z:!\u0003\u0019\u0001(/Z*v[\u00069\u0001O]3Tk6\u0004\u0013AB7jIN+X.A\u0004nS\u0012\u001cV/\u001c\u0011\u0002\u000fA|7\u000f^*v[\u0006A\u0001o\\:u'Vl\u0007%\u0001\u0005d_VtG\u000f\u0015:f\u0003%\u0019w.\u001e8u!J,\u0007%\u0001\u0005d_VtG/T5e\u0003%\u0019w.\u001e8u\u001b&$\u0007%A\u0005d_VtG\u000fU8ti\u0006Q1m\\;oiB{7\u000f\u001e\u0011\u0002\tA,8\u000f\u001b\u000b\u0005C\u00124\u0007\u000e\u0005\u0002/E&\u00111m\f\u0002\u0005+:LG\u000fC\u0003f-\u0001\u0007Q*\u0001\u0005dkJtu\u000eZ3t\u0011\u00159g\u00031\u0001N\u0003\u0019\u0019WO]*v[\")\u0011N\u0006a\u0001U\u000691-\u001e:FI\u001e,\u0007CA\u0015l\u0013\taGDA\u0005FI\u001e,WI^3oi\u0006\u0019\u0001o\u001c9\u0015\t\u0005|\u0007/\u001d\u0005\u0006K^\u0001\r!\u0014\u0005\u0006O^\u0001\r!\u0014\u0005\u0006S^\u0001\rA[\u0001\u000faJ|7-Z:t\u0007V\u0014(/\u001a8u)\t\tG\u000fC\u0003j1\u0001\u0007!.\u0001\bhK:,'/\u0019;f\u000bZ,g\u000e^:\u0015\u0005]D\bc\u0001\u0018OU\")\u00110\u0007a\u0001u\u0006)Q\rZ4fgB\u0019Qg_?\n\u0005q|$\u0001\u0002'jgR\u0004RA\f@.[5J!a`\u0018\u0003\rQ+\b\u000f\\34\u0003%9W\r^\"pk:$8\u000f")
public class StarMotifCounter
extends MotifCounter {
    private final long vid;
    private final Iterable<Object> neighbours;
    private final int N;
    private final long[] preNodes;
    private final long[] postNodes;
    private final long[] preSum;
    private final long[] midSum;
    private final long[] postSum;
    private final long[] countPre;
    private final long[] countMid;
    private final long[] countPost;

    public int N() {
        return this.N;
    }

    @Override
    public long[] preNodes() {
        return this.preNodes;
    }

    @Override
    public long[] postNodes() {
        return this.postNodes;
    }

    @Override
    public long[] preSum() {
        return this.preSum;
    }

    @Override
    public long[] midSum() {
        return this.midSum;
    }

    @Override
    public long[] postSum() {
        return this.postSum;
    }

    public long[] countPre() {
        return this.countPre;
    }

    public long[] countMid() {
        return this.countMid;
    }

    public long[] countPost() {
        return this.countPost;
    }

    @Override
    public void push(long[] curNodes, long[] curSum, EdgeEvent curEdge) {
        int dir = curEdge.dir();
        int nb = curEdge.nb();
        int n = ThreeNodeMotifs$.MODULE$.map2D(this.incoming(), dir);
        curSum[n] = curSum[n] + curNodes[this.incoming() * this.N() + nb];
        int n2 = ThreeNodeMotifs$.MODULE$.map2D(this.outgoing(), dir);
        curSum[n2] = curSum[n2] + curNodes[this.outgoing() * this.N() + nb];
        int n3 = dir * this.N() + nb;
        curNodes[n3] = curNodes[n3] + 1L;
    }

    @Override
    public void pop(long[] curNodes, long[] curSum, EdgeEvent curEdge) {
        int dir = curEdge.dir();
        int nb = curEdge.nb();
        int n = dir * this.N() + nb;
        curNodes[n] = curNodes[n] - 1L;
        int n2 = ThreeNodeMotifs$.MODULE$.map2D(dir, this.incoming());
        curSum[n2] = curSum[n2] - curNodes[this.incoming() * this.N() + nb];
        int n3 = ThreeNodeMotifs$.MODULE$.map2D(dir, this.outgoing());
        curSum[n3] = curSum[n3] - curNodes[this.outgoing() * this.N() + nb];
    }

    @Override
    public void processCurrent(EdgeEvent curEdge) {
        int dir = curEdge.dir();
        int nb = curEdge.nb();
        int n = ThreeNodeMotifs$.MODULE$.map2D(this.incoming(), dir);
        this.midSum()[n] = this.midSum()[n] - this.preNodes()[this.incoming() * this.N() + nb];
        int n2 = ThreeNodeMotifs$.MODULE$.map2D(this.outgoing(), dir);
        this.midSum()[n2] = this.midSum()[n2] - this.preNodes()[this.outgoing() * this.N() + nb];
        ThreeNodeMotifs$.MODULE$.dirs2D().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StarMotifCounter.$anonfun$processCurrent$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            StarMotifCounter.$anonfun$processCurrent$2(this, dir, x$1);
            return BoxedUnit.UNIT;
        });
        int n3 = ThreeNodeMotifs$.MODULE$.map2D(dir, this.incoming());
        this.midSum()[n3] = this.midSum()[n3] + this.postNodes()[this.incoming() * this.N() + nb];
        int n4 = ThreeNodeMotifs$.MODULE$.map2D(dir, this.outgoing());
        this.midSum()[n4] = this.midSum()[n4] + this.postNodes()[this.outgoing() * this.N() + nb];
    }

    @Override
    public EdgeEvent[] generateEvents(List<Tuple3<Object, Object, Object>> edges) {
        LongMap neighMap = new LongMap(this.N());
        ((IterableOnceOps)this.neighbours.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long nb = tuple2._1$mcJ$sp();
            int i = tuple2._2$mcI$sp();
            Option option = neighMap.put(nb, (Object)BoxesRunTime.boxToInteger((int)i));
            return option;
        });
        return (EdgeEvent[])edges.map((Function1 & Serializable)e -> BoxesRunTime.unboxToLong((Object)e._2()) == $this.vid ? new EdgeEvent(BoxesRunTime.unboxToInt((Object)neighMap.apply(BoxesRunTime.unboxToLong((Object)e._1()))), this.incoming(), -1, BoxesRunTime.unboxToLong((Object)e._3())) : new EdgeEvent(BoxesRunTime.unboxToInt((Object)neighMap.apply(BoxesRunTime.unboxToLong((Object)e._2()))), this.outgoing(), -1, BoxesRunTime.unboxToLong((Object)e._3()))).toArray(ClassTag$.MODULE$.apply(EdgeEvent.class));
    }

    public long[] getCounts() {
        return (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps(this.countPre()), (Object)this.countMid(), (ClassTag)ClassTag$.MODULE$.Long())), (Object)this.countPost(), (ClassTag)ClassTag$.MODULE$.Long());
    }

    public static final /* synthetic */ boolean $anonfun$processCurrent$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processCurrent$2(StarMotifCounter $this, int dir$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int dir1 = tuple2._1$mcI$sp();
        int dir2 = tuple2._2$mcI$sp();
        int n = ThreeNodeMotifs$.MODULE$.map3D(dir1, dir2, dir$1);
        $this.countPre()[n] = $this.countPre()[n] + $this.preSum()[ThreeNodeMotifs$.MODULE$.map2D(dir1, dir2)];
        int n2 = ThreeNodeMotifs$.MODULE$.map3D(dir$1, dir1, dir2);
        $this.countPost()[n2] = $this.countPost()[n2] + $this.postSum()[ThreeNodeMotifs$.MODULE$.map2D(dir1, dir2)];
        int n3 = ThreeNodeMotifs$.MODULE$.map3D(dir1, dir$1, dir2);
        $this.countMid()[n3] = $this.countMid()[n3] + $this.midSum()[ThreeNodeMotifs$.MODULE$.map2D(dir1, dir2)];
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StarMotifCounter(long vid, Iterable<Object> neighbours) {
        this.vid = vid;
        this.neighbours = neighbours;
        this.N = neighbours.size();
        this.preNodes = (long[])Array$.MODULE$.fill(2 * neighbours.size(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.postNodes = (long[])Array$.MODULE$.fill(2 * neighbours.size(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.preSum = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.midSum = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.postSum = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.countPre = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.countMid = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.countPost = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
    }
}

