/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.KCore$;
import com.raphtory.algorithms.temporal.motif.LocalThreeNodeMotifs$;
import com.raphtory.algorithms.temporal.motif.StarMotifCounter;
import com.raphtory.algorithms.temporal.motif.ThreeNodeMotifs$;
import com.raphtory.algorithms.temporal.motif.TriadMotifCounter;
import com.raphtory.algorithms.temporal.motif.TwoNodeMotifs;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@Scaladoc(value="/**\n  *  {s}`LocalThreeNodeMotifs(delta:Long, graphWide:Boolean=true, prettyPrint:Boolean=true)`\n  *    : Count occurrences of three-edge up-to-three-node temporal motifs each node participates in. For an efficient global count, use ThreeNodeMotifs\n  *\n  *  The algorithm is very based on that in \"Motifs in Temporal Networks\". An option is given to return results as a hashmap with labels or as an array which is easier for post-processing.\n  *\n  *  ## Parameters\n  *  {s}`delta: Long=3600L`\n  *   : Delta value for the maximum time length between the first and final edge of the motif. The default value is 3600L (1hour) assuming the data's timestamps are in seconds.\n  *  {s}`prettyPrint: Boolean=True`\n  *   : if `True`, returns a list of motifs with a description of the motif. Not recommended if you are doing any post processing on the outputted motifs.\n  *  {s}`graphWide: Boolean=True`\n  *  : if `True`, just one row per perspective is returned with counts for the whole graph, otherwise counts per vertex are returned. Note that the graph-wide counts are not just\n  *  the sum of the per-vertex counts; the triangle counts are divided by three since they are counted once for each vertex.\n  *\n  *  ## Motifs\n  *\n  *  ### Stars\n  *\n  *  There are three classes (in the order they are outputted) of star motif on three nodes based on the switching behaviour of the edges between the two leaf nodes.\n  *\n  *   - PRE: Stars of the form i<->j, i<->j, i<->k (ie two interactions with leaf j followed by one with leaf k)\n  *   - MID: Stars of the form i<->j, i<->k, i<->j (ie switching interactions from leaf j to leaf k, back to j again)\n  *   - POST: Stars of the form i<->j, i<->k, i<->k (ie one interaction with leaf j followed by two with leaf k)\n  *\n  *  Within each of these classes is 8 motifs depending on the direction of the first to the last edge -- incoming \"I\" or outgoing \"O\".\n  *  These are enumerated in the order III, IIO, IOI, IOO, OII, OIO, OOI, OOO (like binary with \"I\"-0 and \"O\"-1).\n  *\n  *  ### Two node motifs\n  *\n  *  Also included are two node motifs, of which there are 8 when counted from the perspective of each vertex. These are characterised by the direction of each edge, enumerated\n  *  in the above order. Note that for the global graph counts, each motif is counted in both directions (a single III motif for one vertex is an OOO motif for the other vertex).\n  *\n  *  ### Triangles\n  *\n  *  There are 8 triangle motifs, below is the order in which they appear in the returned array:\n  *\n  *   1. i --> j, k --> j, i --> k\n  *   2. i --> j, k --> i, j --> k\n  *   3. i --> j, j --> k, i --> k\n  *   4. i --> j, i --> k, j --> k\n  *   5. i --> j, k --> j, k --> i\n  *   6. i --> j, k --> i, k --> j\n  *   7. i --> j, j --> k, k --> i\n  *   8. i --> j, i --> k, k --> j\n  *\n  *   The motif counts are returned as a 40-d array where the first 24 elements are star counts,\n  *   the next 8 are two-node motif counts and the final 8 are triangle counts.\n  *\n  * ## States\n  *  {s}`starCounts: Array[Int]`\n  *    : Three-node star motif counts stored as an array (see indices above)\n  *  {s}`twoNodeCounts: Array[Int]`\n  *    : Two-node motif counts stored as an array (see indices above)\n  *  {s}`triCounts: Array[Int]`\n  *    : Triangle motif counts stored as an array (see indices above)\n  *\n  * ## Returns\n  *\n  *  | vertex name       | 1 2 ... 40                   |\n  *  | ----------------- | ------------------------ |\n  *  | {s}`name: String` | {s}`motifCount: Long` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\b\u0001B\u0001B\u0003%!\bC\u0003?\u0001\u0011\u0005q\bC\u0004F\u0001\t\u0007I\u0011\u0001$\t\rm\u0003\u0001\u0015!\u0003H\u0011\u001da\u0006A1A\u0005\u0002uCa!\u0019\u0001!\u0002\u0013q\u0006b\u00022\u0001\u0005\u0004%\ta\u0019\u0005\u0007U\u0002\u0001\u000b\u0011\u00023\t\u000b-\u0004A\u0011\t7\t\u000bi\u0004A\u0011I>\b\u000f\u0005%\u0012\u0004#\u0001\u0002,\u00191\u0001$\u0007E\u0001\u0003[AaA\u0010\b\u0005\u0002\u0005}\u0002BB6\u000f\t\u0003\t\t\u0005C\u0005\u0002J9\t\n\u0011\"\u0001\u0002L!I\u0011\u0011\r\b\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003Or\u0011\u0013!C\u0001\u0003GB\u0011\"!\u001b\u000f#\u0003%\t!a\u0013\t\u0013\u0005-d\"%A\u0005\u0002\u0005\r\u0004\"CA7\u001dE\u0005I\u0011AA2\u0011%\tyGDA\u0001\n\u0013\t\tH\u0001\u000bM_\u000e\fG\u000e\u00165sK\u0016tu\u000eZ3N_RLgm\u001d\u0006\u00035m\tQ!\\8uS\u001aT!\u0001H\u000f\u0002\u0011Q,W\u000e]8sC2T!AH\u0010\u0002\u0015\u0005dwm\u001c:ji\"l7O\u0003\u0002!C\u0005A!/\u00199ii>\u0014\u0018PC\u0001#\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0011\u00051\u001aT\"A\u0017\u000b\u00059z\u0013!C1mO>\u0014\u0018\u000e\u001e5n\u0015\t\u0001\u0014'\u0001\u0005b]\u0006d\u0017p]5t\u0015\t\u0011t$A\u0002ba&L!\u0001N\u0017\u0003!\u001d+g.\u001a:jGJ+G-^2uS>t\u0017!\u00023fYR\f\u0007C\u0001\u00148\u0013\tAtE\u0001\u0003M_:<\u0017!C4sCBDw+\u001b3f!\t13(\u0003\u0002=O\t9!i\\8mK\u0006t\u0017a\u00039sKR$\u0018\u0010\u0015:j]R\fa\u0001P5oSRtD\u0003\u0002!C\u0007\u0012\u0003\"!\u0011\u0001\u000e\u0003eAq!\u000e\u0003\u0011\u0002\u0003\u0007a\u0007C\u0004:\tA\u0005\t\u0019\u0001\u001e\t\u000fu\"\u0001\u0013!a\u0001u\u0005Qq.\u001e;qkRd\u0015n\u001d;\u0016\u0003\u001d\u00032\u0001\u0013)T\u001d\tIeJ\u0004\u0002K\u001b6\t1J\u0003\u0002MG\u00051AH]8pizJ\u0011\u0001K\u0005\u0003\u001f\u001e\nq\u0001]1dW\u0006<W-\u0003\u0002R%\n!A*[:u\u0015\tyu\u0005\u0005\u0002U1:\u0011QK\u0016\t\u0003\u0015\u001eJ!aV\u0014\u0002\rA\u0013X\rZ3g\u0013\tI&L\u0001\u0004TiJLgn\u001a\u0006\u0003/\u001e\n1b\\;uaV$H*[:uA\u0005\u0001r\r\\8cC2|U\u000f\u001e9vi2K7\u000f^\u000b\u0002=B\u0019\u0001jX*\n\u0005\u0001\u0014&aA*fc\u0006\tr\r\\8cC2|U\u000f\u001e9vi2K7\u000f\u001e\u0011\u0002\u0019M,GN\u001a'p_B4\u0015\u000e\u001c;\u0016\u0003\u0011\u0004BAJ3hO&\u0011am\n\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B)a\u0005\u001b\u001c7m%\u0011\u0011n\n\u0002\u0007)V\u0004H.Z\u001a\u0002\u001bM,GN\u001a'p_B4\u0015\u000e\u001c;!\u0003\u0015\t\u0007\u000f\u001d7z)\ti\u0007\u000f\u0005\u0002oq:\u0011q\u000e\u001d\u0007\u0001\u0011\u0015\t8\u00021\u0001s\u0003\u00159'/\u00199i!\t\u0019h/D\u0001u\u0015\t)x&A\u0005he\u0006\u0004\bN^5fo&\u0011q\u000f\u001e\u0002\u0011\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016L!!\u001f<\u0003\u0019I+G-^2fI\u001e\u0013\u0018\r\u001d5\u0002\u0015Q\f'-\u001e7be&\u001cX\rF\u0002}\u0003\u000b\u00012!`A\u0001\u001b\u0005q(BA@0\u0003\u0015!\u0018M\u00197f\u0013\r\t\u0019A \u0002\u0006)\u0006\u0014G.\u001a\u0005\u0007c2\u0001\r!a\u0002\u0011\u0007M\fI!C\u0002\u0002\fQ\u0014qCU3ek\u000e,Gm\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3)\u000f\u0001\ty!a\t\u0002&A!\u0011\u0011CA\u0010\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001C:dC2\fGm\\2\u000b\t\u0005e\u00111D\u0001\bi\u0006\\WM_8f\u0015\r\ti\"I\u0001\u0007O&$\b.\u001e2\n\t\u0005\u0005\u00121\u0003\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\u0012\u0011qE\u0001\u001ct=R#F\u0003\u0011!U\u0001\u00023p]?a\u0019>\u001c\u0017\r\u001c+ie\u0016,gj\u001c3f\u001b>$\u0018NZ:)I\u0016dG/\u0019\u001eM_:<G\u0006I4sCBDw+\u001b3fu\t{w\u000e\\3b]v\"(/^3-AA\u0014X\r\u001e;z!JLg\u000e\u001e\u001eC_>dW-\u00198>iJ,X-\u000b1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\u001au.\u001e8uA=\u001c7-\u001e:sK:\u001cWm\u001d\u0011pM\u0002\"\bN]3f[\u0015$w-\u001a\u0011va6\"x.\f;ie\u0016,WF\\8eK\u0002\"X-\u001c9pe\u0006d\u0007%\\8uS\u001a\u001c\b%Z1dQ\u0002rw\u000eZ3!a\u0006\u0014H/[2ja\u0006$Xm\u001d\u0011j]:\u0002ci\u001c:!C:\u0004SM\u001a4jG&,g\u000e\u001e\u0011hY>\u0014\u0017\r\u001c\u0011d_VtG\u000f\f\u0011vg\u0016\u0004C\u000b\u001b:fK:{G-Z'pi&47O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!)\",\u0007%\u00197h_JLG\u000f[7!SN\u0004c/\u001a:zA\t\f7/\u001a3!_:\u0004C\u000f[1uA%t\u0007EI'pi&47\u000fI5oAQ+W\u000e]8sC2\u0004c*\u001a;x_J\\7O\t\u0018!\u0003:\u0004s\u000e\u001d;j_:\u0004\u0013n\u001d\u0011hSZ,g\u000e\t;pAI,G/\u001e:oAI,7/\u001e7ug\u0002\n7\u000fI1!Q\u0006\u001c\b.\\1qA]LG\u000f\u001b\u0011mC\n,Gn\u001d\u0011pe\u0002\n7\u000fI1oA\u0005\u0014(/Y=!o\"L7\r\u001b\u0011jg\u0002*\u0017m]5fe\u00022wN\u001d\u0011q_N$X\u0006\u001d:pG\u0016\u001c8/\u001b8h])\u0001\u0003E\u000b\u0006!A)\u0002\u0003eI\u0012!!\u0006\u0014\u0018-\\3uKJ\u001c(\u0002\t\u0011+A\u0001Z8/ 1eK2$\u0018M\u000f\u0011M_:<Wh\r\u001c1a1\u0003'\u0002\t\u0011+A\u0001\u0002#\b\t#fYR\f\u0007E^1mk\u0016\u0004cm\u001c:!i\",\u0007%\\1yS6,X\u000e\t;j[\u0016\u0004C.\u001a8hi\"\u0004#-\u001a;xK\u0016t\u0007\u0005\u001e5fA\u0019L'o\u001d;!C:$\u0007EZ5oC2\u0004S\rZ4fA=4\u0007\u0005\u001e5fA5|G/\u001b4/AQCW\r\t3fM\u0006,H\u000e\u001e\u0011wC2,X\rI5tAM2\u0004\u0007\r'!QEBw.\u001e:*A\u0005\u001c8/^7j]\u001e\u0004C\u000f[3!I\u0006$\u0018mJ:!i&lWm\u001d;b[B\u001c\b%\u0019:fA%t\u0007e]3d_:$7O\f\u0006!A)\u0002\u0003e_:~AB\u0014X\r\u001e;z!JLg\u000e\u001e\u001e!\u0005>|G.Z1o{Q\u0013X/\u001a1\u000bA\u0001R\u0003\u0005\t\u0011;A%4\u0007\u0005\u0019+sk\u0016\u0004G\u0006\t:fiV\u0014hn\u001d\u0011bA1L7\u000f\u001e\u0011pM\u0002jw\u000e^5gg\u0002:\u0018\u000e\u001e5!C\u0002\"Wm]2sSB$\u0018n\u001c8!_\u001a\u0004C\u000f[3![>$\u0018N\u001a\u0018!\u001d>$\bE]3d_6lWM\u001c3fI\u0002Jg\rI=pk\u0002\n'/\u001a\u0011e_&tw\rI1os\u0002\u0002xn\u001d;!aJ|7-Z:tS:<\u0007e\u001c8!i\",\u0007e\\;uaV$H/\u001a3![>$\u0018NZ:/\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004wM]1qQ^KG-\u001a\u001e!\u0005>|G.Z1o{Q\u0013X/\u001a1\u000bA\u0001R\u0003\u0005\t\u001e!S\u001a\u0004\u0003\r\u0016:vK\u0002d\u0003E[;ti\u0002zg.\u001a\u0011s_^\u0004\u0003/\u001a:!a\u0016\u00148\u000f]3di&4X\rI5tAI,G/\u001e:oK\u0012\u0004s/\u001b;iA\r|WO\u001c;tA\u0019|'\u000f\t;iK\u0002:\bn\u001c7fA\u001d\u0014\u0018\r\u001d5-A=$\b.\u001a:xSN,\u0007eY8v]R\u001c\b\u0005]3sAY,'\u000f^3yA\u0005\u0014X\r\t:fiV\u0014h.\u001a3/A9{G/\u001a\u0011uQ\u0006$\b\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5.o&$W\rI2pk:$8\u000fI1sK\u0002rw\u000e\u001e\u0011kkN$(\u0002\t\u0011+A\u0001\"\b.\u001a\u0011tk6\u0004sN\u001a\u0011uQ\u0016\u0004\u0003/\u001a:.m\u0016\u0014H/\u001a=!G>,h\u000e^:<AQDW\r\t;sS\u0006tw\r\\3!G>,h\u000e^:!CJ,\u0007\u0005Z5wS\u0012,G\r\t2zAQD'/Z3!g&t7-\u001a\u0011uQ\u0016L\b%\u0019:fA\r|WO\u001c;fI\u0002zgnY3!M>\u0014\b%Z1dQ\u00022XM\u001d;fq:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I\u0012$A5{G/\u001b4t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023eI\u0012!'R\f'o\u001d\u0006!A)R\u0001\u0005\t\u0016!AQCWM]3!CJ,\u0007\u0005\u001e5sK\u0016\u00043\r\\1tg\u0016\u001c\b\u0005K5oAQDW\rI8sI\u0016\u0014\b\u0005\u001e5fs\u0002\n'/\u001a\u0011pkR\u0004X\u000f\u001e;fI&\u0002sN\u001a\u0011ti\u0006\u0014\b%\\8uS\u001a\u0004sN\u001c\u0011uQJ,W\r\t8pI\u0016\u001c\bEY1tK\u0012\u0004sN\u001c\u0011uQ\u0016\u00043o^5uG\"Lgn\u001a\u0011cK\"\fg/[8ve\u0002zg\r\t;iK\u0002*GmZ3tA\t,Go^3f]\u0002\"\b.\u001a\u0011uo>\u0004C.Z1gA9|G-Z:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003%\f\u0011Q%\u0016S\u0004e\u0015;beN\u0004sN\u001a\u0011uQ\u0016\u0004cm\u001c:nA%dTF\u00106-A%dTF\u00106-A%dTFP6!Q%,\u0007\u0005^<pA%tG/\u001a:bGRLwN\\:!o&$\b\u000e\t7fC\u001a\u0004#\u000e\t4pY2|w/\u001a3!Ef\u0004sN\\3!o&$\b\u000e\t7fC\u001a\u00043.\u000b\u0006!A)\u0002\u0003\u0005I\u0017!\u001b&#%\bI*uCJ\u001c\be\u001c4!i\",\u0007EZ8s[\u0002JG(\f kY\u0001JG(\f lY\u0001JG(\f kA!JW\rI:xSR\u001c\u0007.\u001b8hA%tG/\u001a:bGRLwN\\:!MJ|W\u000e\t7fC\u001a\u0004#\u000e\t;pA1,\u0017M\u001a\u0011lY\u0001\u0012\u0017mY6!i>\u0004#\u000eI1hC&t\u0017F\u0003\u0011!U\u0001\u0002\u0003%\f\u0011Q\u001fN#&\bI*uCJ\u001c\be\u001c4!i\",\u0007EZ8s[\u0002JG(\f kY\u0001JG(\f lY\u0001JG(\f lA!JW\rI8oK\u0002Jg\u000e^3sC\u000e$\u0018n\u001c8!o&$\b\u000e\t7fC\u001a\u0004#\u000e\t4pY2|w/\u001a3!Ef\u0004Co^8!o&$\b\u000e\t7fC\u001a\u00043.\u000b\u0006!A)R\u0001\u0005\t\u0016!A]KG\u000f[5oA\u0015\f7\r\u001b\u0011pM\u0002\"\b.Z:fA\rd\u0017m]:fg\u0002J7\u000f\t\u001d![>$\u0018NZ:!I\u0016\u0004XM\u001c3j]\u001e\u0004sN\u001c\u0011uQ\u0016\u0004C-\u001b:fGRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000f\t;pAQDW\r\t7bgR\u0004S\rZ4fA5j\u0003%\u001b8d_6Lgn\u001a\u0011#\u0013\n\u0002sN\u001d\u0011pkR<w.\u001b8hA\tz%E\f\u0006!A)\u0002\u0003\u0005\u00165fg\u0016\u0004\u0013M]3!K:,X.\u001a:bi\u0016$\u0007%\u001b8!i\",\u0007e\u001c:eKJ\u0004\u0013*S%-A%Ku\n\f\u0011J\u001f&c\u0003%S(PY\u0001z\u0015*\u0013\u0017!\u001f&{E\u0006I(P\u00132\u0002sjT(!Q1L7.\u001a\u0011cS:\f'/\u001f\u0011xSRD\u0007EI%#[A\u0002\u0013M\u001c3!E=\u0013S&M\u0015/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023eI\u0012!)^|\u0007E\\8eK\u0002jw\u000e^5gg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003%\u00117t_\u0002Jgn\u00197vI\u0016$\u0007%\u0019:fAQ<x\u000e\t8pI\u0016\u0004Sn\u001c;jMNd\u0003e\u001c4!o\"L7\r\u001b\u0011uQ\u0016\u0014X\rI1sK\u0002B\u0004e\u001e5f]\u0002\u001aw.\u001e8uK\u0012\u0004cM]8nAQDW\r\t9feN\u0004Xm\u0019;jm\u0016\u0004sN\u001a\u0011fC\u000eD\u0007E^3si\u0016Dh\u0006\t+iKN,\u0007%\u0019:fA\rD\u0017M]1di\u0016\u0014\u0018n]3eA\tL\b\u0005\u001e5fA\u0011L'/Z2uS>t\u0007e\u001c4!K\u0006\u001c\u0007\u000eI3eO\u0016d\u0003%\u001a8v[\u0016\u0014\u0018\r^3e\u0015\u0001\u0002#\u0006\t\u0011j]\u0002\"\b.\u001a\u0011bE>4X\rI8sI\u0016\u0014h\u0006\t(pi\u0016\u0004C\u000f[1uA\u0019|'\u000f\t;iK\u0002:Gn\u001c2bY\u0002:'/\u00199iA\r|WO\u001c;tY\u0001*\u0017m\u00195![>$\u0018N\u001a\u0011jg\u0002\u001aw.\u001e8uK\u0012\u0004\u0013N\u001c\u0011c_RD\u0007\u0005Z5sK\u000e$\u0018n\u001c8tA!\n\u0007e]5oO2,\u0007%S%JA5|G/\u001b4!M>\u0014\be\u001c8fAY,'\u000f^3yA%\u001c\b%\u00198!\u001f>{\u0005%\\8uS\u001a\u0004cm\u001c:!i\",\u0007e\u001c;iKJ\u0004c/\u001a:uKbLcF\u0003\u0011!U)\u0001\u0003E\u000b\u0011!G\r\u001a\u0003\u0005\u0016:jC:<G.Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001\"\u0006.\u001a:fA\u0005\u0014X\r\t\u001d!iJL\u0017M\\4mK\u0002jw\u000e^5gg2\u0002#-\u001a7po\u0002J7\u000f\t;iK\u0002z'\u000fZ3sA%t\u0007e\u001e5jG\"\u0004C\u000f[3zA\u0005\u0004\b/Z1sA%t\u0007\u0005\u001e5fAI,G/\u001e:oK\u0012\u0004\u0013M\u001d:bsjR\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u00112]\u0001J\u0007%L\u0017?A)d\u0003e\u001b\u0011.[y\u0002#\u000e\f\u0011jA5jc\bI6\u000bA\u0001R\u0003\u0005\t\u00113]\u0001J\u0007%L\u0017?A)d\u0003e\u001b\u0011.[y\u0002\u0013\u000e\f\u0011kA5jc\bI6\u000bA\u0001R\u0003\u0005\t\u00114]\u0001J\u0007%L\u0017?A)d\u0003E\u001b\u0011.[y\u00023\u000e\f\u0011jA5jc\bI6\u000bA\u0001R\u0003\u0005\t\u00115]\u0001J\u0007%L\u0017?A)d\u0003%\u001b\u0011.[y\u00023\u000e\f\u0011kA5jc\bI6\u000bA\u0001R\u0003\u0005\t\u00116]\u0001J\u0007%L\u0017?A)d\u0003e\u001b\u0011.[y\u0002#\u000e\f\u0011lA5jc\bI5\u000bA\u0001R\u0003\u0005\t\u00117]\u0001J\u0007%L\u0017?A)d\u0003e\u001b\u0011.[y\u0002\u0013\u000e\f\u0011lA5jc\b\t6\u000bA\u0001R\u0003\u0005\t\u00118]\u0001J\u0007%L\u0017?A)d\u0003E\u001b\u0011.[y\u00023\u000e\f\u0011lA5jc\bI5\u000bA\u0001R\u0003\u0005\t\u00119]\u0001J\u0007%L\u0017?A)d\u0003%\u001b\u0011.[y\u00023\u000e\f\u0011lA5jc\b\t6\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0002C\u000b[3![>$\u0018N\u001a\u0011d_VtGo\u001d\u0011be\u0016\u0004#/\u001a;ve:,G\rI1tA\u0005\u0004C\u0007M\u0017eA\u0005\u0014(/Y=!o\",'/\u001a\u0011uQ\u0016\u0004c-\u001b:ti\u0002\u0012D\u0007I3mK6,g\u000e^:!CJ,\u0007e\u001d;be\u0002\u001aw.\u001e8ug2R\u0001\u0005\t\u0016!A\u0001\"\b.\u001a\u0011oKb$\b\u0005\u000f\u0011be\u0016\u0004Co^8.]>$W\rI7pi&4\u0007eY8v]R\u001c\b%\u00198eAQDW\r\t4j]\u0006d\u0007\u0005\u000f\u0011be\u0016\u0004CO]5b]\u001edW\rI2pk:$8O\f\u0006!A)R\u0001\u0005\t\u0016!G\r\u00023\u000b^1uKNT\u0001\u0005\t\u0016!Am\u001cX\u0010Y:uCJ\u001cu.\u001e8ugj\u0002\u0013I\u001d:bsnKe\u000e^/a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002C\u000b\u001b:fK6rw\u000eZ3!gR\f'\u000fI7pi&4\u0007eY8v]R\u001c\be\u001d;pe\u0016$\u0007%Y:!C:\u0004\u0013M\u001d:bs\u0002B3/Z3!S:$\u0017nY3tA\u0005\u0014wN^3*\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004Go^8O_\u0012,7i\\;oiNT\u0004%\u0011:sCf\\\u0016J\u001c;^A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005V<p[9|G-\u001a\u0011n_RLg\rI2pk:$8\u000fI:u_J,G\rI1tA\u0005t\u0007%\u0019:sCf\u0004\u0003f]3fA%tG-[2fg\u0002\n'm\u001c<fS)\u0001\u0003E\u000b\u0011!wNl\b\r\u001e:j\u0007>,h\u000e^:;A\u0005\u0013(/Y=\\\u0013:$X\f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;AQ\u0013\u0018.\u00198hY\u0016\u0004Sn\u001c;jM\u0002\u001aw.\u001e8ug\u0002\u001aHo\u001c:fI\u0002\n7\u000fI1oA\u0005\u0014(/Y=!QM,W\rI5oI&\u001cWm\u001d\u0011bE>4X-\u000b\u0006!A)R\u0001\u0005\t\u0016!G\r\u0002#+\u001a;ve:\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011}AY,'\u000f^3yA9\fW.\u001a\u0011!A\u0001\u0002\u0003\u0005\t?!c\u0001\u0012\u0004E\f\u0018/AQ\u0002\u0004\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AqT\u0001\u0005\t\u0016!Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015\u0001\u0002#\u0006\t\u0011}Am\u001cX\u0010\u00198b[\u0016T\u0004e\u0015;sS:<\u0007\r\t?!wNl\b-\\8uS\u001a\u001cu.\u001e8uu\u0001buN\\4aAqT\u0001\u0005\t\u00160\u0003QaunY1m)\"\u0014X-\u001a(pI\u0016lu\u000e^5ggB\u0011\u0011ID\n\u0005\u001d\u0015\ny\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0005%|'BAA\u001d\u0003\u0011Q\u0017M^1\n\t\u0005u\u00121\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003W!r\u0001QA\"\u0003\u000b\n9\u0005C\u00046!A\u0005\t\u0019\u0001\u001c\t\u000fe\u0002\u0002\u0013!a\u0001u!9Q\b\u0005I\u0001\u0002\u0004Q\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055#f\u0001\u001c\u0002P-\u0012\u0011\u0011\u000b\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003%)hn\u00195fG.,GMC\u0002\u0002\\\u001d\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty&!\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)GK\u0002;\u0003\u001f\nq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u000f\t\u0005\u0003k\nY(\u0004\u0002\u0002x)!\u0011\u0011PA\u001c\u0003\u0011a\u0017M\\4\n\t\u0005u\u0014q\u000f\u0002\u0007\u001f\nTWm\u0019;")
public class LocalThreeNodeMotifs
implements GenericReduction {
    private final long delta;
    private final boolean graphWide;
    private final boolean prettyPrint;
    private final List<String> outputList;
    private final Seq<String> globalOutputList;
    private final PartialFunction<Tuple3<Object, Object, Object>, Tuple3<Object, Object, Object>> selfLoopFilt;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static boolean $lessinit$greater$default$3() {
        return LocalThreeNodeMotifs$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return LocalThreeNodeMotifs$.MODULE$.$lessinit$greater$default$2();
    }

    public static long $lessinit$greater$default$1() {
        return LocalThreeNodeMotifs$.MODULE$.$lessinit$greater$default$1();
    }

    public static boolean apply$default$3() {
        return LocalThreeNodeMotifs$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$2() {
        return LocalThreeNodeMotifs$.MODULE$.apply$default$2();
    }

    public static long apply$default$1() {
        return LocalThreeNodeMotifs$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(Generic other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    public List<String> outputList() {
        return this.outputList;
    }

    public Seq<String> globalOutputList() {
        return this.globalOutputList;
    }

    public PartialFunction<Tuple3<Object, Object, Object>, Tuple3<Object, Object, Object>> selfLoopFilt() {
        return this.selfLoopFilt;
    }

    @Override
    public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return (ConcreteReducedGraphPerspective)KCore$.MODULE$.apply(2, KCore$.MODULE$.apply$default$2()).apply(graph).clearMessages().reducedView().setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            LocalThreeNodeMotifs.$anonfun$apply$1(state);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$apply$11(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$apply$12(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$apply$14(v);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(v, state) -> {
            LocalThreeNodeMotifs.$anonfun$apply$20(this, v, state);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$apply$29(v);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(v, state) -> {
            LocalThreeNodeMotifs.$anonfun$apply$32(this, v, state);
            return BoxedUnit.UNIT;
        });
    }

    public Table tabularise(ReducedGraphPerspective graph) {
        return !this.graphWide ? (this.prettyPrint ? graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$tabularise$1(v);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "starCounts", "twoNodeCounts", "triCounts"})) : graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$tabularise$2(v);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)this.outputList())) : (this.prettyPrint ? graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            LocalThreeNodeMotifs.$anonfun$tabularise$4(state);
            return BoxedUnit.UNIT;
        }).globalSelect((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"starCountsPretty", "twoNodeCountsPretty", "triCountsPretty"})) : graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            LocalThreeNodeMotifs.$anonfun$tabularise$5(state);
            return BoxedUnit.UNIT;
        }).globalSelect(this.globalOutputList()));
    }

    public static final /* synthetic */ String $anonfun$outputList$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ String $anonfun$globalOutputList$1(int x$2) {
        return Integer.toString(x$2);
    }

    public static final /* synthetic */ long $anonfun$apply$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ long $anonfun$apply$7(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ long $anonfun$apply$10(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$apply$1(GraphState state) {
        state.newAccumulator("twoNodeCounts", Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(ar1, ar2) -> (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(ar1), (IterableOnce)Predef$.MODULE$.wrapLongArray(ar2))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$4(x0$1)), (ClassTag)ClassTag$.MODULE$.Long()));
        state.newAccumulator("triCounts", Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(ar1, ar2) -> (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(ar1), (IterableOnce)Predef$.MODULE$.wrapLongArray(ar2))), (Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$7(x0$2)), (ClassTag)ClassTag$.MODULE$.Long()));
        state.newAccumulator("starCounts", Array$.MODULE$.fill(24, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(ar1, ar2) -> (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(ar1), (IterableOnce)Predef$.MODULE$.wrapLongArray(ar2))), (Function1 & Serializable)x0$3 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$10(x0$3)), (ClassTag)ClassTag$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$apply$11(ReducedVertex v) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            v.messageAllNeighbours(v.ID(), SchemaProviderInstances$.MODULE$.longSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$12(ReducedVertex v) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            scala.collection.immutable.Set neighbours = v.messageQueue().toSet();
            ((EntityVisitor)((Object)v)).setState("effNeighbours", neighbours);
            neighbours.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)nb -> v.messageVertex(BoxesRunTime.boxToLong((long)nb), new Tuple2(v.ID(), (Object)neighbours), SchemaProviderInstances$.MODULE$.genericSchemaProvider()));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$16(ReducedVertex v$2, scala.collection.immutable.Set neighbours$2, Tuple2 x0$4) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            long nb = tuple2._1$mcJ$sp();
            scala.collection.immutable.Set friendsOfFriend = (scala.collection.immutable.Set)tuple2._2();
            if (BoxesRunTime.unboxToLong((Object)v$2.ID()) > nb) {
                friendsOfFriend.intersect((Set)neighbours$2).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)w -> {
                    block0: {
                        if (nb <= w) break block0;
                        v$2.messageVertex(BoxesRunTime.boxToLong((long)w), ((List)v$2.explodedEdge(nb, v$2.explodedEdge$default$2(), v$2.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$apply$14(ReducedVertex v) {
        block0: {
            ((EntityVisitor)((Object)v)).setState("triCounts", Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()));
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            scala.collection.immutable.Set neighbours = (scala.collection.immutable.Set)((EntityVisitor)((Object)v)).getState("effNeighbours", ((EntityVisitor)((Object)v)).getState$default$2());
            ((EntityVisitor)((Object)v)).clearState("effNeighbours");
            Seq queue = v.messageQueue();
            queue.foreach((Function1 & Serializable)x0$4 -> {
                LocalThreeNodeMotifs.$anonfun$apply$16(v, neighbours, x0$4);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ long $anonfun$apply$28(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$apply$21(LocalThreeNodeMotifs $this, ReducedVertex v$3, GraphState state$1, List edges) {
        Tuple3 tuple3 = (Tuple3)edges.head();
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        long u = BoxesRunTime.unboxToLong((Object)tuple3._1());
        long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(u, w);
        Tuple2.mcJJ.sp sp3 = sp2;
        long u2 = sp3._1$mcJ$sp();
        long w2 = sp3._2$mcJ$sp();
        List inputEdges = (List)((SeqOps)((IterableOps)((List)v$3.explodedEdge(u2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).$plus$plus((IterableOnce)((List)v$3.explodedEdge(w2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))))).$plus$plus((IterableOnce)edges)).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$));
        List ids = (List)((SeqOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)v$3.ID()), u2, w2}))).sortWith((Function2)(JFunction2.mcZJJ.sp & Serializable)(x$4, x$5) -> x$4 < x$5);
        TriadMotifCounter mc = new TriadMotifCounter(BoxesRunTime.unboxToLong((Object)ids.apply(0)), BoxesRunTime.unboxToLong((Object)ids.apply(1)), (Iterable<Object>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)ids.apply(2))}))));
        mc.execute((List<Tuple3<Object, Object, Object>>)inputEdges, $this.delta);
        long[] curVal = (long[])((EntityVisitor)((Object)v$3)).getState("triCounts", ((EntityVisitor)((Object)v$3)).getState$default$2());
        ((EntityVisitor)((Object)v$3)).setState("triCounts", ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(curVal), (IterableOnce)Predef$.MODULE$.wrapLongArray(mc.getCounts()))), (Function1 & Serializable)x0$5 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$28(x0$5)), (ClassTag)ClassTag$.MODULE$.Long()));
        v$3.messageVertex(BoxesRunTime.boxToLong((long)u2), mc.getCounts(), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        v$3.messageVertex(BoxesRunTime.boxToLong((long)w2), mc.getCounts(), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        state$1.apply("triCounts").$plus$eq(mc.getCounts());
    }

    public static final /* synthetic */ void $anonfun$apply$20(LocalThreeNodeMotifs $this, ReducedVertex v, GraphState state) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            v.messageQueue().foreach((Function1 & Serializable)edges -> {
                LocalThreeNodeMotifs.$anonfun$apply$21($this, v, state, edges);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ long $anonfun$apply$31(Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$apply$30(ReducedVertex v$4, long[] toAdd) {
        long[] curVal = (long[])((EntityVisitor)((Object)v$4)).getState("triCounts", ((EntityVisitor)((Object)v$4)).getState$default$2());
        ((EntityVisitor)((Object)v$4)).setState("triCounts", ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(curVal), (IterableOnce)Predef$.MODULE$.wrapLongArray(toAdd))), (Function1 & Serializable)x0$6 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$31(x0$6)), (ClassTag)ClassTag$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$apply$29(ReducedVertex v) {
        v.messageQueue().foreach((Function1 & Serializable)toAdd -> {
            LocalThreeNodeMotifs.$anonfun$apply$30(v, toAdd);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$apply$43(Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$apply$32(LocalThreeNodeMotifs $this, ReducedVertex v, GraphState state) {
        StarMotifCounter mc = new StarMotifCounter(BoxesRunTime.unboxToLong((Object)v.ID()), (Iterable<Object>)((Iterable)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$6 -> x$6 != BoxesRunTime.unboxToLong((Object)v.ID()))));
        mc.execute((List<Tuple3<Object, Object, Object>>)((List)v.explodeAllEdges(v.explodeAllEdges$default$1(), v.explodeAllEdges$default$2()).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).collect($this.selfLoopFilt()).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))), $this.delta);
        long[] counts = mc.getCounts();
        ObjectRef twoNodeCounts = ObjectRef.create((Object)((long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long())));
        ((IterableOnceOps)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 != BoxesRunTime.unboxToLong((Object)v.ID()))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)vid -> {
            TwoNodeMotifs mc2node = new TwoNodeMotifs(BoxesRunTime.unboxToLong((Object)v.ID()));
            mc2node.execute((Tuple3[])((IterableOnceOps)((List)v.explodedEdge(vid, v.explodedEdge$default$2(), v.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).toArray(ClassTag$.MODULE$.apply(Tuple3.class)), $this.delta);
            long[] twoNC = mc2node.getCounts();
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.longArrayOps(counts)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                counts$1[i] = counts[i] - twoNC[i % 8];
            });
            twoNodeCounts$1.elem = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps((long[])twoNodeCounts$1.elem), (IterableOnce)Predef$.MODULE$.wrapLongArray(twoNC))), (Function1 & Serializable)x0$7 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$43(x0$7)), (ClassTag)ClassTag$.MODULE$.Long());
        });
        ((EntityVisitor)((Object)v)).setState("twoNodeCounts", (long[])twoNodeCounts.elem);
        state.apply("twoNodeCounts").$plus$eq((long[])twoNodeCounts.elem);
        ((EntityVisitor)((Object)v)).setState("starCounts", counts);
        state.apply("starCounts").$plus$eq(counts);
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(ReducedVertex v) {
        ((EntityVisitor)((Object)v)).setState("name", v.name(v.name$default$1()));
        ((EntityVisitor)((Object)v)).setState("starCounts", ThreeNodeMotifs$.MODULE$.getStarCountsPretty(((EntityVisitor)((Object)v)).getState("starCounts", ((EntityVisitor)((Object)v)).getState$default$2()), Numeric.LongIsIntegral$.MODULE$));
        ((EntityVisitor)((Object)v)).setState("twoNodeCounts", ThreeNodeMotifs$.MODULE$.get2NodeCountsWithoutRepeats(((EntityVisitor)((Object)v)).getState("twoNodeCounts", ((EntityVisitor)((Object)v)).getState$default$2()), Numeric.LongIsIntegral$.MODULE$));
        ((EntityVisitor)((Object)v)).setState("triCounts", ThreeNodeMotifs$.MODULE$.getTriCountsPretty(((EntityVisitor)((Object)v)).getState("triCounts", ((EntityVisitor)((Object)v)).getState$default$2()), Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$tabularise$2(ReducedVertex v) {
        ((EntityVisitor)((Object)v)).setState("name", v.name(v.name$default$1()));
        long[] motif_array = (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])((EntityVisitor)((Object)v)).getState("starCounts", ((EntityVisitor)((Object)v)).getState$default$2())), ((EntityVisitor)((Object)v)).getState("twoNodeCounts", ((EntityVisitor)((Object)v)).getState$default$2()), (ClassTag)ClassTag$.MODULE$.Long())), ((EntityVisitor)((Object)v)).getState("triCounts", ((EntityVisitor)((Object)v)).getState$default$2()), (ClassTag)ClassTag$.MODULE$.Long());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 40).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ((EntityVisitor)((Object)v)).setState(Integer.toString(i), BoxesRunTime.boxToLong((long)motif_array[i - 1])));
    }

    public static final /* synthetic */ void $anonfun$tabularise$4(GraphState state) {
        state.newConstant("starCountsPretty", ThreeNodeMotifs$.MODULE$.getStarCountsPretty(state.apply("starCounts").value(), Numeric.LongIsIntegral$.MODULE$));
        state.newConstant("twoNodeCountsPretty", ThreeNodeMotifs$.MODULE$.get2NodeCountsWithoutRepeats(state.apply("starCounts").value(), Numeric.IntIsIntegral$.MODULE$));
        state.newConstant("triCountsPretty", ThreeNodeMotifs$.MODULE$.getTriCountsPretty(state.apply("starCounts").value(), Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$tabularise$5(GraphState state) {
        long[] motif_array = (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])state.apply("starCounts").value()), state.apply("twoNodeCounts").value(), (ClassTag)ClassTag$.MODULE$.Long())), state.apply("triCounts").value(), (ClassTag)ClassTag$.MODULE$.Long());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 40).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> state.newConstant(Integer.toString(i), BoxesRunTime.boxToLong((long)motif_array[i - 1])));
    }

    public LocalThreeNodeMotifs(long delta, boolean graphWide, boolean prettyPrint) {
        this.delta = delta;
        this.graphWide = graphWide;
        this.prettyPrint = prettyPrint;
        BaseAlgorithm.$init$(this);
        GenericReduction.$init$(this);
        this.outputList = (List)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 40).map((Function1 & Serializable)x$1 -> LocalThreeNodeMotifs.$anonfun$outputList$1(BoxesRunTime.unboxToInt((Object)x$1))));
        this.globalOutputList = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 40).map((Function1 & Serializable)x$2 -> LocalThreeNodeMotifs.$anonfun$globalOutputList$1(BoxesRunTime.unboxToInt((Object)x$2)));
        this.selfLoopFilt = new Serializable(null){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple3<Object, Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    long src = BoxesRunTime.unboxToLong((Object)A1._1());
                    long dst = BoxesRunTime.unboxToLong((Object)A1._2());
                    long time = BoxesRunTime.unboxToLong((Object)A1._3());
                    if (src != dst) {
                        object = new Tuple3((Object)BoxesRunTime.boxToLong((long)src), (Object)BoxesRunTime.boxToLong((long)dst), (Object)BoxesRunTime.boxToLong((long)time));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple3<Object, Object, Object> x1) {
                long dst;
                long src;
                Tuple3<Object, Object, Object> tuple3 = x1;
                boolean bl = tuple3 != null && (src = BoxesRunTime.unboxToLong((Object)tuple3._1())) != (dst = BoxesRunTime.unboxToLong((Object)tuple3._2()));
                return bl;
            }
        };
    }
}

