/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NeighbourNames$;
import com.raphtory.algorithms.temporal.TemporalEdgeList$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ConcreteExplodedEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n  *  {s}`TemporalEdgeList(properties: String*)`\n  *  : Writes out temporal edge list with selected properties\n  *\n  *  {s}`EdgeList(defaults: Map[String, Any], properties: String*)`\n  *  : Specify default values for missing properties\n  *\n  *  {s}`EdgeList(properties: Seq[String] = Seq.empty[String], defaults: Map[String, Any] = Map.empty[String, Any])`\n  *  : Specify sequence of property names\n  *\n  *  ## Parameters\n  *\n  *  {s}`properties: Seq[String]`\n  *  : Sequence of property names to extract (default: empty)\n  *\n  *  {s}`defaults: Map[String, Any]`\n  *  : Map of property names to default values (default value: None)\n  *\n  *  ## Returns\n  *\n  *  temporal edge list with selected properties\n  *\n  *  | source name          | destination name     | time stamp      |  property 1     | ... |\n  *  | -------------------- | -------------------- | --------------- | --------------- | --- |\n  *  | {s}`srcName: String` | {s}`dstName: String` | {s}`time: Long` | {s}`value: Any` | ... |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\t\u0012\u0001iA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\")q\t\u0001C\u0001\u0011\")Q\n\u0001C!\u001d\u001e)1.\u0005E\u0001Y\u001a)\u0001#\u0005E\u0001[\")qI\u0002C\u0001m\")qO\u0002C\u0001q\"91PBI\u0001\n\u0003a\b\"CA\b\rE\u0005I\u0011AA\t\u0011\u00199h\u0001\"\u0001\u0002\u0016!1qO\u0002C\u0001\u0003?A\u0001\"!\n\u0007#\u0003%\t\u0001 \u0005\n\u0003O1\u0011\u0013!C\u0001\u0003#A\u0011\"!\u000b\u0007\u0003\u0003%I!a\u000b\u0003!Q+W\u000e]8sC2,EmZ3MSN$(B\u0001\n\u0014\u0003!!X-\u001c9pe\u0006d'B\u0001\u000b\u0016\u0003)\tGnZ8sSRDWn\u001d\u0006\u0003-]\t\u0001B]1qQR|'/\u001f\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u0011\u0013&D\u0001$\u0015\t!S%A\u0005bY\u001e|'/\u001b;i[*\u0011aeJ\u0001\tC:\fG._:jg*\u0011\u0001&F\u0001\u0004CBL\u0017B\u0001\u0016$\u0005\u001d9UM\\3sS\u000e\f!\u0002\u001d:pa\u0016\u0014H/[3t!\riS\u0007\u000f\b\u0003]Mr!a\f\u001a\u000e\u0003AR!!M\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012B\u0001\u001b\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!AN\u001c\u0003\u0007M+\u0017O\u0003\u00025;A\u0011\u0011(\u0010\b\u0003um\u0002\"aL\u000f\n\u0005qj\u0012A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001P\u000f\u0002\u0011\u0011,g-Y;miN\u0004B!\u000f\"9\t&\u00111i\u0010\u0002\u0004\u001b\u0006\u0004\bC\u0001\u000fF\u0013\t1UDA\u0002B]f\fa\u0001P5oSRtDcA%L\u0019B\u0011!\nA\u0007\u0002#!91f\u0001I\u0001\u0002\u0004a\u0003b\u0002!\u0004!\u0003\u0005\r!Q\u0001\u000bi\u0006\u0014W\u000f\\1sSN,GCA(V!\t\u00016+D\u0001R\u0015\t\u0011V%A\u0003uC\ndW-\u0003\u0002U#\n)A+\u00192mK\")a\u000b\u0002a\u0001/\u0006)qM]1qQB\u0011\u0001lW\u0007\u00023*\u0011!,J\u0001\nOJ\f\u0007\u000f\u001b<jK^L!\u0001X-\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0007\u0006\u0002\u0001_Q&\u0004\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!a\u00193\u0002\u000fQ\f7.\u001a>pK*\u0011QmF\u0001\u0007O&$\b.\u001e2\n\u0005\u001d\u0004'\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003)\fq1[\u0018+U)\u0001\u0003E\u000b\u0011!wNl\b\rV3na>\u0014\u0018\r\\#eO\u0016d\u0015n\u001d;)aJ|\u0007/\u001a:uS\u0016\u001c(\bI*ue&twMK\u0015a\u0015\u0001\u0002#\u0006\t\u0011;A]\u0013\u0018\u000e^3tA=,H\u000f\t;f[B|'/\u00197!K\u0012<W\r\t7jgR\u0004s/\u001b;iAM,G.Z2uK\u0012\u0004\u0003O]8qKJ$\u0018.Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1FI\u001e,G*[:uQ\u0011,g-Y;miNT\u0004%T1q7N#(/\u001b8hY\u0001\ne._/-AA\u0014x\u000e]3si&,7O\u000f\u0011TiJLgn\u001a\u0016*A*\u0001\u0003E\u000b\u0011!u\u0001\u001a\u0006/Z2jMf\u0004C-\u001a4bk2$\bE^1mk\u0016\u001c\bEZ8sA5L7o]5oO\u0002\u0002(o\u001c9feRLWm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y#eO\u0016d\u0015n\u001d;)aJ|\u0007/\u001a:uS\u0016\u001c(\bI*fcn\u001bFO]5oOv\u0003S\bI*fc:*W\u000e\u001d;z7N#(/\u001b8h;2\u0002C-\u001a4bk2$8O\u000f\u0011NCB\\6\u000b\u001e:j]\u001ed\u0003%\u00118z;\u0002j\u0004%T1q]\u0015l\u0007\u000f^=\\'R\u0014\u0018N\\4-A\u0005s\u00170X\u0015a\u0015\u0001\u0002#\u0006\t\u0011;AM\u0003XmY5gs\u0002\u001aX-];f]\u000e,\u0007e\u001c4!aJ|\u0007/\u001a:us\u0002r\u0017-\\3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023e\t\u0011QCJ\fW.\u001a;feNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002\u0004(o\u001c9feRLWm\u001d\u001e!'\u0016\f8l\u0015;sS:<W\f\u0019\u0006!A)\u0002\u0003E\u000f\u0011TKF,XM\\2fA=4\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011oC6,7\u000f\t;pA\u0015DHO]1di\u0002BC-\u001a4bk2$(\bI3naRL\u0018F\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b\rZ3gCVdGo\u001d\u001e!\u001b\u0006\u00048l\u0015;sS:<G\u0006I!osv\u0003'\u0002\t\u0011+A\u0001R\u0004%T1qA=4\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011oC6,7\u000f\t;pA\u0011,g-Y;mi\u00022\u0018\r\\;fg\u0002BC-\u001a4bk2$\bE^1mk\u0016T\u0004ET8oK&R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005^3na>\u0014\u0018\r\u001c\u0011fI\u001e,\u0007\u0005\\5ti\u0002:\u0018\u000e\u001e5!g\u0016dWm\u0019;fI\u0002\u0002(o\u001c9feRLWm\u001d\u0006!A)R\u0001\u0005\t\u0016!Aq\u00043o\\;sG\u0016\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u0010\t3fgRLg.\u0019;j_:\u0004c.Y7fA\u0001\u0002\u0003\u0005\t?!i&lW\rI:uC6\u0004\b\u0005\t\u0011!A\u0001b\b\u0005\t9s_B,'\u000f^=!c\u0001\u0002\u0003\u0005\t\u0011}A9rc\u0006\t?\u000bA\u0001R\u0003\u0005\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[\u0001b(\u0002\t\u0011+A\u0001b\be_:~AN\u00148MT1nKj\u00023\u000b\u001e:j]\u001e\u0004\u0007\u0005 \u0011|gv\u0004Gm\u001d;OC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010\u0019;j[\u0016T\u0004\u0005T8oO\u0002\u0004C\u0010I>t{\u00024\u0018\r\\;fu\u0001\ne.\u001f1!y\u0002rcF\f\u0011}\u0015\u0001\u0002#fL\u0001\u0011)\u0016l\u0007o\u001c:bY\u0016#w-\u001a'jgR\u0004\"A\u0013\u0004\u0014\u0007\u0019Yb\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006\u0011\u0011n\u001c\u0006\u0002g\u0006!!.\u0019<b\u0013\t)\bO\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001m\u0003\u0015\t\u0007\u000f\u001d7z)\rI\u0015P\u001f\u0005\bW!\u0001\n\u00111\u0001-\u0011\u001d\u0001\u0005\u0002%AA\u0002\u0005\u000bq\"\u00199qYf$C-\u001a4bk2$H%M\u000b\u0002{*\u0012AF`\u0016\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C;oG\",7m[3e\u0015\r\tI!H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012TCAA\nU\t\te\u0010F\u0002J\u0003/AaaK\u0006A\u0002\u0005e\u0001\u0003\u0002\u000f\u0002\u001caJ1!!\b\u001e\u0005)a$/\u001a9fCR,GM\u0010\u000b\u0006\u0013\u0006\u0005\u00121\u0005\u0005\u0006\u00012\u0001\r!\u0011\u0005\u0007W1\u0001\r!!\u0007\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u0006\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007:\u0002\t1\fgnZ\u0005\u0005\u0003o\t\tD\u0001\u0004PE*,7\r\u001e")
public class TemporalEdgeList
implements Generic {
    private final Seq<String> properties;
    private final Map<String, Object> defaults;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static Map<String, Object> $lessinit$greater$default$2() {
        return TemporalEdgeList$.MODULE$.$lessinit$greater$default$2();
    }

    public static Seq<String> $lessinit$greater$default$1() {
        return TemporalEdgeList$.MODULE$.$lessinit$greater$default$1();
    }

    public static Map<String, Object> apply$default$2() {
        return TemporalEdgeList$.MODULE$.apply$default$2();
    }

    public static Seq<String> apply$default$1() {
        return TemporalEdgeList$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Main algorithm\n    *\n    * Default implementation returns the graph unchanged.\n    * This should be overridden by subclasses to define the actual\n    * algorithm steps unless the algorithm only outputs existing state or properties.\n    *\n    * @param graph graph to run function upon\n    */")
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return Generic.apply$(this, graph);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return NeighbourNames$.MODULE$.apply(graph.reducedView()).step((Function1 & Serializable)vertex -> {
            TemporalEdgeList.$anonfun$tabularise$1(this, vertex);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)((Seq)((SeqOps)((SeqOps)this.properties.$plus$colon((Object)"neighbourTimestamp")).$plus$colon((Object)"neighbourName")).$plus$colon((Object)"name"))).explode((Seq<String>)((Seq)((SeqOps)this.properties.$plus$colon((Object)"neighbourTimestamp")).$plus$colon((Object)"neighbourName")));
    }

    public static final /* synthetic */ void $anonfun$tabularise$4(TemporalEdgeList $this, List outEdges$1, ReducedVertex vertex$1, String property) {
        List values = outEdges$1.map((Function1 & Serializable)edge -> ((EntityVisitor)((Object)edge)).getPropertyOrElse(property, $this.defaults.getOrElse((Object)property, (Function0 & Serializable)() -> None$.MODULE$)));
        ((EntityVisitor)((Object)vertex$1)).setState(property, values);
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(TemporalEdgeList $this, ReducedVertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("name", vertex.name(vertex.name$default$1()));
        List<ConcreteExplodedEdge> outEdges = vertex.explodeOutEdges(vertex.explodeOutEdges$default$1(), vertex.explodeOutEdges$default$2());
        Map neighbourMap = (Map)((EntityVisitor)((Object)vertex)).getState("neighbourNames", ((EntityVisitor)((Object)vertex)).getState$default$2());
        ((EntityVisitor)((Object)vertex)).setState("neighbourName", outEdges.map((Function1 & Serializable)edge -> (String)neighbourMap.apply(edge.dst())));
        ((EntityVisitor)((Object)vertex)).setState("neighbourTimestamp", outEdges.map((Function1 & Serializable)edge -> BoxesRunTime.boxToLong((long)edge.timestamp())));
        $this.properties.foreach((Function1 & Serializable)property -> {
            TemporalEdgeList.$anonfun$tabularise$4($this, outEdges, vertex, property);
            return BoxedUnit.UNIT;
        });
    }

    public TemporalEdgeList(Seq<String> properties, Map<String, Object> defaults) {
        this.properties = properties;
        this.defaults = defaults;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

