/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.temporal.Ancestors$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.HistoricEvent;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`Ancestors(seed:String, time:Long, delta:Long=Long.MaxValue, directed:Boolean=true)`\n  *  : find all ancestors of a vertex at a given time point\n  *\n  * The ancestors of a seed vertex are defined as those vertices which can reach the seed vertex via a temporal\n  * path (in a temporal path the time of the next edge is always later than the time of the previous edge) by the\n  * specified time.\n  *\n  * ## Parameters\n  *\n  *  {s}`seed: String`\n  *    : The name of the target vertex\n  *\n  *  {s}`time: Long`\n  *    : The time of interest\n  *\n  *  {s}`delta: Long = Long.MaxValue`\n  *    : The maximum timespan for the temporal path. This is currently exclusive of the oldest time\n  *       i.e. if looking back a minute it will not include events that happen exactly 1 minute ago.\n  *\n  *  {s}`directed: Boolean = true`\n  *    : whether to treat the network as directed\n  *\n  *  {s}`strict: Boolean = true`\n  *    : Whether lastActivityBefore is strict in its following of paths that happen exactly at the given time. True will not follow, False will.\n  *\n  * ## States\n  *\n  *  {s}`ancestor: Boolean`\n  *    : flag indicating that the vertex is an ancestor of {s}`seed`\n  *\n  * ## Returns\n  *\n  *  | vertex name       | is ancestor of seed?   |\n  *  | ----------------- | ---------------------- |\n  *  | {s}`name: String` | {s}`ancestor: Boolean` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\n\u0015\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!a\u0004A!A!\u0002\u0013I\u0004\"B\u001f\u0001\t\u0003q\u0004\"\u0002$\u0001\t\u0003:u!B4\u0015\u0011\u0003Ag!B\n\u0015\u0011\u0003I\u0007\"B\u001f\n\t\u0003)\b\"\u0002$\n\t\u00031\bb\u0002?\n#\u0003%\t! \u0005\n\u0003#I\u0011\u0013!C\u0001\u0003'A\u0011\"a\u0006\n#\u0003%\t!a\u0005\t\u0011\u0005e\u0011\"%A\u0005\u0002uD\u0011\"a\u0007\n#\u0003%\t!a\u0005\t\u0013\u0005u\u0011\"%A\u0005\u0002\u0005M\u0001\"CA\u0010\u0013\u0005\u0005I\u0011BA\u0011\u0005%\tenY3ti>\u00148O\u0003\u0002\u0016-\u0005AA/Z7q_J\fGN\u0003\u0002\u00181\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u0005eQ\u0012\u0001\u0003:ba\"$xN]=\u000b\u0003m\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u00052\u0012aB4f]\u0016\u0014\u0018nY\u0005\u0003G\u0001\u0012\u0001BT8eK2K7\u000f^\u0001\u0005g\u0016,G\r\u0005\u0002'_9\u0011q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0003Uq\ta\u0001\u0010:p_Rt$\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z\u0013A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!AL\u0016\u0002\tQLW.\u001a\t\u0003iUj\u0011aK\u0005\u0003m-\u0012A\u0001T8oO\u0006)A-\u001a7uC\u0006AA-\u001b:fGR,G\r\u0005\u00025u%\u00111h\u000b\u0002\b\u0005>|G.Z1o\u0003\u0019\u0019HO]5di\u00061A(\u001b8jiz\"baP!C\u0007\u0012+\u0005C\u0001!\u0001\u001b\u0005!\u0002\"\u0002\u0013\u0007\u0001\u0004)\u0003\"\u0002\u001a\u0007\u0001\u0004\u0019\u0004bB\u001c\u0007!\u0003\u0005\ra\r\u0005\bq\u0019\u0001\n\u00111\u0001:\u0011\u001dad\u0001%AA\u0002e\nQ!\u00199qYf$\"\u0001S&\u0011\u0005%;fB\u0001&L\u0019\u0001AQ\u0001T\u0004A\u00025\u000bQa\u001a:ba\"\u0004\"AT+\u000e\u0003=S!\u0001U)\u0002\u0013\u001d\u0014\u0018\r\u001d5wS\u0016<(B\u0001*T\u0003!\tg.\u00197zg&\u001c(B\u0001+\u0019\u0003\r\t\u0007/[\u0005\u0003->\u0013\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\n\u0005a+&!B$sCBD\u0007\u0006\u0002\u0001[I\u0016\u0004\"a\u00172\u000e\u0003qS!!\u00180\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!a\u00181\u0002\u000fQ\f7.\u001a>pK*\u0011\u0011MG\u0001\u0007O&$\b.\u001e2\n\u0005\rd&\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003\u0019\f!2V\u0018+U)\u0001\u0003E\u000b\u0011|gv\u0004\u0017I\\2fgR|'o\u001d\u0015tK\u0016$'h\u0015;sS:<G\u0006\t;j[\u0016TDj\u001c8hY\u0001\"W\r\u001c;bu1{gnZ\u001fM_:<g&T1y-\u0006dW/\u001a\u0017!I&\u0014Xm\u0019;fIj\u0012un\u001c7fC:lDO];fS\u0001T\u0001\u0005\t\u0016!Ai\u0002c-\u001b8eA\u0005dG\u000eI1oG\u0016\u001cHo\u001c:tA=4\u0007%\u0019\u0011wKJ$X\r\u001f\u0011bi\u0002\n\u0007eZ5wK:\u0004C/[7fAA|\u0017N\u001c;\u000bA\u0001R#\u0002\t\u0011+AQCW\rI1oG\u0016\u001cHo\u001c:tA=4\u0007%\u0019\u0011tK\u0016$\u0007E^3si\u0016D\b%\u0019:fA\u0011,g-\u001b8fI\u0002\n7\u000f\t;i_N,\u0007E^3si&\u001cWm\u001d\u0011xQ&\u001c\u0007\u000eI2b]\u0002\u0012X-Y2iAQDW\rI:fK\u0012\u0004c/\u001a:uKb\u0004c/[1!C\u0002\"X-\u001c9pe\u0006d'\u0002\t\u0011+AA\fG\u000f\u001b\u0011)S:\u0004\u0013\r\t;f[B|'/\u00197!a\u0006$\b\u000e\t;iK\u0002\"\u0018.\\3!_\u001a\u0004C\u000f[3!]\u0016DH\u000fI3eO\u0016\u0004\u0013n\u001d\u0011bY^\f\u0017p\u001d\u0011mCR,'\u000f\t;iC:\u0004C\u000f[3!i&lW\rI8gAQDW\r\t9sKZLw.^:!K\u0012<W-\u000b\u0011cs\u0002\"\b.\u001a\u0006!A)\u00023\u000f]3dS\u001aLW\r\u001a\u0011uS6,gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y:fK\u0012T\u0004e\u0015;sS:<\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!)\",\u0007E\\1nK\u0002zg\r\t;iK\u0002\"\u0018M]4fi\u00022XM\u001d;fq*\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~ARLW.\u001a\u001e!\u0019>tw\r\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;AQCW\r\t;j[\u0016\u0004sN\u001a\u0011j]R,'/Z:u\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?aI\u0016dG/\u0019\u001e!\u0019>tw\rI\u001f!\u0019>twML'bqZ\u000bG.^3a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002C\u000b[3![\u0006D\u0018.\\;nAQLW.Z:qC:\u0004cm\u001c:!i\",\u0007\u0005^3na>\u0014\u0018\r\u001c\u0011qCRDg\u0006\t+iSN\u0004\u0013n\u001d\u0011dkJ\u0014XM\u001c;ms\u0002*\u0007p\u00197vg&4X\rI8gAQDW\rI8mI\u0016\u001cH\u000f\t;j[\u0016T\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011j]\u0015t\u0003%\u001b4!Y>|7.\u001b8hA\t\f7m\u001b\u0011bA5Lg.\u001e;fA%$\be^5mY\u0002rw\u000e\u001e\u0011j]\u000edW\u000fZ3!KZ,g\u000e^:!i\"\fG\u000f\t5baB,g\u000eI3yC\u000e$H.\u001f\u00112A5Lg.\u001e;fA\u0005<wN\f\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00193je\u0016\u001cG/\u001a3;A\t{w\u000e\\3b]\u0002j\u0004\u0005\u001e:vK\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI<iKRDWM\u001d\u0011u_\u0002\"(/Z1uAQDW\r\t8fi^|'o\u001b\u0011bg\u0002\"\u0017N]3di\u0016$'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u00047\u000f\u001e:jGRT\u0004EQ8pY\u0016\fg\u000eI\u001f!iJ,X\r\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A]CW\r\u001e5fe\u0002b\u0017m\u001d;BGRLg/\u001b;z\u0005\u00164wN]3!SN\u00043\u000f\u001e:jGR\u0004\u0013N\u001c\u0011jiN\u0004cm\u001c7m_^Lgn\u001a\u0011pM\u0002\u0002\u0018\r\u001e5tAQD\u0017\r\u001e\u0011iCB\u0004XM\u001c\u0011fq\u0006\u001cG\u000f\\=!CR\u0004C\u000f[3!O&4XM\u001c\u0011uS6,g\u0006\t+sk\u0016\u0004s/\u001b7mA9|G\u000f\t4pY2|w\u000f\f\u0011GC2\u001cX\rI<jY2t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AM#\u0018\r^3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?aC:\u001cWm\u001d;pej\u0002#i\\8mK\u0006t\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!M2\fw\rI5oI&\u001c\u0017\r^5oO\u0002\"\b.\u0019;!i\",\u0007E^3si\u0016D\b%[:!C:\u0004\u0013M\\2fgR|'\u000fI8gAm\u001cX\u0010Y:fK\u0012\u0004'\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005 \u0011wKJ$X\r\u001f\u0011oC6,\u0007\u0005\t\u0011!A\u0001\u0002C\u0010I5tA\u0005t7-Z:u_J\u0004sN\u001a\u0011tK\u0016$w\b\t\u0011!y*\u0001\u0003E\u000b\u0011!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5\u0002CP\u0003\u0011!U\u0001\u0002C\u0010I>t{\u0002t\u0017-\\3;AM#(/\u001b8hA\u0002b\be_:~A\u0006t7-Z:u_JT\u0004EQ8pY\u0016\fg\u000e\u0019\u0011}\u0015\u0001\u0002#fL\u0001\n\u0003:\u001cWm\u001d;peN\u0004\"\u0001Q\u0005\u0014\u0007%QW\u000e\u0005\u00025W&\u0011An\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018AA5p\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003!$baP<ysj\\\b\"\u0002\u0013\f\u0001\u0004)\u0003\"\u0002\u001a\f\u0001\u0004\u0019\u0004bB\u001c\f!\u0003\u0005\ra\r\u0005\bq-\u0001\n\u00111\u0001:\u0011\u001da4\u0002%AA\u0002e\nq\"\u00199qYf$C-\u001a4bk2$HeM\u000b\u0002}*\u00121g`\u0016\u0003\u0003\u0003\u0001B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0005v]\u000eDWmY6fI*\u0019\u00111B\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0010\u0005\u0015!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0016)\u0012\u0011h`\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*E\fA\u0001\\1oO&!\u0011QFA\u0014\u0005\u0019y%M[3di\u0002")
public class Ancestors
extends NodeList {
    private final String seed;
    private final long time;
    private final long delta;
    private final boolean directed;
    private final boolean strict;

    public static boolean $lessinit$greater$default$5() {
        return Ancestors$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return Ancestors$.MODULE$.$lessinit$greater$default$4();
    }

    public static long $lessinit$greater$default$3() {
        return Ancestors$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean apply$default$5() {
        return Ancestors$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return Ancestors$.MODULE$.apply$default$4();
    }

    public static long apply$default$3() {
        return Ancestors$.MODULE$.apply$default$3();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        ConcreteGraphPerspective qual$1 = graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Ancestors.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)vertex -> {
            Ancestors.$anonfun$apply$3(this, vertex);
            return BoxedUnit.UNIT;
        };
        boolean x$2 = true;
        int x$3 = 100;
        return qual$1.iterate(x$1, 100, true);
    }

    public static final /* synthetic */ void $anonfun$apply$2(Ancestors $this, Vertex vertex$1, ConcreteEdge e) {
        Option<HistoricEvent> option = ((EntityVisitor)((Object)e)).lastActivityBefore($this.time, $this.strict);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            HistoricEvent event = (HistoricEvent)some.value();
            if (event.time() > $this.time - $this.delta) {
                vertex$1.messageVertex(e.ID(), BoxesRunTime.boxToLong((long)event.time()), SchemaProviderInstances$.MODULE$.longSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$1(Ancestors $this, Vertex vertex) {
        block0: {
            String string = vertex.name(vertex.name$default$1());
            String string2 = $this.seed;
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            ($this.directed ? vertex.inEdges() : vertex.edges()).foreach((Function1 & Serializable)e -> {
                Ancestors.$anonfun$apply$2($this, vertex, e);
                return BoxedUnit.UNIT;
            });
            ((EntityVisitor)((Object)vertex)).setState("ancestor", BoxesRunTime.boxToBoolean((boolean)false));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(Ancestors $this, Vertex vertex$2, ConcreteEdge e) {
        Option<HistoricEvent> option = ((EntityVisitor)((Object)e)).lastActivityBefore($this.time, $this.strict);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            HistoricEvent event = (HistoricEvent)some.value();
            if (event.time() > $this.time - $this.delta) {
                vertex$2.messageVertex(e.ID(), BoxesRunTime.boxToLong((long)event.time()), SchemaProviderInstances$.MODULE$.longSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$3(Ancestors $this, Vertex vertex) {
        long latestTime = BoxesRunTime.unboxToLong((Object)vertex.messageQueue().max((Ordering)Ordering.Long$.MODULE$));
        ((EntityVisitor)((Object)vertex)).setState("ancestor", BoxesRunTime.boxToBoolean((boolean)true));
        ($this.directed ? vertex.inEdges() : vertex.edges()).foreach((Function1 & Serializable)e -> {
            Ancestors.$anonfun$apply$4($this, vertex, e);
            return BoxedUnit.UNIT;
        });
    }

    public Ancestors(String seed, long time, long delta, boolean directed, boolean strict) {
        this.seed = seed;
        this.time = time;
        this.delta = delta;
        this.directed = directed;
        this.strict = strict;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ancestor"}))), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ancestor"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
    }
}

