/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.motif.ThreeNodeMotifs$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.Vertex;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  *  {s}`ThreeNodeMotifs()`\n  *    : Count occurrences of three-node motifs that a node participates in.\n  *\n  *  The algorithm works by first counting star motifs, including potential triangles.\n  *  Then, for each star we send a message to one of the neighbours to identify the potential third edge.\n  *  Based on the responses, we correct the star counts and count the triangles.\n  *\n  *  ```{note}\n  *  Stars are only counted once as they only appear in the counts for the central vertex. However, triangles\n  *  appear for each of the 3 vertices, so the count for triangles should be divided by 3 when aggregating results to get\n  *  motif counts for the whole graph.\n  *  ```\n  *\n  *  ## Motifs\n  *\n  *  ### Stars\n  *\n  *    - 0: l <- c -> r\n  *    - 1: l -> c <- r\n  *    - 2: l -> c -> r\n  *    - 3: l -> c <-> r\n  *    - 4: l <- c <-> r\n  *    - 5: l <-> c <-> r\n  *\n  *  ### Triangles\n  *\n  *  (Index of star + third edge)\n  *    - 6: 0 + l -> r\n  *    - 7: 2 + l <- r\n  *    - 8: 3 + l -> r\n  *    - 9: 4 + l -> r\n  *    - 10: 4 + l <- r\n  *    - 11: 5 + l -> r\n  *    - 12: 5 + l <-> r\n  *\n  * ## States\n  *  {s}`motifCounts: Array[Long]`\n  *    : Motif counts stored as an array (see indices above)\n  *\n  * ## Returns\n  *\n  *  | vertex name       | Motif 0                   | ... | Motif 12                   |\n  *  | ----------------- | ------------------------- | --- | -------------------------- |\n  *  | {s}`name: String` | {s}`motifCounts(0): Long` | ... | {s}`motifCounts(12): Long` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001ds!\u0002\f\u0018\u0011\u0003\u0011c!\u0002\u0013\u0018\u0011\u0003)\u0003\"\u0002\u001c\u0002\t\u00039\u0004b\u0002\u001d\u0002\u0005\u0004%\t!\u000f\u0005\u0007{\u0005\u0001\u000b\u0011\u0002\u001e\t\u000fy\n!\u0019!C\u0001s!1q(\u0001Q\u0001\niBq\u0001Q\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004B\u0003\u0001\u0006IA\u000f\u0005\b\u0005\u0006\u0011\r\u0011\"\u0001:\u0011\u0019\u0019\u0015\u0001)A\u0005u!9A)\u0001b\u0001\n\u0003)\u0005BB)\u0002A\u0003%a\tC\u0004S\u0003\t\u0007I\u0011A#\t\rM\u000b\u0001\u0015!\u0003G\u0011\u0015!\u0016\u0001\"\u0001V\u0011\u00151\u0017\u0001\"\u0011h\u0011\u001d!\u0018A1A\u0005\nUDq!a\u0001\u0002A\u0003%a\u000fC\u0004\u0002\u0006\u0005!\t%a\u0002\t\u000f\u0005]\u0011\u0001\"\u0003\u0002\u001a!I\u0011qD\u0001\u0002\u0002\u0013%\u0011\u0011E\u0001\u0010)\"\u0014X-\u001a(pI\u0016lu\u000e^5gg*\u0011\u0001$G\u0001\u0006[>$\u0018N\u001a\u0006\u00035m\tqaZ3oKJL7M\u0003\u0002\u001d;\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u0005yy\u0012\u0001\u0003:ba\"$xN]=\u000b\u0003\u0001\n1aY8n\u0007\u0001\u0001\"aI\u0001\u000e\u0003]\u0011q\u0002\u00165sK\u0016tu\u000eZ3N_RLgm]\n\u0004\u0003\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002.i5\taF\u0003\u00020a\u0005I\u0011\r\\4pe&$\b.\u001c\u0006\u0003cI\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003gu\t1!\u00199j\u0013\t)dFA\u0004HK:,'/[2\u0002\rqJg.\u001b;?)\u0005\u0011\u0013!C5o_V$X\tZ4f+\u0005Q\u0004CA\u0014<\u0013\ta\u0004FA\u0002J]R\f!\"\u001b8pkR,EmZ3!\u0003\u001dyW\u000f^#eO\u0016\f\u0001b\\;u\u000b\u0012<W\rI\u0001\u0007S:,EmZ3\u0002\u000f%tW\tZ4fA\u00051an\\#eO\u0016\fqA\\8FI\u001e,\u0007%\u0001\bti\u0006\u0014Xj\u001c;jM&sG-\u001a=\u0016\u0003\u0019\u0003Ba\u0012'Ou5\t\u0001J\u0003\u0002J\u0015\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u0017\"\n!bY8mY\u0016\u001cG/[8o\u0013\ti\u0005JA\u0002NCB\u0004BaJ(;u%\u0011\u0001\u000b\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001fM$\u0018M]'pi&4\u0017J\u001c3fq\u0002\n!\u0003\u001e:jC:<G.Z'pi&4\u0017J\u001c3fq\u0006\u0019BO]5b]\u001edW-T8uS\u001aLe\u000eZ3yA\u0005aqlZ3u\u000b\u0012<W\rV=qKR\u0011a\u000b\u0018\t\u0005O]K&(\u0003\u0002YQ\tIa)\u001e8di&|g.\r\t\u00035\u0012t!a\u0017/\r\u0001!)Ql\u0004a\u0001=\u00061a/\u001a:uKb\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\u0019\u0002\u000fYL7/\u001b;pe&\u00111\r\u0019\u0002\u0007-\u0016\u0014H/\u001a=\n\u0005\u0015\u0014'AB%E)f\u0004X-A\u0003baBd\u0017\u0010\u0006\u0002iUB\u0011\u0011N\u001d\b\u00037*DQa\u001b\tA\u00021\fQa\u001a:ba\"\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0019\u0002\u0013\u001d\u0014\u0018\r\u001d5wS\u0016<\u0018BA9o\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4X-\u0003\u0002ta\n)qI]1qQ\u000691m\u001c7v[:\u001cX#\u0001<\u0011\u0007\u001d;\u00180\u0003\u0002y\u0011\n\u00191+Z9\u0011\u0005i|X\"A>\u000b\u0005ql\u0018\u0001\u00027b]\u001eT\u0011A`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0002m\u0014aa\u0015;sS:<\u0017\u0001C2pYVlgn\u001d\u0011\u0002\u0015Q\f'-\u001e7be&\u001cX\r\u0006\u0003\u0002\n\u0005U\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=\u0001'A\u0003uC\ndW-\u0003\u0003\u0002\u0014\u00055!!\u0002+bE2,\u0007\"B6\u0014\u0001\u0004a\u0017\u0001E7pi&47i\\;oi\u000e{G.^7o)\rI\u00181\u0004\u0005\u0007\u0003;!\u0002\u0019\u0001\u001e\u0002\u000b%tG-\u001a=\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\r\u0002c\u0001>\u0002&%\u0019\u0011qE>\u0003\r=\u0013'.Z2uQ\u001d\t\u00111FA \u0003\u0003\u0002B!!\f\u0002<5\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\t)$a\u000e\u0002\u000fQ\f7.\u001a>pK*\u0019\u0011\u0011H\u0010\u0002\r\u001dLG\u000f[;c\u0013\u0011\ti$a\f\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!a\u0011\u0002\u0017'|#F\u000b\u0006!A)\u0002\u0003e_:~ARC'/Z3O_\u0012,Wj\u001c;jMND\u0013\u0006\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A\r{WO\u001c;!_\u000e\u001cWO\u001d:f]\u000e,7\u000fI8gAQD'/Z3.]>$W\rI7pi&47\u000f\t;iCR\u0004\u0013\r\t8pI\u0016\u0004\u0003/\u0019:uS\u000eL\u0007/\u0019;fg\u0002JgN\f\u0006!A)R\u0001\u0005\t\u0016!AQCW\rI1mO>\u0014\u0018\u000e\u001e5nA]|'o[:!Ef\u0004c-\u001b:ti\u0002\u001aw.\u001e8uS:<\u0007e\u001d;be\u0002jw\u000e^5gg2\u0002\u0013N\\2mk\u0012Lgn\u001a\u0011q_R,g\u000e^5bY\u0002\"(/[1oO2,7O\f\u0006!A)\u0002\u0003\u0005\u00165f]2\u0002cm\u001c:!K\u0006\u001c\u0007\u000eI:uCJ\u0004s/\u001a\u0011tK:$\u0007%\u0019\u0011nKN\u001c\u0018mZ3!i>\u0004sN\\3!_\u001a\u0004C\u000f[3!]\u0016Lw\r\u001b2pkJ\u001c\b\u0005^8!S\u0012,g\u000e^5gs\u0002\"\b.\u001a\u0011q_R,g\u000e^5bY\u0002\"\b.\u001b:eA\u0015$w-\u001a\u0018\u000bA\u0001R\u0003\u0005\t\"bg\u0016$\u0007e\u001c8!i\",\u0007E]3ta>t7/Z:-A],\u0007eY8se\u0016\u001cG\u000f\t;iK\u0002\u001aH/\u0019:!G>,h\u000e^:!C:$\u0007eY8v]R\u0004C\u000f[3!iJL\u0017M\\4mKNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011aA\u0002\\hn\u001c;f{*\u0001\u0003E\u000b\u0011!'R\f'o\u001d\u0011be\u0016\u0004sN\u001c7zA\r|WO\u001c;fI\u0002zgnY3!CN\u0004C\u000f[3zA=tG.\u001f\u0011baB,\u0017M\u001d\u0011j]\u0002\"\b.\u001a\u0011d_VtGo\u001d\u0011g_J\u0004C\u000f[3!G\u0016tGO]1mAY,'\u000f^3y]\u0001Bun^3wKJd\u0003\u0005\u001e:jC:<G.Z:\u000bA\u0001R\u0003\u0005I1qa\u0016\f'\u000f\t4pe\u0002*\u0017m\u00195!_\u001a\u0004C\u000f[3!g\u00012XM\u001d;jG\u0016\u001cH\u0006I:pAQDW\rI2pk:$\bEZ8sAQ\u0014\u0018.\u00198hY\u0016\u001c\be\u001d5pk2$\u0007EY3!I&4\u0018\u000eZ3eA\tL\be\r\u0011xQ\u0016t\u0007%Y4he\u0016<\u0017\r^5oO\u0002\u0012Xm];miN\u0004Co\u001c\u0011hKRT\u0001\u0005\t\u0016!A5|G/\u001b4!G>,h\u000e^:!M>\u0014\b\u0005\u001e5fA]Dw\u000e\\3!OJ\f\u0007\u000f\u001b\u0018\u000bA\u0001R\u0003\u0005\t1aA*\u0001\u0003E\u000b\u0006!A)\u0002\u0003eI\u0012!\u001b>$\u0018NZ:\u000bA\u0001R#\u0002\t\u0011+A\u0001\u001a3e\t\u0011Ti\u0006\u00148O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!A\u0001j\u0003\u0005\r\u001e!Y\u0002bT\u0006I2![y\u0002#O\u0003\u0011!U\u0001\u0002\u0003\u0005I\u0017!ci\u0002C\u000eI\u0017?A\r\u0004C(\f\u0011s\u0015\u0001\u0002#\u0006\t\u0011!A5\u0002#G\u000f\u0011mA5r\u0004e\u0019\u0011.}\u0001\u0012(\u0002\t\u0011+A\u0001\u0002\u0003%\f\u00114u\u0001b\u0007%\f !G\u0002bTF\u0010\u0011s\u0015\u0001\u0002#\u0006\t\u0011!A5\u0002CG\u000f\u0011mAqj\u0003e\u0019\u0011=[y\u0002#O\u0003\u0011!U\u0001\u0002\u0003\u0005I\u0017!ki\u0002C\u000e\t\u001f.}\u0001\u001a\u0007\u0005P\u0017?AIT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I\u0012$G\u0001\"&/[1oO2,7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!Q%sG-\u001a=!_\u001a\u00043\u000f^1sA-\u0002C\u000f[5sI\u0002*GmZ3*\u0015\u0001\u0002#\u0006\t\u0011!A5\u0002cG\u000f\u00111A-\u0002C\u000eI\u0017?AIT\u0001\u0005\t\u0016!A\u0001\u0002S\u0006I\u001c;AI\u00023\u0006\t7!y5\u0002#O\u0003\u0011!U\u0001\u0002\u0003\u0005I\u0017!qi\u00023\u0007I\u0016!Y\u0002jc\b\t:\u000bA\u0001R\u0003\u0005\t\u0011![\u0001J$\b\t\u001b!W\u0001b\u0007%\f !e*\u0001\u0003E\u000b\u0011!A\u0001j\u0003%\r\u0019;AQ\u00023\u0006\t7!y5\u0002#O\u0003\u0011!U\u0001\u0002\u0003\u0005I\u0017!cER\u0004%\u000e\u0011,A1\u0004SF\u0010\u0011s\u0015\u0001\u0002#\u0006\t\u0011!A5\u0002\u0013G\r\u001e!k\u0001Z\u0003\u0005\u001c\u0011=[y\u0002#O\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u001aF/\u0019;fg*\u0001\u0003E\u000b\u0011!wNl\b-\\8uS\u001a\u001cu.\u001e8ugj\u0002\u0013I\u001d:bsncuN\\4^A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004%T8uS\u001a\u00043m\\;oiN\u00043\u000f^8sK\u0012\u0004\u0013m\u001d\u0011b]\u0002\n'O]1zA!\u001aX-\u001a\u0011j]\u0012L7-Z:!C\n|g/Z\u0015\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003EU3ukJt7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!y\u00022XM\u001d;fq\u0002r\u0017-\\3!A\u0001\u0002\u0003\u0005\t\u0011}A5{G/\u001b4!a\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011}A9rc\u0006\t?!\u001b>$\u0018N\u001a\u00112e\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011}\u0015\u0001\u0002#\u0006\t\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?\u000bA\u0001R\u0003\u0005\t?!wNl\bM\\1nKj\u00023\u000b\u001e:j]\u001e\u0004\u0007\u0005 \u0011|gv\u0004Wn\u001c;jM\u000e{WO\u001c;tQAJ#\b\t'p]\u001e\u0004\u0007\u0005 \u0011/]9\u0002C\u0010I>t{\u0002lw\u000e^5g\u0007>,h\u000e^:)cIJ#\b\t'p]\u001e\u0004\u0007\u0005 \u0006!A)z\u0003f\u0002\u0001\u0002,\u0005}\u0012\u0011\t")
public final class ThreeNodeMotifs {
    public static Table tabularise(GraphPerspective graph) {
        return ThreeNodeMotifs$.MODULE$.tabularise(graph);
    }

    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return ThreeNodeMotifs$.MODULE$.apply(graph);
    }

    public static Function1<Object, Object> _getEdgeType(Vertex vertex) {
        return ThreeNodeMotifs$.MODULE$._getEdgeType(vertex);
    }

    public static Map<Tuple2<Object, Object>, Object> triangleMotifIndex() {
        return ThreeNodeMotifs$.MODULE$.triangleMotifIndex();
    }

    public static Map<Tuple2<Object, Object>, Object> starMotifIndex() {
        return ThreeNodeMotifs$.MODULE$.starMotifIndex();
    }

    public static int noEdge() {
        return ThreeNodeMotifs$.MODULE$.noEdge();
    }

    public static int inEdge() {
        return ThreeNodeMotifs$.MODULE$.inEdge();
    }

    public static int outEdge() {
        return ThreeNodeMotifs$.MODULE$.outEdge();
    }

    public static int inoutEdge() {
        return ThreeNodeMotifs$.MODULE$.inoutEdge();
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return ThreeNodeMotifs$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return ThreeNodeMotifs$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return ThreeNodeMotifs$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return ThreeNodeMotifs$.MODULE$.name();
    }

    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public static Table run(GraphPerspective graph) {
        return ThreeNodeMotifs$.MODULE$.run(graph);
    }
}

