/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.motif.LocalClusteringCoefficient$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`LocalClusteringCoefficient()`\n  *  : Returns the local clustering coefficient for each vertex.\n  *\n  * The clustering coefficient is the number of triangles of that vertex as\n  *    a proportion of the total possible triangles of that vertex\n  *\n  * ## States\n  *\n  *  {s}`clustering: Double`\n  *    : local clustering coefficient\n  *\n  * ## Returns\n  *\n  *  | vertex name       | clustering               |\n  *  | ----------------- | ------------------------ |\n  *  | {s}`name: String` | {s}`clustering: Double`  |\n  *\n  * ```{note}\n  *  Edges here are treated as undirected, so if the underlying network is directed here,\n  * 'neighbours' refers to the union of in-neighbours and out-neighbours.\n  * ``\n  */")
@ScalaSignature(bytes="\u0006\u0005\u001d;Q!\u0002\u0004\t\u0002E1Qa\u0005\u0004\t\u0002QAQ!G\u0001\u0005\u0002iAQaG\u0001\u0005BqAqAL\u0001\u0002\u0002\u0013%q&\u0001\u000eM_\u000e\fGn\u00117vgR,'/\u001b8h\u0007>,gMZ5dS\u0016tGO\u0003\u0002\b\u0011\u0005)Qn\u001c;jM*\u0011\u0011BC\u0001\bO\u0016tWM]5d\u0015\tYA\"\u0001\u0006bY\u001e|'/\u001b;i[NT!!\u0004\b\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011aD\u0001\u0004G>l7\u0001\u0001\t\u0003%\u0005i\u0011A\u0002\u0002\u001b\u0019>\u001c\u0017\r\\\"mkN$XM]5oO\u000e{WM\u001a4jG&,g\u000e^\n\u0003\u0003U\u0001\"AF\f\u000e\u0003!I!\u0001\u0007\u0005\u0003\u00119{G-\u001a'jgR\fa\u0001P5oSRtD#A\t\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005u\u0001\u0003C\u0001\u0010-\u001d\ty\u0002\u0005\u0004\u0001\t\u000b\u0005\u001a\u0001\u0019\u0001\u0012\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013!C4sCBDg/[3x\u0015\t9\u0003&\u0001\u0005b]\u0006d\u0017p]5t\u0015\tIC\"A\u0002ba&L!a\u000b\u0013\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017BA\u0017+\u0005\u00159%/\u00199i\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005\u0001\u0004CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0011a\u0017M\\4\u000b\u0003U\nAA[1wC&\u0011qG\r\u0002\u0007\u001f\nTWm\u0019;)\t\u0005I4\t\u0012\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\n\u0001b]2bY\u0006$wn\u0019\u0006\u0003}}\nq\u0001^1lKj|WM\u0003\u0002A\u001d\u00051q-\u001b;ik\nL!AQ\u001e\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013!R\u0001\u0006$>R#F\u0003\u0011!U\u0001Z8/ 1M_\u000e\fGn\u00117vgR,'/\u001b8h\u0007>,gMZ5dS\u0016tG\u000fK\u0015a\u0015\u0001\u0002#\u0006\t\u0011;AI+G/\u001e:og\u0002\"\b.\u001a\u0011m_\u000e\fG\u000eI2mkN$XM]5oO\u0002\u001aw.\u001a4gS\u000eLWM\u001c;!M>\u0014\b%Z1dQ\u00022XM\u001d;fq:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00165fA\rdWo\u001d;fe&tw\rI2pK\u001a4\u0017nY5f]R\u0004\u0013n\u001d\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011ue&\fgn\u001a7fg\u0002zg\r\t;iCR\u0004c/\u001a:uKb\u0004\u0013m\u001d\u0006!A)\u0002\u0003\u0005\t\u0011bAA\u0014x\u000e]8si&|g\u000eI8gAQDW\r\t;pi\u0006d\u0007\u0005]8tg&\u0014G.\u001a\u0011ue&\fgn\u001a7fg\u0002zg\r\t;iCR\u0004c/\u001a:uKbT\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1dYV\u001cH/\u001a:j]\u001eT\u0004\u0005R8vE2,\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!Y>\u001c\u0017\r\u001c\u0011dYV\u001cH/\u001a:j]\u001e\u00043m\\3gM&\u001c\u0017.\u001a8u\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t*fiV\u0014hn\u001d\u0006!A)R\u0001\u0005\t\u0016!Aq\u0004c/\u001a:uKb\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!y\u0002\u001aG.^:uKJLgn\u001a\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011}\u0015\u0001\u0002#\u0006\t\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010I>t{\u0002\u001cG.^:uKJLgn\u001a\u001e!\t>,(\r\\3aA\u0001b(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t1aAntw\u000e^3~\u0015\u0001\u0002#\u0006\t\u0011FI\u001e,7\u000f\t5fe\u0016\u0004\u0013M]3!iJ,\u0017\r^3eA\u0005\u001c\b%\u001e8eSJ,7\r^3eY\u0001\u001ax\u000eI5gAQDW\rI;oI\u0016\u0014H._5oO\u0002rW\r^<pe.\u0004\u0013n\u001d\u0011eSJ,7\r^3eA!,'/\u001a\u0017\u000bA\u0001R\u0003e\n8fS\u001eD'm\\;sg\u001e\u0002#/\u001a4feN\u0004Co\u001c\u0011uQ\u0016\u0004SO\\5p]\u0002zg\rI5o[9,\u0017n\u001a5c_V\u00148\u000fI1oI\u0002zW\u000f^\u0017oK&<\u0007NY8veNt#\u0002\t\u0011+A\u0001\u0004'\u0002\t\u0011+_!\"\u0001!O\"E\u0001")
public final class LocalClusteringCoefficient {
    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return LocalClusteringCoefficient$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return LocalClusteringCoefficient$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return LocalClusteringCoefficient$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return LocalClusteringCoefficient$.MODULE$.$minus$greater(other);
    }

    public static Table tabularise(GraphPerspective graph) {
        return LocalClusteringCoefficient$.MODULE$.tabularise(graph);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return LocalClusteringCoefficient$.MODULE$.name();
    }

    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public static Table run(GraphPerspective graph) {
        return LocalClusteringCoefficient$.MODULE$.run(graph);
    }
}

