/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.motif.LocalTriangleCount$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`LocalClusteringCoefficient()`\n  *  : Returns the local clustering coefficient for each vertex.\n  *\n  * The clustering coefficient is the number of triangles of that vertex as\n  *    a proportion of the total possible triangles of that vertex\n  *\n  * ## States\n  *\n  *  {s}`clustering: Double`\n  *    : local clustering coefficient\n  *\n  * ## Returns\n  *\n  *  | vertex name       | clustering               |\n  *  | ----------------- | ------------------------ |\n  *  | {s}`name: String` | {s}`clustering: Double`  |\n  *\n  * ```{note}\n  *  Edges here are treated as undirected, so if the underlying network is directed here,\n  * 'neighbours' refers to the union of in-neighbours and out-neighbours.\n  * ``\n  */")
public final class LocalClusteringCoefficient$
extends NodeList {
    public static final LocalClusteringCoefficient$ MODULE$ = new LocalClusteringCoefficient$();

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return LocalTriangleCount$.MODULE$.apply(graph).step((Function1 & Serializable)vertex -> {
            LocalClusteringCoefficient$.$anonfun$apply$1(vertex);
            return BoxedUnit.UNIT;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LocalClusteringCoefficient$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$1(Vertex vertex) {
        int tC = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("triangles", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        int k = vertex.degree();
        ((EntityVisitor)((Object)vertex)).setState("clustering", k > 1 ? BoxesRunTime.boxToDouble((double)(2.0 * (double)tC / (double)(k * (k - 1)))) : BoxesRunTime.boxToDouble((double)0.0));
    }

    private LocalClusteringCoefficient$() {
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"clustering"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

