/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.GraphState;
import com.raphtory.algorithms.generic.GraphState$;
import com.raphtory.algorithms.generic.motif.LocalTriangleCount$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`GlobalTriangleCount()`\n  *  : Returns the total number of undirected triangles in the graph.\n  *\n  * ## States\n  *\n  *  {s}`triangleCount: Int`\n  *    : the number of triangles in the graph (treated as undirected and simple).\n  *\n  * ## Returns\n  *\n  *  | total triangles          |\n  *  | ------------------------ |\n  *  | {s}`triangleCount: Int`  |\n  *\n  * ```{note}\n  *  Edges here are treated as undirected, so if the underlying network is directed here,\n  * 'neighbours' refers to the union of in-neighbours and out-neighbours.\n  * ``\n  */")
public final class GlobalTriangleCount$
extends GraphState {
    public static final GlobalTriangleCount$ MODULE$ = new GlobalTriangleCount$();

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return LocalTriangleCount$.MODULE$.apply(graph).setGlobalState((Function1<com.raphtory.api.analysis.graphstate.GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            state.newAdder("triangles", true, Numeric.IntIsIntegral$.MODULE$);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            GlobalTriangleCount$.$anonfun$apply$2(vertex, state);
            return BoxedUnit.UNIT;
        }).setGlobalState((Function1<com.raphtory.api.analysis.graphstate.GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            state.newConstant("triangleCount", BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(state.apply("triangles").value()) / 3)));
            return BoxedUnit.UNIT;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GlobalTriangleCount$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex, com.raphtory.api.analysis.graphstate.GraphState state) {
        int tri = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("triangleCount", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        state.apply("triangles").$plus$eq$mcI$sp(tri);
    }

    private GlobalTriangleCount$() {
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"triangleCount"}))), GraphState$.MODULE$.$lessinit$greater$default$2());
    }
}

