/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.motif.GlobalTriangleCount$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`GlobalClusteringCoefficient()`\n  *  : Returns the two graph-wide clustering coefficients.\n  *\n  *  The first of these is the average clustering\n  *  coefficient, the mean of all node local clustering coefficients. The second of these is the transitivity\n  *  which is 3 times the number of triangles divided by the number of wedges, representing the probability that\n  *  a randomly chosen wedge is closed as a triangle.\n  *\n  * ## Returns\n  *\n  *  | average clustering       | transitivity               |\n  *  | ------------------------ | -------------------------- |\n  *  | {s}`avgCluster: Double`  | {s}`transitivity: Double`  |\n  *\n  * ```{note}\n  *  Edges here are treated as undirected, so if the underlying network is directed here,\n  * 'neighbours' refers to the union of in-neighbours and out-neighbours.\n  * ``\n  */")
public final class GlobalClusteringCoefficient$
implements Generic {
    public static final GlobalClusteringCoefficient$ MODULE$ = new GlobalClusteringCoefficient$();
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private static Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    static {
        BaseAlgorithm.$init$(MODULE$);
        Generic.$init$(MODULE$);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return GlobalTriangleCount$.MODULE$.apply(graph).setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            GlobalClusteringCoefficient$.$anonfun$apply$1(state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            GlobalClusteringCoefficient$.$anonfun$apply$2(vertex, state);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            GlobalClusteringCoefficient$.$anonfun$tabularise$1(state);
            return BoxedUnit.UNIT;
        }).globalSelect((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"averageCluster", "globalCluster"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GlobalClusteringCoefficient$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$1(GraphState state) {
        state.newAdder("wedges", true, Numeric.IntIsIntegral$.MODULE$);
        state.newAdder("totalClustering", BoxesRunTime.boxToDouble((double)0.0), true, Numeric.DoubleIsFractional$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex, GraphState state) {
        int k = vertex.degree();
        state.apply("totalClustering").$plus$eq(k > 1 ? BoxesRunTime.boxToDouble((double)(2.0 * (double)BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("triangleCount", ((EntityVisitor)((Object)vertex)).getState$default$2())) / (double)(k * (k - 1)))) : BoxesRunTime.boxToDouble((double)0.0));
        state.apply("wedges").$plus$eq$mcI$sp(k * (k - 1) / 2);
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(GraphState state) {
        double avgCluster = state.nodeCount() > 0 ? BoxesRunTime.unboxToDouble(state.apply("totalClustering").value()) / (double)state.nodeCount() : 0.0;
        double globalCluster = BoxesRunTime.unboxToInt(state.apply("wedges").value()) > 0 ? (double)(BoxesRunTime.unboxToInt(state.apply("triangles").value()) / BoxesRunTime.unboxToInt(state.apply("wedges").value())) : 0.0;
        state.newConstant("averageCluster", BoxesRunTime.boxToDouble((double)avgCluster));
        state.newConstant("globalCluster", BoxesRunTime.boxToDouble((double)globalCluster));
    }

    private GlobalClusteringCoefficient$() {
    }
}

