/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.centrality.WeightedPageRank$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`WeightedPageRank(dampingFactor:Double = 0.85, iterateSteps:Int = 100, weightProperty = \"weight\")`\n  *  : Compute PageRank for all nodes, treating the network as weighted\n  *\n  * Page Rank algorithm ranks nodes depending on their connections to determine how important\n  * the node is. This assumes a node is more important if it receives more connections from others.\n  * Each vertex begins with an initial state. If it has any neighbours, it sends them a message\n  * which is the inital label / the number of neighbours.\n  * Each vertex, checks its messages and computes a new label based on: the total value of\n  * messages received and the damping factor. This new value is propogated to all outgoing neighbours.\n  * A vertex will stop propogating messages if its value becomes stagnant (i.e. has a change of less\n  * than 0.00001) This process is repeated for a number of iterate step times. Most algorithms should\n  * converge after approx. 20 iterations.\n  *\n  * ## Parameters\n  *\n  *  {s}`dampingFactor: Double = 0.85`\n  *    : Probability that a node will be randomly selected by a user traversing the graph, defaults to 0.85.\n  *\n  *  {s}`iterateSteps: Int = 100`\n  *    : Maximum number of iterations for the algorithm to run.\n  *\n  *  {s}`weightProperty: String = \"weight\"`\n  *    : the property (if any) containing a numerical weight value for each edge, defaults to \"weight\".\n  *\n  *  ```{note}\n  *  If the weight property is not found, weight is treated as the number of edge occurrences.\n  *  ```\n  *\n  * ## States\n  *\n  *  {s}`prlabel: Double`\n  *    : PageRank of the node\n  *\n  * ## Returns\n  *\n  *  | vertex name       | PageRank             |\n  *  | ----------------- | -------------------- |\n  *  | {s}`name: String` | {s}`prlabel: Double` |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.centrality.PageRank)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\n\u0014\u0001yA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005<\u0001\t\u0005\t\u0015a\u0003=\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015I\u0006\u0001\"\u0011[\u000f\u0015I8\u0003#\u0001{\r\u0015\u00112\u0003#\u0001|\u0011\u0019\u0001\u0006\u0002\"\u0001\u0002\u0010!1\u0011\f\u0003C\u0001\u0003#A\u0011\"!\u000b\t#\u0003%\t!a\u000b\t\u0013\u0005\u0015\u0003\"%A\u0005\u0002\u0005\u001d\u0003\"CA(\u0011E\u0005I\u0011AA)\u0011%\tI\u0006CI\u0001\n\u0003\tY\u0006C\u0005\u0002`!\t\n\u0011\"\u0001\u0002b!I\u0011Q\r\u0005\u0012\u0002\u0013\u0005\u0011q\r\u0005\n\u0003WB\u0011\u0011!C\u0005\u0003[\u0012\u0001cV3jO\"$X\r\u001a)bO\u0016\u0014\u0016M\\6\u000b\u0005Q)\u0012AC2f]R\u0014\u0018\r\\5us*\u0011acF\u0001\bO\u0016tWM]5d\u0015\tA\u0012$\u0001\u0006bY\u001e|'/\u001b;i[NT!AG\u000e\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011\u0001H\u0001\u0004G>l7\u0001A\u000b\u0003?\u001d\u001b\"\u0001\u0001\u0011\u0011\u0005\u0005\u0012S\"A\u000b\n\u0005\r*\"\u0001\u0003(pI\u0016d\u0015n\u001d;\u0002\u001b\u0011\fW\u000e]5oO\u001a\u000b7\r^8s!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019!u.\u001e2mK\u0006a\u0011\u000e^3sCR,7\u000b^3qgB\u0011a%L\u0005\u0003]\u001d\u00121!\u00138u\u000399X-[4iiB\u0013x\u000e]3sif\u0004\"!\r\u001d\u000f\u0005I2\u0004CA\u001a(\u001b\u0005!$BA\u001b\u001e\u0003\u0019a$o\\8u}%\u0011qgJ\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028O\u00059a.^7fe&\u001c\u0007cA\u001fC\u000b:\u0011a\b\u0011\b\u0003g}J\u0011\u0001K\u0005\u0003\u0003\u001e\nq\u0001]1dW\u0006<W-\u0003\u0002D\t\n9a*^7fe&\u001c'BA!(!\t1u\t\u0004\u0001\u0005\u000b!\u0003!\u0019A%\u0003\u0003Q\u000b\"AS'\u0011\u0005\u0019Z\u0015B\u0001'(\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\n(\n\u0005=;#aA!os\u00061A(\u001b8jiz\"BA\u0015,X1R\u00111+\u0016\t\u0004)\u0002)U\"A\n\t\u000bm*\u00019\u0001\u001f\t\u000f\u0011*\u0001\u0013!a\u0001K!91&\u0002I\u0001\u0002\u0004a\u0003bB\u0018\u0006!\u0003\u0005\r\u0001M\u0001\u0006CB\u0004H.\u001f\u000b\u00037v\u0003\"\u0001X5\u000f\u0005\u0019k\u0006\"\u00020\u0007\u0001\u0004y\u0016!B4sCBD\u0007C\u00011h\u001b\u0005\t'B\u00012d\u0003%9'/\u00199im&,wO\u0003\u0002eK\u0006A\u0011M\\1msNL7O\u0003\u0002g3\u0005\u0019\u0011\r]5\n\u0005!\f'\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0013\tQwMA\u0003He\u0006\u0004\b\u000e\u000b\u0003\u0001YZ<\bCA7u\u001b\u0005q'BA8q\u0003!\u00198-\u00197bI>\u001c'BA9s\u0003\u001d!\u0018m[3{_\u0016T!a]\u000e\u0002\r\u001dLG\u000f[;c\u0013\t)hN\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\u0005A\u0018A$'0U)R\u0001\u0005\t\u0016!wNl\bmV3jO\"$X\r\u001a)bO\u0016\u0014\u0016M\\6)I\u0006l\u0007/\u001b8h\r\u0006\u001cGo\u001c:;\t>,(\r\\3!{\u0001\u0002d\u0006O\u001b-A%$XM]1uKN#X\r]:;\u0013:$\b%\u0010\u00112aAb\u0003e^3jO\"$\bK]8qKJ$\u0018\u0010I\u001f!E],\u0017n\u001a5uE%\u0002'\u0002\t\u0011+A\u0001R\u0004eQ8naV$X\r\t)bO\u0016\u0014\u0016M\\6!M>\u0014\b%\u00197mA9|G-Z:-AQ\u0014X-\u0019;j]\u001e\u0004C\u000f[3!]\u0016$xo\u001c:lA\u0005\u001c\be^3jO\"$X\r\u001a\u0006!A)R\u0001\u0005\t\u0016!!\u0006<W\r\t*b].\u0004\u0013\r\\4pe&$\b.\u001c\u0011sC:\\7\u000f\t8pI\u0016\u001c\b\u0005Z3qK:$\u0017N\\4!_:\u0004C\u000f[3je\u0002\u001awN\u001c8fGRLwN\\:!i>\u0004C-\u001a;fe6Lg.\u001a\u0011i_^\u0004\u0013.\u001c9peR\fg\u000e\u001e\u0006!A)\u0002C\u000f[3!]>$W\rI5t]\u0001\"\u0006.[:!CN\u001cX/\\3tA\u0005\u0004cn\u001c3fA%\u001c\b%\\8sK\u0002JW\u000e]8si\u0006tG\u000fI5gA%$\bE]3dK&4Xm\u001d\u0011n_J,\u0007eY8o]\u0016\u001cG/[8og\u00022'o\\7!_RDWM]:/\u0015\u0001\u0002#\u0006I#bG\"\u0004c/\u001a:uKb\u0004#-Z4j]N\u0004s/\u001b;iA\u0005t\u0007%\u001b8ji&\fG\u000eI:uCR,g\u0006I%gA%$\b\u0005[1tA\u0005t\u0017\u0010\t8fS\u001eD'm\\;sg2\u0002\u0013\u000e\u001e\u0011tK:$7\u000f\t;iK6\u0004\u0013\rI7fgN\fw-\u001a\u0006!A)\u0002s\u000f[5dQ\u0002J7\u000f\t;iK\u0002Jg.\u001b;bY\u0002b\u0017MY3mA=\u0002C\u000f[3!]Vl'-\u001a:!_\u001a\u0004c.Z5hQ\n|WO]:/\u0015\u0001\u0002#\u0006I#bG\"\u0004c/\u001a:uKbd\u0003e\u00195fG.\u001c\b%\u001b;tA5,7o]1hKN\u0004\u0013M\u001c3!G>l\u0007/\u001e;fg\u0002\n\u0007E\\3xA1\f'-\u001a7!E\u0006\u001cX\r\u001a\u0011p]j\u0002C\u000f[3!i>$\u0018\r\u001c\u0011wC2,X\rI8g\u0015\u0001\u0002#\u0006I7fgN\fw-Z:!e\u0016\u001cW-\u001b<fI\u0002\ng\u000e\u001a\u0011uQ\u0016\u0004C-Y7qS:<\u0007EZ1di>\u0014h\u0006\t+iSN\u0004c.Z<!m\u0006dW/\u001a\u0011jg\u0002\u0002(o\u001c9pO\u0006$X\r\u001a\u0011u_\u0002\nG\u000e\u001c\u0011pkR<w.\u001b8hA9,\u0017n\u001a5c_V\u00148O\f\u0006!A)\u0002\u0013\t\t<feR,\u0007\u0010I<jY2\u00043\u000f^8qAA\u0014x\u000e]8hCRLgn\u001a\u0011nKN\u001c\u0018mZ3tA%4\u0007%\u001b;tAY\fG.^3!E\u0016\u001cw.\\3tAM$\u0018m\u001a8b]R\u0004\u0003&\u001b\u0018f]\u0001B\u0017m\u001d\u0011bA\rD\u0017M\\4fA=4\u0007\u0005\\3tg*\u0001\u0003E\u000b\u0011uQ\u0006t\u0007\u0005\r\u00181aA\u0002\u0014'\u000b\u0011UQ&\u001c\b\u0005\u001d:pG\u0016\u001c8\u000fI5tAI,\u0007/Z1uK\u0012\u0004cm\u001c:!C\u0002rW/\u001c2fe\u0002zg\rI5uKJ\fG/\u001a\u0011ti\u0016\u0004\b\u0005^5nKNt\u0003%T8ti\u0002\nGnZ8sSRDWn\u001d\u0011tQ>,H\u000e\u001a\u0006!A)\u00023m\u001c8wKJ<W\rI1gi\u0016\u0014\b%\u00199qe>Dh\u0006\t\u001a1A%$XM]1uS>t7O\f\u0006!A)R\u0001\u0005\t\u0016!G\r\u0002\u0003+\u0019:b[\u0016$XM]:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1eC6\u0004\u0018N\\4GC\u000e$xN\u001d\u001e!\t>,(\r\\3!{\u0001\u0002d\u0006O\u001ba\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002\u0003K]8cC\nLG.\u001b;zAQD\u0017\r\u001e\u0011bA9|G-\u001a\u0011xS2d\u0007EY3!e\u0006tGm\\7ms\u0002\u001aX\r\\3di\u0016$\u0007EY=!C\u0002*8/\u001a:!iJ\fg/\u001a:tS:<\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5-A\u0011,g-Y;miN\u0004Co\u001c\u00111]a*dF\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b-\u001b;fe\u0006$Xm\u0015;faNT\u0004%\u00138uAu\u0002\u0013\u0007\r\u0019a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002S*\u0019=j[Vl\u0007E\\;nE\u0016\u0014\be\u001c4!SR,'/\u0019;j_:\u001c\bEZ8sAQDW\rI1mO>\u0014\u0018\u000e\u001e5nAQ|\u0007E];o])\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A^,\u0017n\u001a5u!J|\u0007/\u001a:usj\u00023\u000b\u001e:j]\u001e\u0004S\b\t\u0012xK&<\u0007\u000e\u001e\u0012a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002C\u000f[3!aJ|\u0007/\u001a:us\u0002B\u0013N\u001a\u0011b]fL\u0003eY8oi\u0006Lg.\u001b8hA\u0005\u0004c.^7fe&\u001c\u0017\r\u001c\u0011xK&<\u0007\u000e\u001e\u0011wC2,X\r\t4pe\u0002*\u0017m\u00195!K\u0012<W\r\f\u0011eK\u001a\fW\u000f\u001c;tAQ|\u0007EI<fS\u001eDGO\t\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0002\u0007\rY>o_R,WP\u0003\u0011!U\u0001\u0002\u0013J\u001a\u0011uQ\u0016\u0004s/Z5hQR\u0004\u0003O]8qKJ$\u0018\u0010I5tA9|G\u000f\t4pk:$G\u0006I<fS\u001eDG\u000fI5tAQ\u0014X-\u0019;fI\u0002\n7\u000f\t;iK\u0002rW/\u001c2fe\u0002zg\rI3eO\u0016\u0004snY2veJ,gnY3t])\u0001\u0003E\u000b\u0011!A\u0002\u0004'\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AM#\u0018\r^3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?aaJd\u0017MY3mu\u0001\"u.\u001e2mK\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t)bO\u0016\u0014\u0016M\\6!_\u001a\u0004C\u000f[3!]>$WM\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!m\u0016\u0014H/\u001a=!]\u0006lW\r\t\u0011!A\u0001\u0002\u0003\u0005 \u0011QC\u001e,'+\u00198lA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011}\u0015\u0001\u0002#\u0006\t\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y*\u0001\u0003E\u000b\u0011!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010\u00199sY\u0006\u0014W\r\u001c\u001e!\t>,(\r\\3aAqT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00191awN,W-\u00197t_vT\u0001\u0005\t\u0016!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018hK:,'/[2/G\u0016tGO]1mSRLh\u0006U1hKJ\u000bgn[\u0015\u000bA\u0001R\u0003\u0005\u00191a\u0015\u0001\u0002#fL\u0001\u0011/\u0016Lw\r\u001b;fIB\u000bw-\u001a*b].\u0004\"\u0001\u0016\u0005\u0014\u0007!ax\u0010\u0005\u0002'{&\u0011ap\n\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005\u0011\u0011n\u001c\u0006\u0003\u0003\u0013\tAA[1wC&!\u0011QBA\u0002\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005QX\u0003BA\n\u00037!\u0002\"!\u0006\u0002$\u0005\u0015\u0012q\u0005\u000b\u0005\u0003/\ti\u0002\u0005\u0003U\u0001\u0005e\u0001c\u0001$\u0002\u001c\u0011)\u0001J\u0003b\u0001\u0013\"I\u0011q\u0004\u0006\u0002\u0002\u0003\u000f\u0011\u0011E\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004\u0003B\u001fC\u00033Aq\u0001\n\u0006\u0011\u0002\u0003\u0007Q\u0005C\u0004,\u0015A\u0005\t\u0019\u0001\u0017\t\u000f=R\u0001\u0013!a\u0001a\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0002.\u0005\rSCAA\u0018U\r)\u0013\u0011G\u0016\u0003\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0005v]\u000eDWmY6fI*\u0019\u0011QH\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002B\u0005]\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)\u0001j\u0003b\u0001\u0013\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0003\u0002J\u00055SCAA&U\ra\u0013\u0011\u0007\u0003\u0006\u00112\u0011\r!S\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%gU!\u00111KA,+\t\t)FK\u00021\u0003c!Q\u0001S\u0007C\u0002%\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT\u0003BA\u0017\u0003;\"Q\u0001\u0013\bC\u0002%\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012T\u0003BA%\u0003G\"Q\u0001S\bC\u0002%\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT\u0003BA*\u0003S\"Q\u0001\u0013\tC\u0002%\u000bAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gRA!!\u001e\u0002\b\u0005!A.\u00198h\u0013\u0011\tI(a\u001d\u0003\r=\u0013'.Z2u\u0001")
public class WeightedPageRank<T>
extends NodeList {
    private final double dampingFactor;
    private final int iterateSteps;
    private final String weightProperty;
    private final Numeric<T> numeric;

    public static <T> String $lessinit$greater$default$3() {
        return WeightedPageRank$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> int $lessinit$greater$default$2() {
        return WeightedPageRank$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> double $lessinit$greater$default$1() {
        return WeightedPageRank$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> String apply$default$3() {
        return WeightedPageRank$.MODULE$.apply$default$3();
    }

    public static <T> int apply$default$2() {
        return WeightedPageRank$.MODULE$.apply$default$2();
    }

    public static <T> double apply$default$1() {
        return WeightedPageRank$.MODULE$.apply$default$1();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            WeightedPageRank.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            WeightedPageRank.$anonfun$apply$3(this, vertex);
            return BoxedUnit.UNIT;
        }, this.iterateSteps, false);
    }

    public static final /* synthetic */ void $anonfun$apply$1(WeightedPageRank $this, Vertex vertex) {
        double initLabel = 1.0;
        ((EntityVisitor)((Object)vertex)).setState("prlabel", BoxesRunTime.boxToDouble((double)initLabel));
        double outWeight = $this.numeric.toDouble(vertex.weightedOutDegree($this.numeric));
        vertex.outEdges().foreach((Function1 & Serializable)e -> {
            vertex.messageVertex(e.ID(), BoxesRunTime.boxToDouble((double)($this.numeric.toDouble(e.weight($this.weightProperty, $this.numeric)) / outWeight)), SchemaProviderInstances$.MODULE$.doubleSchemaProvider());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$3(WeightedPageRank $this, Vertex vertex) {
        block0: {
            String vname = vertex.name(vertex.name$default$1());
            double currentLabel = BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("prlabel", ((EntityVisitor)((Object)vertex)).getState$default$2()));
            Seq queue = vertex.messageQueue();
            double newLabel = 1.0 - $this.dampingFactor + $this.dampingFactor * BoxesRunTime.unboxToDouble((Object)queue.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            ((EntityVisitor)((Object)vertex)).setState("prlabel", BoxesRunTime.boxToDouble((double)newLabel));
            double outWeight = $this.numeric.toDouble(vertex.weightedOutDegree($this.weightProperty, $this.numeric));
            vertex.outEdges().foreach((Function1 & Serializable)e -> {
                vertex.messageVertex(e.ID(), BoxesRunTime.boxToDouble((double)(newLabel * $this.numeric.toDouble(e.weight($this.weightProperty, $this.numeric)) / outWeight)), SchemaProviderInstances$.MODULE$.doubleSchemaProvider());
                return BoxedUnit.UNIT;
            });
            if (!(Math.abs(newLabel - currentLabel) / currentLabel < 1.0E-5)) break block0;
            vertex.voteToHalt();
        }
    }

    public WeightedPageRank(double dampingFactor, int iterateSteps, String weightProperty, Numeric<T> numeric) {
        this.dampingFactor = dampingFactor;
        this.iterateSteps = iterateSteps;
        this.weightProperty = weightProperty;
        this.numeric = numeric;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"prlabel"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

