/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.centrality.WeightedDegree$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`WeightedDegree(weightProperty: String = \"weight\")`\n  *  : compute the weighted degree (i.e. strength)\n  *\n  * This algorithm returns the weighted degree (i.e., strength) of a node, defined by the weighted sum of incoming,\n  * outgoing or total edges to that node. If an edge has a numerical weight property, the name of this property can\n  * be specified as a parameter -- default is \"weight\". In this case, the sum of edge weights for respectively\n  * incoming and outgoing edges respectively is returned, as well as the total\n  * of these. Otherwise, the number of incoming and outgoing edges (including multiple edges between the same\n  * node pairs) is returned, as well as the sum of these.\n  *\n  * ## Parameters\n  *\n  *  {s}`weightProperty: String = \"weight\"`\n  *    : the property (if any) containing a numerical weight value for each edge, defaults to \"weight\".\n  *\n  * ## States\n  *\n  *  {s}`inWeight: Double`\n  *    : Sum of weighted incoming edges\n  *\n  *  {s}`outWeight: Double`\n  *    : Sum of weighted outgoing edges\n  *\n  *  {s}`totWeight: Double`\n  *    : Sum of the above\n  *\n  * ## Returns\n  *\n  *  | vertex name       | total incoming weight | total outgoing weight  | total weight           |\n  *  | ----------------- | --------------------- | ---------------------- | ---------------------- |\n  *  | {s}`name: String` | {s}`inWeight: Double` | {s}`outWeight: Double` | {s}`totWeight: Double` |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.centrality.Degree)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\u0007\u000e\u0001aA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tY\u0001\u0011\u0019\u0011)A\u0006[!)!\t\u0001C\u0001\u0007\")\u0011\n\u0001C!\u0015\u001e)\u0011.\u0004E\u0001U\u001a)A\"\u0004E\u0001W\")!I\u0002C\u0001o\")\u0011J\u0002C\u0001q\"I\u0011Q\u0001\u0004\u0012\u0002\u0013\u0005\u0011q\u0001\u0005\n\u0003C1\u0011\u0013!C\u0001\u0003GA\u0011\"a\n\u0007\u0003\u0003%I!!\u000b\u0003\u001d]+\u0017n\u001a5uK\u0012$Um\u001a:fK*\u0011abD\u0001\u000bG\u0016tGO]1mSRL(B\u0001\t\u0012\u0003\u001d9WM\\3sS\u000eT!AE\n\u0002\u0015\u0005dwm\u001c:ji\"l7O\u0003\u0002\u0015+\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001+\tI\u0002h\u0005\u0002\u00015A\u00111\u0004H\u0007\u0002\u001f%\u0011Qd\u0004\u0002\t\u001d>$W\rT5ti\u0006qq/Z5hQR\u0004&o\u001c9feRL\bC\u0001\u0011*\u001d\t\ts\u0005\u0005\u0002#K5\t1E\u0003\u0002%/\u00051AH]8pizR\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\na\u0001\u0015:fI\u00164\u0017B\u0001\u0016,\u0005\u0019\u0019FO]5oO*\u0011\u0001&J\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u0001\u00184m9\u0011q&\r\b\u0003EAJ\u0011AJ\u0005\u0003e\u0015\nq\u0001]1dW\u0006<W-\u0003\u00025k\t9a*^7fe&\u001c'B\u0001\u001a&!\t9\u0004\b\u0004\u0001\u0005\u000be\u0002!\u0019\u0001\u001e\u0003\u0003Q\u000b\"aO \u0011\u0005qjT\"A\u0013\n\u0005y*#a\u0002(pi\"Lgn\u001a\t\u0003y\u0001K!!Q\u0013\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0003\t\"#\"!R$\u0011\u0007\u0019\u0003a'D\u0001\u000e\u0011\u0015a3\u0001q\u0001.\u0011\u001dq2\u0001%AA\u0002}\tQ!\u00199qYf$\"aS'\u0011\u00051KfBA\u001cN\u0011\u0015qE\u00011\u0001P\u0003\u00159'/\u00199i!\t\u0001v+D\u0001R\u0015\t\u00116+A\u0005he\u0006\u0004\bN^5fo*\u0011A+V\u0001\tC:\fG._:jg*\u0011akE\u0001\u0004CBL\u0017B\u0001-R\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4X-\u0003\u0002[/\n)qI]1qQ\"\"\u0001\u0001\u00184h!\tiF-D\u0001_\u0015\ty\u0006-\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\t\t'-A\u0004uC.,'p\\3\u000b\u0005\r,\u0012AB4ji\",(-\u0003\u0002f=\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001i\u0003-uwF\u000b\u0016\u000bA\u0001R\u0003e_:~A^+\u0017n\u001a5uK\u0012$Um\u001a:fK\":X-[4iiB\u0013x\u000e]3sifT\u0004e\u0015;sS:<\u0007%\u0010\u0011#o\u0016Lw\r\u001b;#S\u0001T\u0001\u0005\t\u0016!Ai\u00023m\\7qkR,\u0007\u0005\u001e5fA],\u0017n\u001a5uK\u0012\u0004C-Z4sK\u0016\u0004\u0003&\u001b\u0018f]\u0001\u001aHO]3oORD\u0017F\u0003\u0011!U)\u0001\u0003E\u000b\u0011UQ&\u001c\b%\u00197h_JLG\u000f[7!e\u0016$XO\u001d8tAQDW\rI<fS\u001eDG/\u001a3!I\u0016<'/Z3!Q%tSM\f\u0017!gR\u0014XM\\4uQ&\u0002sN\u001a\u0011bA9|G-\u001a\u0017!I\u00164\u0017N\\3eA\tL\b\u0005\u001e5fA],\u0017n\u001a5uK\u0012\u00043/^7!_\u001a\u0004\u0013N\\2p[&tw\r\f\u0006!A)\u0002s.\u001e;h_&tw\rI8sAQ|G/\u00197!K\u0012<Wm\u001d\u0011u_\u0002\"\b.\u0019;!]>$WM\f\u0011JM\u0002\ng\u000eI3eO\u0016\u0004\u0003.Y:!C\u0002rW/\\3sS\u000e\fG\u000eI<fS\u001eDG\u000f\t9s_B,'\u000f^=-AQDW\r\t8b[\u0016\u0004sN\u001a\u0011uQ&\u001c\b\u0005\u001d:pa\u0016\u0014H/\u001f\u0011dC:T\u0001\u0005\t\u0016!E\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011bg\u0002\n\u0007\u0005]1sC6,G/\u001a:![5\u0002C-\u001a4bk2$\b%[:!E],\u0017n\u001a5uE9\u0002\u0013J\u001c\u0011uQ&\u001c\beY1tK2\u0002C\u000f[3!gVl\u0007e\u001c4!K\u0012<W\rI<fS\u001eDGo\u001d\u0011g_J\u0004#/Z:qK\u000e$\u0018N^3ms*\u0001\u0003E\u000b\u0011j]\u000e|W.\u001b8hA\u0005tG\rI8vi\u001e|\u0017N\\4!K\u0012<Wm\u001d\u0011sKN\u0004Xm\u0019;jm\u0016d\u0017\u0010I5tAI,G/\u001e:oK\u0012d\u0003%Y:!o\u0016dG\u000eI1tAQDW\r\t;pi\u0006d'\u0002\t\u0011+A=4\u0007\u0005\u001e5fg\u0016t\u0003e\u0014;iKJ<\u0018n]3-AQDW\r\t8v[\n,'\u000fI8gA%t7m\\7j]\u001e\u0004\u0013M\u001c3!_V$xm\\5oO\u0002*GmZ3tA!Jgn\u00197vI&tw\rI7vYRL\u0007\u000f\\3!K\u0012<Wm\u001d\u0011cKR<X-\u001a8!i\",\u0007e]1nK*\u0001\u0003E\u000b\u0011o_\u0012,\u0007\u0005]1jeNL\u0003%[:!e\u0016$XO\u001d8fI2\u0002\u0013m\u001d\u0011xK2d\u0007%Y:!i\",\u0007e];nA=4\u0007\u0005\u001e5fg\u0016t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AA\u000b'/Y7fi\u0016\u00148O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\bm^3jO\"$\bK]8qKJ$\u0018P\u000f\u0011TiJLgn\u001a\u0011>A\t:X-[4ii\n\u0002'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011uQ\u0016\u0004\u0003O]8qKJ$\u0018\u0010\t\u0015jM\u0002\ng._\u0015!G>tG/Y5oS:<\u0007%\u0019\u0011ok6,'/[2bY\u0002:X-[4ii\u00022\u0018\r\\;fA\u0019|'\u000fI3bG\"\u0004S\rZ4fY\u0001\"WMZ1vYR\u001c\b\u0005^8!E],\u0017n\u001a5uE9R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1j]^+\u0017n\u001a5uu\u0001\"u.\u001e2mK\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI*v[\u0002zg\rI<fS\u001eDG/\u001a3!S:\u001cw.\\5oO\u0002*GmZ3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?a_V$x+Z5hQRT\u0004\u0005R8vE2,\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!'Vl\u0007e\u001c4!o\u0016Lw\r\u001b;fI\u0002zW\u000f^4pS:<\u0007%\u001a3hKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$x\u000e^,fS\u001eDGO\u000f\u0011E_V\u0014G.\u001a1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\u001aV/\u001c\u0011pM\u0002\"\b.\u001a\u0011bE>4XM\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!m\u0016\u0014H/\u001a=!]\u0006lW\r\t\u0011!A\u0001\u0002\u0003\u0005 \u0011u_R\fG\u000eI5oG>l\u0017N\\4!o\u0016Lw\r\u001b;!y\u0002\"x\u000e^1mA=,HoZ8j]\u001e\u0004s/Z5hQR\u0004\u0003\u0005 \u0011u_R\fG\u000eI<fS\u001eDG\u000f\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AqT\u0001\u0005\t\u0016!Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010I>t{\u0002LgnV3jO\"$(\b\t#pk\ndW\r\u0019\u0011}Am\u001cX\u0010Y8vi^+\u0017n\u001a5uu\u0001\"u.\u001e2mK\u0002\u0004C\u0010I>t{\u0002$x\u000e^,fS\u001eDGO\u000f\u0011E_V\u0014G.\u001a1!y*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\r\u00191|g\u0016,\u0017\r\\:p{*\u0001\u0003E\u000b\u0011\\;\"\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0005dwm\u001c:ji\"l7OL4f]\u0016\u0014\u0018n\u0019\u0018dK:$(/\u00197jiftC)Z4sK\u0016L#\u0002\t\u0011+A\u0001\u0004\u0007M\u0003\u0011!U=\nabV3jO\"$X\r\u001a#fOJ,W\r\u0005\u0002G\rM\u0019a\u0001\\8\u0011\u0005qj\u0017B\u00018&\u0005\u0019\te.\u001f*fMB\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\u0003S>T\u0011\u0001^\u0001\u0005U\u00064\u0018-\u0003\u0002wc\na1+\u001a:jC2L'0\u00192mKR\t!.\u0006\u0002z{R\u0019!0a\u0001\u0015\u0005mt\bc\u0001$\u0001yB\u0011q' \u0003\u0006s!\u0011\rA\u000f\u0005\t\u007f\"\t\t\u0011q\u0001\u0002\u0002\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\u00079\u001aD\u0010C\u0004\u001f\u0011A\u0005\t\u0019A\u0010\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE*B!!\u0003\u0002 U\u0011\u00111\u0002\u0016\u0004?\u000551FAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eQ%\u0001\u0006b]:|G/\u0019;j_:LA!!\b\u0002\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000beJ!\u0019\u0001\u001e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0011\tI!!\n\u0005\u000beR!\u0019\u0001\u001e\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E2/\u0001\u0003mC:<\u0017\u0002BA\u001b\u0003_\u0011aa\u00142kK\u000e$\b")
public class WeightedDegree<T>
extends NodeList {
    private final String weightProperty;
    private final Numeric<T> evidence$1;

    public static <T> String $lessinit$greater$default$1() {
        return WeightedDegree$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> String apply$default$1() {
        return WeightedDegree$.MODULE$.apply$default$1();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            WeightedDegree.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(WeightedDegree $this, Vertex vertex) {
        Object inWeight = vertex.weightedInDegree($this.weightProperty, $this.evidence$1);
        ((EntityVisitor)((Object)vertex)).setState("inStrength", inWeight);
        Object outWeight = vertex.weightedOutDegree($this.weightProperty, $this.evidence$1);
        ((EntityVisitor)((Object)vertex)).setState("outStrength", outWeight);
        Object totWeight = Numeric.Implicits$.MODULE$.infixNumericOps(inWeight, $this.evidence$1).$plus(outWeight);
        ((EntityVisitor)((Object)vertex)).setState("totStrength", vertex.weightedTotalDegree($this.weightProperty, $this.evidence$1));
    }

    public WeightedDegree(String weightProperty, Numeric<T> evidence$1) {
        this.weightProperty = weightProperty;
        this.evidence$1 = evidence$1;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"inStrength", "outStrength", "totStrength"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

