/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.TwoHopPaths$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/**\n  * {s}`TwoHopPaths()`\n  *    : List all two-hop paths in the network\n  *\n  * {s}`TwoHopPaths(seeds: Iterable[String])`, {s}`TwoHopPaths(seeds: String*)`\n  *    : List all two-hop paths starting at nodes in {s}`seeds`\n  *\n  * This algorithm will return the two hop neighbours of each node in\n  * the graph. If the user provides input seeds, then it will only return\n  * the two hop neighbours starting from those nodes.\n  *\n  * ```{Warning}\n  *    As this sends alot of messages between nodes, running this for the entire\n  *    graph with a large number of nodes may cause you to run out of memory.\n  *    Therefore it is most optimal to run with a few select nodes at a time.\n  * ```\n  *\n  * ## Parameters\n  *\n  *  {s}`seeds: Set[String]`\n  *    : The set of node names to start paths from. If not specified, then this is\n  *      run for all nodes.\n  *\n  * ## Returns\n  *\n  *  | vertex1           | vertex2           | vertex3           |\n  *  | ----------------- | ----------------- | ----------------- |\n  *  | {s}`name: String` | {s}`name: String` | {s}`name: String` |\n  *\n  * ## Implementation\n  *\n  *  1. In the first step the node messages all its neighbours, saying that it is\n  *     asking for a two-hop analysis.\n  *\n  *  2. The first-hop node forwards the message to all its neighbours, adding its name\n  *\n  *  3. The second-hop node adds its name and responds to the source\n  *\n  *  4. The source node compiles all response messages\n  */")
@ScalaSignature(bytes="\u0006\u0005\r\u0005d\u0001\u0002,X\u0001\u0001D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!!\u000b\u0001\t\u0003\nYcB\u0004\u0002X]C\t!!\u0017\u0007\rY;\u0006\u0012AA.\u0011\u001d\t\tA\u0002C\u0001\u0003[Bq!a\u0003\u0007\t\u0003\ty\u0007C\u0005\u0002\u0006\u001a\t\n\u0011\"\u0001\u0002\b\"9\u00111\u0002\u0004\u0005\u0002\u0005ue!CAT\rA\u0005\u0019\u0013EAU\r\u0019\t\tM\u0002!\u0002D\"Q\u0011\u0011\u001c\u0007\u0003\u0016\u0004%\t!a7\t\u0015\u0005uGB!E!\u0002\u0013\tY\rC\u0004\u0002\u00021!\t!a8\t\u0013\u0005\u0015H\"!A\u0005\u0002\u0005\u001d\b\"CAz\u0019E\u0005I\u0011AA{\u0011%\ti\u0010DA\u0001\n\u0003\ny\u0010C\u0005\u0003\f1\t\t\u0011\"\u0001\u0003\u000e!I!Q\u0003\u0007\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u0005;a\u0011\u0011!C!\u0005?A\u0011B!\f\r\u0003\u0003%\tAa\f\t\u0013\teB\"!A\u0005B\tm\u0002\"\u0003B \u0019\u0005\u0005I\u0011\tB!\u0011%\u0011\u0019\u0005DA\u0001\n\u0003\u0012)\u0005C\u0005\u0003H1\t\t\u0011\"\u0011\u0003J\u001dI!q\u001b\u0004\u0002\u0002#\u0005!\u0011\u001c\u0004\n\u0003\u00034\u0011\u0011!E\u0001\u00057Dq!!\u0001\u001d\t\u0003\u0011i\u000eC\u0005\u0003Dq\t\t\u0011\"\u0012\u0003F!I\u00111\u0002\u000f\u0002\u0002\u0013\u0005%q\u001c\u0005\n\u0005Wd\u0012\u0011!CA\u0005[D\u0011b!\u0001\u001d\u0003\u0003%Iaa\u0001\u0007\r\t5c\u0001\u0011B(\u0011)\tIN\tBK\u0002\u0013\u0005!\u0011\f\u0005\u000b\u0003;\u0014#\u0011#Q\u0001\n\tU\u0003B\u0003B.E\tU\r\u0011\"\u0001\u0003^!I!q\f\u0012\u0003\u0012\u0003\u0006I! \u0005\b\u0003\u0003\u0011C\u0011\u0001B1\u0011%\t)OIA\u0001\n\u0003\u0011I\u0007C\u0005\u0002t\n\n\n\u0011\"\u0001\u0003x!I!q\u0010\u0012\u0012\u0002\u0013\u0005!\u0011\u0011\u0005\n\u0003{\u0014\u0013\u0011!C!\u0003\u007fD\u0011Ba\u0003#\u0003\u0003%\tA!\u0004\t\u0013\tU!%!A\u0005\u0002\t%\u0005\"\u0003B\u000fE\u0005\u0005I\u0011\tB\u0010\u0011%\u0011iCIA\u0001\n\u0003\u0011i\tC\u0005\u0003:\t\n\t\u0011\"\u0011\u0003\u0012\"I!q\b\u0012\u0002\u0002\u0013\u0005#\u0011\t\u0005\n\u0005\u0007\u0012\u0013\u0011!C!\u0005\u000bB\u0011Ba\u0012#\u0003\u0003%\tE!&\b\u0013\r-a!!A\t\u0002\r5a!\u0003B'\r\u0005\u0005\t\u0012AB\b\u0011\u001d\t\t!\u000eC\u0001\u0007#A\u0011Ba\u00116\u0003\u0003%)E!\u0012\t\u0013\u0005-Q'!A\u0005\u0002\u000eM\u0001\"\u0003Bvk\u0005\u0005I\u0011QB\u0011\u0011%\u0019\t!NA\u0001\n\u0013\u0019\u0019A\u0002\u0004\u0003\u001a\u001a\u0001%1\u0014\u0005\u000b\u00057Z$Q3A\u0005\u0002\tu\u0003\"\u0003B0w\tE\t\u0015!\u0003~\u0011)\u0011)k\u000fBK\u0002\u0013\u0005!Q\f\u0005\n\u0005O[$\u0011#Q\u0001\nuDq!!\u0001<\t\u0003\u0011I\u000bC\u0005\u0002fn\n\t\u0011\"\u0001\u00032\"I\u00111_\u001e\u0012\u0002\u0013\u0005!q\u0018\u0005\n\u0005\u007fZ\u0014\u0013!C\u0001\u0005\u0007D\u0011\"!@<\u0003\u0003%\t%a@\t\u0013\t-1(!A\u0005\u0002\t5\u0001\"\u0003B\u000bw\u0005\u0005I\u0011\u0001Bd\u0011%\u0011ibOA\u0001\n\u0003\u0012y\u0002C\u0005\u0003.m\n\t\u0011\"\u0001\u0003L\"I!\u0011H\u001e\u0002\u0002\u0013\u0005#q\u001a\u0005\n\u0005\u007fY\u0014\u0011!C!\u0005\u0003B\u0011Ba\u0011<\u0003\u0003%\tE!\u0012\t\u0013\t\u001d3(!A\u0005B\tMw!CB\u001b\r\u0005\u0005\t\u0012AB\u001c\r%\u0011IJBA\u0001\u0012\u0003\u0019I\u0004C\u0004\u0002\u00029#\taa\u000f\t\u0013\t\rc*!A\u0005F\t\u0015\u0003\"CA\u0006\u001d\u0006\u0005I\u0011QB\u001f\u0011%\u0011YOTA\u0001\n\u0003\u001bY\u0005C\u0005\u0004\u00029\u000b\t\u0011\"\u0003\u0004\u0004!I11\f\u0004\u0012\u0002\u0013\u00051Q\f\u0005\n\u0007\u00031\u0011\u0011!C\u0005\u0007\u0007\u00111\u0002V<p\u0011>\u0004\b+\u0019;ig*\u0011\u0001,W\u0001\bO\u0016tWM]5d\u0015\tQ6,\u0001\u0006bY\u001e|'/\u001b;i[NT!\u0001X/\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011AX\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0005<\u0007C\u00012f\u001b\u0005\u0019'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001c'AB!osJ+g\r\u0005\u0002i_6\t\u0011N\u0003\u0002kW\u0006I\u0011\r\\4pe&$\b.\u001c\u0006\u0003Y6\f\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003]n\u000b1!\u00199j\u0013\t\u0001\u0018NA\u0004HK:,'/[2\u0002\u000bM,W\rZ:\u0011\u0007MTXP\u0004\u0002uqB\u0011QoY\u0007\u0002m*\u0011qoX\u0001\u0007yI|w\u000e\u001e \n\u0005e\u001c\u0017A\u0002)sK\u0012,g-\u0003\u0002|y\n\u00191+\u001a;\u000b\u0005e\u001c\u0007CA:\u007f\u0013\tyHP\u0001\u0004TiJLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005\u0015\u0011\u0011\u0002\t\u0004\u0003\u000f\u0001Q\"A,\t\u000fE\u0014\u0001\u0013!a\u0001e\u0006)\u0011\r\u001d9msR!\u0011qBA\u000b!\u0011\t\t\"!\n\u000f\t\u0005M\u0011Q\u0003\u0007\u0001\u0011\u001d\t9b\u0001a\u0001\u00033\tQa\u001a:ba\"\u0004B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?Y\u0017!C4sCBDg/[3x\u0013\u0011\t\u0019#!\b\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017\u0002BA\u0014\u0003C\u0011Qa\u0012:ba\"\f!\u0002^1ck2\f'/[:f)\u0011\ti#!\u000f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\rl\u0003\u0015!\u0018M\u00197f\u0013\u0011\t9$!\r\u0003\u000bQ\u000b'\r\\3\t\u000f\u0005]A\u00011\u0001\u0002\u001a!:\u0001!!\u0010\u0002R\u0005M\u0003\u0003BA \u0003\u001bj!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\tg\u000e\fG.\u00193pG*!\u0011qIA%\u0003\u001d!\u0018m[3{_\u0016T1!a\u0013^\u0003\u00199\u0017\u000e\u001e5vE&!\u0011qJA!\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017EAA+\u0003-\u0015tF\u000b\u0016\u000bA\u0001R\u0003e_:~AR;x\u000eS8q!\u0006$\bn\u001d\u0015*A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005T5ti\u0002\nG\u000e\u001c\u0011uo>l\u0003n\u001c9!a\u0006$\bn\u001d\u0011j]\u0002\"\b.\u001a\u0011oKR<xN]6\u000bA\u0001R#\u0002\t\u0011+Am\u001cX\u0010\u0019+x_\"{\u0007\u000fU1uQND3/Z3egj\u0002\u0013\n^3sC\ndWmW*ue&tw-X\u0015aY\u0001Z8/ 1Uo>Du\u000e\u001d)bi\"\u001c\bf]3fINT\u0004e\u0015;sS:<'&\u000b1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001b\u0015n\u001d;!C2d\u0007\u0005^<p[!|\u0007\u000f\t9bi\"\u001c\be\u001d;beRLgn\u001a\u0011bi\u0002rw\u000eZ3tA%t\u0007e_:~AN,W\rZ:a\u0015\u0001\u0002#F\u0003\u0011!U\u0001\"\u0006.[:!C2<wN]5uQ6\u0004s/\u001b7mAI,G/\u001e:oAQDW\r\t;x_\u0002Bw\u000e\u001d\u0011oK&<\u0007NY8veN\u0004sN\u001a\u0011fC\u000eD\u0007E\\8eK\u0002JgN\u0003\u0011!U\u0001\"\b.\u001a\u0011he\u0006\u0004\bN\f\u0011JM\u0002\"\b.\u001a\u0011vg\u0016\u0014\b\u0005\u001d:pm&$Wm\u001d\u0011j]B,H\u000fI:fK\u0012\u001cH\u0006\t;iK:\u0004\u0013\u000e\u001e\u0011xS2d\u0007e\u001c8ms\u0002\u0012X\r^;s]*\u0001\u0003E\u000b\u0011uQ\u0016\u0004Co^8!Q>\u0004\bE\\3jO\"\u0014w.\u001e:tAM$\u0018M\u001d;j]\u001e\u0004cM]8nAQDwn]3!]>$Wm\u001d\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0004\u0007m_,be:LgnZ?\u000bA\u0001R\u0003\u0005\t\u0011!\u0003N\u0004C\u000f[5tAM,g\u000eZ:!C2|G\u000fI8gA5,7o]1hKN\u0004#-\u001a;xK\u0016t\u0007E\\8eKNd\u0003E];o]&tw\r\t;iSN\u0004cm\u001c:!i\",\u0007%\u001a8uSJ,'\u0002\t\u0011+A\u0001\u0002\u0003e\u001a:ba\"\u0004s/\u001b;iA\u0005\u0004C.\u0019:hK\u0002rW/\u001c2fe\u0002zg\r\t8pI\u0016\u001c\b%\\1zA\r\fWo]3!s>,\b\u0005^8!eVt\u0007e\\;uA=4\u0007%\\3n_JLhF\u0003\u0011!U\u0001\u0002\u0003\u0005\t+iKJ,gm\u001c:fA%$\b%[:![>\u001cH\u000fI8qi&l\u0017\r\u001c\u0011u_\u0002\u0012XO\u001c\u0011xSRD\u0007%\u0019\u0011gK^\u00043/\u001a7fGR\u0004cn\u001c3fg\u0002\nG\u000fI1!i&lWM\f\u0006!A)\u0002\u0003\r\u00191\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003\u0005U1sC6,G/\u001a:t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?ag\u0016,Gm\u001d\u001e!'\u0016$8l\u0015;sS:<W\f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;AQCW\rI:fi\u0002zg\r\t8pI\u0016\u0004c.Y7fg\u0002\"x\u000eI:uCJ$\b\u0005]1uQN\u0004cM]8n]\u0001Je\r\t8pi\u0002\u001a\b/Z2jM&,G\r\f\u0011uQ\u0016t\u0007\u0005\u001e5jg\u0002J7O\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011!eVt\u0007EZ8sA\u0005dG\u000e\t8pI\u0016\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!m\u0016\u0014H/\u001a=2A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005 \u0011wKJ$X\r\u001f\u001a!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u0010\t<feR,\u0007p\r\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001b(\u0002\t\u0011+A\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015\u0001\u0002#\u0006\t\u0011}Am\u001cX\u0010\u00198b[\u0016T\u0004e\u0015;sS:<\u0007\r\t?!wNl\bM\\1nKj\u00023\u000b\u001e:j]\u001e\u0004\u0007\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004CP\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001JU\u000e\u001d7f[\u0016tG/\u0019;j_:T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I\u0019/A%s\u0007\u0005\u001e5fA\u0019L'o\u001d;!gR,\u0007\u000f\t;iK\u0002rw\u000eZ3![\u0016\u001c8/Y4fg\u0002\nG\u000e\u001c\u0011jiN\u0004c.Z5hQ\n|WO]:-AM\f\u00170\u001b8hAQD\u0017\r\u001e\u0011ji\u0002J7O\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011bg.Lgn\u001a\u0011g_J\u0004\u0013\r\t;x_6Bw\u000e\u001d\u0011b]\u0006d\u0017p]5t])\u0001\u0003E\u000b\u0006!A)\u0002\u0003E\r\u0018!)\",\u0007EZ5sgRl\u0003n\u001c9!]>$W\r\t4pe^\f'\u000fZ:!i\",\u0007%\\3tg\u0006<W\r\t;pA\u0005dG\u000eI5ug\u0002rW-[4iE>,(o\u001d\u0017!C\u0012$\u0017N\\4!SR\u001c\bE\\1nK*\u0001\u0003E\u000b\u0006!A)\u0002\u0003e\r\u0018!)\",\u0007e]3d_:$W\u0006[8qA9|G-\u001a\u0011bI\u0012\u001c\b%\u001b;tA9\fW.\u001a\u0011b]\u0012\u0004#/Z:q_:$7\u000f\t;pAQDW\rI:pkJ\u001cWM\u0003\u0011!U)\u0001\u0003E\u000b\u0011!i9\u0002C\u000b[3!g>,(oY3!]>$W\rI2p[BLG.Z:!C2d\u0007E]3ta>t7/\u001a\u0011nKN\u001c\u0018mZ3t\u0015\u0001\u0002#fL\u0001\f)^|\u0007j\u001c9QCRD7\u000fE\u0002\u0002\b\u0019\u0019BAB1\u0002^A!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014AA5p\u0015\t\t9'\u0001\u0003kCZ\f\u0017\u0002BA6\u0003C\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\"!!\u0017\u0015\t\u0005\u0015\u0011\u0011\u000f\u0005\tc\"\u0001\n\u00111\u0001\u0002tA)\u0011QOA@{:!\u0011qOA>\u001d\r)\u0018\u0011P\u0005\u0002I&\u0019\u0011QP2\u0002\u000fA\f7m[1hK&!\u0011\u0011QAB\u0005!IE/\u001a:bE2,'bAA?G\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\n*\"\u00111OAFW\t\ti\t\u0005\u0003\u0002\u0010\u0006eUBAAI\u0015\u0011\t\u0019*!&\u0002\u0013Ut7\r[3dW\u0016$'bAALG\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0015\u0011\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0003BA\u0003\u0003?Ca!\u001d\u0006A\u0002\u0005\u0005\u0006\u0003\u00022\u0002$vL1!!*d\u0005)a$/\u001a9fCR,GM\u0010\u0002\b\u001b\u0016\u001c8/Y4f+\u0011\tY+!,\u0014\u0005-\tGaBAX\u0017\t\u0007\u0011\u0011\u0017\u0002\t-\u0016\u0014H/\u001a=J\tF!\u00111WA]!\r\u0011\u0017QW\u0005\u0004\u0003o\u001b'a\u0002(pi\"Lgn\u001a\t\u0004E\u0006m\u0016bAA_G\n\u0019\u0011I\\=*\t-a!e\u000f\u0002\u0010%\u0016\fX/Z:u\r&\u00148\u000f\u001e%paV!\u0011QYAg'!a\u0011-a2\u0002P\u0006U\u0007#BAe\u0017\u0005-W\"\u0001\u0004\u0011\t\u0005M\u0011Q\u001a\u0003\b\u0003_c!\u0019AAY!\r\u0011\u0017\u0011[\u0005\u0004\u0003'\u001c'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003k\n9.\u0003\u0003\u0002l\u0005\r\u0015AB:pkJ\u001cW-\u0006\u0002\u0002L\u000691o\\;sG\u0016\u0004C\u0003BAq\u0003G\u0004R!!3\r\u0003\u0017Dq!!7\u0010\u0001\u0004\tY-\u0001\u0003d_BLX\u0003BAu\u0003_$B!a;\u0002rB)\u0011\u0011\u001a\u0007\u0002nB!\u00111CAx\t\u001d\ty\u000b\u0005b\u0001\u0003cC\u0011\"!7\u0011!\u0003\u0005\r!!<\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!\u0011q_A~+\t\tIP\u000b\u0003\u0002L\u0006-EaBAX#\t\u0007\u0011\u0011W\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u0013i!A!\u0002\u000b\t\t\u001d\u0011QM\u0001\u0005Y\u0006tw-C\u0002\u0000\u0005\u000b\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0004\u0011\u0007\t\u0014\t\"C\u0002\u0003\u0014\r\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!/\u0003\u001a!I!1\u0004\u000b\u0002\u0002\u0003\u0007!qB\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0002C\u0002B\u0012\u0005S\tI,\u0004\u0002\u0003&)\u0019!qE2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003,\t\u0015\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\r\u00038A\u0019!Ma\r\n\u0007\tU2MA\u0004C_>dW-\u00198\t\u0013\tma#!AA\u0002\u0005e\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u0001\u0003>!I!1D\f\u0002\u0002\u0003\u0007!qB\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qB\u0001\ti>\u001cFO]5oOR\u0011!\u0011A\u0001\u0007KF,\u0018\r\\:\u0015\t\tE\"1\n\u0005\n\u00057Q\u0012\u0011!a\u0001\u0003s\u0013\u0001CU3rk\u0016\u001cHoU3d_:$\u0007j\u001c9\u0016\t\tE#qK\n\tE\u0005\u0014\u0019&a4\u0002VB)\u0011\u0011Z\u0006\u0003VA!\u00111\u0003B,\t\u001d\tyK\tb\u0001\u0003c+\"A!\u0016\u0002\u0011\u0019L'o\u001d;I_B,\u0012!`\u0001\nM&\u00148\u000f\u001e%pa\u0002\"bAa\u0019\u0003f\t\u001d\u0004#BAeE\tU\u0003bBAmO\u0001\u0007!Q\u000b\u0005\u0007\u00057:\u0003\u0019A?\u0016\t\t-$\u0011\u000f\u000b\u0007\u0005[\u0012\u0019H!\u001e\u0011\u000b\u0005%'Ea\u001c\u0011\t\u0005M!\u0011\u000f\u0003\b\u0003_C#\u0019AAY\u0011%\tI\u000e\u000bI\u0001\u0002\u0004\u0011y\u0007\u0003\u0005\u0003\\!\u0002\n\u00111\u0001~+\u0011\u0011IH! \u0016\u0005\tm$\u0006\u0002B+\u0003\u0017#q!a,*\u0005\u0004\t\t,\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\t\r%qQ\u000b\u0003\u0005\u000bS3!`AF\t\u001d\tyK\u000bb\u0001\u0003c#B!!/\u0003\f\"I!1D\u0017\u0002\u0002\u0003\u0007!q\u0002\u000b\u0005\u0005c\u0011y\tC\u0005\u0003\u001c=\n\t\u00111\u0001\u0002:R!!\u0011\u0001BJ\u0011%\u0011Y\u0002MA\u0001\u0002\u0004\u0011y\u0001\u0006\u0003\u00032\t]\u0005\"\u0003B\u000eg\u0005\u0005\t\u0019AA]\u0005!\u0011Vm\u001d9p]N,W\u0003\u0002BO\u0005G\u001b\u0002bO1\u0003 \u0006=\u0017Q\u001b\t\u0006\u0003\u0013\\!\u0011\u0015\t\u0005\u0003'\u0011\u0019\u000bB\u0004\u00020n\u0012\r!!-\u0002\u0013M,7m\u001c8e\u0011>\u0004\u0018AC:fG>tG\rS8qAQ1!1\u0016BW\u0005_\u0003R!!3<\u0005CCaAa\u0017A\u0001\u0004i\bB\u0002BS\u0001\u0002\u0007Q0\u0006\u0003\u00034\neFC\u0002B[\u0005w\u0013i\fE\u0003\u0002Jn\u00129\f\u0005\u0003\u0002\u0014\teFaBAX\u0003\n\u0007\u0011\u0011\u0017\u0005\t\u00057\n\u0005\u0013!a\u0001{\"A!QU!\u0011\u0002\u0003\u0007Q0\u0006\u0003\u0003\u0004\n\u0005GaBAX\u0005\n\u0007\u0011\u0011W\u000b\u0005\u0005\u0007\u0013)\rB\u0004\u00020\u000e\u0013\r!!-\u0015\t\u0005e&\u0011\u001a\u0005\n\u000571\u0015\u0011!a\u0001\u0005\u001f!BA!\r\u0003N\"I!1\u0004%\u0002\u0002\u0003\u0007\u0011\u0011\u0018\u000b\u0005\u0005\u0003\u0011\t\u000eC\u0005\u0003\u001c%\u000b\t\u00111\u0001\u0003\u0010Q!!\u0011\u0007Bk\u0011%\u0011Y\u0002TA\u0001\u0002\u0004\tI,A\bSKF,Xm\u001d;GSJ\u001cH\u000fS8q!\r\tI\rH\n\u00059\u0005\fi\u0006\u0006\u0002\u0003ZV!!\u0011\u001dBt)\u0011\u0011\u0019O!;\u0011\u000b\u0005%GB!:\u0011\t\u0005M!q\u001d\u0003\b\u0003_{\"\u0019AAY\u0011\u001d\tIn\ba\u0001\u0005K\fq!\u001e8baBd\u00170\u0006\u0003\u0003p\neH\u0003\u0002By\u0005w\u0004RA\u0019Bz\u0005oL1A!>d\u0005\u0019y\u0005\u000f^5p]B!\u00111\u0003B}\t\u001d\ty\u000b\tb\u0001\u0003cC\u0011B!@!\u0003\u0003\u0005\rAa@\u0002\u0007a$\u0003\u0007E\u0003\u0002J2\u001190\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004\u0006A!!1AB\u0004\u0013\u0011\u0019IA!\u0002\u0003\r=\u0013'.Z2u\u0003A\u0011V-];fgR\u001cVmY8oI\"{\u0007\u000fE\u0002\u0002JV\u001aB!N1\u0002^Q\u00111QB\u000b\u0005\u0007+\u0019Y\u0002\u0006\u0004\u0004\u0018\ru1q\u0004\t\u0006\u0003\u0013\u00143\u0011\u0004\t\u0005\u0003'\u0019Y\u0002B\u0004\u00020b\u0012\r!!-\t\u000f\u0005e\u0007\b1\u0001\u0004\u001a!1!1\f\u001dA\u0002u,Baa\t\u00040Q!1QEB\u0019!\u0015\u0011'1_B\u0014!\u0019\u00117\u0011FB\u0017{&\u001911F2\u0003\rQ+\b\u000f\\33!\u0011\t\u0019ba\f\u0005\u000f\u0005=\u0016H1\u0001\u00022\"I!Q`\u001d\u0002\u0002\u0003\u000711\u0007\t\u0006\u0003\u0013\u00143QF\u0001\t%\u0016\u001c\bo\u001c8tKB\u0019\u0011\u0011\u001a(\u0014\t9\u000b\u0017Q\f\u000b\u0003\u0007o)Baa\u0010\u0004FQ11\u0011IB$\u0007\u0013\u0002R!!3<\u0007\u0007\u0002B!a\u0005\u0004F\u00119\u0011qV)C\u0002\u0005E\u0006B\u0002B.#\u0002\u0007Q\u0010\u0003\u0004\u0003&F\u0003\r!`\u000b\u0005\u0007\u001b\u001aI\u0006\u0006\u0003\u0004P\rM\u0003#\u00022\u0003t\u000eE\u0003#\u00022\u0004*ul\b\"\u0003B\u007f%\u0006\u0005\t\u0019AB+!\u0015\tImOB,!\u0011\t\u0019b!\u0017\u0005\u000f\u0005=&K1\u0001\u00022\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"aa\u0018+\u0007I\fY\t")
public class TwoHopPaths
implements Generic {
    private final Set<String> seeds;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static Set<String> $lessinit$greater$default$1() {
        return TwoHopPaths$.MODULE$.$lessinit$greater$default$1();
    }

    public static Iterable<String> apply$default$1() {
        return TwoHopPaths$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            TwoHopPaths.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            TwoHopPaths.$anonfun$apply$2(vertex);
            return BoxedUnit.UNIT;
        }, 3, true);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.select((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "hop1", "hop2"})).explode((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hop1", "hop2"}));
    }

    public static final /* synthetic */ void $anonfun$apply$1(TwoHopPaths $this, Vertex vertex) {
        block0: {
            if (!$this.seeds.isEmpty() && !$this.seeds.contains((Object)vertex.name(vertex.name$default$1()))) break block0;
            vertex.messageOutNeighbours(new RequestFirstHop<Object>(vertex.ID()), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(Object source$1, Vertex vertex$1, Object n) {
        block0: {
            if (BoxesRunTime.equals((Object)n, (Object)source$1)) break block0;
            vertex$1.messageVertex(n, new RequestSecondHop<Object>(source$1, vertex$1.name(vertex$1.name$default$1())), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex) {
        Seq newMessages = vertex.messageQueue();
        newMessages.foreach((Function1 & Serializable)message -> {
            BoxedUnit boxedUnit;
            Message message2 = message;
            if (message2 instanceof RequestFirstHop) {
                RequestFirstHop requestFirstHop = (RequestFirstHop)message2;
                Object source = requestFirstHop.source();
                vertex.outNeighbours().foreach((Function1 & Serializable)n -> {
                    TwoHopPaths.$anonfun$apply$4(source, vertex, n);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else if (message2 instanceof RequestSecondHop) {
                RequestSecondHop requestSecondHop = (RequestSecondHop)message2;
                Object source = requestSecondHop.source();
                String firstHop = requestSecondHop.firstHop();
                vertex.messageVertex(source, new Response(firstHop, vertex.name(vertex.name$default$1())), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else if (message2 instanceof Response) {
                Response response = (Response)message2;
                String firstHop = response.firstHop();
                String secondHop = response.secondHop();
                ArrayBuffer firstHops = (ArrayBuffer)((EntityVisitor)((Object)vertex)).getOrSetState("hop1", ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), ((EntityVisitor)((Object)vertex)).getOrSetState$default$3());
                ArrayBuffer secondHops = (ArrayBuffer)((EntityVisitor)((Object)vertex)).getOrSetState("hop2", ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), ((EntityVisitor)((Object)vertex)).getOrSetState$default$3());
                firstHops.append((Object)firstHop);
                boxedUnit = secondHops.append((Object)secondHop);
            } else {
                throw new MatchError((Object)message2);
            }
            return boxedUnit;
        });
    }

    public TwoHopPaths(Set<String> seeds) {
        this.seeds = seeds;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }

    public static interface Message<VertexID> {
    }

    public static class RequestFirstHop<VertexID>
    implements Message<VertexID>,
    Product,
    Serializable {
        private final VertexID source;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public VertexID source() {
            return this.source;
        }

        public <VertexID> RequestFirstHop<VertexID> copy(VertexID source) {
            return new RequestFirstHop<VertexID>(source);
        }

        public <VertexID> VertexID copy$default$1() {
            return this.source();
        }

        public String productPrefix() {
            return "RequestFirstHop";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.source();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RequestFirstHop;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "source";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RequestFirstHop)) return false;
            boolean bl = true;
            if (!bl) return false;
            RequestFirstHop requestFirstHop = (RequestFirstHop)x$1;
            if (!BoxesRunTime.equals(this.source(), requestFirstHop.source())) return false;
            if (!requestFirstHop.canEqual(this)) return false;
            return true;
        }

        public RequestFirstHop(VertexID source) {
            this.source = source;
            Product.$init$((Product)this);
        }
    }

    public static class RequestSecondHop<VertexID>
    implements Message<VertexID>,
    Product,
    Serializable {
        private final VertexID source;
        private final String firstHop;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public VertexID source() {
            return this.source;
        }

        public String firstHop() {
            return this.firstHop;
        }

        public <VertexID> RequestSecondHop<VertexID> copy(VertexID source, String firstHop) {
            return new RequestSecondHop<VertexID>(source, firstHop);
        }

        public <VertexID> VertexID copy$default$1() {
            return this.source();
        }

        public <VertexID> String copy$default$2() {
            return this.firstHop();
        }

        public String productPrefix() {
            return "RequestSecondHop";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.source();
                    break;
                }
                case 1: {
                    object = this.firstHop();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RequestSecondHop;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "source";
                    break;
                }
                case 1: {
                    string = "firstHop";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RequestSecondHop)) return false;
            boolean bl = true;
            if (!bl) return false;
            RequestSecondHop requestSecondHop = (RequestSecondHop)x$1;
            if (!BoxesRunTime.equals(this.source(), requestSecondHop.source())) return false;
            String string = this.firstHop();
            String string2 = requestSecondHop.firstHop();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!requestSecondHop.canEqual(this)) return false;
            return true;
        }

        public RequestSecondHop(VertexID source, String firstHop) {
            this.source = source;
            this.firstHop = firstHop;
            Product.$init$((Product)this);
        }
    }

    public static class Response<VertexID>
    implements Message<VertexID>,
    Product,
    Serializable {
        private final String firstHop;
        private final String secondHop;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String firstHop() {
            return this.firstHop;
        }

        public String secondHop() {
            return this.secondHop;
        }

        public <VertexID> Response<VertexID> copy(String firstHop, String secondHop) {
            return new Response<VertexID>(firstHop, secondHop);
        }

        public <VertexID> String copy$default$1() {
            return this.firstHop();
        }

        public <VertexID> String copy$default$2() {
            return this.secondHop();
        }

        public String productPrefix() {
            return "Response";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.firstHop();
                    break;
                }
                case 1: {
                    object = this.secondHop();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Response;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "firstHop";
                    break;
                }
                case 1: {
                    string = "secondHop";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Response)) return false;
            boolean bl = true;
            if (!bl) return false;
            Response response = (Response)x$1;
            String string = this.firstHop();
            String string2 = response.firstHop();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.secondHop();
            String string4 = response.secondHop();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!response.canEqual(this)) return false;
            return true;
        }

        public Response(String firstHop, String secondHop) {
            this.firstHop = firstHop;
            this.secondHop = secondHop;
            Product.$init$((Product)this);
        }
    }
}

