/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.GraphStateOutput;
import com.raphtory.api.analysis.algorithm.GraphStateOutput$;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.Accumulator;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`NodeEdgeCount`\n  *  Stores/returns the number of nodes and edges in the graph.\n  *\n  *  This counts the number of nodes and edges in the perspective and returns them. We count both the number of \"undirected\"\n  *  edges, treating the graph as a simple undirected graph, the number of directed edges, treating the graph as directed\n  *  and simple, and the number of temporal edges which includes duplicate directed edges between the same pair of nodes.\n  *\n  * ## States\n  *\n  *  {s}`numNodes: Int`\n  *  : Number of nodes in the perspective\n  *\n  *  {s}`directedEdges: Int`\n  *  : Number of directed edges in the perspective\n  *\n  *  {s}`undirectedEdges: Int`\n  *  : Number of undirected edges in the perspective\n  *\n  *  {s}`temporalEdges: Int`\n  *  : Number of directed edges with multiplicity in the perspective\n  *\n  *\n  *  ## Returns\n  *\n  *  | no nodes          | no directed edges       | no undirected edges       | no temporal edges |\n  *  | ----------------- | ----------------------- | ------------------------- | ----------------- |\n  *  | {s}`numNodes: Int` | {s}`directedEdges: Int` | {s}`undirectedEdges: Int` | {s}`temporalEdges: Int` |\n  *\n  */")
public final class NodeEdgeCount$
extends GraphStateOutput
implements GenericReduction {
    public static final NodeEdgeCount$ MODULE$ = new NodeEdgeCount$();

    static {
        GenericReduction.$init$(MODULE$);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(Generic other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return (ConcreteReducedGraphPerspective)graph.reducedView().setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            NodeEdgeCount$.$anonfun$apply$1(state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            NodeEdgeCount$.$anonfun$apply$2(vertex, state);
            return BoxedUnit.UNIT;
        }).setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            state.newConstant("undirectedEdges", BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(state.apply("undirectedEdgesAcc").value()) / 2)));
            return BoxedUnit.UNIT;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NodeEdgeCount$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$1(GraphState state) {
        state.newIntAdder("directedEdges", 0, true);
        state.newIntAdder("undirectedEdgesAcc", 0, true);
        state.newIntAdder("temporalEdges", 0, true);
        state.newConstant("numNodes", BoxesRunTime.boxToInteger((int)state.nodeCount()));
    }

    public static final /* synthetic */ void $anonfun$apply$2(ReducedVertex vertex, GraphState state) {
        Accumulator acc1 = state.apply("directedEdges");
        acc1.$plus$eq$mcI$sp(vertex.outEdges().size());
        Accumulator acc2 = state.apply("undirectedEdgesAcc");
        acc2.$plus$eq$mcI$sp(vertex.degree());
        Accumulator acc3 = state.apply("temporalEdges");
        acc3.$plus$eq$mcI$sp(vertex.explodeOutEdges(vertex.explodeOutEdges$default$1(), vertex.explodeOutEdges$default$2()).size());
    }

    private NodeEdgeCount$() {
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numNodes", "directedEdges", "undirectedEdges", "temporalEdges"}))), GraphStateOutput$.MODULE$.$lessinit$greater$default$2());
    }
}

