/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`AdjPlus()`\n  * : AdjPlus transform of the graph\n  *\n  *  This transforms the graph using the AdjPlus projection, which treats the input graph as undirected and returns a\n  *  directed graph where all edges point from low to high degree.\n  *  For each vertex, the algorithm finds the set of neighbours that have a larger degree than the current vertex\n  *  or the same degree and a larger ID and store it as state \"adjPlus\". This algorithm treats the network as undirected.\n  *  Further, the vertex IDs in \"adjPlus\" are ordered by increasing degree. This projection is particularly useful to\n  *  make certain motif-counting algorithms more efficient.\n  *\n  * ## States\n  *\n  *  {s}`adjPlus: Array[Long]`\n  *  : List of neighbour IDs that have a larger degree than the current vertex\n  *    or the same degree and a larger ID, ordered by increasing degree\n  *\n  * ## Returns\n  *  edge list for the AdjPlus projection\n  *\n  *  | source name          | destination name     |\n  *  | -------------------- | -------------------- |\n  *  | {s}`srcName: String` | {s}`dstName: String` |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.motif.SquareCount)\n  * ```\n  */")
public final class AdjPlus$
implements Generic {
    public static final AdjPlus$ MODULE$ = new AdjPlus$();
    private static final List<String> columns;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private static Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    static {
        BaseAlgorithm.$init$(MODULE$);
        Generic.$init$(MODULE$);
        columns = (List)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"adjPlusSet"})));
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    private List<String> columns() {
        return columns;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            vertex.messageAllNeighbours(new Tuple2(vertex.ID(), (Object)BoxesRunTime.boxToInteger((int)vertex.degree())), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)vertex -> {
            AdjPlus$.$anonfun$apply$2(vertex);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            AdjPlus$.$anonfun$tabularise$1(vertex);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)vertex -> {
            AdjPlus$.$anonfun$tabularise$3(vertex);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)vertex -> {
            AdjPlus$.$anonfun$tabularise$5(vertex);
            return BoxedUnit.UNIT;
        }).select((Seq<String>)this.columns()).explode((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"adjPlusSet"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AdjPlus$.class);
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(int degree$1, Vertex vertex$1, Tuple2 message) {
        return degree$1 < message._2$mcI$sp() || message._2$mcI$sp() == degree$1 && Ordering.Implicits$.MODULE$.infixOrderingOps(vertex$1.ID(), vertex$1.IDOrdering()).$less(message._1());
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex) {
        int degree = vertex.degree();
        Object adj = ((IterableOnceOps)((IterableOps)((SeqOps)vertex.messageQueue().filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)AdjPlus$.$anonfun$apply$3(degree, vertex, message)))).sortBy((Function1 & Serializable)m -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)m._2$mcI$sp()), m._1()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, vertex.IDOrdering()))).map((Function1 & Serializable)message -> message._1())).toArray(vertex.IDClassTag());
        ((EntityVisitor)((Object)vertex)).setState("adjPlus", adj);
        ((EntityVisitor)((Object)vertex)).setState("name", vertex.name(vertex.name$default$1()));
    }

    public static final /* synthetic */ void $anonfun$tabularise$1(Vertex vertex) {
        Object adj = ((EntityVisitor)((Object)vertex)).getState("adjPlus", ((EntityVisitor)((Object)vertex)).getState$default$2());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(adj), (Function1 & Serializable)a -> {
            vertex.messageVertex(a, vertex.ID(), vertex.provider());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tabularise$3(Vertex vertex) {
        vertex.messageQueue().foreach((Function1 & Serializable)v -> {
            vertex.messageVertex(v, vertex.name(vertex.name$default$1()), SchemaProviderInstances$.MODULE$.stringSchemaProvider());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tabularise$5(Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("adjPlusSet", vertex.messageQueue());
    }

    private AdjPlus$() {
    }
}

