/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.filters;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.filters.EdgeFilterGraphState$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.Edge;
import com.typesafe.scalalogging.Logger;
import scala.Function2;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`EdgeFilter(f: (Vertex, State) => Boolean)`\n  *   : Filtered view of the graph achieved by retaining edges according to a predicate function {s}`f`\n  *\n  *   This transforms the graph by keeping only edges for which {s}`f` returns true, where {s}`f` may depend on graph state.\n  *   This fits well within a chain of algorithms as a way of pruning the graph: for example, one could first filter out edges\n  *   below a certain weight before running a chosen algorithm.\n  *\n  * ## Parameters\n  *\n  * {s}`pruneNodes: Boolean=true`\n  *   : if this is {s}`true` then vertices which become isolated (have no incoming or outgoing edges)\n  *        after this filtering are also removed.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.filters.VertexFilter)\n  * [](com.raphtory.algorithms.filters.EdgeQuantileFilter)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001\u0002\u0007\u000e\u0001YA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tu\u0001\u0011\t\u0011)A\u0005o!)1\b\u0001C\u0001y!)\u0011\t\u0001C!\u0005\u001e)a,\u0004E\u0001?\u001a)A\"\u0004E\u0001A\")1H\u0002C\u0001S\")\u0011I\u0002C\u0001U\"9QNBI\u0001\n\u0003q\u0007bB=\u0007#\u0003%\tA\u001c\u0005\bu\u001a\t\t\u0011\"\u0003|\u0005Q)EmZ3GS2$XM]$sCBD7\u000b^1uK*\u0011abD\u0001\bM&dG/\u001a:t\u0015\t\u0001\u0012#\u0001\u0006bY\u001e|'/\u001b;i[NT!AE\n\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011\u0001F\u0001\u0004G>l7\u0001A\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001fK5\tqD\u0003\u0002!C\u0005I\u0011\r\\4pe&$\b.\u001c\u0006\u0003E\r\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003IE\t1!\u00199j\u0013\t1sDA\u0004HK:,'/[2\u0002\u0003\u0019\u0004R\u0001G\u0015,c]J!AK\r\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\u00170\u001b\u0005i#B\u0001\u0018\"\u0003\u001d1\u0018n]5u_JL!\u0001M\u0017\u0003\t\u0015#w-\u001a\t\u0003eUj\u0011a\r\u0006\u0003i\u0005\n!b\u001a:ba\"\u001cH/\u0019;f\u0013\t14G\u0001\u0006He\u0006\u0004\bn\u0015;bi\u0016\u0004\"\u0001\u0007\u001d\n\u0005eJ\"a\u0002\"p_2,\u0017M\\\u0001\u000baJ,h.\u001a(pI\u0016\u001c\u0018A\u0002\u001fj]&$h\bF\u0002>\u007f\u0001\u0003\"A\u0010\u0001\u000e\u00035AQaJ\u0002A\u0002!BqAO\u0002\u0011\u0002\u0003\u0007q'A\u0003baBd\u0017\u0010\u0006\u0002D\rB\u0011AI\u0014\b\u0003\u000b\u001ac\u0001\u0001C\u0003H\t\u0001\u0007\u0001*A\u0003he\u0006\u0004\b\u000e\u0005\u0002J\u00196\t!J\u0003\u0002LC\u0005IqM]1qQZLWm^\u0005\u0003\u001b*\u0013\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\n\u0005=c%!B$sCBD\u0007\u0006\u0002\u0001R7r\u0003\"AU-\u000e\u0003MS!\u0001V+\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!AV,\u0002\u000fQ\f7.\u001a>pK*\u0011\u0001lE\u0001\u0007O&$\b.\u001e2\n\u0005i\u001b&\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003u\u000ba\u0011R\u0018+U)\u0001\u0003E\u000b\u0011|gv\u0004W\tZ4f\r&dG/\u001a:)Mj\u0002\u0003FV3si\u0016DH\u0006I*uCR,\u0017\u0006I\u001f?A\t{w\u000e\\3b]&\u0002'\u0002\t\u0011+A\u0001\u0002#\b\t$jYR,'/\u001a3!m&,w\u000fI8gAQDW\rI4sCBD\u0007%Y2iS\u00164X\r\u001a\u0011cs\u0002\u0012X\r^1j]&tw\rI3eO\u0016\u001c\b%Y2d_J$\u0017N\\4!i>\u0004\u0013\r\t9sK\u0012L7-\u0019;fA\u0019,hn\u0019;j_:\u00043p]?aM\u0002T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011UQ&\u001c\b\u0005\u001e:b]N4wN]7tAQDW\rI4sCBD\u0007EY=!W\u0016,\u0007/\u001b8hA=tG.\u001f\u0011fI\u001e,7\u000f\t4pe\u0002:\b.[2iAm\u001cX\u0010\u00194aAI,G/\u001e:og\u0002\"(/^3-A]DWM]3!wNl\bM\u001a1![\u0006L\b\u0005Z3qK:$\u0007e\u001c8!OJ\f\u0007\u000f\u001b\u0011ti\u0006$XM\f\u0006!A)\u0002\u0003\u0005\t+iSN\u0004c-\u001b;tA],G\u000e\u001c\u0011xSRD\u0017N\u001c\u0011bA\rD\u0017-\u001b8!_\u001a\u0004\u0013\r\\4pe&$\b.\\:!CN\u0004\u0013\rI<bs\u0002zg\r\t9sk:Lgn\u001a\u0011uQ\u0016\u0004sM]1qQj\u0002cm\u001c:!Kb\fW\u000e\u001d7fY\u0001zg.\u001a\u0011d_VdG\r\t4jeN$\bEZ5mi\u0016\u0014\be\\;uA\u0015$w-Z:\u000bA\u0001R\u0003\u0005\t\u0011cK2|w\u000fI1!G\u0016\u0014H/Y5oA],\u0017n\u001a5uA\t,gm\u001c:fAI,hN\\5oO\u0002\n\u0007e\u00195pg\u0016t\u0007%\u00197h_JLG\u000f[7/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t)be\u0006lW\r^3sg*\u0001\u0003E\u000b\u0006!A)\u00023p]?aaJ,h.\u001a(pI\u0016\u001c(\b\t\"p_2,\u0017M\\\u001fueV,\u0007M\u0003\u0011!U\u0001\u0002\u0003E\u000f\u0011jM\u0002\"\b.[:!SN\u00043p]?aiJ,X\r\u0019\u0011uQ\u0016t\u0007E^3si&\u001cWm\u001d\u0011xQ&\u001c\u0007\u000e\t2fG>lW\rI5t_2\fG/\u001a3!Q!\fg/\u001a\u0011o_\u0002JgnY8nS:<\u0007e\u001c:!_V$xm\\5oO\u0002*GmZ3tS)\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u0011bMR,'\u000f\t;iSN\u0004c-\u001b7uKJLgn\u001a\u0011be\u0016\u0004\u0013\r\\:pAI,Wn\u001c<fI:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00191awN,W-\u00197t_vT\u0001\u0005\t\u0016!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018gS2$XM]:/-\u0016\u0014H/\u001a=GS2$XM]\u0015\u000bA\u0001R\u0003eW/)G>lgF]1qQR|'/\u001f\u0018bY\u001e|'/\u001b;i[Ntc-\u001b7uKJ\u001ch&\u00123hKF+\u0018M\u001c;jY\u00164\u0015\u000e\u001c;fe&R\u0001\u0005\t\u0016!A\u0002\u0004'\u0002\t\u0011+_\u0005!R\tZ4f\r&dG/\u001a:He\u0006\u0004\bn\u0015;bi\u0016\u0004\"A\u0010\u0004\u0014\u0007\u00199\u0012\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006\u0011\u0011n\u001c\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7M\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001`)\ri4\u000e\u001c\u0005\u0006O!\u0001\r\u0001\u000b\u0005\bu!\u0001\n\u00111\u00018\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012T#A8+\u0005]\u00028&A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018!C;oG\",7m[3e\u0015\t1\u0018$\u0001\u0006b]:|G/\u0019;j_:L!\u0001_:\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT!a`3\u0002\t1\fgnZ\u0005\u0004\u0003\u0007q(AB(cU\u0016\u001cG\u000f")
public class EdgeFilterGraphState
implements Generic {
    private final Function2<Edge, GraphState, Object> f;
    private final boolean pruneNodes;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static boolean $lessinit$greater$default$2() {
        return EdgeFilterGraphState$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean apply$default$2() {
        return EdgeFilterGraphState$.MODULE$.apply$default$2();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Write out results to a table (this method is only called after `apply`)\n    *\n    * The default implementation returns an empty table\n    *\n    * @param graph Graph that results from the call to `apply`\n    */")
    public Table tabularise(GraphPerspective graph) {
        return BaseAlgorithm.tabularise$(this, graph);
    }

    @Override
    @Scaladoc(value="/** Apply the algorithm to the graph and return the output as a table using the `tabularise` method */")
    public final Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.edgeFilter(this.f, this.pruneNodes);
    }

    public EdgeFilterGraphState(Function2<Edge, GraphState, Object> f, boolean pruneNodes) {
        this.f = f;
        this.pruneNodes = pruneNodes;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

