(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["node_modules_monaco-editor_esm_vs_basic-languages_restructuredtext_restructuredtext_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/restructuredtext/restructuredtext.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/restructuredtext/restructuredtext.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/restructuredtext/restructuredtext.ts
var conf = {
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  autoClosingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: "<", close: ">", notIn: ["string"] }
  ],
  surroundingPairs: [
    { open: "(", close: ")" },
    { open: "[", close: "]" },
    { open: "`", close: "`" }
  ],
  folding: {
    markers: {
      start: new RegExp("^\\s*<!--\\s*#?region\\b.*-->"),
      end: new RegExp("^\\s*<!--\\s*#?endregion\\b.*-->")
    }
  }
};
var language = {
  defaultToken: "",
  tokenPostfix: ".rst",
  control: /[\\`*_\[\]{}()#+\-\.!]/,
  escapes: /\\(?:@control)/,
  empty: [
    "area",
    "base",
    "basefont",
    "br",
    "col",
    "frame",
    "hr",
    "img",
    "input",
    "isindex",
    "link",
    "meta",
    "param"
  ],
  alphanumerics: /[A-Za-z0-9]/,
  simpleRefNameWithoutBq: /(?:@alphanumerics[-_+:.]*@alphanumerics)+|(?:@alphanumerics+)/,
  simpleRefName: /(?:`@phrase`|@simpleRefNameWithoutBq)/,
  phrase: /@simpleRefNameWithoutBq(?:\s@simpleRefNameWithoutBq)*/,
  citationName: /[A-Za-z][A-Za-z0-9-_.]*/,
  blockLiteralStart: /(?:[!"#$%&'()*+,-./:;<=>?@\[\]^_`{|}~]|[\s])/,
  precedingChars: /(?:[ -:/'"<([{])/,
  followingChars: /(?:[ -.,:;!?/'")\]}>]|$)/,
  punctuation: /(=|-|~|`|#|"|\^|\+|\*|:|\.|'|_|\+)/,
  tokenizer: {
    root: [
      [/^(@punctuation{3,}$){1,1}?/, "keyword"],
      [/^\s*([\*\-+‣•]|[a-zA-Z0-9]+\.|\([a-zA-Z0-9]+\)|[a-zA-Z0-9]+\))\s/, "keyword"],
      [/([ ]::)\s*$/, "keyword", "@blankLineOfLiteralBlocks"],
      [/(::)\s*$/, "keyword", "@blankLineOfLiteralBlocks"],
      { include: "@tables" },
      { include: "@explicitMarkupBlocks" },
      { include: "@inlineMarkup" }
    ],
    explicitMarkupBlocks: [
      { include: "@citations" },
      { include: "@footnotes" },
      [
        /^(\.\.\s)(@simpleRefName)(::\s)(.*)$/,
        [{ token: "", next: "subsequentLines" }, "keyword", "", ""]
      ],
      [
        /^(\.\.)(\s+)(_)(@simpleRefName)(:)(\s+)(.*)/,
        [{ token: "", next: "hyperlinks" }, "", "", "string.link", "", "", "string.link"]
      ],
      [
        /^((?:(?:\.\.)(?:\s+))?)(__)(:)(\s+)(.*)/,
        [{ token: "", next: "subsequentLines" }, "", "", "", "string.link"]
      ],
      [/^(__\s+)(.+)/, ["", "string.link"]],
      [
        /^(\.\.)( \|)([^| ]+[^|]*[^| ]*)(\| )(@simpleRefName)(:: .*)/,
        [{ token: "", next: "subsequentLines" }, "", "string.link", "", "keyword", ""],
        "@rawBlocks"
      ],
      [/(\|)([^| ]+[^|]*[^| ]*)(\|_{0,2})/, ["", "string.link", ""]],
      [/^(\.\.)([ ].*)$/, [{ token: "", next: "@comments" }, "comment"]]
    ],
    inlineMarkup: [
      { include: "@citationsReference" },
      { include: "@footnotesReference" },
      [/(@simpleRefName)(_{1,2})/, ["string.link", ""]],
      [/(`)([^<`]+\s+)(<)(.*)(>)(`)(_)/, ["", "string.link", "", "string.link", "", "", ""]],
      [/\*\*([^\\*]|\*(?!\*))+\*\*/, "strong"],
      [/\*[^*]+\*/, "emphasis"],
      [/(``)((?:[^`]|\`(?!`))+)(``)/, ["", "keyword", ""]],
      [/(__\s+)(.+)/, ["", "keyword"]],
      [/(:)((?:@simpleRefNameWithoutBq)?)(:`)([^`]+)(`)/, ["", "keyword", "", "", ""]],
      [/(`)([^`]+)(`:)((?:@simpleRefNameWithoutBq)?)(:)/, ["", "", "", "keyword", ""]],
      [/(`)([^`]+)(`)/, ""],
      [/(_`)(@phrase)(`)/, ["", "string.link", ""]]
    ],
    citations: [
      [
        /^(\.\.\s+\[)((?:@citationName))(\]\s+)(.*)/,
        [{ token: "", next: "@subsequentLines" }, "string.link", "", ""]
      ]
    ],
    citationsReference: [[/(\[)(@citationName)(\]_)/, ["", "string.link", ""]]],
    footnotes: [
      [
        /^(\.\.\s+\[)((?:[0-9]+))(\]\s+.*)/,
        [{ token: "", next: "@subsequentLines" }, "string.link", ""]
      ],
      [
        /^(\.\.\s+\[)((?:#@simpleRefName?))(\]\s+)(.*)/,
        [{ token: "", next: "@subsequentLines" }, "string.link", "", ""]
      ],
      [
        /^(\.\.\s+\[)((?:\*))(\]\s+)(.*)/,
        [{ token: "", next: "@subsequentLines" }, "string.link", "", ""]
      ]
    ],
    footnotesReference: [
      [/(\[)([0-9]+)(\])(_)/, ["", "string.link", "", ""]],
      [/(\[)(#@simpleRefName?)(\])(_)/, ["", "string.link", "", ""]],
      [/(\[)(\*)(\])(_)/, ["", "string.link", "", ""]]
    ],
    blankLineOfLiteralBlocks: [
      [/^$/, "", "@subsequentLinesOfLiteralBlocks"],
      [/^.*$/, "", "@pop"]
    ],
    subsequentLinesOfLiteralBlocks: [
      [/(@blockLiteralStart+)(.*)/, ["keyword", ""]],
      [/^(?!blockLiteralStart)/, "", "@popall"]
    ],
    subsequentLines: [
      [/^[\s]+.*/, ""],
      [/^(?!\s)/, "", "@pop"]
    ],
    hyperlinks: [
      [/^[\s]+.*/, "string.link"],
      [/^(?!\s)/, "", "@pop"]
    ],
    comments: [
      [/^[\s]+.*/, "comment"],
      [/^(?!\s)/, "", "@pop"]
    ],
    tables: [
      [/\+-[+-]+/, "keyword"],
      [/\+=[+=]+/, "keyword"]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm9kZV9tb2R1bGVzX21vbmFjby1lZGl0b3JfZXNtX3ZzX2Jhc2ljLWxhbmd1YWdlc19yZXN0cnVjdHVyZWR0ZXh0X3Jlc3RydWN0dXJlZHRleHRfanMud2ViLmpzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsT0FBTyxLQUFLO0FBQ1o7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNLFFBQVEsWUFBWSxHQUFHO0FBQzdCLE1BQU0sdUJBQXVCO0FBQzdCLE1BQU0sdUJBQXVCO0FBQzdCLE1BQU07QUFDTjtBQUNBO0FBQ0EsTUFBTSx1QkFBdUI7QUFDN0IsTUFBTSx1QkFBdUI7QUFDN0IsTUFBTTtBQUNOO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3QkFBd0I7QUFDeEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsMkNBQTJDLGFBQWEsRUFBRTtBQUMxRCxpQ0FBaUM7QUFDakMsNkJBQTZCLFNBQVM7QUFDdEM7QUFDQTtBQUNBO0FBQ0EsdUJBQXVCLEdBQUcsR0FBRyxJQUFJO0FBQ2pDO0FBQ0E7QUFDQTtBQUNBLFFBQVEsb0JBQW9CO0FBQzVCLFFBQVEsa0NBQWtDO0FBQzFDLFFBQVE7QUFDUjtBQUNBO0FBQ0EsUUFBUSx1QkFBdUI7QUFDL0IsUUFBUSx1QkFBdUI7QUFDL0I7QUFDQTtBQUNBLFdBQVcsb0NBQW9DO0FBQy9DO0FBQ0E7QUFDQTtBQUNBLFdBQVcsK0JBQStCO0FBQzFDO0FBQ0E7QUFDQTtBQUNBLFdBQVcsb0NBQW9DO0FBQy9DO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxvQ0FBb0M7QUFDL0M7QUFDQTtBQUNBLG9DQUFvQyxJQUFJO0FBQ3hDLDZCQUE2Qiw4QkFBOEI7QUFDM0Q7QUFDQTtBQUNBLFFBQVEsZ0NBQWdDO0FBQ3hDLFFBQVEsZ0NBQWdDO0FBQ3hDLDJCQUEyQixJQUFJO0FBQy9CO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxxQ0FBcUM7QUFDaEQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxxQ0FBcUM7QUFDaEQ7QUFDQTtBQUNBO0FBQ0EsV0FBVyxxQ0FBcUM7QUFDaEQ7QUFDQTtBQUNBO0FBQ0EsV0FBVyxxQ0FBcUM7QUFDaEQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBSUUiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly93ZWIuanMvLi9ub2RlX21vZHVsZXMvbW9uYWNvLWVkaXRvci9lc20vdnMvYmFzaWMtbGFuZ3VhZ2VzL3Jlc3RydWN0dXJlZHRleHQvcmVzdHJ1Y3R1cmVkdGV4dC5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKiEtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxuICogQ29weXJpZ2h0IChjKSBNaWNyb3NvZnQgQ29ycG9yYXRpb24uIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gKiBWZXJzaW9uOiAwLjM0LjEoNTQ3ODcwYjY4ODEzMDJjNWI0ZmYzMjE3M2MxNmQwNjAwOWUzNTg4ZilcbiAqIFJlbGVhc2VkIHVuZGVyIHRoZSBNSVQgbGljZW5zZVxuICogaHR0cHM6Ly9naXRodWIuY29tL21pY3Jvc29mdC9tb25hY28tZWRpdG9yL2Jsb2IvbWFpbi9MSUNFTlNFLnR4dFxuICotLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSovXG5cbi8vIHNyYy9iYXNpYy1sYW5ndWFnZXMvcmVzdHJ1Y3R1cmVkdGV4dC9yZXN0cnVjdHVyZWR0ZXh0LnRzXG52YXIgY29uZiA9IHtcbiAgYnJhY2tldHM6IFtcbiAgICBbXCJ7XCIsIFwifVwiXSxcbiAgICBbXCJbXCIsIFwiXVwiXSxcbiAgICBbXCIoXCIsIFwiKVwiXVxuICBdLFxuICBhdXRvQ2xvc2luZ1BhaXJzOiBbXG4gICAgeyBvcGVuOiBcIntcIiwgY2xvc2U6IFwifVwiIH0sXG4gICAgeyBvcGVuOiBcIltcIiwgY2xvc2U6IFwiXVwiIH0sXG4gICAgeyBvcGVuOiBcIihcIiwgY2xvc2U6IFwiKVwiIH0sXG4gICAgeyBvcGVuOiBcIjxcIiwgY2xvc2U6IFwiPlwiLCBub3RJbjogW1wic3RyaW5nXCJdIH1cbiAgXSxcbiAgc3Vycm91bmRpbmdQYWlyczogW1xuICAgIHsgb3BlbjogXCIoXCIsIGNsb3NlOiBcIilcIiB9LFxuICAgIHsgb3BlbjogXCJbXCIsIGNsb3NlOiBcIl1cIiB9LFxuICAgIHsgb3BlbjogXCJgXCIsIGNsb3NlOiBcImBcIiB9XG4gIF0sXG4gIGZvbGRpbmc6IHtcbiAgICBtYXJrZXJzOiB7XG4gICAgICBzdGFydDogbmV3IFJlZ0V4cChcIl5cXFxccyo8IS0tXFxcXHMqIz9yZWdpb25cXFxcYi4qLS0+XCIpLFxuICAgICAgZW5kOiBuZXcgUmVnRXhwKFwiXlxcXFxzKjwhLS1cXFxccyojP2VuZHJlZ2lvblxcXFxiLiotLT5cIilcbiAgICB9XG4gIH1cbn07XG52YXIgbGFuZ3VhZ2UgPSB7XG4gIGRlZmF1bHRUb2tlbjogXCJcIixcbiAgdG9rZW5Qb3N0Zml4OiBcIi5yc3RcIixcbiAgY29udHJvbDogL1tcXFxcYCpfXFxbXFxde30oKSMrXFwtXFwuIV0vLFxuICBlc2NhcGVzOiAvXFxcXCg/OkBjb250cm9sKS8sXG4gIGVtcHR5OiBbXG4gICAgXCJhcmVhXCIsXG4gICAgXCJiYXNlXCIsXG4gICAgXCJiYXNlZm9udFwiLFxuICAgIFwiYnJcIixcbiAgICBcImNvbFwiLFxuICAgIFwiZnJhbWVcIixcbiAgICBcImhyXCIsXG4gICAgXCJpbWdcIixcbiAgICBcImlucHV0XCIsXG4gICAgXCJpc2luZGV4XCIsXG4gICAgXCJsaW5rXCIsXG4gICAgXCJtZXRhXCIsXG4gICAgXCJwYXJhbVwiXG4gIF0sXG4gIGFscGhhbnVtZXJpY3M6IC9bQS1aYS16MC05XS8sXG4gIHNpbXBsZVJlZk5hbWVXaXRob3V0QnE6IC8oPzpAYWxwaGFudW1lcmljc1stXys6Ll0qQGFscGhhbnVtZXJpY3MpK3woPzpAYWxwaGFudW1lcmljcyspLyxcbiAgc2ltcGxlUmVmTmFtZTogLyg/OmBAcGhyYXNlYHxAc2ltcGxlUmVmTmFtZVdpdGhvdXRCcSkvLFxuICBwaHJhc2U6IC9Ac2ltcGxlUmVmTmFtZVdpdGhvdXRCcSg/Olxcc0BzaW1wbGVSZWZOYW1lV2l0aG91dEJxKSovLFxuICBjaXRhdGlvbk5hbWU6IC9bQS1aYS16XVtBLVphLXowLTktXy5dKi8sXG4gIGJsb2NrTGl0ZXJhbFN0YXJ0OiAvKD86WyFcIiMkJSYnKCkqKywtLi86Ozw9Pj9AXFxbXFxdXl9ge3x9fl18W1xcc10pLyxcbiAgcHJlY2VkaW5nQ2hhcnM6IC8oPzpbIC06LydcIjwoW3tdKS8sXG4gIGZvbGxvd2luZ0NoYXJzOiAvKD86WyAtLiw6OyE/LydcIilcXF19Pl18JCkvLFxuICBwdW5jdHVhdGlvbjogLyg9fC18fnxgfCN8XCJ8XFxefFxcK3xcXCp8OnxcXC58J3xffFxcKykvLFxuICB0b2tlbml6ZXI6IHtcbiAgICByb290OiBbXG4gICAgICBbL14oQHB1bmN0dWF0aW9uezMsfSQpezEsMX0/LywgXCJrZXl3b3JkXCJdLFxuICAgICAgWy9eXFxzKihbXFwqXFwtK+KAo+KAol18W2EtekEtWjAtOV0rXFwufFxcKFthLXpBLVowLTldK1xcKXxbYS16QS1aMC05XStcXCkpXFxzLywgXCJrZXl3b3JkXCJdLFxuICAgICAgWy8oWyBdOjopXFxzKiQvLCBcImtleXdvcmRcIiwgXCJAYmxhbmtMaW5lT2ZMaXRlcmFsQmxvY2tzXCJdLFxuICAgICAgWy8oOjopXFxzKiQvLCBcImtleXdvcmRcIiwgXCJAYmxhbmtMaW5lT2ZMaXRlcmFsQmxvY2tzXCJdLFxuICAgICAgeyBpbmNsdWRlOiBcIkB0YWJsZXNcIiB9LFxuICAgICAgeyBpbmNsdWRlOiBcIkBleHBsaWNpdE1hcmt1cEJsb2Nrc1wiIH0sXG4gICAgICB7IGluY2x1ZGU6IFwiQGlubGluZU1hcmt1cFwiIH1cbiAgICBdLFxuICAgIGV4cGxpY2l0TWFya3VwQmxvY2tzOiBbXG4gICAgICB7IGluY2x1ZGU6IFwiQGNpdGF0aW9uc1wiIH0sXG4gICAgICB7IGluY2x1ZGU6IFwiQGZvb3Rub3Rlc1wiIH0sXG4gICAgICBbXG4gICAgICAgIC9eKFxcLlxcLlxccykoQHNpbXBsZVJlZk5hbWUpKDo6XFxzKSguKikkLyxcbiAgICAgICAgW3sgdG9rZW46IFwiXCIsIG5leHQ6IFwic3Vic2VxdWVudExpbmVzXCIgfSwgXCJrZXl3b3JkXCIsIFwiXCIsIFwiXCJdXG4gICAgICBdLFxuICAgICAgW1xuICAgICAgICAvXihcXC5cXC4pKFxccyspKF8pKEBzaW1wbGVSZWZOYW1lKSg6KShcXHMrKSguKikvLFxuICAgICAgICBbeyB0b2tlbjogXCJcIiwgbmV4dDogXCJoeXBlcmxpbmtzXCIgfSwgXCJcIiwgXCJcIiwgXCJzdHJpbmcubGlua1wiLCBcIlwiLCBcIlwiLCBcInN0cmluZy5saW5rXCJdXG4gICAgICBdLFxuICAgICAgW1xuICAgICAgICAvXigoPzooPzpcXC5cXC4pKD86XFxzKykpPykoX18pKDopKFxccyspKC4qKS8sXG4gICAgICAgIFt7IHRva2VuOiBcIlwiLCBuZXh0OiBcInN1YnNlcXVlbnRMaW5lc1wiIH0sIFwiXCIsIFwiXCIsIFwiXCIsIFwic3RyaW5nLmxpbmtcIl1cbiAgICAgIF0sXG4gICAgICBbL14oX19cXHMrKSguKykvLCBbXCJcIiwgXCJzdHJpbmcubGlua1wiXV0sXG4gICAgICBbXG4gICAgICAgIC9eKFxcLlxcLikoIFxcfCkoW158IF0rW158XSpbXnwgXSopKFxcfCApKEBzaW1wbGVSZWZOYW1lKSg6OiAuKikvLFxuICAgICAgICBbeyB0b2tlbjogXCJcIiwgbmV4dDogXCJzdWJzZXF1ZW50TGluZXNcIiB9LCBcIlwiLCBcInN0cmluZy5saW5rXCIsIFwiXCIsIFwia2V5d29yZFwiLCBcIlwiXSxcbiAgICAgICAgXCJAcmF3QmxvY2tzXCJcbiAgICAgIF0sXG4gICAgICBbLyhcXHwpKFtefCBdK1tefF0qW158IF0qKShcXHxfezAsMn0pLywgW1wiXCIsIFwic3RyaW5nLmxpbmtcIiwgXCJcIl1dLFxuICAgICAgWy9eKFxcLlxcLikoWyBdLiopJC8sIFt7IHRva2VuOiBcIlwiLCBuZXh0OiBcIkBjb21tZW50c1wiIH0sIFwiY29tbWVudFwiXV1cbiAgICBdLFxuICAgIGlubGluZU1hcmt1cDogW1xuICAgICAgeyBpbmNsdWRlOiBcIkBjaXRhdGlvbnNSZWZlcmVuY2VcIiB9LFxuICAgICAgeyBpbmNsdWRlOiBcIkBmb290bm90ZXNSZWZlcmVuY2VcIiB9LFxuICAgICAgWy8oQHNpbXBsZVJlZk5hbWUpKF97MSwyfSkvLCBbXCJzdHJpbmcubGlua1wiLCBcIlwiXV0sXG4gICAgICBbLyhgKShbXjxgXStcXHMrKSg8KSguKikoPikoYCkoXykvLCBbXCJcIiwgXCJzdHJpbmcubGlua1wiLCBcIlwiLCBcInN0cmluZy5saW5rXCIsIFwiXCIsIFwiXCIsIFwiXCJdXSxcbiAgICAgIFsvXFwqXFwqKFteXFxcXCpdfFxcKig/IVxcKikpK1xcKlxcKi8sIFwic3Ryb25nXCJdLFxuICAgICAgWy9cXCpbXipdK1xcKi8sIFwiZW1waGFzaXNcIl0sXG4gICAgICBbLyhgYCkoKD86W15gXXxcXGAoPyFgKSkrKShgYCkvLCBbXCJcIiwgXCJrZXl3b3JkXCIsIFwiXCJdXSxcbiAgICAgIFsvKF9fXFxzKykoLispLywgW1wiXCIsIFwia2V5d29yZFwiXV0sXG4gICAgICBbLyg6KSgoPzpAc2ltcGxlUmVmTmFtZVdpdGhvdXRCcSk/KSg6YCkoW15gXSspKGApLywgW1wiXCIsIFwia2V5d29yZFwiLCBcIlwiLCBcIlwiLCBcIlwiXV0sXG4gICAgICBbLyhgKShbXmBdKykoYDopKCg/OkBzaW1wbGVSZWZOYW1lV2l0aG91dEJxKT8pKDopLywgW1wiXCIsIFwiXCIsIFwiXCIsIFwia2V5d29yZFwiLCBcIlwiXV0sXG4gICAgICBbLyhgKShbXmBdKykoYCkvLCBcIlwiXSxcbiAgICAgIFsvKF9gKShAcGhyYXNlKShgKS8sIFtcIlwiLCBcInN0cmluZy5saW5rXCIsIFwiXCJdXVxuICAgIF0sXG4gICAgY2l0YXRpb25zOiBbXG4gICAgICBbXG4gICAgICAgIC9eKFxcLlxcLlxccytcXFspKCg/OkBjaXRhdGlvbk5hbWUpKShcXF1cXHMrKSguKikvLFxuICAgICAgICBbeyB0b2tlbjogXCJcIiwgbmV4dDogXCJAc3Vic2VxdWVudExpbmVzXCIgfSwgXCJzdHJpbmcubGlua1wiLCBcIlwiLCBcIlwiXVxuICAgICAgXVxuICAgIF0sXG4gICAgY2l0YXRpb25zUmVmZXJlbmNlOiBbWy8oXFxbKShAY2l0YXRpb25OYW1lKShcXF1fKS8sIFtcIlwiLCBcInN0cmluZy5saW5rXCIsIFwiXCJdXV0sXG4gICAgZm9vdG5vdGVzOiBbXG4gICAgICBbXG4gICAgICAgIC9eKFxcLlxcLlxccytcXFspKCg/OlswLTldKykpKFxcXVxccysuKikvLFxuICAgICAgICBbeyB0b2tlbjogXCJcIiwgbmV4dDogXCJAc3Vic2VxdWVudExpbmVzXCIgfSwgXCJzdHJpbmcubGlua1wiLCBcIlwiXVxuICAgICAgXSxcbiAgICAgIFtcbiAgICAgICAgL14oXFwuXFwuXFxzK1xcWykoKD86I0BzaW1wbGVSZWZOYW1lPykpKFxcXVxccyspKC4qKS8sXG4gICAgICAgIFt7IHRva2VuOiBcIlwiLCBuZXh0OiBcIkBzdWJzZXF1ZW50TGluZXNcIiB9LCBcInN0cmluZy5saW5rXCIsIFwiXCIsIFwiXCJdXG4gICAgICBdLFxuICAgICAgW1xuICAgICAgICAvXihcXC5cXC5cXHMrXFxbKSgoPzpcXCopKShcXF1cXHMrKSguKikvLFxuICAgICAgICBbeyB0b2tlbjogXCJcIiwgbmV4dDogXCJAc3Vic2VxdWVudExpbmVzXCIgfSwgXCJzdHJpbmcubGlua1wiLCBcIlwiLCBcIlwiXVxuICAgICAgXVxuICAgIF0sXG4gICAgZm9vdG5vdGVzUmVmZXJlbmNlOiBbXG4gICAgICBbLyhcXFspKFswLTldKykoXFxdKShfKS8sIFtcIlwiLCBcInN0cmluZy5saW5rXCIsIFwiXCIsIFwiXCJdXSxcbiAgICAgIFsvKFxcWykoI0BzaW1wbGVSZWZOYW1lPykoXFxdKShfKS8sIFtcIlwiLCBcInN0cmluZy5saW5rXCIsIFwiXCIsIFwiXCJdXSxcbiAgICAgIFsvKFxcWykoXFwqKShcXF0pKF8pLywgW1wiXCIsIFwic3RyaW5nLmxpbmtcIiwgXCJcIiwgXCJcIl1dXG4gICAgXSxcbiAgICBibGFua0xpbmVPZkxpdGVyYWxCbG9ja3M6IFtcbiAgICAgIFsvXiQvLCBcIlwiLCBcIkBzdWJzZXF1ZW50TGluZXNPZkxpdGVyYWxCbG9ja3NcIl0sXG4gICAgICBbL14uKiQvLCBcIlwiLCBcIkBwb3BcIl1cbiAgICBdLFxuICAgIHN1YnNlcXVlbnRMaW5lc09mTGl0ZXJhbEJsb2NrczogW1xuICAgICAgWy8oQGJsb2NrTGl0ZXJhbFN0YXJ0KykoLiopLywgW1wia2V5d29yZFwiLCBcIlwiXV0sXG4gICAgICBbL14oPyFibG9ja0xpdGVyYWxTdGFydCkvLCBcIlwiLCBcIkBwb3BhbGxcIl1cbiAgICBdLFxuICAgIHN1YnNlcXVlbnRMaW5lczogW1xuICAgICAgWy9eW1xcc10rLiovLCBcIlwiXSxcbiAgICAgIFsvXig/IVxccykvLCBcIlwiLCBcIkBwb3BcIl1cbiAgICBdLFxuICAgIGh5cGVybGlua3M6IFtcbiAgICAgIFsvXltcXHNdKy4qLywgXCJzdHJpbmcubGlua1wiXSxcbiAgICAgIFsvXig/IVxccykvLCBcIlwiLCBcIkBwb3BcIl1cbiAgICBdLFxuICAgIGNvbW1lbnRzOiBbXG4gICAgICBbL15bXFxzXSsuKi8sIFwiY29tbWVudFwiXSxcbiAgICAgIFsvXig/IVxccykvLCBcIlwiLCBcIkBwb3BcIl1cbiAgICBdLFxuICAgIHRhYmxlczogW1xuICAgICAgWy9cXCstWystXSsvLCBcImtleXdvcmRcIl0sXG4gICAgICBbL1xcKz1bKz1dKy8sIFwia2V5d29yZFwiXVxuICAgIF1cbiAgfVxufTtcbmV4cG9ydCB7XG4gIGNvbmYsXG4gIGxhbmd1YWdlXG59O1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9