"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const fs_1 = require("fs");
const os_1 = require("os");
const path_1 = require("path");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.dir = fs_1.mkdtempSync(path_1.join(os_1.tmpdir(), 'chwebapp'));
        this.path = path_1.join(this.dir, 'config.json');
        fs_1.writeFileSync(this.path, JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        const withoutDomains = packageLinks.map(({ allowedDomains, ...rest }) => rest);
        return { packageLinks: withoutDomains };
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,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