"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sqsQueueUrl = exports.stateMachineUrl = exports.s3ObjectUrl = exports.lambdaSearchLogGroupUrl = exports.lambdaFunctionUrl = exports.codeArtifactRepositoryUrl = void 0;
const core_1 = require("@aws-cdk/core");
function codeArtifactRepositoryUrl(repository) {
    return `/codesuite/codeartifact/d/${repository.attrDomainOwner}/${repository.attrDomainName}/r/${repository.attrName}`;
}
exports.codeArtifactRepositoryUrl = codeArtifactRepositoryUrl;
function lambdaFunctionUrl(lambda) {
    return `/lambda/home#/functions/${lambda.functionName}`;
}
exports.lambdaFunctionUrl = lambdaFunctionUrl;
function lambdaSearchLogGroupUrl(lambda) {
    return `/cloudwatch/home#logsV2:log-groups/log-group/$252Faws$252flambda$252f${lambda.functionName}/log-events`;
}
exports.lambdaSearchLogGroupUrl = lambdaSearchLogGroupUrl;
function s3ObjectUrl(bucket, objectKey) {
    if (objectKey) {
        return `/s3/object/${bucket.bucketName}?prefix=${objectKey}`;
    }
    else {
        return `/s3/buckets/${bucket.bucketName}`;
    }
}
exports.s3ObjectUrl = s3ObjectUrl;
function stateMachineUrl(stateMachine) {
    return `/states/home#/statemachines/view/${stateMachine.stateMachineArn}`;
}
exports.stateMachineUrl = stateMachineUrl;
function sqsQueueUrl(queue) {
    const stack = core_1.Stack.of(queue);
    // We can't use the Queue URL as-is, because we can't "easily" URL-encode it in CFN...
    return `/sqs/v2/home#/queues/https%3A%2F%2Fsqs.${stack.region}.amazonaws.com%2F${stack.account}%2F${queue.queueName}`;
}
exports.sqsQueueUrl = sqsQueueUrl;
//# sourceMappingURL=data:application/json;base64,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