"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws = require("../shared/aws.lambda-shared");
const env_lambda_shared_1 = require("../shared/env.lambda-shared");
async function handler(event, context) {
    const stateMachineArn = env_lambda_shared_1.requireEnv('STATE_MACHINE_ARN');
    const queueUrl = env_lambda_shared_1.requireEnv('QUEUE_URL');
    console.log(`Event: ${JSON.stringify(event, null, 2)}`);
    const sfn = aws.stepFunctions();
    for await (const message of messagesToRedrive(queueUrl)) {
        const input = JSON.parse(message.Body);
        console.log(`Redriving message ${JSON.stringify(input, null, 2)}`);
        const { executionArn } = await sfn.startExecution({
            stateMachineArn: stateMachineArn,
            input: JSON.stringify({
                ...input,
                // Remove the _error information
                _error: undefined,
                // Add the redrive information
                _redrive: {
                    lambdaRequestId: context.awsRequestId,
                    lambdaLogGroupName: context.logGroupName,
                    lambdaLogStreamName: context.logStreamName,
                },
            }),
        }).promise();
        console.log(`Redrive execution ARN: ${executionArn}`);
        await aws.sqs().deleteMessage({
            QueueUrl: queueUrl,
            ReceiptHandle: message.ReceiptHandle,
        }).promise();
    }
}
exports.handler = handler;
async function* messagesToRedrive(queueUrl) {
    const sqs = aws.sqs();
    let result;
    do {
        result = await sqs.receiveMessage({
            QueueUrl: queueUrl,
            VisibilityTimeout: 900,
        }).promise();
        if (result.Messages) {
            yield* result.Messages;
        }
    } while (result.Messages != null && result.Messages.length > 0);
}
//# sourceMappingURL=data:application/json;base64,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