var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __require = typeof require !== "undefined" ? require : (x) => {
  throw new Error('Dynamic require of "' + x + '" is not supported');
};
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toModule = (module2) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};

// src/backend/deny-list/prune-queue-handler.lambda.ts
__export(exports, {
  handler: () => handler
});
var AWS = __toModule(require("aws-sdk"));

// src/backend/shared/env.lambda-shared.ts
var import_process = __toModule(require("process"));
function requireEnv(name) {
  const result = import_process.env[name];
  if (!result) {
    throw new Error(`No value specified for required environment variable: ${name}`);
  }
  return result;
}

// src/backend/deny-list/constants.ts
var ENV_DELETE_OBJECT_DATA_BUCKET_NAME = "PACKAGE_DATA_BUCKET_NAME";
var MetricName;
(function(MetricName2) {
  MetricName2["DENY_LIST_RULE_COUNT"] = "DenyListRuleCount";
})(MetricName || (MetricName = {}));

// src/backend/deny-list/prune-queue-handler.lambda.ts
var s3 = new AWS.S3();
async function handler(event) {
  var _a;
  console.log(JSON.stringify({ event }));
  const bucket = requireEnv(ENV_DELETE_OBJECT_DATA_BUCKET_NAME);
  const records = (_a = event.Records) != null ? _a : [];
  for (const record of records) {
    const objectKey = record.body;
    console.log(`deleting s3://${bucket}/${objectKey}`);
    await s3.deleteObject({ Bucket: bucket, Key: objectKey }).promise();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
