import * as cdk from '@aws-cdk/core';
/**
 * Construct properties for ServerlessApp.
 *
 * @stability stable
 */
export interface ServerlessAppProps {
    /**
     * @stability stable
     */
    readonly applicationId: string;
    /**
     * @stability stable
     */
    readonly semanticVersion: string;
    /**
     * The parameters for the ServerlessApp.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export declare class ServerlessApp extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly resource: cdk.CfnResource;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: ServerlessAppProps);
}
