import requests
from typing import Optional
from vesselapi.models import operations
from . import utils

class EngUsers:
    _client: requests.Session
    _security_client: requests.Session
    _server_url: str
    _language: str
    _sdk_version: str
    _gen_version: str

    def __init__(self, client: requests.Session, security_client: requests.Session, server_url: str, language: str, sdk_version: str, gen_version: str) -> None:
        self._client = client
        self._security_client = security_client
        self._server_url = server_url
        self._language = language
        self._sdk_version = sdk_version
        self._gen_version = gen_version

    
    def find(self, request: operations.GetOneEngagementUserRequest) -> operations.GetOneEngagementUserResponse:
        r"""Get User
        Retrieve a single User by Id
        """
        
        base_url = self._server_url
        
        url = base_url.removesuffix("/") + "/engagement/user"
        
        query_params = utils.get_query_params(request.query_params)
        
        client = self._security_client
        
        r = client.request("GET", url, params=query_params)
        content_type = r.headers.get("Content-Type")

        res = operations.GetOneEngagementUserResponse(status_code=r.status_code, content_type=content_type)
        
        if r.status_code == 200:
            if utils.match_content_type(content_type, "application/json"):
                out = utils.unmarshal_json(r.text, Optional[operations.GetOneEngagementUserResponseBody])
                res.response_body = out

        return res

    
    def list(self, request: operations.GetAllEngagementUsersRequest) -> operations.GetAllEngagementUsersResponse:
        r"""Get All Users
        Retrieve all Users
        """
        
        base_url = self._server_url
        
        url = base_url.removesuffix("/") + "/engagement/users"
        
        query_params = utils.get_query_params(request.query_params)
        
        client = self._security_client
        
        r = client.request("GET", url, params=query_params)
        content_type = r.headers.get("Content-Type")

        res = operations.GetAllEngagementUsersResponse(status_code=r.status_code, content_type=content_type)
        
        if r.status_code == 200:
            if utils.match_content_type(content_type, "application/json"):
                out = utils.unmarshal_json(r.text, Optional[operations.GetAllEngagementUsersResponseBody])
                res.response_body = out

        return res

    