# -*- coding: utf-8 -*-
"""MX Nickname class file."""

import os
import sys


class Nicknames(object):
    """Nicknames class."""

    def __init__(self, update):
        """Initialize a class instance."""
        self.update = update
        self.mx = update.mx
        self.verbose = update.mx.verbose

        # define the name of the nicknames alias file
        self.aliasfile = 'aliases.nicknames'

        # define the path to the nicknames puppet file
        self.puppetfile = '%s/%s%s' % (
            self.mx.aliases_puppetdir,
            self.aliasfile,
            self.mx.extension,
        )

        # get program name
        self.program = os.path.basename(sys.argv[0])

    def generate(self):
        """Return the contents of the puppetfile."""
        # define header
        output = '# This file is autogenerated by the bits-mx %s script.\n' % (
            self.program
        )
        output += '# Do not make local modifications to this file.\n'

        # get autoreplies
        aliases = self.get_aliases()

        # users without a forward
        output += '\n# Nickname aliases\n'
        output += '\n'.join(aliases)

        return output

    def get_aliases(self):
        """Return the rules with forwards."""
        nicknames = self.update.nicknames

        aliases = []
        for username in sorted(nicknames):
            # get user nicknames
            user_nicknames = nicknames.get(username)

            # # get user aliases
            user_aliases = []
            if user_nicknames:
                user_aliases = user_nicknames.get('nicknames', [])

            # process aliases
            for alias in user_aliases:
                aliases.append('%s: %s@broadinstitute.org' % (
                    alias,
                    username
                ))

        # add in sa account aliases for folks without a google sa
        for oid in self.update.all_other_accounts:
            user = self.update.all_other_accounts[oid]

            # get ad username, broad username, and google username
            ad_username = user.get('ad_username')
            broad_username = user.get('broad_username')
            google_username = user.get('google_username')

            # if ad_username starts with "sa-" and google_username doesn't exist
            if ad_username and ad_username.startswith('sa-') and not google_username:
                aliases.append('%s: %s@broadinstitute.org' % (
                    ad_username,
                    broad_username
                ))

        return sorted(aliases)
