# -*- coding: utf-8 -*-
"""MX Gnarwl class file."""

import os
import sys


class Gnarwl(object):
    """Gnarwl class."""

    def __init__(self, update):
        """Initialize a class instance."""
        self.update = update
        self.mx = update.mx
        self.verbose = update.mx.verbose

        # define the name of the gnarwl alias file
        self.aliasfile = 'aliases.autoreply'

        # define the path to the gnarwl puppet file
        self.puppetfile = '%s/%s%s' % (
            self.mx.aliases_puppetdir,
            self.aliasfile,
            self.mx.extension,
        )

        # get program name
        self.program = os.path.basename(sys.argv[0])

    def generate(self):
        """Return the contents of the puppetfile."""
        # define header
        output = '# This file is autogenerated by the bits-mx %s script.\n' % (
            self.program
        )
        output += '# Do not make local modifications to this file.\n'

        # get autoreplies
        with_forward, without_forward = self.get_autoreplies()

        # users without a forward
        output += '\n# Autoreplies without forwards\n'
        output += '\n'.join(without_forward)

        # users with a forward
        output += '\n\n# Autoreplies with forwards\n'
        output += '\n'.join(with_forward)

        return output

    def get_autoreplies(self):
        """Return the rules with forwards."""
        gnarwl = self.update.gnarwl
        nicknames = self.update.nicknames

        with_forward = []
        without_forward = []
        for username in sorted(gnarwl):
            # get user nicknames
            user_nicknames = nicknames.get(username, {})

            # get user aliases
            aliases = []
            if user_nicknames:
                aliases = user_nicknames.get('nicknames', [])

            # get user usernames
            usernames = [username] + aliases

            # check if user has a forward
            forward = None
            if 'forward' in gnarwl[username]:
                forward = gnarwl[username]['forward']

            for name in usernames:
                if forward:
                    with_forward.append('%s: gnarwl@broadinstitute.org,%s' % (
                        name,
                        forward
                    ))
                else:
                    without_forward.append('%s: gnarwl@broadinstitute.org' % (
                        name
                    ))

        return with_forward, without_forward
